#include <kdebug.h>
#include <klibloader.h>
#include <ktrader.h>

#include "kmtmoduleiface.h"


ModuleInterface::ModuleInterface(QObject* parent, const char* name)
  : QObject(parent, name)
{
  _modules.setAutoDelete(true);
}

void ModuleInterface::loadModules( )
{
  KTrader::OfferList offers = KTrader::self( )->query("KMathToolModule");

  if (!offers.count( ))
    emit signalNoModules( );

  for (KTrader::OfferListIterator it = offers.begin( ); it != offers.end( ); ++it) {
    KLibFactory* factory = KLibLoader::self( )->factory((*it)->library( ).local8Bit( ));
    if (!factory) {
      kdDebug( ) << "No factory" << endl;
      return;
    }
    KMathToolModule* module = static_cast<KMathToolModule*>(factory->create(0, 0));
    if (module) {
      _modules.append(module);
      emit signalModuleLoaded(module);
    }
  }
}

#include "kmtmoduleiface.moc"
