%{

#include "infolex.h"

#ifdef USE_PURE_PARSER
#define YY_DECL int infolex YY_PROTO((YYSTYPE *lvalp))
#define YY_LVALP lvalp
#else
#define YY_LVALP (&yylval)
#endif

#include "infotype.h"

#include <stdlib.h>
#include <string.h>

int lex_line;
int lex_pofs;
int lex_ofs;

char *my_strndup(char *s, int n)
{
	char *q=(char*)malloc(n+1);
	memmove(q, s, n);
	q[n]=0;
	return q;
}

char *find_substr(char *in, char *find)
{
	int n=strlen(find);
	while (*in) {
		if (strncmp(in, find, n)==0) return in;
		in++;
	}
	return in;
}

char *skip_ws(char *s)
{
	while (((unsigned char)*s<=32) && (*s)) s++;
	return s;
}	
		
char *file_block_attribs[] = {
	"File: ", "Node: ", "Prev: ", "Next: ", "Up: "
};

void file_block(info_node_t *b, char *s)
{
#define FILE_BLOCK_ATTRIBS (sizeof (file_block_attribs) / sizeof (file_block_attribs[0]))
	char **vals[FILE_BLOCK_ATTRIBS]={ 
	    &b->file, &b->node, &b->prev, &b->next, &b->up };
	int i;
	for (i=0; i<FILE_BLOCK_ATTRIBS; i++) *vals[i]=NULL;
	b->codelen = strlen(s);
	b->body_ofs = lex_ofs + b->codelen;
	while (*s) {
		char *start, *end;
		int k=0;
		s=skip_ws(s);
		for (i=0; i<FILE_BLOCK_ATTRIBS; i++) {
			int l=strlen(file_block_attribs[i]);
			if (strncmp(s, file_block_attribs[i], l)==0) {
				int q = 3;
				start=s+l;
				end=find_substr(start, ",  ");
				if (!*vals[i]) *vals[i]=my_strndup(start, end-start);
				while (q-- && *(end++));
				s=end;
				k=1;
				break;
			}				
		}
/* error not a valid attribute to "File: ", so we quit */
		if (!k) return;
	}
}

void xref(info_xref_t *x, char *s, int sofs)
{
	char *m;
	char *k;
/*	int start_line, start_pofs;*/
	int end_line, end_pofs;
	
	s+=sofs;
	s = skip_ws(s);
	m = strchr(s, ':');
	k = my_strndup(s, m-s);
	x->text = k;
	if (m[1] == ':') {
		x->target = strdup(k);
	} else {
		m = skip_ws(m+1);
		x->target = my_strndup(m, strlen(m)-1);
	}
	{
		int i;
		int c = strlen(x->target);
		for (i=0; i<c; i++) {
			if (x->target[i] == '\n') x->target[i] = ' ';
		}
	}
/**/
	end_line=lex_line;
	end_pofs=lex_pofs+sofs;
	while (1) {
		char *z=strchr(s, '\n');
		if (z) {
			end_line++;
			end_pofs=0;
			s=z+1;
		} else {
			end_pofs+=strlen(s);
			break;
		}
	}
/**/	
	x->start_line = lex_line;
	x->start_pofs = lex_pofs;
	x->end_line = end_line;
	x->end_pofs = end_pofs;
	x->codelen = infoleng;
	lex_ofs += infoleng;
	lex_pofs += infoleng;
}

void infolex_init()
{
	lex_ofs = 0;
}

void *infolex_current_buffer()
{
	return (void*)YY_CURRENT_BUFFER;
}

void infolex_switch_buffer(void *buffer)
{
	info_switch_to_buffer(buffer);	
}

void infolex_delete_buffer(void *buffer)
{
	info_delete_buffer(buffer);	
}

void *infolex_scan_string_buffer(const char *str)
{
	return info_scan_string(str);
}

void *infolex_scan_bytes_buffer(const char *str, int len)
{
	return info_scan_bytes(str, len);
}

%}

%option noyywrap

%%

\x1f\nFile:.*\n			lex_line = 0; lex_pofs = 0; file_block(&YY_LVALP->node, yytext); lex_ofs += yyleng; return INFO_FILE;
\x1f\nTag\ Table:.*\n		lex_ofs += strlen(yytext); return INFO_TTBL;
\x1f\nEnd\ Tag\ Table.*\n	lex_ofs += strlen(yytext); return INFO_ENDTTBL;
\*[nN]ote(\ |\n).[^:]*::	xref(&YY_LVALP->xref, yytext, 6); return INFO_XREF;
\*[nN]ote(\ |\n).[^:]*:\ ((\(.+\))|.)[^.,]*[.,]	xref(&YY_LVALP->xref, yytext, 6); return INFO_XREF;
^\*\ .[^:]*::			xref(&YY_LVALP->xref, yytext, 2); return INFO_XREF;
^\*\ .[^:]*:\ ((\(.+\))|.)[^.,]*[.,]	xref(&YY_LVALP->xref, yytext, 2); return INFO_XREF;
.				lex_ofs++; lex_pofs++; return yytext[0];
\n				lex_ofs++; lex_line++; lex_pofs=0; return yytext[0];

%%
