/*
 *	HT Editor
 *	htpehead.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "htatom.h"
#include "htcoff.h"
#include "htendian.h"
#include "htnewexe.h"
#include "htpe.h"
#include "htpehead.h"
#include "httag.h"
#include "htstring.h"
#include "formats.h"

#include "pestruct.h"

#include <string.h>

int_hash pe_optional_magics[] =
{
	{COFF_OPTMAGIC_ROMIMAGE, "ROM image"},
	{COFF_OPTMAGIC_PE32, "PE/PE32"},
	{COFF_OPTMAGIC_PE64, "PE32+/PE64"},
	{0, 0}
};

int_hash pe_subsystems[] =
{
	{0, "generic"},
	{PE_SUBSYSTEM_NATIVE, "native"},
	{PE_SUBSYSTEM_WINDOWS_GUI, "Windows GUI"},
	{PE_SUBSYSTEM_WINDOWS_CUI, "Windows CUI"},
	{PE_SUBSYSTEM_OS2_CUI, "OS/2 CUI"},
	{PE_SUBSYSTEM_POSIX_CUI, "POSIX CUI"},
	{9, "Windows CE GUI"},
	{10, "EFI"},
	{11, "EFI/boot"},
	{12, "EFI/runtime"},
	{0, 0}
};

ht_mask_ptable pemagic[] = {
	{"magic",						STATICTAG_EDIT_DWORD_LE("00000000")},
	{0, 0}
};

ht_mask_ptable pe32header[] = {
	{"optional magic",				STATICTAG_EDIT_WORD_LE("00000014")" "STATICTAG_DESC_WORD_LE("00000014", ATOM_PE_OPTIONAL_MAGICS_STR)},
	{"major linker version",			STATICTAG_EDIT_BYTE("00000016")},
	{"minor linker version",			STATICTAG_EDIT_BYTE("00000017")},
	{"size of code",				STATICTAG_EDIT_DWORD_LE("00000018")},
	{"size of data",				STATICTAG_EDIT_DWORD_LE("0000001c")},
	{"size of bss",				STATICTAG_EDIT_DWORD_LE("00000020")},
	{"entry point",				STATICTAG_EDIT_DWORD_LE("00000024")},
	{"code base",					STATICTAG_EDIT_DWORD_LE("00000028")},
	{"data base",					STATICTAG_EDIT_DWORD_LE("0000002c")},
	{0, 0}
};

ht_mask_ptable pe32header_nt[] = {
	{"image base",					STATICTAG_EDIT_DWORD_LE("00000030")},
	{"section alignment",			STATICTAG_EDIT_DWORD_LE("00000034")},
	{"file alignment",				STATICTAG_EDIT_DWORD_LE("00000038")},
	{"major OS version",			STATICTAG_EDIT_WORD_LE("0000003c")},
	{"minor OS version",			STATICTAG_EDIT_WORD_LE("0000003e")},
	{"major image version",			STATICTAG_EDIT_WORD_LE("00000040")},
	{"minor image version",			STATICTAG_EDIT_WORD_LE("00000042")},
	{"major subsystem version",		STATICTAG_EDIT_WORD_LE("00000044")},
	{"minor subsystem version",		STATICTAG_EDIT_WORD_LE("00000046")},
	{"Win32 version",				STATICTAG_EDIT_DWORD_LE("00000048")},
	{"size of image",				STATICTAG_EDIT_DWORD_LE("0000004c")},
	{"size of headers",				STATICTAG_EDIT_DWORD_LE("00000050")},
	{"checksum",					STATICTAG_EDIT_DWORD_LE("00000054")},
	{"subsystem",					STATICTAG_EDIT_WORD_LE("00000058")" "STATICTAG_DESC_WORD_LE("00000058", ATOM_PE_SUBSYSTEMS_STR)},
	{"dll characteristics",			STATICTAG_EDIT_WORD_LE("0000005a")},
	{"stack reserve",				STATICTAG_EDIT_DWORD_LE("0000005c")},
	{"stack commit",				STATICTAG_EDIT_DWORD_LE("00000060")},
	{"heap reserve",				STATICTAG_EDIT_DWORD_LE("00000064")},
	{"heap commit",				STATICTAG_EDIT_DWORD_LE("00000068")},
	{"loader flags",				STATICTAG_EDIT_DWORD_LE("0000006c")},
	{"number of directory entries",	STATICTAG_EDIT_DWORD_LE("00000070")},
	{0, 0}
};

ht_mask_ptable pe32header_nt_dirs[] = {
	{"export directory",			STATICTAG_EDIT_DWORD_LE("00000074")" size "STATICTAG_EDIT_DWORD_LE("00000078")},
	{"import directory",			STATICTAG_EDIT_DWORD_LE("0000007c")" size "STATICTAG_EDIT_DWORD_LE("00000080")},
	{"resource directory",			STATICTAG_EDIT_DWORD_LE("00000084")" size "STATICTAG_EDIT_DWORD_LE("00000088")},
	{"exception directory",			STATICTAG_EDIT_DWORD_LE("0000008c")" size "STATICTAG_EDIT_DWORD_LE("00000090")},
	{"security directory",			STATICTAG_EDIT_DWORD_LE("00000094")" size "STATICTAG_EDIT_DWORD_LE("00000098")},
	{"base relocation table",		STATICTAG_EDIT_DWORD_LE("0000009c")" size "STATICTAG_EDIT_DWORD_LE("000000a0")},
	{"debug directory",				STATICTAG_EDIT_DWORD_LE("000000a4")" size "STATICTAG_EDIT_DWORD_LE("000000a8")},
	{"description string",			STATICTAG_EDIT_DWORD_LE("000000ac")" size "STATICTAG_EDIT_DWORD_LE("000000b0")},
	{"machine value (GP)",			STATICTAG_EDIT_DWORD_LE("000000b4")" size "STATICTAG_EDIT_DWORD_LE("000000b8")},
	{"thread local storage (TLS)",	STATICTAG_EDIT_DWORD_LE("000000bc")" size "STATICTAG_EDIT_DWORD_LE("000000c0")},
	{"load configuration directory",	STATICTAG_EDIT_DWORD_LE("000000c4")" size "STATICTAG_EDIT_DWORD_LE("000000c8")},
	{"bound import directory",		STATICTAG_EDIT_DWORD_LE("000000cc")" size "STATICTAG_EDIT_DWORD_LE("000000d0")},
	{"import address table (IAT)",	STATICTAG_EDIT_DWORD_LE("000000d4")" size "STATICTAG_EDIT_DWORD_LE("000000d8")},
	{"delay import descriptor",		STATICTAG_EDIT_DWORD_LE("000000dc")" size "STATICTAG_EDIT_DWORD_LE("000000e0")},
	{"COM+ runtime header",			STATICTAG_EDIT_DWORD_LE("000000e4")" size "STATICTAG_EDIT_DWORD_LE("000000e8")},
	{"reserved (15)",				STATICTAG_EDIT_DWORD_LE("000000ec")" size "STATICTAG_EDIT_DWORD_LE("000000f0")},
	{0, 0}
};

ht_view *htpeheader_init(bounds *b, ht_streamfile *file, ht_format_group *group)
{
	ht_pe_shared_data *pe_shared=(ht_pe_shared_data *)group->get_shared_data();

	FILEOFS h=pe_shared->header_ofs;
	ht_uformat_viewer *v=new ht_uformat_viewer();
	v->init(b, DESC_PE_HEADER, VC_EDIT, file, group);
	register_atom(ATOM_COFF_MACHINES, coff_machines);
	register_atom(ATOM_COFF_CHARACTERISTICS, coff_characteristics);
	register_atom(ATOM_COFF_SECTION_CHARACTERISTICS, coff_section_characteristics);
	register_atom(ATOM_PE_OPTIONAL_MAGICS, pe_optional_magics);
	register_atom(ATOM_PE_SUBSYSTEMS, pe_subsystems);

	ht_mask_sub *s;
	ht_collapsable_sub *cs;
	
	s=new ht_mask_sub();
	s->init(file, 0);
	char info[128];
	sprintf(info, "* PE header at offset %08x", h);
	s->add_mask(info);
	v->insertsub(s);

/* FIXME: */
	bool pe_bigendian = false;
	
	s=new ht_mask_sub();
	s->init(file, 1);
	s->add_staticmask_ptable(pemagic, h, pe_bigendian);
	
/* COFF header */
	s->add_staticmask_ptable(coffheader, h+4, pe_bigendian);
	cs=new ht_collapsable_sub();
	cs->init(file, s, 1, "COFF header", 1);
	v->insertsub(cs);
	
/* optional header */
	s=new ht_mask_sub();
	s->init(file, 2);
	word opt;
	file->seek(h+24);
	file->read(&opt, 2);
	opt = create_host_int(&opt, 2, little_endian);
	switch (opt) {
		case COFF_OPTMAGIC_PE32:
			s->add_staticmask_ptable(pe32header, h+4, pe_bigendian);
			cs=new ht_collapsable_sub();
			cs->init(file, s, 1, "optional header", 1);
			v->insertsub(cs);
			
			s=new ht_mask_sub();
			s->init(file, 3);
			s->add_staticmask_ptable(pe32header_nt, h+4, pe_bigendian);
			cs=new ht_collapsable_sub();
			cs->init(file, s, 1, "optional header: NT fields", 1);
			v->insertsub(cs);
			
			s=new ht_mask_sub();
			s->init(file, 4);
			s->add_staticmask_ptable(pe32header_nt_dirs, h+4, pe_bigendian);
			cs=new ht_collapsable_sub();
			cs->init(file, s, 1, "optional header: directories", 1);
			v->insertsub(cs);
			break;
		default: {
			s->add_staticmask("optional magic                                   "STATICTAG_EDIT_WORD_LE("00000014")" "STATICTAG_DESC_WORD_LE("00000014", ATOM_PE_OPTIONAL_MAGICS_STR), h+4, pe_bigendian);
			s->add_mask("-------------------------------------------------------------------------");
			s->add_mask("Unsupported optional magic ! If you get this message in an original");
			s->add_mask("(unmodified) file, please contact us (see help).");
			cs=new ht_collapsable_sub();
			cs->init(file, s, 1, "optional header", 1);
			v->insertsub(cs);
		}
	}
	
/* section headers */
	
	for (UINT i=0; i<pe_shared->sections.section_count; i++) {
		s=new ht_mask_sub();
		s->init(file, 100+i);
		
		s->add_staticmask_ptable(coff_section, h+24+pe_shared->coffheader.optional_header_size+i*COFF_SIZEOF_SECTION_HEADER, pe_bigendian);

		char nm[9];
		memmove(nm, pe_shared->sections.sections[i].name, 8);
		nm[8]=0;
		
		char t[32];
		sprintf(t, "section header %d: %s", i, nm);
		
		cs=new ht_collapsable_sub();
		cs->init(file, s, 1, t, 1);
	
		v->insertsub(cs);
	}
	return v;
}

format_viewer_if htpeheader_if = {
	htpeheader_init,
	0
};

