/*****************************************************************************/
/*
 *      cw.c  --  CW encoder implementation.
 *	
 *	
 *      Copyright (C) 2004 Günther Montag dl4mge@darc.de 
 *	based on rtty.c by Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*****************************************************************************/

	
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h> 
#include <assert.h>
#include <syslog.h>
#include <string.h>
#include <stdio.h>
#include <sys/io.h>
#include <sys/time.h>
#include <time.h>
#include <sys/ioctl.h>
#include <fcntl.h>

#include "fskl1.h"
#include "fskutil.h"
#include "msg.h"
#include "main.h"
#include "cw.h"


/* --------------------------------------------------------------------- */

#define IDLE_SHIFT_FREQ 10
int lastcwmsg = 0, dotus = 100000, port = 0, pin = TIOCM_RTS;
int elbug_rts, elbug_ok;

/* --------------------------------------------------------------------- */

static struct {
	unsigned int wpm, tone, farnsworth, dtr;
} cwp = { 12, 880, 0, 0};

/* --------------------------------------------------------------------- */

#define NUMTXCHARS 1
#define NUMTXSLOTS 4
/* I take only the first tx slot
    to prevent sending 4 dits instead of one... */

static l1_time_t txtimes[NUMTXSLOTS];
static unsigned char txchars[NUMTXSLOTS];

/* --------------------------------------------------------------------- */

void wait(int us) {
    struct timeval tv;
    tv.tv_sec = 0;
    tv.tv_usec = us;
    select (0, NULL, NULL, NULL, &tv);
}

/* --------------------------------------------------------------------- */

void output_elbug_serial(int ptt)
{
	if (fd_ptt < 0) {
	    printf("no ptt port open for elbug.\n");
	    return;
	}
	if (ioctl(fd_ptt, 
	    ((ptt && !invert_ptt) || (!ptt && invert_ptt)) ? 
	    TIOCMBIS : TIOCMBIC, &pin)) {
	    printf ("ioctl: TIOCMBI[CS]\n");
	    printf ( "serial port pin %d for elbug can not be accessed!\n",
	    pin);
	    return;
	}
	if (pin == TIOCM_RTS) elbug_rts = ptt;
}

/* --------------------------------------------------------------------- */

void elbug_send_dit() {
    if (! elbug_ok) {
	printf("no serial port prepared for elbug\n");
	wait(3000);
	return;
    }
    output_elbug_serial(1);
    wait(dotus);
    output_elbug_serial(0);
    wait(dotus);
}

/* --------------------------------------------------------------------- */

void elbug_send_dah() {
    if (! elbug_ok) {
	printf("no serial port prepared for elbug\n");
	wait(3000);
	return;
    }
    output_elbug_serial(1);
    wait(dotus * 3);
    output_elbug_serial(0);
    wait(dotus);
}

/* --------------------------------------------------------------------- */

void cw_set_params(unsigned int wpm, unsigned int tone, 
    unsigned int farnsworth, unsigned int dtr)
{
	errprintf(SEV_INFO, "cw params: wpm %u, tone %d, %s\n",
		  wpm, tone, farnsworth ? " Farnsworth Spacing." : "");
	if (wpm >= 3 && wpm  <= 100)
		cwp.wpm = wpm;
	if (tone >= 100 && tone <= 2000)
	cwp.tone = tone;
	cwp.dtr = !!dtr;
	cwp.farnsworth = !!farnsworth;
	if (dtr) pin = TIOCM_DTR;
}

/* --------------------------------------------------------------------- */
/*
void *mode_cw_rx(void *dummy)
{
  printf("dummy! sorry, cw rx mode is not yet implemented! See gMFSK!! \n");
}
*/
/* --------------------------------------------------------------------- */

unsigned char morse(char keypress)
{
// encodes cw, still to be stolen... 
//  return (unsigned char)42; 
// test: 42 = 2 + 8 + 32, bin 0101010, looks like morse `s`
  return (unsigned char)0; 
}

/* --------------------------------------------------------------------- */

static unsigned char cw_getcharbits(void)
{
	unsigned char bp;
//	unsigned short ch;
unsigned short dit = 2;     // 2 bits, one dot and one pause, binary: 000010
unsigned short dah = 14;    // 4 bits, 3 dots and one pause,  binary: 001110
unsigned short tune = 1;  // 1 bit, short to react quick in hand-keying
unsigned short pause = 0;   // 1 bit, short to make onset of dah/dit quick 
	for (;;) {
//	    kbd_negack();
	    /*
	     * serial elbug is better than mouse and
	     * gets priority
	     */
	    if (elbug_ok) {
		if ((inb(port + 6) & 128 )) {
		    bp = (unsigned char)dah;
		    break;
		}
		else if ((inb(port + 6) & 16)) {
		    bp = (unsigned char)dit;
	    	    break;
		}
	    }
	    /* 
	     * mouseclicks and -releases cause messages
	     * from hfterm to hfkernel
	     */
	    if (lastcwmsg == HFAPP_MSG_CW_ELBUG_DIT) {
		bp = (unsigned char)dit;
		break;
	    }
	    else if (lastcwmsg == HFAPP_MSG_CW_ELBUG_DAH) {
		bp = (unsigned char)dah;
	    	break;
	    }
	    else if (lastcwmsg == HFAPP_MSG_CW_ELBUG_TUNE) {
		bp = (unsigned char)tune;
	    	break;
	    }
	    else if (lastcwmsg == HFAPP_MSG_CW_ELBUG_PAUSE) {
		bp = (unsigned char)pause;
	    	break; 
	    }
	    else {
		bp = (unsigned char)pause;
	    	break; 
	    }

/* if pause, maybe i want to send with keyboard */
/*  maybe later i will implement this...        */
/*
	    if ((ch = kbd_get()) == KBD_EOF) {
		idlecount++;
		if (idlecount >= eof_ack_start) {
		    //bufprintf(HFAPP_MSG_DATA_STATUS, 
		    //"I kbd_ack() the EOF at %d", idlecount);
		    kbd_ack();
		    return 0xff;
	    } else idlecount = 0; 
		//something to transmit: -> reset of idlecount
	    //bufprintf(HFAPP_MSG_DATA_STATUS, "idlecount: %d", idlecount);
	    ch &= KBD_CHAR;
	    if (ch >= 'a' && ch <= 'z')
		ch -= 'a'-'A';
	    }
	    bp = morse(ch);
	    break;
*/
	}
//	kbd_ack();
	return bp;
}

/* --------------------------------------------------------------------- */

void *mode_cw_tx(void *dummy)
{
	/* duration of 1 dot, i suppose a word has 50 dots */
	/* ---> so i think 1 baud in cw is 50 * wpm / 60   */
	int i = 0, err = 0, pausecount = 0;
	l1_time_t tm_dot, tm_idlepause, newtime;
	unsigned char txchar;
	
	if (name_ptt) {
	    if (! strcmp (name_ptt, "/dev/ttyS0")) {
		    port = 0x3F8;
	    }
	    if (! strcmp (name_ptt, "/dev/ttyS1")) {
		    port = 0x2F8;
	    }
	    if (! strcmp (name_ptt, "/dev/ttyS2")) {
		    port = 0x3E8;
	    }
	    if (! strcmp (name_ptt, "/dev/ttyS3")) {
		    port = 0x2E8;
	    }
	}
	if (! port) {
	    bufprintf(HFAPP_MSG_DATA_STATUS, 
		"CW: No serial port specified for elbug.");
	    printf("CW: No serial port specified for elbug.\n");
	}
	else if ((err = ioperm(port, 8, 1))) {
	    printf("CW: permission problem for serial port %04x: ioperm = %d\n", 
		port, err);
	    printf("This program has to be called with root permissions.\n");
	}
	if (port && (fd_ptt < 0)) {
	    if ((fd_ptt = open(name_ptt, O_RDWR, 0)) < 0) {
		printf("CW: error in opening ptt %s - try another serial port.\n", 
		    name_ptt);
	    } else {
		printf("CW: opened ptt %04x\n for elbug.", port); 
	    } 
	}
	if (port && !err && fd_ptt) {
	    bufprintf(HFAPP_MSG_DATA_STATUS, 
		"CW: serial port %04x prepared for elbug.", port);
	    printf("CW: serial port %04x prepared for elbug.\n",port);
	    elbug_ok = 1;
	}
        dotus = 1000000 / (cwp.wpm * 50 / 60);
	tm_dot = (l1_time_t)dotus;
	tm_idlepause = 100000;
	modefamily = FSK;  /* yeah cw is a kind of fsk, mark = 0! */
       	l1_fsk_clear_requests();
	l1_set_fsk_params(0, cwp.tone);
	
	errprintf(SEV_INFO, "mode: cw tx\n");
	
	printf(
	    "CW TX: %d WPM, %d Hz, 1 dit is %d ms %s\n",
	    cwp.wpm, cwp.tone, dotus / 1000,
	    cwp.farnsworth ? ", Farnsworth Spacing." : "");
	bufprintf(HFAPP_MSG_DATA_STATUS, 
	    "CW TX: %d WPM, %d Hz, 1 dit is %d ms %s\n",
	    cwp.wpm, cwp.tone, dotus / 1000,
	    cwp.farnsworth ? ", Farnsworth Spacing." : "");
	    
	if (elbug_ok) {
	    printf(
		"CW elbug: serial port %04x, output pin %s.\n",
		port, cwp.dtr ? "DTR" : "RTS");
	    bufprintf(HFAPP_MSG_DATA_STATUS, 
		"CW elbug: serial port %04x, output pin %s.\n",
		port, cwp.dtr ? "DTR" : "RTS");
	}	
	memset(txchars, 0xff, sizeof(txchars));
	newtime = txtimes[0] = l1_get_current_time() - 10000000;// + 100000;

	for (i = 1; i < NUMTXSLOTS; i++)
		txtimes[i] = txtimes[i-1] ; //+ tm_dot; //chinc;
	newtime = txtimes[i];
	for (i = 0; i < NUMTXSLOTS; i++)
		l1_fsk_tx_request
		    (txtimes[i], tm_idlepause, 0, 0, i, 0, txchars);
	send_short_msg(HFAPP_MSG_STATE_CW_TX, ERR_NOERR);

	for (;;) {
	    txchar = cw_getcharbits();
	    if(txchar) pausecount = 0;
	    switch (txchar) {
		case 2 :	
		    elbug_send_dit();		    
		    bufprintf(HFAPP_MSG_DATA_MONITOR, ".");
		    break;
		    
		case 14:
		    elbug_send_dah();
		    bufprintf(HFAPP_MSG_DATA_MONITOR, "_");
		    break;		    
	
		case 1:
		    do {
			i = l1_fsk_wait_request();
		    }
		    while (i);
		    errprintf(SEV_INFO, "cwtx: req %d ready\n", i);

		    l1_fsk_tx_request
			(newtime, tm_dot, 0, 0, i, 1, txchars+i);
		    newtime = newtime + (tm_dot);
		    pausecount = 0;
		    bufprintf(HFAPP_MSG_DATA_MONITOR, "-");
		    break;		    
		    
		case 0:
		    if (! pausecount) {
			bufprintf(HFAPP_MSG_DATA_MONITOR, " ");
			pausecount++;
		    }
		    wait(3000);
		    break;
		default :
		    do {
			i = l1_fsk_wait_request();
		    }
		    while (i);
		    errprintf(SEV_INFO, "cwtx: req %d ready\n", i);
		    /* we only use slot 0  */
		    l1_fsk_tx_request
			(newtime, tm_dot, 0, 0, i, 16, txchars+i);
		    newtime = newtime + (tm_idlepause);
		    if (!pausecount) {
		        bufprintf(HFAPP_MSG_DATA_MONITOR, " ");
			pausecount++;
		    }
		    break;
	    }
//		if (txchars[i] != 0xff)
//		    bufprintf(HFAPP_MSG_DATA_MONITOR, 
//			"<%02x >", (txchars[i] >> 1) & 0x1f);
	    if (1) { // (txchars[i]) {
//		errprintf(SEV_INFO, "cwtx: sending %d\n", txchars[i]);
//		bufprintf(HFAPP_MSG_DATA_MONITOR, "%d ", txchars[i]);
	    }
	    
	}
}

/* --------------------------------------------------------------------- */



