/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: munixsite.cpp,v 1.1.1.1.42.1 2004/07/09 01:59:14 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "minisite.h"
#include "munixsite.h"
#include "munixsurf.h"
#include "visuals.h"

Display* CHXUnixSite::zm_display = NULL;

CHXUnixSite::CHXUnixSite(IUnknown* pContext, IUnknown* pUnkOuter, INT32 lZorder)
    :  CMiniBaseSite(pContext, pUnkOuter, lZorder) ,
       m_bIsChildWindow(FALSE)
{
}

CHXUnixSite::~CHXUnixSite()
{
}

void* CHXUnixSite::_Create(void* pParentWindow, UINT32 style)
{
    HRESULT result = HXR_OK;
    if( m_pWindow && m_pWindow->window )
    {
        HX_ASSERT( "We already have created a window"==NULL);
        return NULL;
    }

    if (pParentWindow==NULL || style)
    {
        m_bIsChildWindow = FALSE;
    }
    else
    {
        m_bIsChildWindow = TRUE;
    }

    if( _OpenXDisplay(NULL) != HXR_OK )
    {
        return NULL;
    }
    return (void*)CreateXWindow((Window)pParentWindow);
}

void  CHXUnixSite::_Destroy(HXxWindow* pWindow)
{
    HX_ASSERT( pWindow && pWindow->display && pWindow->window );
    XDestroyWindow( (Display*)pWindow->display, (Window)pWindow->window );
}

void  CHXUnixSite::_SetSize(HXxSize size)
{
    HX_ASSERT( m_pWindow && m_pWindow->display && m_pWindow->window);
    XResizeWindow((Display*) m_pWindow->display,
                  (Window) m_pWindow->window,
                  size.cx,
                  size.cy);
}

void  CHXUnixSite::_SetPosition(HXxPoint position)
{
    HX_ASSERT( m_pWindow && m_pWindow->display && m_pWindow->window);
    XMoveWindow((Display*)m_pWindow->display,
                (Window)m_pWindow->window,
                position.x,
                position.y);
}


//This returns the OS specific window handle, as void*, that the
//pointer is currently in.
BOOL  CHXUnixSite::_MoveWindow(void* pParent ,
                               INT32 X,
                               INT32 Y,
                               INT32 nWidth,
                               INT32 nHeight,
                               BOOL bRepaint)
{   //XXXgfw we still have to do bRepaint....
    HX_ASSERT( m_pWindow && m_pWindow->window && m_pWindow->display);
    XMoveResizeWindow( (Display*)m_pWindow->display,
                       (Window)m_pWindow->window,
                       X,
                       Y,
                       nWidth,
                       nHeight
                       );
    return TRUE;
}

HX_RESULT CHXUnixSite::_OpenXDisplay(char* pszDisplayString)
{
    HX_RESULT retVal = HXR_OK;
    
    //Is the connection open already?
    if( NULL==zm_display )
    {
        zm_display = XOpenDisplay(pszDisplayString);
      
        //If you can't open the display your done.
        if(NULL == zm_display )
        {
            HX_ASSERT("Can't open X Display..."==NULL);
            retVal = HXR_FAIL;
        }
    }
    return retVal;
}

Window CHXUnixSite::CreateXWindow( Window win )
{
   Window     parentWindow;
   HXxWindow* pWindow = NULL;

   //If parentWin is NULL then we belong to the root window.    
   if( win )
   {
      parentWindow = win;
   }
   else
   {
      HX_ASSERT(zm_display);
      parentWindow = RootWindow(zm_display, DefaultScreen(zm_display));
   }
    
   //Find the best visual to use on this display.
   Visual* visual = GetBestVisual(zm_display);

   //Get the visual info.
   int         nNotUsed=0;
   XVisualInfo stVisInfo;
    
   memset(&stVisInfo, 0, sizeof(XVisualInfo));
   stVisInfo.visualid = XVisualIDFromVisual(visual);
   XVisualInfo* pVisual = XGetVisualInfo( zm_display,
                                          VisualIDMask,
                                          &stVisInfo,
                                          &nNotUsed );

   // Set up attributes of the window.
   int                  attrMask = CWBackPixel | CWBorderPixel;
   XSetWindowAttributes attr;
    
   memset(&attr, 0, sizeof(XSetWindowAttributes));
   attr.background_pixel = BlackPixel(zm_display, DefaultScreen(zm_display));
   attr.border_pixel     = BlackPixel(zm_display, DefaultScreen(zm_display));
   
   //See if the default visaul of hte screen is the same one we Want
   //to use. If not, create a new one and install it.
   Colormap cmap;
   Visual*  defVisual = DefaultVisual(zm_display, DefaultScreen(zm_display));
   if( defVisual->visualid != stVisInfo.visualid )
   {
      //XXXgfw Are we leaking this colormap????
      cmap = XCreateColormap(zm_display, parentWindow, visual, AllocNone);
      attr.colormap = cmap;
      attrMask |= CWColormap;
   }

   // Set the size/position of the window before creating.
   XSizeHints size_hints;

   size_hints.flags  = PPosition | PSize;
   size_hints.x      = m_position.x;
   size_hints.y      = m_position.y;
   size_hints.width  = 1;
   size_hints.height = 1;

   //Create it.
   Window window = XCreateWindow(zm_display, 
                                 parentWindow,
                                 size_hints.x,
                                 size_hints.y,
                                 size_hints.width,
                                 size_hints.height, 
                                 0,
                                 pVisual->depth,
                                 InputOutput,
                                 visual,
                                 attrMask,
                                 &attr);

   XFree(pVisual);

   //Tell the WM about this window.
#if 0
   XSetStandardProperties( zm_display,
                           window,
                           "CHXUnixSite",
                           "CHXUnixSite",
                           None,
                           NULL, 0,
                           &size_hints
                           );
#endif

   //Select all input events on the window since the other platforms
   //we work with have no concept of event masks
   int result = XSelectInput( zm_display, window,
                              ButtonPressMask   | ButtonReleaseMask | KeyPressMask    |
                              KeyReleaseMask    | EnterWindowMask   | LeaveWindowMask |
                              PointerMotionMask | ButtonMotionMask  | KeymapStateMask |
                              ExposureMask      | StructureNotifyMask | FocusChangeMask
                              );
   if( BadWindow == result )
   {
#ifdef _DEBUG
      fprintf( stderr, "Can select events.\n" );
#endif      
   }
   
   //Map the window.
   XMapWindow(zm_display, window);

   //Flush event queue.
   XFlush(zm_display);


   return window;
}

void CHXUnixSite::_AttachWindow()
{
   void* pDummy=NULL; 
   
   //Set the display variable.
   if( m_pWindow->display == NULL )
   {
      HX_ASSERT(zm_display);
      m_pWindow->display = zm_display;
   }
   
   //Now that we have a window be sure to init the CUnixRootSurf.
   //this lets it set up the display, colormap, etc.
   ((CMiniUnixSurface*)m_pVideoSurface)->_init();
}
