/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxgerror.h,v 1.1.10.3 2004/07/09 01:48:31 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __HXERROR_H__
#define __HXERROR_H__

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Some people (myself included) may complain about the enum below as being an
   unecessary level of translation. What's wrong with using the error as defined in
   common/include/hxresult.h?
   
   There are several small things that, together, make this extra level of translation appealing:

   - Up to this point, the gtk widget has no dependancies on any of the
     internal core files. You just need the gtk widget headers -- no core
     headers -- to build a player application
   - Many of the errors defined in hxresult.h don't apply to client-based
     applications. By paring down the list, we make things easier for
     application developers.
   - We have to do some sort of forward lookup anyway in order to set the error
     string of the GError.
   - We can put any widget level errors here too without cluttering up hxresult.h
   - We can rename errors to be consistant with the way that other gtk libs name errors
   - 0x80000000-style errors are so... windows ;)  */

/* Naming here is inspired by gconf's error naming */
/* This called hxgerror.{cpp,h} instead of hxerror.{cpp,h} because
   hxerror.h is already claimed by the client core. Since we're
   dealing with GError objects, hxgerror seemed like the next best
   choice. HXGError is ugly and inconsistant, though, so we'll stick
   with HXError for the actual struct name and api */
typedef enum
{
    /* RGG: Stick all the errors under the catch-all of HX_ERROR_GENERAL.
       Someday, if someone asks, I will revisit this and break things
       up a little more. I'm switching our top level client to using a more
       complex error handling structure (reported with "hxerror" signal) so
       that I can get a little more fancy with error "details".
     */
    HX_ERROR_GENERAL            = 0,  // HXR_OK
    
    HX_ERROR_LAST // Not a real error. Used to sanity check reverse error lookups.
        
} HXError;
    
GQuark  hx_error_quark (void);

G_CONST_RETURN gchar*
        hx_error_get_message_from_hxresult(guint hxCode);
    
GError* hx_error_new   (guint        hxCode,
                        guint        userCode,
                        const gchar* pErrorString,
                        const gchar* pUserString,
                        const gchar* pMoreInfoURL);

#define HX_ERROR hx_error_quark ()
    
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
