/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxstatustop.cpp,v 1.10.2.5 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <gtk/gtk.h>

#include "hxstatustop.h"
#include "commonapp.h"

#include "hxplayer.h"
#include "hxplayer-i18n.h"

// Notebook tab id's
#define PROGRESS_BAR_PAGE   0
#define POSITION_FIELD_PAGE 1

#define CONTACTING_PULSE_INTERVAL 500

static void hxstatus_display_top_class_init (HXStatusDisplayTopClass* klass);
static void hxstatus_display_top_init       (HXStatusDisplayTop*      status,
                                             HXStatusDisplayTopClass* klass);

static void hxstatus_display_top_finalize   (GObject* object);

static void hxstatus_display_top_set_player (HXStatusDisplay* status,
                                             HXPlayer* player);

static HXStatusDisplayClass* g_parent_class = NULL;

GType
hxstatus_display_top_get_type (void)
{
    static GType hxstatus_display_top_type = 0;

    if (!hxstatus_display_top_type)
    {
	static const GTypeInfo hxstatus_display_top_info =
	    {
		sizeof (HXStatusDisplayTopClass),
		NULL,		/* base_init */
		NULL,		/* base_finalize */
		(GClassInitFunc) hxstatus_display_top_class_init,
		NULL,		/* class_finalize */
		NULL,		/* class_data */
		sizeof (HXStatusDisplayTop),
		0,		/* n_preallocs */
		(GInstanceInitFunc) hxstatus_display_top_init,
		NULL,           /* value_table */
	    };

	hxstatus_display_top_type = g_type_register_static (HX_TYPE_STATUS_DISPLAY, "HXStatusDisplayTop",
                                                            &hxstatus_display_top_info, (GTypeFlags)0);
    }

    return hxstatus_display_top_type;
}


static void
hxstatus_display_top_class_init (HXStatusDisplayTopClass* klass)
{
    HXStatusDisplayClass* status_class = HX_STATUS_DISPLAY_CLASS(klass);
    GObjectClass* gobject_class = G_OBJECT_CLASS(klass);
    
    g_parent_class = (HXStatusDisplayClass*)g_type_class_peek_parent (klass);

    status_class->set_player = hxstatus_display_top_set_player;
    gobject_class->finalize = hxstatus_display_top_finalize;
}

static void
hxstatus_display_top_init(HXStatusDisplayTop* status, HXStatusDisplayTopClass* /* klass */)
{
    /* Do nothing - struct will be initialized when tlc calls
       hxstatus_display_attach_top */

    status->notebook = NULL;
    status->status_label = NULL;
    status->buffering_progress_bar = NULL;
    status->position_field = NULL;
    status->status_field = NULL;
    status->player_signal_handlers_array = NULL;
    status->player_signal_handlers_array_len = 0;
}

static gboolean
hxstatus_display_top_pulse_contacting(gpointer user_data)
{
    HXContentStateType state;
    HXStatusDisplay* status = HX_STATUS_DISPLAY(user_data);
    HXStatusDisplayTop* status_top = HX_STATUS_DISPLAY_TOP(user_data);

    state = hx_player_get_content_state(status->player);
    if(state != HX_CONTENT_STATE_CONTACTING)
    {
        return FALSE; // remove
    }

    gtk_progress_bar_pulse(GTK_PROGRESS_BAR(status_top->buffering_progress_bar));

    return TRUE;
}


static void
st_contacting(GtkWidget*, const gchar* /* host */, HXStatusDisplayTop* status)
{
    gtk_notebook_set_current_page(GTK_NOTEBOOK(status->notebook),
                                  PROGRESS_BAR_PAGE);

    gtk_timeout_add(CONTACTING_PULSE_INTERVAL,
                    hxstatus_display_top_pulse_contacting,
                    status);    
}


static void
st_buffering(GtkWidget*, HXBufferingReason /* reason */, guint percent, HXStatusDisplayTop* status)
{
    if(percent < 100)
    {
        /* Show progress bar */
        gtk_notebook_set_current_page(GTK_NOTEBOOK(status->notebook),
                                      PROGRESS_BAR_PAGE);
    }
    else
    {
        /* Show counter */
        gtk_notebook_set_current_page(GTK_NOTEBOOK(status->notebook),
                                      POSITION_FIELD_PAGE);
    }
    
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(status->buffering_progress_bar),
                                  (gdouble)percent / 100.0);
}

static void
st_play_stop_pause(GtkWidget*, HXStatusDisplayTop* status)
{
    /* Show counter */
    gtk_notebook_set_current_page(GTK_NOTEBOOK(status->notebook),
                                  POSITION_FIELD_PAGE);
}

static void
propagate_size_request(GtkWidget* /* widget */,
                       GtkRequisition *requisition,
                       GtkWidget* notebook)
{
    gtk_widget_set_size_request(GTK_WIDGET(notebook),
                                requisition->width,
                                requisition->height);
}

GtkWidget*
hxstatus_display_top_new(void)
{
    HXStatusDisplayTop* status = (HXStatusDisplayTop*)g_object_new(HX_TYPE_STATUS_DISPLAY_TOP, NULL);
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *frame;
    
    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
    gtk_container_add(GTK_CONTAINER(status), frame);
    
    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    status->statistics_table = gtk_table_new (1, 2, FALSE);
    gtk_box_pack_start (GTK_BOX (vbox), status->statistics_table, TRUE, TRUE, 0);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

    status->status_field = hxstatus_display_status_field_new();
    gtk_box_pack_start (GTK_BOX (hbox), status->status_field, TRUE, TRUE, 0);

    status->notebook = gtk_notebook_new ();
    gtk_box_pack_start (GTK_BOX (hbox), status->notebook, FALSE, FALSE, 0);
    gtk_widget_set_size_request (status->notebook, 80, -1);
    GTK_WIDGET_UNSET_FLAGS (status->notebook, GTK_CAN_FOCUS);
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK (status->notebook), FALSE);
    gtk_notebook_set_show_border (GTK_NOTEBOOK (status->notebook), FALSE);

    status->buffering_progress_bar = gtk_progress_bar_new ();
    gtk_container_add (GTK_CONTAINER (status->notebook), status->buffering_progress_bar);
    gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (status->notebook), status->buffering_progress_bar,
                                        FALSE, FALSE, GTK_PACK_END);
    
    status->position_field = hxstatus_display_position_field_new();
    gtk_container_add (GTK_CONTAINER (status->notebook), status->position_field);
    GTK_WIDGET_UNSET_FLAGS (status->position_field, GTK_CAN_FOCUS);
    GTK_WIDGET_UNSET_FLAGS (status->position_field, GTK_CAN_DEFAULT);

    // RGG: there's some weirdness with the notebook propagating
    // up a gtk_widget_set_size_request here -- set the signal manually.
    g_signal_connect(G_OBJECT(status->position_field),
                     "size-request",
                     G_CALLBACK(propagate_size_request),
                     status->notebook);
    
    gtk_widget_show_all(frame);

    status->player_signal_handlers_array = g_array_new (FALSE, FALSE, sizeof (gint));    
    
    return GTK_WIDGET(status);
}

GtkWidget*
create_statistics_table(void)
{
    GtkWidget* table;
    
    table = gtk_table_new(1,      // rows
                          3,      // columns
                          FALSE); // homogeneous

    return table;
}

/* Function to hook up status display to player:
 * ============================================
 */

static void
hxstatus_display_top_set_player(HXStatusDisplay* status, HXPlayer* player)
{
    guint i;
    guint signal;
    
    HXStatusDisplayTop* status_top = HX_STATUS_DISPLAY_TOP(status);
    g_return_if_fail(status_top != NULL);    

    static const struct
    {
        const gchar* name;
        GCallback callback;
    } signal_map[] = 
    {
        { "buffering",  G_CALLBACK(st_buffering)       },
        { "contacting", G_CALLBACK(st_contacting)      },
        { "play",       G_CALLBACK(st_play_stop_pause) },
        { "pause",      G_CALLBACK(st_play_stop_pause) },
        { "stop",       G_CALLBACK(st_play_stop_pause) }
    };

    /* Disconnect from the old player, if any */    
    if(status->player)
    {
        for(i = 0; i < status_top->player_signal_handlers_array_len; i++)
        {
            signal = g_array_index(status_top->player_signal_handlers_array, gint, i);
            g_signal_handler_disconnect(G_OBJECT(status->player), signal);
                                        
        }
    }        
    
    status_top->player_signal_handlers_array_len = 0;

    if(player)
    {
        /* Connect the new player */
        for(i = 0; i < sizeof(signal_map) / sizeof(*signal_map); i++)
        {    
            /* Hook up to the new player */
            signal = g_signal_connect(G_OBJECT(player),
                                      signal_map[i].name,
                                      signal_map[i].callback,
                                      status);

            g_array_insert_val(status_top->player_signal_handlers_array,
                               status_top->player_signal_handlers_array_len,
                               signal);
            status_top->player_signal_handlers_array_len++;
        }
    }
    
    /* Propagate to the status display */
    hxstatus_display_set_player(HX_STATUS_DISPLAY(status_top->status_field),
                                player);
    
    hxstatus_display_set_player(HX_STATUS_DISPLAY(status_top->position_field),
                                player);

    /* call the parent class method */
    HX_STATUS_DISPLAY_CLASS(g_parent_class)->set_player(status, player);
}

static void
hxstatus_display_top_finalize(GObject* object)
{
    HXStatusDisplayTop* status = HX_STATUS_DISPLAY_TOP(object);

    G_OBJECT_CLASS(g_parent_class)->finalize(object);
    
    if(status->player_signal_handlers_array)
    {
        g_array_free(status->player_signal_handlers_array, TRUE);
    }

    status->player_signal_handlers_array_len = 0;
}
