/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: auth.cpp,v 1.2.2.3 2004/07/09 01:48:54 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "auth.h"

#include "libgladeemu.h"
#include "commonapp.h"

#include "hxplayer-i18n.h"

typedef struct
{
    GladeXML* xml;
    GtkWidget* username_entry;
    GtkWidget* password_entry;
} HXAuthenticationDialog;

G_CONST_RETURN gchar*
hxplay_authentication_dialog_get_username(GtkDialog* dialog)
{
    HXAuthenticationDialog* info = (HXAuthenticationDialog*)g_object_get_data(G_OBJECT(dialog), "dialog_info");
    if(info)
    {
        if(info->username_entry)
        {
            return gtk_entry_get_text(GTK_ENTRY(info->username_entry));
        }
    }

    return NULL;
}

G_CONST_RETURN gchar*
hxplay_authentication_dialog_get_password(GtkDialog* dialog)
{
    HXAuthenticationDialog* info = (HXAuthenticationDialog*)g_object_get_data(G_OBJECT(dialog), "dialog_info");
    if(info)
    {
        if(info->password_entry)
        {
            return gtk_entry_get_text(GTK_ENTRY(info->password_entry));
        }
    }

    return NULL;    
}

static void
had_destroy(GtkWidget* /* widget */,
            HXAuthenticationDialog* auth)
{
    glade_xml_destroy (auth->xml);

    g_free(auth);
}

GtkDialog*
hxplay_authentication_dialog_new   (HXPlayer*    player,
                                    const gchar* server_proxy,
                                    const gchar* realm,
                                    gboolean     is_proxy_server)
{
    GtkWidget* dialog;
    gchar* filename;
    GtkWidget* server_realm_table;
    GtkWidget* server_proxy_label;
    GtkWidget* server_proxy_text;
    GtkWidget* realm_text;
    gchar* text;
    HXAuthenticationDialog* info;
    GladeXML* xml;
    
    filename = hxcommon_locate_file("auth.glade");
    xml = glade_xml_new (filename, NULL, NULL);
    g_free(filename);
    g_return_val_if_fail(xml != NULL, NULL);

    info = g_new0(HXAuthenticationDialog, 1);
    info->xml = xml;
    
    dialog = glade_xml_get_widget(xml, "hxplayer_auth_dialog");

    info->username_entry = glade_xml_get_widget(info->xml, "had_username");
    info->password_entry = glade_xml_get_widget(info->xml, "had_password");

    g_signal_connect_swapped(G_OBJECT(info->username_entry), "activate",
                             G_CALLBACK(gtk_window_activate_default),
                             dialog);

    g_signal_connect_swapped(G_OBJECT(info->password_entry), "activate",
                             G_CALLBACK(gtk_window_activate_default),
                             dialog);

    g_object_set_data(G_OBJECT(dialog), "dialog_info", info);
    
    server_realm_table = glade_xml_get_widget(xml, "had_server_realm_table");

    server_proxy_label = glade_xml_get_widget(xml, "had_server_proxy_label");
    server_proxy_text = glade_xml_get_widget(xml, "had_server_proxy");
    realm_text = glade_xml_get_widget(xml, "had_realm");

    if(server_proxy && *server_proxy)
    {
        if(is_proxy_server)
        {
            gtk_label_set_text(GTK_LABEL(server_proxy_label), _("Proxy"));
        }
        else
        {
            gtk_label_set_text(GTK_LABEL(server_proxy_label), _("Server"));
        }

        text = g_strdup_printf("<span weight=\"bold\">%s</span>", server_proxy);
        gtk_label_set_markup(GTK_LABEL(server_proxy_text), text);
        g_free(text);

        if(realm && *realm)
        {
            text = g_strdup_printf("<span weight=\"bold\">%s</span>", realm);
            gtk_label_set_markup(GTK_LABEL(realm_text), text);
            g_free(text);
        }
        else
        {
            gtk_label_set_text(GTK_LABEL(realm_text), "");
        }
                             
        gtk_widget_show(server_realm_table);
    }

    g_signal_connect (G_OBJECT (dialog), "destroy",
                      G_CALLBACK (had_destroy),
                      info);
        
    
    return GTK_DIALOG(dialog);
}
