/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 

#include "baseobj.h"

#ifdef _UNIX
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#endif

#ifndef _PCMRENDR_H_
#define _PCMRENDR_H_

/* used for endianness in the pcm header */
#define PN_PCM_LITTLEENDIAN 0
#define PN_PCM_BIGENDIAN    1

/* used for usFormatTag in the pcm header */
#define PN_PCM_TWOS_COMPLEMENT 1
#define PN_PCM_ZERO_OFFSET     2

#ifdef _DEBUG
//#define DEBUG_LOG
#endif


class CPCMRenderer :    public IHXPlugin, 
			public IHXRenderer,
			public IHXInterruptSafe,
			public IHXDryNotification,
			public IHXUpdateProperties,
			public CHXBaseCountingObject
{
private:

    LONG32		m_lRefCount;
    IUnknown*		m_pContext;
    IHXStream*		m_pStream;
    IHXPlayer*		m_pPlayer;
    IHXValues*		m_pHeader;
    IHXPacket*		m_pLastPacket;
    IHXAudioPlayer*    m_pAudioPlayer;
    IHXAudioStream*    m_pAudioStream;
    IHXCommonClassFactory* m_pCommonClassFactory;
    ULONG32		m_ulLastTime;
    ULONG32		m_ulGranularity;
    UINT32              m_ulCurrentTime;
#ifdef DEBUG_LOG
    FILE*		m_pLogFile;
#endif
    int			m_pcmfile;
   
    BOOL		m_bFirstPacket;
    INT32		m_lTimeOffset;
    UINT32		m_ulTrackStartTime;
    UINT32		m_ulTrackEndTime;
    HXAudioFormat	m_audioFmt;

    /* DryNotification */
    BOOL		m_bStreamDry;
    BOOL		m_bPacketsDone;
    UINT8		m_chBufferingCount;

    BOOL		m_bSwapSampleBytes;
    BOOL		m_bZeroOffsetPCM;
    BOOL		m_bIsGapInStreaming;
    BOOL		m_bInSeekMode;
    BOOL		m_bEightBitsPerSample;
    BOOL		m_bIsStereo;

    ULONG32		m_ulSamplesPerSecond;
    ULONG32		m_ulLastEndTime;
    ULONG32		m_ulFudge;
    
    static const char*	zm_pDescription;
    static const char*	zm_pCopyright;
    static const char*	zm_pMoreInfoURL;
    
    static const char*	zm_pStreamMimeTypes[];

    // adjust offset
    UINT32  ConvertMsToBytes(UINT32 ulMs);
    UINT32  ConvertBytesToMs(UINT32 ulBytes);
    BOOL    AdjustAudioData(REF(HXAudioData) audioData);

    ~CPCMRenderer();

    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME


public:
    CPCMRenderer();
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
    static HX_RESULT STDAPICALLTYPE CanUnload2();

    // *** IHXPlugin methods ***

    /************************************************************************
     *	Method:
     *	    IHXPlugin::GetPluginInfo
     *	Purpose:
     *	    Returns the basic information about this plugin. Including:
     *
     *	    bLoadMultiple	whether or not this plugin DLL can be loaded
     *				multiple times. All File Formats must set
     *				this value to TRUE.
     *	    pDescription	which is used in about UIs (can be NULL)
     *	    pCopyright		which is used in about UIs (can be NULL)
     *	    pMoreInfoURL	which is used in about UIs (can be NULL)
     */
    STDMETHOD(GetPluginInfo)	(THIS_
				REF(BOOL)        /*OUT*/ bLoadMultiple,
				REF(const char*) /*OUT*/ pDescription,
				REF(const char*) /*OUT*/ pCopyright,
				REF(const char*) /*OUT*/ pMoreInfoURL,
				REF(ULONG32)	 /*OUT*/ ulVersionNumber
				);

    /************************************************************************
     *	Method:
     *	    IHXPlugin::InitPlugin
     *	Purpose:
     *	    Initializes the plugin for use. This interface must always be
     *	    called before any other method is called. This is primarily needed 
     *	    so that the plugin can have access to the context for creation of
     *	    IHXBuffers and IMalloc.
     */
    STDMETHOD(InitPlugin)   (THIS_
			    IUnknown*   /*IN*/  pContext);

    // *** IUnknown methods ***
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    // *** IHXRenderer methods ***

    /************************************************************************
     *	Method:
     *	    IHXRenderer::GetRendererInfo
     *	Purpose:
     *	    Returns information vital to the instantiation of rendering 
     *	    plugins.
     */
    STDMETHOD(GetRendererInfo)	    (THIS_
				    REF(const char**) /*OUT*/ pStreamMimeTypes,
				    REF(UINT32)      /*OUT*/ unInitialGranularity
				    );

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::StartStream
    //	Purpose:
    //	    Called by client engine to inform the renderer of the stream it
    //	    will be rendering. The stream interface can provide access to
    //	    its source or player. This method also provides access to the 
    //	    primary client controller interface.
    //
    STDMETHOD (StartStream)	(THIS_
				IHXStream*	    pStream,
				IHXPlayer*	    pPlayer);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::EndStream
    //	Purpose:
    //	    Called by client engine to inform the renderer that the stream
    //	    is was rendering is closed.
    //
    STDMETHOD (EndStream)	(THIS);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnHeader
    //	Purpose:
    //		Called by client engine when a header for this renderer is 
    //		available. The header will arrive before any packets.
    //
    STDMETHOD (OnHeader)	(THIS_
				IHXValues*	    pHeader);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPacket
    //	Purpose:
    //	    Called by client engine when a packet for this renderer is 
    //	    due.
    //
    STDMETHOD (OnPacket)	(THIS_
				IHXPacket*	    pPacket,
				LONG32		    lTimeOffset);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnTimeSync
    //	Purpose:
    //	    Called by client engine to inform the renderer of the current
    //	    time relative to the streams synchronized time-line. The 
    //	    renderer should use this time value to update its display or
    //	    render it's stream data accordingly.
    //
    STDMETHOD (OnTimeSync)	(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //	    IHXRenderer::OnPreSeek
    //  Purpose:
    //	    Called by client engine to inform the renderer that a seek is
    //	    about to occur. The render is informed the last time for the 
    //	    stream's time line before the seek, as well as the first new
    //	    time for the stream's time line after the seek will be completed.
    //
    STDMETHOD (OnPreSeek)	(THIS_
				ULONG32		    ulOldTime,
				ULONG32		    ulNewTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPostSeek
    //	Purpose:
    //	    Called by client engine to inform the renderer that a seek has
    //	    just occured. The render is informed the last time for the 
    //	    stream's time line before the seek, as well as the first new
    //	    time for the stream's time line after the seek.
    //
    STDMETHOD (OnPostSeek)	(THIS_
				ULONG32		    ulOldTime,
				ULONG32		    ulNewTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPause
    //	Purpose:
    //	    Called by client engine to inform the renderer that a pause has
    //	    just occured. The render is informed the last time for the 
    //	    stream's time line before the pause.
    //
    STDMETHOD (OnPause)		(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnBegin
    //	Purpose:
    //		Called by client engine to inform the renderer that a begin or
    //		resume has just occured. The render is informed the first time 
    //		for the stream's time line after the resume.
    //
    STDMETHOD (OnBegin)		(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnBuffering
    //	Purpose:
    //		Called by client engine to inform the renderer that buffering
    //		of data is occuring. The render is informed of the reason for
    //		the buffering (start-up of stream, seek has occured, network
    //		congestion, etc.), as well as percentage complete of the 
    //		buffering process.
    //
    STDMETHOD (OnBuffering)	(THIS_
				ULONG32		    ulFlags,
				UINT16		    unPercentComplete);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::GetDisplayType
    //	Purpose:
    //		Called by client engine to ask the renderer for it's preferred
    //		display type. When layout information is not present, the 
    //		renderer will be asked for it's prefered display type. Depending
    //		on the display type a buffer of additional information may be 
    //		needed. This buffer could contain information about preferred
    //		window size.
    //
    STDMETHOD (GetDisplayType)	(THIS_
				REF(HX_DISPLAY_TYPE)	ulFlags,
				REF(IHXBuffer*)	pBuffer);

    /************************************************************************
     *	Method:
     *	    IHXRenderer::OnEndofPackets
     *	Purpose:
     *	    Called by client engine to inform the renderer that all the
     *	    packets have been delivered. However, if the user seeks before
     *	    EndStream() is called, renderer may start getting packets again
     *	    and the client engine will eventually call this function again.
     */
    STDMETHOD(OnEndofPackets)	(THIS);


    /************************************************************************
     *  Method:
     *      IHXDryNotification::OnDryNotification
     *  Purpose:
     *	    This function is called when it is time to write to audio device 
     *	    and there is not enough data in the audio stream. The renderer can
     *	    then decide to add more data to the audio stream. This should be 
     *	    done synchronously within the call to this function.
     *	    It is OK to not write any data. Silence will be played instead.
     */
    STDMETHOD(OnDryNotification) (THIS_
				UINT32 /*IN*/ ulCurrentStreamTime,
				UINT32 /*IN*/ ulMinimumDurationRequired);    

    /*
     *	IHXInterruptSafe methods
     */

    /************************************************************************
     *	Method:
     *	    IHXInterruptSafe::IsInterruptSafe
     *	Purpose:
     *	    This is the function that will be called to determine if
     *	    interrupt time execution is supported.
     */
    STDMETHOD_(BOOL,IsInterruptSafe)	(THIS) 
    					{ return TRUE; };

    /************************************************************************
     *	Method:
     *	    IHXUpdateProperties::UpdatePacketTimeOffset
     *	Purpose:
     *	    Call this method to update the timestamp offset of cached packets
     */
    STDMETHOD(UpdatePacketTimeOffset) (THIS_
				       INT32 lTimeOffset);

    /************************************************************************
     *	Method:
     *	    IHXUpdateProperties::UpdatePlayTimes
     *	Purpose:
     *	    Call this method to update the playtime attributes
     */
    STDMETHOD(UpdatePlayTimes)	      (THIS_
				       IHXValues* pProps);
};


#endif // ndef _PCMRENDR_H_

