/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: txtcntnr.h,v 1.1.2.1 2004/07/09 01:50:15 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  TXTCNTNR.H
//
//  TextContainer class definition.
//
//	A class TextContainer object holds the actual buffer of text to be
//	rendered.
//
//	TextContainerList class definition.
//
//	A class TextContainerList object is a list of TextContainer objects.
//
//

#if !defined(_TXTCNTNR_HPP_)
#define _TXTCNTNR_HPP_


//////////////////////////////////////////////////////////////////////////////
//
//	TextContainer class:
//
class TextContainer : public TextAttributes
{ 
  private: 
    _CHAR* m_pBuffer; 
    //  Holds current size of buffer, including terminating '\0':
    ULONG32 m_textLengthPlus1;
    //Is set to TRUE by appendText() or overwriteText() if they alter
    // the m_pBuffer contents.  If this is TRUE when 
    // RealTextRenderer::OnTimeSynch() is called, then
    // RealTextRenderer::OnTimeSynch() renders the text and sets
    // m_textHasChanged to FALSE:
    BOOL m_textHasChanged;
    BOOL m_bTextShouldBeDrawn;

    //Added this so I can "erase" text only once when
    // it goes out of scope, time-wise:
    BOOL m_bFinalDrawWasDone;

    //These are needed so we can figure out how much looping
    // has occured since the last <CLEAR> tag became effective (NOT when
    // the <CLEAR> was parsed, which could have been earlier):
    ULONG32 m_ulTimeOfLastClearTag;
    LONG32 m_lAmountLoopedSoFar;
	
  public: 
    TextContainer();
    TextContainer(_CHAR* pText, ULONG32 textLen);

    ~TextContainer() { deleteBuffer(); } 
    
    void deleteBuffer(); //is in file "TxtCntnr.cpp"

    _CHAR* getBuffer();
    
    //returns equivalent of: strlen(m_pBuffer)+1:
    ULONG32 getTextLengthPlus1() { return m_textLengthPlus1; }

    BOOL textHasChangedSinceLastDraw() { return m_textHasChanged; }
    void textHasChangedSinceLastDraw(BOOL thc) { m_textHasChanged = thc; }

    BOOL textShouldBeDrawn() { return m_bTextShouldBeDrawn; }
    void textShouldBeDrawn(BOOL tsbr) { m_bTextShouldBeDrawn = tsbr; }

    BOOL appendText(_CHAR* pMoreText, ULONG32 moreTextLen); 

    BOOL overwriteText(_CHAR* pNewText, ULONG32 len);

    //Added these so I can "erase" text only once when it
    // goes out of scope, time-wise:
    BOOL getFinalDrawWasDone() { return m_bFinalDrawWasDone; }
    void setFinalDrawWasDone(BOOL wasDone) { m_bFinalDrawWasDone=wasDone; }

    ULONG32 getTimeOfLastClearTag() { return m_ulTimeOfLastClearTag; }
    void setTimeOfLastClearTag(ULONG32 tlc) { m_ulTimeOfLastClearTag = tlc; }
    LONG32 getAmountLoopedSoFar() { return m_lAmountLoopedSoFar; }
    void setAmountLoopedSoFar(LONG32 l) { m_lAmountLoopedSoFar = l; }

    //This function converts characters from mac-roman to iso-8859-1
    // (us-ascii) or vice versa, depending on both the client operating
    // system and the active charset of *this.  So, if we're rendering on a
    // Macintosh, the following RealText as authored in Windows Notepad
    // would do as it says:
    //	<font charset="iso-8859-1">"" will renderer as an a with an umlaut.
    //		which is 0xE4 in the iso-8859-1 charset.
    //	<font charset="mac-roman">"" will renderer as "per thousand" sign,
    //		which is 0xE4 in the mac-roman charset.
    //
    // This should only be called from the renderer so it doesn't get double-
    // translated which is why the second parameter is mandatory:
    HX_RESULT ConvertNativeCharsetChars(BOOL bRendererIsCallingThis,
				        UINT16 uiMaxSupportedLevel);
};

inline
TextContainer::TextContainer()
{
    m_pBuffer = NULL;
    m_textHasChanged = m_bTextShouldBeDrawn=FALSE;
    m_textLengthPlus1 = 0L;
    m_bFinalDrawWasDone = FALSE;
}

inline
_CHAR* TextContainer::getBuffer()
{
    return (m_pBuffer); 
}


/*////////////////////////////////////////////////////////////////////////////
*
*	TextContainerList class:
*/
class TextContainerList : public CHXSimpleList
{
  public:
    TextContainerList() 
    { 
	m_ulLatestSentTimeToRender = 0L;
	//Changed the following from 0L to MAX LONG:
	m_ulLatestSentTimeToStopRendering = 0xFFFFFFFFL;
    } 
    ~TextContainerList() { flush(); }

    ULONG32 size() { return (GetCount()<0? 0L : (ULONG32)GetCount()); }
    ULONG32 nodeCount() { return (GetCount()<0? 0L : (ULONG32)GetCount()); }

    LISTPOSITION GetStartPosition();
    LISTPOSITION GetEndPosition();

    TextContainer* start();//gets T.C.* at head of list (earliest inserted).
    TextContainer* end(); //gets T.C.* at tail of list (latest).

    /*  Copies data in tc and inserts the copy into the list:  */ 
    BOOL insertAtEndOfList(TextContainer* tc);

    ULONG32 flush();

    //If <CLEAR> tag is sent, effective at m_ulLatestSentTimeToRender, then 
    //	this function is called to change all in this list whose m_endTime
    //	is > m_ulLatestSentTimeToRender;
    //  Returns the number of nodes in the list whose endTimes were 
    //	reduced to t:
    ULONG32 MarkAllForClear(BOOL bIsLiveSource);

    //Function is used by file format so it can delete
    // all in this list except the few that make up the last "line" of text;
    // this keeps the file format from using up more & more memory over time:
    ULONG32 deleteAllTCsUpToLastLine();

    void SetLatestSentTimeToRender(ULONG32 t);
    void SetLatestSentTimeToStopRendering(ULONG32 t);
    ULONG32 GetLatestSentTimeToRender();
    ULONG32 GetLatestSentTimeToStopRendering();

  private:
    ULONG32 m_ulLatestSentTimeToRender;
    ULONG32 m_ulLatestSentTimeToStopRendering;

}; //END class TextContainerList declaration.




#endif
