/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: textprsr.h,v 1.1.2.1 2004/07/09 01:50:15 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  TEXTPRSR.H
//
//
//  class TextParser's methods
//
//

#if !defined(_TEXTPRSR_H_)
#define _TEXTPRSR_H_

//The following is sent by the RT file format to the RT renderer to notify
// it what "parsing" version to use.  This is done via the stream header
// properties "RTMarkupParsing[Major|Minor]Version" (which is a ULONG32).
// This must be
// done so that the ff and the renderer are in sync as far as how they
// deal with new tags, e.g., if the file format ignores a tag it doesn't
// recognize but the renderer is newer and recognizes the tag, the renderer
// should behave as does the ff and ignore the tag otherwise the renderer
// might display the text in a different place than the ff thinks it is
// and the next packet sent by the ff will tell the renderer to draw in
// a place that might overlap the prior packet's text due to this
// discrepancy.
#define DEFAULT_MARKUP_PARSING_MAJOR_VERSION	    0
#define DEFAULT_MARKUP_PARSING_MINOR_VERSION	    1
//Note: 0.1 is beta-1 release and 0.2 is beta-2 release:
// and gold (11/23/1998) is 1.0 release, and bongo Mac is 1.1:
#define REAL_TEXT_MARKUP_PARSING_MAJOR_VERSION	    1
#define REAL_TEXT_MARKUP_PARSING_MINOR_VERSION	    1
//This is the highest content version that the plug-in that links to
// this can handle, e.g., if rtrender has these vals defined as 1.0 and
// gets a stream header property of 2.1, then it will need to auto-
// upgrade because the rt file (or live text) being streamed has an
// author-specified higher content version:
// NOTE: content version 1.3 is supported in RP7-U1 and later.  It
// includes a fix to the scrolling/crawling text position calculations
// that were wrong with very high stream time values, resulting in
// missing text:
#define REAL_TEXT_CONTENT_MAJOR_VERSION		    1
#define REAL_TEXT_CONTENT_MINOR_VERSION		    6

#define REAL_TEXT_MAJOR_VERSION_G2_GOLD_19981123    1
#define REAL_TEXT_MINOR_VERSION_G2_GOLD_19981123    0

#define REAL_TEXT_MAJOR_VERSION_WALLCLOCK_19990120    1
#define REAL_TEXT_MINOR_VERSION_WALLCLOCK_19990120    1

//These, combined, are what is sent as MinRT...version vals to
// force auto-upgrade in older (pre-"version=..."-handling) rtrenders
// that the ff has determined can't deal with the content version:
#define REAL_TEXT_1ST_MAJ_VER_POST_VER_TAG	    1
#define REAL_TEXT_1ST_MNR_VER_POST_VER_TAG	    2

#define REAL_TEXT_MAC_CHARSET_HANDLING_CONTENT_MAJOR_VERSION	1
#define REAL_TEXT_MAC_CHARSET_HANDLING_CONTENT_MINOR_VERSION	2

#define REAL_TEXT_KOREAN_FONT_HANDLING_CONTENT_MAJOR_VERSION	1
#define REAL_TEXT_KOREAN_FONT_HANDLING_CONTENT_MINOR_VERSION	4

#define REAL_TEXT_URL_HANDLING_FIX_PR37146_CONTENT_MAJOR_VERSION 1
#define REAL_TEXT_URL_HANDLING_FIX_PR37146_CONTENT_MINOR_VERSION 5

#define REAL_TEXT_TRANSPARENT_BGCOLOR_MAJOR_VERSION 1
#define REAL_TEXT_TRANSPARENT_BGCOLOR_MINOR_VERSION 6


// Level 1 charsets are: iso-8859-2 through 9 (except 3),
// iso-ir-166 (Thai), johab and hangeul and ksc5601 (Korean):
#define PLAINTEXT_MAX_CHARSET_LEVEL_SUPPORTED	1
// /A max level of 0 means don't support the new charsets (see level 1, above);
#define REALTEXT_MAX_CHARSET_LEVEL_SUPPORTED	0


class TextWindow;    //class is defined in txtwindw.h
class TextLine;	     //class is defined in textline.h

class TextParser
{
  public:

    TextParser(TextWindow* pTxtWin) :
	    m_ulCurrentPacketNum(0L)
	    , m_bIsBeta1Player(FALSE)

    {
	m_pTextWindow = pTxtWin;
    };

    ~TextParser() {};	//Note: m_pTextWindow is not deleted here!

    TextWindow* GetTextWindow() { return m_pTextWindow; }; //can be NULL.

    ULONG32 ParseHeader(void* pData, ULONG32 dataLength,
	    ULONG32 ulRTFileFormatMarkupParsingMajorVersion,
	    ULONG32 ulRTFileFormatMarkupParsingMinorVersion);

    //ulEarliestTimeOfNewData gets set to the time which is the earliest
    // time of the TextLines into which this data is parsed.
    // Return value is HXR_OK if successful and in-bound data was valid:
    HX_RESULT ParseText(void* pData, ULONG32 dataLength, LONG32 lTimeOffset,
	    ULONG32& ulEarliestTimeOfNewData,
	    ULONG32& ulEndTimeOfPacket,
	    BOOL& bDataHasREQUIREDContents,
	    BOOL bFileFormatIsCallingThis=FALSE,
	    ULONG32 ulByteOffsetIntoFile=0L,
	    TextLine** ppFirstTextLineInPkt=NULL
	    );

    static HX_RESULT convertCharsetNameToCharsetULONG32(
	    const char* pszCharsetName,
	    ULONG32 ulCharsetNameLen,
	    UINT16 uiMaxSupportedLevel,
	    ULONG32& ulCharset_retVal /*OUT*/);

    void FindEscapeSequenceChar(_CHAR*& pCurText,
	    ULONG32& ulIndexOfLastCharInTCsBuf,
	    ULONG32& theFollowingSpaceCharIndex,
	    ULONG32& ulIndexOfAmpersand,
	    ULONG32& ulCurCharset);

    void HandleEndTag(_CHAR* pTagContents,
	    ULONG32 tagContentsLen,
	    BOOL& bSomeCharsFoundSinceLastBreakTag,
	    BOOL& bSomeCharsFoundSinceLastPosTag,
	    BOOL& bPosTagFoundSinceLastTextContainer,
	    ULONG32 ulByteOffsetIntoFile,
	    LONG32 indexOfLeftBracket,
	    LONG32 indexOfRightBracket,
	    BOOL bFileFormatIsCallingThis);


    //Added the following to keep track of what
    // packet number we're on (0 means none have arrived yet):
    ULONG32 GetCurrentPacketNum() { return m_ulCurrentPacketNum; }
    void IncrementCurrentPacketNum() {m_ulCurrentPacketNum++;}
    void SetCurrentPacketNum(ULONG32 curNum) {m_ulCurrentPacketNum=curNum;}

    void SetIsBeta1Player(BOOL b) { m_bIsBeta1Player = b; }
    BOOL IsBeta1Player() { return m_bIsBeta1Player; }

  protected:
    TextWindow* m_pTextWindow;

    //Added the following to keep track of what
    // packet number we're on (0 means none have arrived yet):
    ULONG32 m_ulCurrentPacketNum;

    //There are some cases where the file format needs to decide
    // to use the old version of the code if the connected player is
    // Beta-1:
    BOOL    m_bIsBeta1Player;



  private:
	
    TextParser() { ; }; //private so this can't be instantiated.

}; //end class RealTextRenderer.

#endif
