/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: textline.h,v 1.1.2.1 2004/07/09 01:50:15 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  textline.h
//
//  class TextLine defined.
//
//


#if !defined(_TEXTLINE_H_)
#define _TEXTLINE_H_

#define AVG_SIZE_OF_HEADER_PART_OF_PKT		80L
#define IDEAL_SIZE_OF_NONHEADER_PART_OF_PKT	420L
#define MIN_SIZE_OF_NONHEADER_PART_OF_PKT	100L
#define MAX_LIVE_FONT_UNDO_STACK_DEPTH		8

class TextContainer;
class TextAttributes;
class TextLineList;

class TextLine : public TextAttributes
{
  public:
    TextLine(TextLine& refTL);
    
    //This constructor allows us to create a font-attribute only T.L. for
    // keeping track of what the state of the font stacks is right after
    // a </FONT..> tag is seen:
    TextLine(
	    ULONG32 ulStartByteOfFontUndoTagInFile,
	    ULONG32 ulEndByteOfFontUndoTagInFile,
	    ULONG32 ulStartByteOfMatchingFontTagInFile,
	    ULONG32 ulFontPointSize,
	    COLORTYPE ulTextColor,
	    COLORTYPE ulTextBGColor,
	    ULONG32 ulFontCharset,
	    ULONG32 ulFontFace,
	    ULONG32 ulMinorContentVersion,
	    ULONG32 ulMajorContentVersion);

/*XXXEH- 
    //Note: if ulEndByteInFile is 0, this means it's not yet known:
    TextLine(TextContainer& refTC, ULONG32 ulLineNumOfFile,
	    ULONG32 ulStartByteInFile, ULONG32 ulEndByteInFile,
	    ULONG32 ulTimeOfLastCLEAR);
*/
    ~TextLine() {};
    ULONG32 OutputPacketHeaderString(
	    ULONG32 ulDataID,
	    TextWindow* pTextWin,
	    BOOL bStateIsGetPacketSeekBackReadPending,
	    char* pPacketHeaderBuf, ULONG32 packetHeaderBufSize,
	    TextLineList* pFontUndoTagList,
	    ULONG32 ulPacketLen);


    ULONG32 getLineNumOfFile() { return m_ulLineNumOfFile;}
    ULONG32 getStartByteInFile() { return m_ulStartByteInFile;}
    ULONG32 getEndByteInFile() { return m_ulEndByteInFile;}
    ULONG32 getTimeOfLastClear() { return m_ulTimeOfLastClear;}

    void setLineNumOfFile(ULONG32 lineNum) { m_ulLineNumOfFile = lineNum;}
    void setStartByteInFile(ULONG32 startByte) 
	{ m_ulStartByteInFile = startByte;}
    void setEndByteInFile(ULONG32 endByte)
	{ m_ulEndByteInFile = endByte;}
    void setTimeOfLastClear(ULONG32 timeOfLastClr)
 	{ m_ulTimeOfLastClear = timeOfLastClr;}

    //tells if the matching <FONT> tag contained something new over the
    // default vals; if not, special care needs to be taken in
    // TextLine::OutputPacketHeaderString() to make sure a <FONT> tag is
    // output for this's </FONT> and for the previous font info, as well.
    BOOL getSomethingChanged() { return m_bSomethingChanged; }
    void setSomethingChanged(BOOL sc) { m_bSomethingChanged = sc; }

  private:
    TextLine() {}; //this is private so it won't get called.

    ULONG32 m_ulLineNumOfFile;
    ULONG32 m_ulStartByteInFile;
    ULONG32 m_ulEndByteInFile; //if== 0, this means it's not yet known.
    ULONG32 m_ulTimeOfLastClear;

    BOOL m_bSomethingChanged;

  private:
    //XXXEH- this is only used when *this is inserted into the
    // FontUndoTagList; move this variable when that list is done as its
    // own class:
    ULONG32 m_ulStartByteOfMatchingFontTagInFile;
  public:
    ULONG32 getStartByteOfMatchingFontTagInFile()
	{ return m_ulStartByteOfMatchingFontTagInFile; }
    void setStartByteOfMatchingFontTagInFile(ULONG32 ulStartByte)
	{ m_ulStartByteOfMatchingFontTagInFile = ulStartByte; }
};


class TextLineList: public CHXSimpleList
{
  public:
    TextLineList() {}; 
    ~TextLineList() { flush(); }

    ULONG32 size() { return (GetCount()<0? 0L : (ULONG32)GetCount()); }
    ULONG32 nodeCount() { return (GetCount()<0? 0L : (ULONG32)GetCount()); }

    LISTPOSITION GetStartPosition();
    LISTPOSITION GetEndPosition();

    TextLine* start();//gets T.L.* at head of list (earliest inserted).
    TextLine* end(); //gets T.L.* at tail of list (latest).

    //Copies data in tc and inserts the copy into the list:
    BOOL insertAtEndOfList(TextLine* tc);

    //Goes through the list and finds all the TextList objects therein who
    // have a starttime<seekToTime and an endtime>seekToTime and returns
    // the 

    ULONG32 flush();

    //If <CLEAR> tag is sent, effective at ulTimeOfClear, then 
    //	this function is called to change all in this list whose m_endTime
    //	is > ulTimeOfClear;
    //  Returns the number of nodes in the list whose endTimes were 
    //	reduced to t:
    ULONG32 MarkAllForClear(ULONG32 ulTimeOfClear, BOOL bIsLiveSource);

    //Added this so seek() can calculate what to send;
    // returns 0 if there are no active TextLines at ulTime or later,
    // or if error:
    ULONG32 findBoundingStartAndEndBytesOfActiveTextLines(ULONG32 ulTime,
	    ULONG32* p_ulPktStartByte, ULONG32* p_ulPktEndByte,
	    TextLine** ppFirstTextLineInPkt);

    //Added this so GetPacket() can calculate how many
    // bytes need to be read; returns 0 if there are no already-read 
    // TextLines at startByte or later, or if other error:
    ULONG32 makeReasonableSizedPacketFromTextLinesAtStartByte(
	    ULONG32 ulStartByte, ULONG32* p_ulPktEndByte,
	    BOOL* p_bCurPacketHasREQUIREDContents,
	    TextLine** ppFirstTextLineInPkt);

  private:

}; //END class TextLineList declaration.


#endif
