/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: fxpkgmgr.cpp,v 1.1.24.1 2004/07/09 01:51:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxcom.h"
#include "hxplugn.h"
#include "ihxpckts.h"

// pncont
#include "hxslist.h"
#include "hxmap.h"

// pnmisc
#include "unkimp.h"
#include "baseobj.h"

// pxcomlib
#include "pxcmpmgr.h"
#include "rpeffect.h"

// pxrend
#include "fxpkgmgr.h"

// pndebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

BEGIN_INTERFACE_LIST(PXEffectsPackageManager)
END_INTERFACE_LIST

PXEffectsPackageManager::PXEffectsPackageManager()
{
}

PXEffectsPackageManager::~PXEffectsPackageManager()
{
}

HX_RESULT PXEffectsPackageManager::IsEffectPresent(const char* pszPackageName,
                                                   const char* pszEffectName,
                                                   BOOL*       pbPresent)
{
    HX_RESULT retVal = HXR_OK;

    if (pszPackageName && pszEffectName && pbPresent)
    {
        // Set default
        *pbPresent = FALSE;

        // Run through our list of components
        LISTPOSITION pos = m_pComponentList->GetHeadPosition();
        while (pos)
        {
            IUnknown* pUnk = (IUnknown*) m_pComponentList->GetNext(pos);
            if (pUnk)
            {
                IIMFEffect* pFXPackage = NULL;
                retVal                 = pUnk->QueryInterface(IID_IIMFEffect, (void**) &pFXPackage);
                if (SUCCEEDED(retVal))
                {
                    const char*  pszName    = NULL;
                    const char** ppszEffect = NULL;
                    retVal                  = pFXPackage->GetEffectInfo(pszName, ppszEffect);
                    if (SUCCEEDED(retVal))
                    {
                        // Is this the right package?
                        if (!strcmp(pszPackageName, pszName))
                        {
                            // Now loop through the effect names and see if
                            // the effect we want is there
                            while (*ppszEffect)
                            {
                                if (!strcmp(pszEffectName, *ppszEffect))
                                {
                                    *pbPresent = TRUE;
                                    break;
                                }
                                ppszEffect++;
                            }
                        }
                    }
                }
                HX_RELEASE(pFXPackage);

                // If we found it, we can break
                if (SUCCEEDED(retVal) && *pbPresent)
                {
                    break;
                }
            }
            else
            {
                retVal = HXR_FAIL;
            }

            if (FAILED(retVal))
            {
                break;
            }
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

HX_RESULT PXEffectsPackageManager::GetID(IUnknown* pComponent, REF(const char*) rpszID)
{
    HX_RESULT   retVal     = HXR_OK;
    IIMFEffect* pFXPackage = NULL;

    if (pComponent)
    {
        retVal = pComponent->QueryInterface(IID_IIMFEffect, (void**) &pFXPackage);
        if (SUCCEEDED(retVal))
        {
            const char** ppTmp = NULL;
            retVal             = pFXPackage->GetEffectInfo(rpszID, ppTmp);
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    HX_RELEASE(pFXPackage);

    return retVal;
}
