/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: gifvsrc.h,v 1.1.26.1 2004/07/09 01:54:17 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _GIFVSRC_H_
#define _GIFVSRC_H_


class CGIFViewSource :  public CHXBaseCountingObject,
                        public IHXFileResponse,
			public IHXFileViewSource,
			public IHXFileStatResponse
{
private:
    enum ViewState { 
	kStateConstructed,
        kStateInitFilePending,
        kStateReady,
        kStateStatPending,
        kStateReadPending
    };
    
    ViewState			m_state;

    // viewsource stuff
    IHXFileViewSourceResponse* m_pViewSourceResponse;
    SOURCE_TYPE			m_type;
    IHXValues*			m_pViewSourceOptions;

    UINT32			m_ulFileSize;
    UINT32			m_ulModTime;
    BOOL			m_bIsGIF89a;
    // FileFormat...
    IHXFileObject*		m_pFileObject;
    IHXBuffer*			m_pFileBuffer;
    
    // IUnknown Stuff
    IUnknown*			m_pContext;
    LONG32			m_lRefCount;
    IUnknown*			m_pContainer;
    IHXCommonClassFactory*	m_pCommonClassFactory;

    ~CGIFViewSource();
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

    STDMETHOD(CreateInfoBuffer)(THIS_ REF(IHXBuffer*) pBuffer);
    STDMETHOD(ParseGif)(THIS_ REF(CGIFCodec::LogicalScreenDescriptor) m_pLSD);

public:
    CGIFViewSource(IUnknown* pContext, IUnknown* pContainer);

        // *** IUnknown methods ***
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);


    /************************************************************************
     *	Method:
     *	    IHXFileViewSource::InitViewSource
     *	Purpose:
     *	    Called by the user to init before a viewsource.
     */

    STDMETHOD(InitViewSource)	(THIS_
				IHXFileObject* pFileObject,
				IHXFileViewSourceResponse* pResp,
				SOURCE_TYPE sourceType,
				IHXValues* pOptions);

    /************************************************************************
     *	Method:
     *	    IHXFileViewSource::GetHTMLSource
     *	Purpose:
     *	    Called to get source html source.  Return the source
     *	through m_pViewSourceResoponse
     */
    STDMETHOD(GetSource)(THIS);

    /************************************************************************
     *	Method:
     *	    IHXFileViewSource::Close()
     *	Purpose:
     *	    Called to shut things down
     *	Shared with IHXFileFormatObject
     */
    STDMETHOD(Close)		(THIS);


    /************************************************************************
     *	IHXFileResponse
     */
    STDMETHOD(InitDone)          (THIS_ HX_RESULT status);
    STDMETHOD(SeekDone)          (THIS_ HX_RESULT status);
    STDMETHOD(ReadDone)          (THIS_ HX_RESULT status, IHXBuffer *pBuffer);
    STDMETHOD(WriteDone)         (THIS_ HX_RESULT status);
    STDMETHOD(CloseDone)         (THIS_ HX_RESULT status);

    /************************************************************************
     *	IHXFileStatResponse
     */
    STDMETHOD(StatDone)		(THIS_
				 HX_RESULT status,
				 UINT32 ulSize,
				 UINT32 ulCreationTime,
				 UINT32 ulAccessTime,
				 UINT32 ulModificationTime,
				 UINT32 ulMode);

};


#endif // _GIFVSRC_H_
