/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: gifcodec.h,v 1.1.26.1 2004/07/09 01:54:26 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CGIFCODEC_H
#define _CGIFCODEC_H

class CGIFCodec : public CHXBaseCountingObject,
                  public CUnknownIMP
{
    DECLARE_UNKNOWN(CGIFCodec)
public:
    enum
    {
        kImageDescriptor                   = 0x2C,
        kTrailer                           = 0x3B,
        kExtension                         = 0x21,
        kGraphicControlExtension           = 0xF9,
        kApplicationExtension              = 0xFF,
        kCommentExtension                  = 0xFE,
        kPlainTextExtension                = 0x01
    };

    struct LogicalScreenDescriptor
    {
        UINT32 m_ulLogicalScreenWidth;
        UINT32 m_ulLogicalScreenHeight;
        BOOL   m_bGlobalColorTablePresent;
        UINT32 m_ulOriginalColorBits;
        BOOL   m_bColorsSorted;
        UINT32 m_ulColorTableBits;
        UINT32 m_ulColorTableNumEntries;
        UINT32 m_ulBackgroundColorIndex;
        UINT32 m_ulPixelAspectRatio;
        float  m_fPixelAspectRatio;
    };

    CGIFCodec();
    virtual ~CGIFCodec();

    static UINT32 GetMaxNumPackets(BYTE* pBuf, UINT32 ulLen);
    HX_RESULT    InitParseWireFormat(BYTE *pBuffer, UINT32 ulLen);
    UINT32       GetDelayTime(UINT32 i);
    UINT32       GetImageDataSize(UINT32 i);
    HX_RESULT    GetPacketBufferLength(UINT32 &rulLen);
    HX_RESULT    GetPacketBuffer(BYTE *pBuffer, UINT32 ulLen, BOOL &rbFirstInImage);
    void         TermParse();

    HX_RESULT    InitDecompress(BYTE *pBuffer, UINT32 ulLen);
    HX_RESULT    Decompress(BYTE *pBuffer, UINT32 ulLen, BOOL bNewImage);
    HX_RESULT    GetIndexImage(INT32 lCurIndex, UINT32 ulImgIndex, BYTE *pBuffer, UINT32 ulWidth, UINT32 ulHeight,
                               UINT32 ulPadWidth, BOOL bRowsInverted);
    HX_RESULT    GetRGBImage(INT32 lCurIndex, UINT32 ulImgIndex, BYTE *pBuffer, UINT32 ulWidth, UINT32 ulHeight, UINT32 ulPadWidth,
                             UINT32 ulBytesPerPixel, BOOL bRowsInverted, BOOL bRGBOrdering, BYTE ucBackRed, BYTE ucBackGreen, BYTE ucBackBlue,
                             BYTE ucBackAlpha = 0);
    HX_RESULT    GetRGBImageEx(INT32 lCurIndex, UINT32 ulImgIndex, BYTE *pBuffer, UINT32 ulWidth, UINT32 ulHeight,
                               UINT32 ulPadWidth, UINT32 ulBytesPerPixel, BOOL bRowsInverted, BOOL bRGBOrdering,
                               UINT32 ulBgColor, BOOL bMediaOpacity, UINT32 ulMediaOpacity,
                               BOOL bChromaKey, UINT32 ulChromaKey, UINT32 ulChromaKeyTol, UINT32 ulChromaKeyOpacity);
    HX_RESULT    GetRGB32(UINT32 ulImageNum, BYTE *pBuffer, UINT32 ulRowStride, BOOL bRowsInverted);
    void         PacketLost();
    void         TermDecompress();

    BOOL         LocalColorMapsPresent();

    BOOL         IsGIF89a()                              { return m_bIsGIF89a; }
    UINT32       GetNumImages()                          { return m_ulNumImages; }
    CGIFImage   *GetImage(UINT32 i)                      { return (i < m_ulNumImages ? &m_pImage[i] : NULL); }
    UINT32       GetLogicalScreenWidth()                 { return m_cLSD.m_ulLogicalScreenWidth; }
    UINT32       GetLogicalScreenHeight()                { return m_cLSD.m_ulLogicalScreenHeight; }
    UINT32       GetDelayTimeSum()                       { return m_ulDelayTimeSum; }
    UINT32       GetLoopCount()                          { return m_ulLoopCount; }
    BOOL         DecompressFinished()                    { return (m_ulState == kStateDecoFinished ? TRUE : FALSE);  }
    BOOL         ParseFinished()                         { return (m_ulParseState == kStateParseFinished ? TRUE : FALSE);  }
    BOOL         GetValid()                              { return m_bValid; }
    void         SetValid(BOOL bValid)                   { m_bValid = bValid; }
    BOOL         GetNeedPacket()                         { return m_bNeedPacket; }
    void         SetNeedPacket(BOOL bNeed)               { m_bNeedPacket = bNeed; }

    static void  ParseLogicalScreenDescriptor(BYTE *pBuffer, LogicalScreenDescriptor &cLSD);

    // Methods common to both parsing and decompression
    static void  SkipBlocks(BYTE * &pBuffer, BYTE* pBufLimit = NULL);
protected:
    enum
    {
        kStateConstructed      = 0,
        kStateDecoInitialized  = 1,
        kStateDecoInProgress   = 2,
        kStateDecoFinished     = 3,
        kStateParseInitialized = 1,
        kStateParseInProgress  = 2,
        kStateParseFinished    = 3,
        kIdealPacketSize       = 480,
        kMinimumPacketSize     = 320
    };

    struct ParseSegment
    {
        BYTE  *pMark;
        UINT32 ulSize;
    };

    // Members common to both parsing and decompression
    UINT32                  m_ulNumImages;
    UINT32                  m_ulLoopCount;

    // Member variables for wire format parsing
    UINT32                  m_ulParseState;
    BYTE                   *m_pParseBuffer;
    UINT32                  m_ulParseBufferLength;
    ParseSegment           *m_pSegment;
    UINT32                  m_ulDelayTimeSum;
    UINT32                  m_ulNumSegmentsAllocated;
    UINT32                  m_ulNumSegments;
    UINT32                  m_ulCurSegIndex;
    UINT32                  m_ulCurSegOffset;

    // Members for decompression
    LogicalScreenDescriptor m_cLSD;
    BOOL                    m_bIsGIF89a;
    BYTE                   *m_pucGlobalColorMap;
    UINT32                 *m_pImageHeaderSize;
    UINT32                 *m_pCompressedBufferSize;
    CGIFImage              *m_pImage;
    UINT32                  m_ulCurrentImageIndex;
    BOOL                    m_bNeedPacket;
    UINT32                  m_ulState;
    BOOL                    m_bValid;

    // Common member methods
    void ParseApplicationExtension(BYTE * &pBuf);

    // Member functions for parsing
    void          ResetParse();
    UINT32        ComputeLZWDataSize(BYTE *pLZW);
    inline void Pack32(UINT32 ulValue, UINT8 *pData)
    {
        pData[0] = (UINT8) ((ulValue >> 24) & 0x000000FF);
        pData[1] = (UINT8) ((ulValue >> 16) & 0x000000FF);
        pData[2] = (UINT8) ((ulValue >>  8) & 0x000000FF);
        pData[3] = (UINT8) ( ulValue        & 0x000000FF);
    };
    inline void Pack16(UINT16 usValue, UINT8 *pData)
    {
        pData[0] = (UINT8) ((usValue >> 8) & 0x00FF);
        pData[1] = (UINT8) ( usValue       & 0x00FF);
    };

    // Member functions for decompressing
    void          ResetDecompress();
    HX_RESULT     ParseContainerHeader(BYTE * &pBuffer);
    INT32         ComputeStartingImageIndex(INT32 lCurIndex, INT32 lDesiredIndex);
    inline UINT32 UnPack32(BYTE *pBuf)
    {
        return (pBuf[0] << 24) | (pBuf[1] << 16) | (pBuf[2] << 8) | pBuf[3];
    };
    inline UINT16 UnPack16(BYTE *pBuf)
    {
        return (UINT16) ((pBuf[0] << 8) | pBuf[1]);
    };
};

#define GIF_RENDERER_FLAG_PARSEFAILED  1

#endif
