/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: parserp.cpp,v 1.1.26.1 2004/07/09 01:54:43 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#define INITGUID

// include
#include "hxtypes.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "ihxpckts.h"
#include "hxxml.h"
#include "hxxrsmg.h"
#include "hxerror.h"

// hxmisc
#include "baseobj.h"
#include "unkimp.h"

// hxcont
#include "hxstring.h"
#include "hxmap.h"
#include "hxslist.h"
#include "hxbuffer.h"

// pxcomlib
#include "pxslist.h"
#include "pxmap.h"
#include "pxcolor.h"
#include "pxrect.h"
#include "pxeffect.h"
#include "rpfile.h"
#include "rpparser.h"
#include "pxcontxt.h"

void main(int argc, char** argv)
{
    // Check args
    if (argc < 2 || argc > 3)
    {
        fprintf(stdout, "Usage: parserp foo.rp [strictness]\n");
        exit(0);
    }

    // Open the file
    FILE *fp = fopen(argv[1], "rb");
    if (!fp)
    {
        fprintf(stdout, "Cannot open %s.\n", argv[1]);
        exit(0);
    }

    UINT32 ulStrictLevel = REALPIX_STRICTNESS_HIGH;
    if (argc == 3)
    {
	ulStrictLevel = (UINT32) atoi(argv[2]);
    }

    // Get the size of the file
    fseek(fp, 0, SEEK_END);
    UINT32 ulSize = (UINT32) ftell(fp);
    fseek(fp, 0, SEEK_SET);

    // Create the test context
    PXTestContext* pContext = NULL;
    HX_RESULT      retVal   = PXTestContext::CreateObject(&pContext);
    if (SUCCEEDED(retVal))
    {
        // Get an IUnknown interface from the context
        IUnknown* pUnknown = NULL;
        retVal             = pContext->QueryInterface(IID_IUnknown,
                                                      (void**) &pUnknown);
        if (SUCCEEDED(retVal))
        {
            // Get an IHXBuffer object to hold the file
            IHXBuffer* pBuffer = NULL;
            retVal              = pContext->CreateInstance(CLSID_IHXBuffer,
                                                           (void**) &pBuffer);
            if (SUCCEEDED(retVal))
            {
                // Set the size of the buffer
                retVal = pBuffer->SetSize(ulSize);
                if (SUCCEEDED(retVal))
                {
                    // Read the file into the buffer
                    fread(pBuffer->GetBuffer(), 1, ulSize, fp);

                    // Create a PXRealPixFile object
                    PXRealPixFile* pRealPixFile = NULL;
                    retVal = PXRealPixFile::CreateObject(&pRealPixFile);
                    if (SUCCEEDED(retVal))
                    {
                        // AddRef the object
                        pRealPixFile->AddRef();

                        // Create a PXRealPixParser object
                        PXRealPixParser* pRealPixParser = NULL;
                        retVal = PXRealPixParser::CreateObject(&pRealPixParser);
                        if (SUCCEEDED(retVal))
                        {
                            // AddRef the object
                            pRealPixParser->AddRef();

                            // Init the parser
                            retVal = pRealPixParser->Init(pUnknown, pRealPixFile, ulStrictLevel);
                            if (SUCCEEDED(retVal))
                            {
                                // Parse the file
                                IHXBuffer* pError = NULL;
                                retVal             = pRealPixParser->Parse(pBuffer,   // the .rp file
                                                                           TRUE,      // bIsFinal == TRUE
                                                                           pError);   // output error string
                                if (SUCCEEDED(retVal))
                                {
                                    fprintf(stdout, "%s parsed successfully.\n", argv[1]);
                                }
                                else
                                {
                                    fprintf(stdout, "Error parsing %s: %s\n", argv[1], (const char*) pError->GetBuffer());
                                }
                            }
                        }
                        HX_RELEASE(pRealPixParser);
                    }
                    HX_RELEASE(pRealPixFile);
                }
            }
            HX_RELEASE(pBuffer);
        }
        HX_RELEASE(pUnknown);
    }

    // Close the file
    fclose(fp);
}
