/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxcallbk.cpp,v 1.1.26.1 2004/07/09 01:54:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxcom.h"
#include "hxengin.h"

// pxcomlib
#include "pxcallbk.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

PXCallback::PXCallback(UINT32 ulInstance)
{
    m_lRefCount            = 0;
    m_pScheduler           = NULL;
    m_pResponse            = NULL;
    m_ulCallbackHandle     = 0;
    m_bCallbackPending     = FALSE;
    m_bReportSchedulerTime = TRUE;
    m_ulTimeDelta          = 0;
    m_ulInstance           = ulInstance;
}

PXCallback::~PXCallback()
{
    Deallocate();
}

STDMETHODIMP PXCallback::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (IsEqualIID(riid, IID_IUnknown))
    {
        AddRef();
        *ppvObj = (IUnknown*) this;
    }
    else if (IsEqualIID(riid, IID_IHXCallback))
    {
        AddRef();
        *ppvObj = (IHXCallback*) this;
    }
    else
    {
        *ppvObj = NULL;
        retVal  = HXR_NOINTERFACE;
    }

    return retVal;
}

STDMETHODIMP_(UINT32) PXCallback::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(UINT32) PXCallback::Release()
{
    
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;

    return 0;
}

STDMETHODIMP PXCallback::Func()
{
    HX_RESULT retVal = HXR_UNEXPECTED;

    if (m_pScheduler && m_pResponse)
    {
        // Compute time in milliseconds
        HXTimeval cTime  = m_pScheduler->GetCurrentSchedulerTime();
        UINT32     ulTime = (cTime.tv_sec * 1000) + ((cTime.tv_usec + 500) / 1000);
        if (!m_bReportSchedulerTime)
        {
            ulTime -= m_ulTimeDelta;
        }
        // Clear the pending callback flag
        m_bCallbackPending = FALSE;
        m_ulCallbackHandle = 0;
        // Call back to the response interface
        retVal = m_pResponse->HandleCallback(ulTime, m_ulInstance);
    }

    return retVal;
}

HX_RESULT PXCallback::Init(IUnknown* pContext, PXCallbackResponse* pResponse,
                           BOOL bReportSchedulerTime, UINT32 ulCurrentTime)
{
    HX_RESULT retVal = HXR_OK;

    if (pContext && pResponse)
    {
        // Clear out everything if necessary
        Deallocate();
        // Init members
        retVal = pContext->QueryInterface(IID_IHXScheduler,
                                          (void**) &m_pScheduler);
        if (SUCCEEDED(retVal))
        {
            m_pResponse            = pResponse;
            m_ulCallbackHandle     = 0;
            m_bCallbackPending     = FALSE;
            m_bReportSchedulerTime = bReportSchedulerTime;
            m_pResponse->AddRef();

            if (!m_bReportSchedulerTime)
            {
                // If the caller says NOT to report scheduler time, then the 
                // caller should have provided a current time for us to use.
                // Therefore, we need to compute the delta between the scheduler time
                // and the caller's current time.
                //
                // Compute the current scheduler time
                HXTimeval cTime  = m_pScheduler->GetCurrentSchedulerTime();
                UINT32     ulTime = (cTime.tv_sec * 1000) + ((cTime.tv_usec + 500) / 1000);
                // Compute the delta between the current scheduler time and the caller's current time
                m_ulTimeDelta = ulTime - ulCurrentTime;
            }
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

HX_RESULT PXCallback::ScheduleRelativeCallback(UINT32 ulTimeFromNow)
{
    HX_RESULT retVal = HXR_OK;

    if (m_pScheduler)
    {
        // Remove any pending callback
        RemovePendingCallback();
        // Schedule a callback for ulTimeFromNow milliseconds from now
        m_ulCallbackHandle = m_pScheduler->RelativeEnter(this, ulTimeFromNow);
        // Set the callback flag
        m_bCallbackPending = TRUE;
    }
    else
    {
        retVal = HXR_UNEXPECTED;
    }

    return retVal;
}

HX_RESULT PXCallback::ScheduleAbsoluteCallback(HXTimeval cTime)
{
    HX_RESULT retVal = HXR_OK;

    if (m_pScheduler)
    {
        // Remove any pending callback
        RemovePendingCallback();
        // Schedule a callback for ulTimeFromNow milliseconds from now
        m_ulCallbackHandle = m_pScheduler->AbsoluteEnter(this, cTime);
        // Set the callback flag
        m_bCallbackPending = TRUE;
    }
    else
    {
        retVal = HXR_UNEXPECTED;
    }

    return retVal;
}

void PXCallback::Deallocate()
{
    if (IsCallbackPending())
    {
        RemovePendingCallback();
    }
    HX_RELEASE(m_pScheduler);
    HX_RELEASE(m_pResponse);
}
