/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rpcodec.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _IMF_CODEC_H
#define _IMF_CODEC_H

typedef _INTERFACE IIMFCodecParse          IIMFCodecParse;
typedef _INTERFACE IIMFCodecParseResponse  IIMFCodecParseResponse;
typedef _INTERFACE IIMFCodecRender         IIMFCodecRender;
typedef _INTERFACE IIMFCodecRenderResponse IIMFCodecRenderResponse;

/****************************************************************************
 *
 *  Explanation of IIMFCodecParse/IIMFCodecParseResponse protocol
 *
 *  1. File Format calls IIMFCodecParse::GetCodecInfo() at initialization
 *     time in order to find out what codecs are present and what
 *     image formats can be handled.
 *  2. File Format calls IIMFCodecParse::OpenParse() once at the beginning of
 *     the presentation.
 *  3. File Format calls IIMFCodecParse::CalculateDataSize() to get the codec
 *     to calculate the amount of data which will be sent for a given file.
 *  4. For each image that is scheduled to be parsed:
 *     a) FileFormat calls IIMFCodecParse::StartImageParse()
 *     b) Codec calls IIMFCodecParseResponse::StartImageParseDone()
 *     c) File Format calls IIMFCodecParse::ParseImageData()
 *     d) Codec calls IIMFCodecParseResponse::ParseImageDataDone().
 *     e) If the bLastPacket parameter of ParseImageDataDone() is
 *        FALSE, then the File Format goes to 3(c);
 *        Else, the FileFormat calls IIMFCodecParse::FinishImageParse().
 *     f) Codec calls IIMFCodecParseResponse::ImageParseFinished().
 *  5. At the end of the presentation, File Format calls
 *     IIMFCodecParse::CloseParse().
 *
 ****************************************************************************/

 /****************************************************************************
 *
 *  Interface:          IIMFCodecParse
 *
 *  Purpose:            IMF Codec Parse Interface
 *
 *  IID_IIMFCodecParse: {65583BC1-44AC-11d1-A8BC-00A0C90826B9}
 *
 ****************************************************************************/

DEFINE_GUID(IID_IIMFCodecParse, 0x65583bc1, 0x44ac, 0x11d1, 0xa8, 0xbc, 0x0,
            0xa0, 0xc9, 0x8, 0x26, 0xb9);

#define CLSID_IIMFCodecParse IID_IIMFCodecParse

#undef  INTERFACE
#define INTERFACE       IIMFCodecParse

DECLARE_INTERFACE_(IIMFCodecParse, IUnknown)
{
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void **ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)  (THIS) PURE;

    STDMETHOD_(ULONG32,Release) (THIS) PURE;

    /*
     * This method is used to determine what kinds of images this
     * codec supports. The file format plug-in uses the file extensions strings
     * and the render plug-in uses the mime-types strings
     */
    STDMETHOD(GetCodecInfo) (THIS_ REF(const char **) /*OUT*/ ppszFileExtensions,
                                   REF(const char  *) /*OUT*/ ppszCodecMimeType,
                                   REF(const char  *) /*OUT*/ pszCodecASMRules) PURE;

    /*
     * Methods called by FileFormat Plugin
     */

    /*
     * OpenParse() should be called once for the entire IMF presentation. This method
     * sets up several things needed for parsing:
     *
     * 1) Pointer to the .imf IHXFileObject (needed for IHXFileSystemManager::GetRelativeFileObject)
     * 2) Pointer to the IIMFCodecResponse interface
     * 3) String containing all the ASM rules for this presentation.
     *
     * This method is synchronous - an asynchronous response is not necessary.
     */
    STDMETHOD(OpenParse) (THIS_ IHXFileObject *         /*IN*/ pIMFFileObject,
                                IIMFCodecParseResponse * /*IN*/ pCodecResponse,
                                const char *             /*IN*/ pszASMRuleBook) PURE;

    /*
     * CloseParse() should be called once for the entire IMF presentation. This method
     * informs the codec that it can release the interface pointers it addref'd
     * in OpenParse().
     *
     * This method is synchronous - an asynchronous response is not necessary.
     */
    STDMETHOD(CloseParse) (THIS) PURE;

    /*
     * CalculateDataSize() is called once for every image file in an .imf file.
     * 
     * Note that this is called independent of StartImageParse() and any interfaces
     * AddRef'd during CalculateDataSize() should be released after calling
     * DataSizeCalculated().
     */
    STDMETHOD(CalculateDataSize) (THIS_ const char * /*IN*/ pszFileName,
                                        UINT32       /*IN*/ ulDisplayWidth,
                                        UINT32       /*IN*/ ulDisplayHeight) PURE;

    /*
     * StartImageParse() is called once for every image file in an .imf file and
     * it initiates the parsing of a particular image file.
     *
     * This method is asynchronous and the response to this call is StartImageParseDone()
     * in IIMFCodecResponse. An asynchronous reponse is necessary since StartImageParse()
     * will cause the codec to initiate an asynchronous chain of file I/O calls.
     */
    STDMETHOD(StartImageParse) (THIS_ const char * /*IN*/ pszFileName,
                                      ULONG32      /*IN*/ ulFileSize) PURE;

    /*
     * ParseImageData() will be called once a StartImageParseDone() is received from
     * the codec with a successful status. ParseImageData() will also be called at
     * every IHXFileFormatObject::GetPacket() call.
     *
     * This call is asynchronous, and the response is ParseImageDataReady() in
     * IIMFCodecResponse. ParseImageDataReady() returns a packet with everything filled
     * out in the IHXPacket object except the timestamp. The Codec cannot fill out
     * the timestamp since it has no knowledge of the overall presentation, just this image.
     */
    STDMETHOD(ParseImageData) (THIS) PURE;

    /*
     * After seeing that the bLastPacket parameter of IIMFCodecResponse::ParseImageDataReady()
     * is TRUE, it is the job of the FileFormat plugin to call FinishImageParse().
     * This allows the Codec to free up any resources allocated during the parse
     * of a particular image. The Codec will respond asynchronously with
     * IIMFCodecResponse::ImageParseFinished().
     */
    STDMETHOD(FinishImageParse) (THIS) PURE;
};

/****************************************************************************
 *
 *  Interface:                  IIMFCodecParseResponse
 *
 *  Purpose:                    IMF Codec Parse Response Interface
 *
 *  IID_IIMFCodecParseResponse: {981FEC20-4584-11D1-B006-00A0243C2E90}
 *
 ****************************************************************************/

DEFINE_GUID(IID_IIMFCodecParseResponse, 0x981fec20, 0x4584, 0x11d1, 0xb0, 0x6,  0x0,
            0xa0, 0x24, 0x3c, 0x2e, 0x90);

#define CLSID_IIMFCodecParseResponse IID_IIMFCodecParseResponse

#undef  INTERFACE
#define INTERFACE IIMFCodecParseResponse

DECLARE_INTERFACE_(IIMFCodecParseResponse, IUnknown)
{
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void **ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)  (THIS) PURE;

    STDMETHOD_(ULONG32,Release) (THIS) PURE;

    /*
     * IIMFCodecParseResponse methods
     */

    /*
     * DataSizeCalculated() is the asynchronous response to
     * IIMFCodecParse::CalcualteDataSize(). It informs the calling
     * interface the size of the data to be transmitted for the
     * specified image filename given in CalculateDataSize.
     */
    STDMETHOD(DataSizeCalculated) (THIS_ HX_RESULT status, UINT32 ulDataSize) PURE;

    /*
     * StartImageParseDone() is the async response to StartImageParse()
     */
    STDMETHOD(StartImageParseDone) (THIS_ HX_RESULT status) PURE;

    /*
     * ParseImageDataReady is the async response to ParseImageData().
     * The flag bLastPacket is TRUE if the codec has determined that
     * this packet is the last packet to be parsed in this image.
     */
    STDMETHOD(ParseImageDataReady) (THIS_ HX_RESULT   status,
                                          IHXPacket *pPacket,
                                          BOOL        bLastPacket) PURE;

    /*
     * ImageParseFinished() is the asynchronous response to
     * IIMFCodec::FinishImageParse(). It informs the File Format plugin
     * that the codec has successfully released all resources allocated
     * during the parse of a particular image.
     */
    STDMETHOD(ImageParseFinished) (THIS_ HX_RESULT status) PURE;

};

/****************************************************************************
 *
 *  Interface:           IIMFCodecRender
 *
 *  Purpose:             IMF Codec Render Interface
 *
 *  IID_IIMFCodecRender: {1FEA07F1-97FC-11d1-AF1B-0060082083F9}
 *
 ****************************************************************************/

DEFINE_GUID(IID_IIMFCodecRender, 0x1fea07f1, 0x97fc, 0x11d1, 0xaf, 0x1b,
            0x0, 0x60, 0x8, 0x20, 0x83, 0xf9);

#define CLSID_IIMFCodecRender IID_IIMFCodecRender

#undef  INTERFACE
#define INTERFACE       IIMFCodecRender

DECLARE_INTERFACE_(IIMFCodecRender, IUnknown)
{
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void **ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)  (THIS) PURE;

    STDMETHOD_(ULONG32,Release) (THIS) PURE;

    /*
     * IIMFCodecRender Methods
     */
    STDMETHOD(GetCodecRenderInfo)  (THIS_ REF(const char *) pszFileMimeType) PURE;

    STDMETHOD(OpenRender)          (THIS) PURE;

    STDMETHOD(InitRender)          (THIS_ UINT32     ulCompressedBufferLength,
                                          REF(INT32) rlSessionHandle) PURE;

    STDMETHOD(ParseHeader)         (THIS_ INT32       lSessionHandle,
                                          IHXPacket *pPacket,
                                          IHXValues *pValues) PURE;

    STDMETHOD(SetOutputParameters) (THIS_ INT32       lSessionHandle,
                                          BYTE       *pImageBuffer,
                                          UINT32      ulImageBufferSize,
                                          UINT32      ulPadWidth) PURE;

    STDMETHOD(OnPacket)            (THIS_ INT32       lSessionHandle,
                                          IHXPacket *pPacket) PURE;

    STDMETHOD(ValidateImage)       (THIS_ INT32 lSessionHandle) PURE;

    STDMETHOD(TermRender)          (THIS_ INT32 lSessionHandle) PURE;

    STDMETHOD(CloseRender)         (THIS) PURE;
};

#endif

