package networkwatcher

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// NetworkWatchersClient is the the Microsoft Azure Network management API
// provides a RESTful set of web services that interact with Microsoft Azure
// Networks service to manage your network resources. The API has entities that
// capture the relationship between an end user and the Microsoft Azure
// Networks service.
type NetworkWatchersClient struct {
	ManagementClient
}

// NewNetworkWatchersClient creates an instance of the NetworkWatchersClient
// client.
func NewNetworkWatchersClient(subscriptionID string) NetworkWatchersClient {
	return NewNetworkWatchersClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewNetworkWatchersClientWithBaseURI creates an instance of the
// NetworkWatchersClient client.
func NewNetworkWatchersClientWithBaseURI(baseURI string, subscriptionID string) NetworkWatchersClient {
	return NetworkWatchersClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates a network watcher in the specified
// resource group.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher. parameters is parameters that define the
// network watcher resource.
func (client NetworkWatchersClient) CreateOrUpdate(resourceGroupName string, networkWatcherName string, parameters NetworkWatcher) (result NetworkWatcher, err error) {
	req, err := client.CreateOrUpdatePreparer(resourceGroupName, networkWatcherName, parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "CreateOrUpdate", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "CreateOrUpdate", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client NetworkWatchersClient) CreateOrUpdatePreparer(resourceGroupName string, networkWatcherName string, parameters NetworkWatcher) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) CreateOrUpdateResponder(resp *http.Response) (result NetworkWatcher, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the specified network watcher resource. This method may poll
// for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher.
func (client NetworkWatchersClient) Delete(resourceGroupName string, networkWatcherName string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.DeletePreparer(resourceGroupName, networkWatcherName, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "Delete", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "Delete", resp, "Failure sending request")
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client NetworkWatchersClient) DeletePreparer(resourceGroupName string, networkWatcherName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the specified network watcher by resource group.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher.
func (client NetworkWatchersClient) Get(resourceGroupName string, networkWatcherName string) (result NetworkWatcher, err error) {
	req, err := client.GetPreparer(resourceGroupName, networkWatcherName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "Get", nil, "Failure preparing request")
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "Get", resp, "Failure sending request")
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client NetworkWatchersClient) GetPreparer(resourceGroupName string, networkWatcherName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) GetResponder(resp *http.Response) (result NetworkWatcher, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFlowLogStatus queries status of flow log on a specified resource. This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is the name of the network watcher resource group.
// networkWatcherName is the name of the network watcher resource. parameters
// is parameters that define a resource to query flow log status.
func (client NetworkWatchersClient) GetFlowLogStatus(resourceGroupName string, networkWatcherName string, parameters FlowLogStatusParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetResourceID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "networkwatcher.NetworkWatchersClient", "GetFlowLogStatus")
	}

	req, err := client.GetFlowLogStatusPreparer(resourceGroupName, networkWatcherName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetFlowLogStatus", nil, "Failure preparing request")
	}

	resp, err := client.GetFlowLogStatusSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetFlowLogStatus", resp, "Failure sending request")
	}

	result, err = client.GetFlowLogStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetFlowLogStatus", resp, "Failure responding to request")
	}

	return
}

// GetFlowLogStatusPreparer prepares the GetFlowLogStatus request.
func (client NetworkWatchersClient) GetFlowLogStatusPreparer(resourceGroupName string, networkWatcherName string, parameters FlowLogStatusParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryFlowLogStatus", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// GetFlowLogStatusSender sends the GetFlowLogStatus request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) GetFlowLogStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// GetFlowLogStatusResponder handles the response to the GetFlowLogStatus request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) GetFlowLogStatusResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetNextHop gets the next hop from the specified VM. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher. parameters is parameters that define the
// source and destination endpoint.
func (client NetworkWatchersClient) GetNextHop(resourceGroupName string, networkWatcherName string, parameters NextHopParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetResourceID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.SourceIPAddress", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.DestinationIPAddress", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "networkwatcher.NetworkWatchersClient", "GetNextHop")
	}

	req, err := client.GetNextHopPreparer(resourceGroupName, networkWatcherName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetNextHop", nil, "Failure preparing request")
	}

	resp, err := client.GetNextHopSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetNextHop", resp, "Failure sending request")
	}

	result, err = client.GetNextHopResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetNextHop", resp, "Failure responding to request")
	}

	return
}

// GetNextHopPreparer prepares the GetNextHop request.
func (client NetworkWatchersClient) GetNextHopPreparer(resourceGroupName string, networkWatcherName string, parameters NextHopParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/nextHop", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// GetNextHopSender sends the GetNextHop request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) GetNextHopSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// GetNextHopResponder handles the response to the GetNextHop request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) GetNextHopResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetTopology gets the current network topology by resource group.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher. parameters is parameters that define the
// representation of topology.
func (client NetworkWatchersClient) GetTopology(resourceGroupName string, networkWatcherName string, parameters TopologyParameters) (result Topology, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetResourceGroupName", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "networkwatcher.NetworkWatchersClient", "GetTopology")
	}

	req, err := client.GetTopologyPreparer(resourceGroupName, networkWatcherName, parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTopology", nil, "Failure preparing request")
	}

	resp, err := client.GetTopologySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTopology", resp, "Failure sending request")
	}

	result, err = client.GetTopologyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTopology", resp, "Failure responding to request")
	}

	return
}

// GetTopologyPreparer prepares the GetTopology request.
func (client NetworkWatchersClient) GetTopologyPreparer(resourceGroupName string, networkWatcherName string, parameters TopologyParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/topology", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetTopologySender sends the GetTopology request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) GetTopologySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetTopologyResponder handles the response to the GetTopology request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) GetTopologyResponder(resp *http.Response) (result Topology, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTroubleshooting initiate troubleshooting on a specified resource This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher resource. parameters is parameters that
// define the resource to troubleshoot.
func (client NetworkWatchersClient) GetTroubleshooting(resourceGroupName string, networkWatcherName string, parameters TroubleshootingParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetResourceID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.TroubleshootingProperties", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "parameters.TroubleshootingProperties.StorageID", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "parameters.TroubleshootingProperties.StoragePath", Name: validation.Null, Rule: true, Chain: nil},
					}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "networkwatcher.NetworkWatchersClient", "GetTroubleshooting")
	}

	req, err := client.GetTroubleshootingPreparer(resourceGroupName, networkWatcherName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTroubleshooting", nil, "Failure preparing request")
	}

	resp, err := client.GetTroubleshootingSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTroubleshooting", resp, "Failure sending request")
	}

	result, err = client.GetTroubleshootingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTroubleshooting", resp, "Failure responding to request")
	}

	return
}

// GetTroubleshootingPreparer prepares the GetTroubleshooting request.
func (client NetworkWatchersClient) GetTroubleshootingPreparer(resourceGroupName string, networkWatcherName string, parameters TroubleshootingParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/troubleshoot", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// GetTroubleshootingSender sends the GetTroubleshooting request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) GetTroubleshootingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// GetTroubleshootingResponder handles the response to the GetTroubleshooting request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) GetTroubleshootingResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetTroubleshootingResult get the last completed troubleshooting result on a
// specified resource This method may poll for completion. Polling can be
// canceled by passing the cancel channel argument. The channel will be used to
// cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher resource. parameters is parameters that
// define the resource to query the troubleshooting result.
func (client NetworkWatchersClient) GetTroubleshootingResult(resourceGroupName string, networkWatcherName string, parameters QueryTroubleshootingParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetResourceID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "networkwatcher.NetworkWatchersClient", "GetTroubleshootingResult")
	}

	req, err := client.GetTroubleshootingResultPreparer(resourceGroupName, networkWatcherName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTroubleshootingResult", nil, "Failure preparing request")
	}

	resp, err := client.GetTroubleshootingResultSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTroubleshootingResult", resp, "Failure sending request")
	}

	result, err = client.GetTroubleshootingResultResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetTroubleshootingResult", resp, "Failure responding to request")
	}

	return
}

// GetTroubleshootingResultPreparer prepares the GetTroubleshootingResult request.
func (client NetworkWatchersClient) GetTroubleshootingResultPreparer(resourceGroupName string, networkWatcherName string, parameters QueryTroubleshootingParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryTroubleshootResult", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// GetTroubleshootingResultSender sends the GetTroubleshootingResult request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) GetTroubleshootingResultSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// GetTroubleshootingResultResponder handles the response to the GetTroubleshootingResult request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) GetTroubleshootingResultResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetVMSecurityRules gets the configured and effective security group rules on
// the specified VM. This method may poll for completion. Polling can be
// canceled by passing the cancel channel argument. The channel will be used to
// cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher. parameters is parameters that define the VM
// to check security groups for.
func (client NetworkWatchersClient) GetVMSecurityRules(resourceGroupName string, networkWatcherName string, parameters SecurityGroupViewParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetResourceID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "networkwatcher.NetworkWatchersClient", "GetVMSecurityRules")
	}

	req, err := client.GetVMSecurityRulesPreparer(resourceGroupName, networkWatcherName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetVMSecurityRules", nil, "Failure preparing request")
	}

	resp, err := client.GetVMSecurityRulesSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetVMSecurityRules", resp, "Failure sending request")
	}

	result, err = client.GetVMSecurityRulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "GetVMSecurityRules", resp, "Failure responding to request")
	}

	return
}

// GetVMSecurityRulesPreparer prepares the GetVMSecurityRules request.
func (client NetworkWatchersClient) GetVMSecurityRulesPreparer(resourceGroupName string, networkWatcherName string, parameters SecurityGroupViewParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/securityGroupView", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// GetVMSecurityRulesSender sends the GetVMSecurityRules request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) GetVMSecurityRulesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// GetVMSecurityRulesResponder handles the response to the GetVMSecurityRules request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) GetVMSecurityRulesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// List gets all network watchers by resource group.
//
// resourceGroupName is the name of the resource group.
func (client NetworkWatchersClient) List(resourceGroupName string) (result ListResult, err error) {
	req, err := client.ListPreparer(resourceGroupName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "List", nil, "Failure preparing request")
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "List", resp, "Failure sending request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client NetworkWatchersClient) ListPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) ListResponder(resp *http.Response) (result ListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAll gets all network watchers by subscription.
func (client NetworkWatchersClient) ListAll() (result ListResult, err error) {
	req, err := client.ListAllPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "ListAll", nil, "Failure preparing request")
	}

	resp, err := client.ListAllSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "ListAll", resp, "Failure sending request")
	}

	result, err = client.ListAllResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "ListAll", resp, "Failure responding to request")
	}

	return
}

// ListAllPreparer prepares the ListAll request.
func (client NetworkWatchersClient) ListAllPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Network/networkWatchers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListAllSender sends the ListAll request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) ListAllSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListAllResponder handles the response to the ListAll request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) ListAllResponder(resp *http.Response) (result ListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SetFlowLogConfiguration configures flow log on a specified resource. This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is the name of the network watcher resource group.
// networkWatcherName is the name of the network watcher resource. parameters
// is parameters that define the configuration of flow log.
func (client NetworkWatchersClient) SetFlowLogConfiguration(resourceGroupName string, networkWatcherName string, parameters FlowLogInformation, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetResourceID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.FlowLogProperties", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "parameters.FlowLogProperties.StorageID", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "parameters.FlowLogProperties.Enabled", Name: validation.Null, Rule: true, Chain: nil},
					}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "networkwatcher.NetworkWatchersClient", "SetFlowLogConfiguration")
	}

	req, err := client.SetFlowLogConfigurationPreparer(resourceGroupName, networkWatcherName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "SetFlowLogConfiguration", nil, "Failure preparing request")
	}

	resp, err := client.SetFlowLogConfigurationSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "SetFlowLogConfiguration", resp, "Failure sending request")
	}

	result, err = client.SetFlowLogConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "SetFlowLogConfiguration", resp, "Failure responding to request")
	}

	return
}

// SetFlowLogConfigurationPreparer prepares the SetFlowLogConfiguration request.
func (client NetworkWatchersClient) SetFlowLogConfigurationPreparer(resourceGroupName string, networkWatcherName string, parameters FlowLogInformation, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/configureFlowLog", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// SetFlowLogConfigurationSender sends the SetFlowLogConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) SetFlowLogConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// SetFlowLogConfigurationResponder handles the response to the SetFlowLogConfiguration request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) SetFlowLogConfigurationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// VerifyIPFlow verify IP flow from the specified VM to a location given the
// currently configured NSG rules. This method may poll for completion. Polling
// can be canceled by passing the cancel channel argument. The channel will be
// used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. networkWatcherName is
// the name of the network watcher. parameters is parameters that define the IP
// flow to be verified.
func (client NetworkWatchersClient) VerifyIPFlow(resourceGroupName string, networkWatcherName string, parameters VerificationIPFlowParameters, cancel <-chan struct{}) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetResourceID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.LocalPort", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.RemotePort", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.LocalIPAddress", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.RemoteIPAddress", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "networkwatcher.NetworkWatchersClient", "VerifyIPFlow")
	}

	req, err := client.VerifyIPFlowPreparer(resourceGroupName, networkWatcherName, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "VerifyIPFlow", nil, "Failure preparing request")
	}

	resp, err := client.VerifyIPFlowSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "VerifyIPFlow", resp, "Failure sending request")
	}

	result, err = client.VerifyIPFlowResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "networkwatcher.NetworkWatchersClient", "VerifyIPFlow", resp, "Failure responding to request")
	}

	return
}

// VerifyIPFlowPreparer prepares the VerifyIPFlow request.
func (client NetworkWatchersClient) VerifyIPFlowPreparer(resourceGroupName string, networkWatcherName string, parameters VerificationIPFlowParameters, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkWatcherName": autorest.Encode("path", networkWatcherName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/ipFlowVerify", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// VerifyIPFlowSender sends the VerifyIPFlow request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkWatchersClient) VerifyIPFlowSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// VerifyIPFlowResponder handles the response to the VerifyIPFlow request. The method always
// closes the http.Response Body.
func (client NetworkWatchersClient) VerifyIPFlowResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
