/* 
---------------------------------------------------------------------------
 $Id: xmlparse.h,v 1.7 2001/05/30 16:13:54 acormier Exp $
---------------------------------------------------------------------------
Copyright (c) 2001 Viagenie Inc. All rights reserved.

     The contents of this file are subject to the Viagnie
     Public License Version 1.0 (the "License"); you may not
     use this file except in compliance with the License. You
     may obtain a copy of the License at
     http://www.freenet6.net/VPL/

     Software distributed under the License is distributed on
     an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either
     express or implied. See the License for the specific
     language governing rights and limitations under the
     License.

     The Original Code is _source code of the tunnel server
     protocol-client side_.

     The Initial Developer of the Original Code is Viagnie .

     All Rights Reserved.

     Contributor(s): ______________________________________.

---------------------------------------------------------------------------
*/
#ifndef XMLPARSE_H
#define XMLPARSE_H

#ifdef XMLPARSE
# define ACCESS
#else
# define ACCESS extern
#endif

/*
 * In the node structure, the following identify how many attributes a node can
 * have max. It can be adjusted at compile time.
 */

#define MAX_ATTRIBUTES 4

/*
 * The following identify the format of a node processing function that must be
 * supplied in the node structure to take care of the information supplied in the
 * structure.
 */

struct stNode;

typedef int processNode(struct stNode *n, char *content);

/*
 * The node structure contains the relevant information of each node to be
 * parsed by each invocation of the parser.
 */

typedef struct stAttribute {
  char *name;
  char *value;
} tAttribute;

typedef struct stNode {
  char *name;
  processNode *p;
  tAttribute attributes[MAX_ATTRIBUTES + 1];
} tNode;

/*
 * The XMLParser function is responsible of parsing the contain of a string,
 * calling the appropriate processNode function when a node token is recognized.
 *
 * Parameters:
 *
 * 
 * Return value:
 *
 *    0 - Success
 *   -1 - Memory allocation error
 *    n - Parsing error at position n in the string
 */

ACCESS int XMLParse(char *str, tNode nodes[]);

/*
 * The following macros are usefull to declare the node structures
 *
 * They assume that the event functions will be named the same as the
 * XML tags, prefixed with p_
 *
 */
 
#define NODE(n) { #n, p_##n, {
#define ENDNODE { "", 0 } } },
#define ATTR(a) { #a, 0 },
#define ENDLIST { "", 0, { { "", 0 } } } };
#define STARTLIST {

#define PROC(pr) int p_##pr (tNode *n, char *content)

#undef ACCESS

#endif
