# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# DO NOT ADD THINGS OTHER THAN ERROR MESSAGES HERE.
# This file gets parsed into a JS dictionary of all known error message ids in
# gen_aboutneterror_codes.py . If we end up needing fluent attributes or
# refactoring them in some way, the script will need updating.

# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Kod juumre: { $error }

psmerr-ssl-disabled = Waawaa seŋaade e kisal sabu jaɓɓitorde SSL ndee ko daaƴaande.
psmerr-ssl2-disabled = Waawaa seŋaade e kisal sabu ndee lowre huutortoo ko yamre ɓooynde, nde hisaani jaɓɓitorde SSL ndee.

# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    Keɓ-ɗaa ko seedamfaagu ngu moƴƴaani.  Tiiɗno jokkondir e jiiloowo sarworde oo walla jokkondiral iimeel oo ngam hokkude-ɓe ngoo humpito:
    
    Seedamfaagu maajogii ko tonngoode degginol nandugole seedamfaagu ngonɗngu ngu kohowo seedamfaagu bayyini.  Tiiɗno heɓ seedamfaagu kesu njogiingu tonngoode degginol gootol.

ssl-error-export-only-server = Waawaa jokkondireede e kisal. Peer tammbaaki gangol dowrowol.
ssl-error-us-only-server = Waawaa jokkondireede e kisal. Peer ina ɗaɓɓi gangol dowrowol ngol tammbaaka ɗoo.
ssl-error-no-cypher-overlap = Waawaa jokkondirde Peer nder kisal: alaa algoritma goowaaɗo woni ɗoo.
ssl-error-no-certificate = Waawaa yiytude sartifikaa walla coktirgal katojinangal ngam goongɗinde.
ssl-error-bad-certificate = Waawaa jokkondirde e peer nder kisal: sartifikaa peer oo riiwtaama.
ssl-error-bad-client = Carwo oo fottii e keɓe ñawɗe ummoraade e jowitiiɗo oo.
ssl-error-bad-server = Jowitiiɗo oo fottii e keɓe ñawɗe ummoraade e carwo oo.
ssl-error-unsupported-certificate-type = Sartifikaa mo tammbaaka
ssl-error-unsupported-version = Peer oo huutortoo ko harilde portokol kisal mo tammbaaka.
ssl-error-wrong-certificate = Goongɗingol kiliyaan gallii: coktirgal keeringal gonngal e ruttorde keɓe ngal yahdaani e coktirgal peeñcu gonngal e ruttorde keɓe sartifikaaji.
ssl-error-bad-cert-domain = Waawaa jokkondirde nder kisal e peer: ɗaɓɓaande innde domen ndee yahdaani e sartifikaa carwo oo.
ssl-error-post-warning = Dokkol juumre SSL ngol heɓtinaaka.
ssl-error-ssl2-disabled = Peer tammbii tan ko SSL yamre 2, nde hurminaaka e nokku hee.
ssl-error-bad-mac-read = SSL heɓii nanngitol ngondungol e Message Authentication Code mo moƴƴaani.
ssl-error-bad-mac-alert = SSL peer jaŋtiima Message Authentication Code mo moƴƴaani.
ssl-error-bad-cert-alert = SSL peer waawaa ƴeewtaade seedamfaagu maa.
ssl-error-revoked-cert-alert = SSL peer riiwtii seedamfaagu maa no saltaande.
ssl-error-expired-cert-alert = SSL peer riiwtii seedamfaagu maa no hiiɗtunde.
ssl-error-ssl-disabled = Waawaa seŋaade: SSL koko daaƴaa.
ssl-error-fortezza-pqg = Waawaa seŋaade: SSL peer ko domen FORTEZZA goɗɗo.
ssl-error-unknown-cipher-suite = SSL cipher suite mo anndaaka ɗaɓɓitaama.
ssl-error-no-ciphers-supported = Alaa cipher suite goodɗo kadi ena hurmi e ngoo yuɓɓo.
ssl-error-bad-block-padding = SSL heɓii nanngitol baɗngol bad lock padding.
ssl-error-rx-record-too-long = SSL heɓii nanngitol ɓurtungol njuuteendi dowrol njamiraande.
ssl-error-tx-record-too-long = SSL etiima neldude nanngitol ɓurtungol njuuteendi dowrol njamiraande.
ssl-error-rx-malformed-hello-request = SSL heɓii ɓatakol jowtaango Hello Request ngol mahaaki.
ssl-error-rx-malformed-client-hello = SSL heɓii ɓatakol jowtaango Client Hello ngol mahaaki.
ssl-error-rx-malformed-server-hello = SSL heɓii ɓatakol jowtaango Server Hello ngol mahaaki.
ssl-error-rx-malformed-certificate = SSL heɓii ɓatakol jowtaango Seedamfaagu ngol mahaaki.
ssl-error-rx-malformed-server-key-exch = SSL heɓii ɓatakol jowtaango Server Key ngol mahaaki.
ssl-error-rx-malformed-cert-request = SSL heɓii ɓatakol jowtaango Ɗaɓɓitannde Seedamfaagu ngol mahaaki.
ssl-error-rx-malformed-hello-done = SSL heɓii ɓatakol jowtaango Server Hello Done ngol mahaaki.
ssl-error-rx-malformed-cert-verify = SSL heɓii ɓatakol jowtaango Certificate Verify ngol mahaaki.
ssl-error-rx-malformed-client-key-exch = SSL heɓii ɓatakol jowtaango Cient Key ngol mahaaki.
ssl-error-rx-malformed-finished = SSL heɓii ɓatakol jowtaango Finished ngol mahaaki.
ssl-error-rx-malformed-change-cipher = SSL heɓii nanngitol Change Cipher Spec ngol mahaaki.
ssl-error-rx-malformed-alert = SSL heɓii nanngitol Alert ngol mahaaki.
ssl-error-rx-malformed-handshake = SSL heɓii nanngitol Jowtaango ngol mahaaki.
ssl-error-rx-malformed-application-data = SSL heɓii nanngitol Application Data record ngol mahaaki.
ssl-error-rx-unexpected-hello-request = SSL heɓii ɓatakol jowtaango Hello Request ngol tijjaaka.
ssl-error-rx-unexpected-client-hello = SSL heɓii ɓatakol jowtaango Client Hello ngol tijjaaka.
ssl-error-rx-unexpected-server-hello = SSL heɓii ɓatakol jowtaango Server Hello ngol tijjaaka.
ssl-error-rx-unexpected-certificate = SSL heɓii ɓatakol jowtaango Seedamfaagu ngol tijjaaka.
ssl-error-rx-unexpected-server-key-exch = SSL heɓii ɓatakol jowtaango Server Key ngol tijjaaka.
ssl-error-rx-unexpected-cert-request = SSL heɓii ɓatakol jowtaango Certificate Request ngol tijjaaka.
ssl-error-rx-unexpected-hello-done = SSL heɓii ɓatakol jowtaango Server Hello Done ngol tijjaaka.
ssl-error-rx-unexpected-cert-verify = SSL heɓii ɓatakol jowtaango Certificate Verify ngol tijjaaka.
ssl-error-rx-unexpected-client-key-exch = SSL heɓii ɓatakol jowtaango Client Key ngol tijjaaka.
ssl-error-rx-unexpected-finished = SSL heɓii ɓatakol jowtaango Finished ngol tijjaaka.
ssl-error-rx-unexpected-change-cipher = SSL heɓii nanngitol Change Cipher Spec mo tijjaaka.
ssl-error-rx-unexpected-alert = SSL heɓii nanngitol Alert ngol tijjaaka.
ssl-error-rx-unexpected-handshake = SSL heɓii nanngitol Handshake ngol tijjaaka.
ssl-error-rx-unexpected-application-data = SSL heɓii nanngitol Application Data record ngol tijjaaka.
ssl-error-rx-unknown-record-type = SSL heɓii nanngitol gondungol e fannu loowdi ndi anndaaka.
ssl-error-rx-unknown-handshake = SSL heɓii jowtaango wondungo e fannu loowdi ndi anndaaka.
ssl-error-rx-unknown-alert = SSL heɓii nanngitol jeertino gondungol e cifagol jeertino ngol anndaaka.
ssl-error-close-notify-alert = SSL peer uddii ngol ceŋol.
ssl-error-handshake-unexpected-alert = SSL peer tijjanooki heɓde ɓatakol jowtaango keɓangol ngol.
ssl-error-decompression-failure-alert = Peer SSL ronkii tiɗɗitde daɗndal SSL keɓangal.
ssl-error-handshake-failure-alert = Peer SSL waawaani termondireede dental ñaawirkon kisal jaɓningal.
ssl-error-illegal-parameter-alert = Peer SSL riiwtii mesaas jokkondiral ndi jaɓnaaki.
ssl-error-unsupported-cert-alert = Peer SSL tammbaaki sifaa sartifikaaji keɓaaɗi ɗii.
ssl-error-certificate-unknown-alert = Peer SSL dañdii e sartifikaa keɓaaɗo oo saɗre nde heertinaaka.
ssl-error-generate-random-failure = Peer SSL hawrii e leefre jeñtinirgel limooje kaytooje.
ssl-error-sign-hashes-failure = Horiima siifde keɓe e mbaydi ngaandiwal ngam ƴeewtaade seedamfaagu maa.
ssl-error-extract-public-key-failure = SSL ronkii yaltinde coktirgal peeñcu sartifikaa peer.
ssl-error-server-key-exchange-failure = Gallugol ngol sifaaka tuma jokkondiral e carwo coktirgal SSL.
ssl-error-client-key-exchange-failure = Gallugol ngol sifaaka nde jokkondiral waɗdetee e SSL Client Key Exchange ndee.
ssl-error-encryption-failure = Algoritm gangol keɓe ronkii ande gorol ngol.
ssl-error-decryption-failure = Algoritm gangol keɓe ronkii antude gorol ngol.
ssl-error-socket-write-failure = Enndugol binndugol keɓe ganaaɗe dow soket cakkiiɗo oo galli.
ssl-error-md5-digest-failure = Gollirgel tonngol MD5 gallii.
ssl-error-sha-digest-failure = Gollirgel tonngol SHA-1 gallii.
ssl-error-mac-computation-failure = Hiisa MAC gallii.
ssl-error-sym-key-context-failure = Ronkii sosde weeyo coktirgal kiɓɓal.
ssl-error-sym-key-unwrap-failure = Gallii e coomtugol coktirgal kiɓɓal nder mesaas Client Key Exchange.
ssl-error-pub-key-size-limit-exceeded = Carwo SSL etiima huutoriraade coktirgal peeñcu domestic-grade e doggol gangol neldal.
ssl-error-iv-param-failure = Kod PKCS11 ronkii firde IV nder param.
ssl-error-init-cipher-suite-failure = Gallugol kurmingol doggol gangol cuvangol ngol.
ssl-error-session-key-gen-failure = Kiliyaan oo ronkii feewnude coktirɗe dokkitgol wonande rogere SSL ndee.
ssl-error-no-server-key-for-alg = Carwo oo alanaa algoritma gostondiral oo coktirgal gootal enndanoongal.
ssl-error-token-insertion-removal = Seede PKCS#11 soɗaama walla soɗtaama nde golletee ndee.
ssl-error-token-slot-not-found = Alaa seede PKCS#11 yiytaa ngam waɗde gollal katojinangal ngal.
ssl-error-no-compression-overlap = Aaɓnotaako waɗirde jokkondiral ngal peer nder kisal : alaa algoritma tiɗɗugol denndaaɗo woodi.
ssl-error-handshake-not-completed = Waawaa umminde jokkondiral e SSL goɗngal ɗoon ɗo jokkondiral gonangal ngal joofaani.
ssl-error-bad-handshake-hash-value = Njaru hash mo moƴƴaani heɓaama rewrude e peer.
ssl-error-cert-kea-mismatch = Sartifikaa dokkaaɗo oo waawaa huutoreede e algoritma gostondiral coktirgal cuɓaaɗo oo.
ssl-error-no-trusted-ssl-client-ca = Alaa dokkaaɗo mbaawka keɓtinoowo jaɓaa ngam goongɗinde kiliyaan SSL oo.
ssl-error-session-not-found = ID dokkal SSL kiliyaan yiytaaka nder moggirde naatal carwo oo.
ssl-error-decryption-failed-alert = Peer ronkii antude daɗndal SSL keɓangal ngal.
ssl-error-record-overflow-alert = Peer heɓii daɗndal SSL ɓurngal ko yamiraa koo juutde.
ssl-error-unknown-ca-alert = Peer heɓtinaani tee hoolaaki mbaawka sartifikaa CA njaltinka oo sartifaa.
ssl-error-access-denied-alert = Peer heɓii sartifikaa moƴƴo, kono naatal ngal jaɓaaka.
ssl-error-decode-error-alert = Peer ronkii antude mesaas jokkondiral SSL.
ssl-error-decrypt-error-alert = Peer yaltinii gallere ƴeewtagol siifannde walla gostondiral coktirgal.
ssl-error-export-restriction-alert = Peer feeñninii wonde termondiral ngal ɗooftaaki doosɗe taccingol.
ssl-error-protocol-version-alert = Peer feeñninii wonde yamre jaɓɓitorde ndee tammbaaka walla yahdaani.
ssl-error-insufficient-security-alert = Carwo oo ina ɗɓɓi gangol ɓurngol ngol kiliyaan oo tammbii ngol hisneede.
ssl-error-internal-error-alert = Peer feeñninii hawrii e juumre ndernderde.
ssl-error-user-canceled-alert = Jokkondiral huutorɓe peer niilnaama.
ssl-error-no-renegotiation-alert = Peer yamirtaa ɗaɓɓitgol bannanɗe kisal SSL.
ssl-error-server-cache-not-configured = Moggirgel carwo SSL yahdaani tee ñifanaako oo soket.
ssl-error-unsupported-extension-alert = Peer SSL tammbaaki jokkel TLS hello ɗaɓɓangel ngal.
ssl-error-certificate-unobtainable-alert = Peer SSL ronkii heɓde sartifikaa maa rewrude e URL dokkaaɗo oo.
ssl-error-unrecognized-name-alert = Peer SSL alanaa innde DNS naamnaande ndee sartifikaa.
ssl-error-bad-cert-status-response-alert = Peer SSL ronkii heɓde e OCSP jaabawol paatungol e sartifikaa mum.
ssl-error-bad-cert-hash-value-alert = Peer SSL saaktii njaru hash sartifikaa ngu moƴƴaani.
ssl-error-rx-unexpected-new-session-ticket = SSL heɓii mesaas tikket keso jokkondiral Naatal Kesal bettungal.
ssl-error-rx-malformed-new-session-ticket = SSL heɓii mesaas tikket keso jokkondiral Naatal Kesal mo feewaani.
ssl-error-decompression-failure = SSL heɓii daɗngal tiɗɗangal donkangal tiɗɗiteede.
ssl-error-renegotiation-not-allowed = Ennditgol yamiraaka e oo soket SSL.
ssl-error-unsafe-negotiation = Peer etiima jokkondiral e mbaadi kiiɗndi (baawngal naatteede).
ssl-error-rx-unexpected-uncompressed-record = SSL heɓii daɗndal tiɗɗangal bettungal.
ssl-error-weak-server-ephemeral-dh-key = SSL heɓii coktirgal Diffie-Hellman leefngal nder mesaas jokkondiral gostondiral coktirɗe carwo.
ssl-error-next-protocol-data-invalid = SSL heɓii jookel keɓe NPN ngel gollataa.
ssl-error-feature-not-supported-for-ssl2 = Ceŋirɗe SSL 2.0 ɗee tammbaaki gollirgel SSL ngel.
ssl-error-feature-not-supported-for-servers = Carwooji ɗii tammbaaki gollirgal SSL ngal.
ssl-error-feature-not-supported-for-clients = Jowitiiɗi ɗii tammbaaki gollirgal SSL ngal.
ssl-error-invalid-version-range = Njaajeendi yamre SSL ndee moƴƴaani.
ssl-error-cipher-disallowed-for-version = Peer SSL suɓiima doggol gangol ngol yamiraaka wonande yamre portokol suɓaande ndee.
ssl-error-rx-malformed-hello-verify-request = SSL heɓii messas jokkondiral Hello Verify Request mo feewaani.
ssl-error-rx-unexpected-hello-verify-request = SSL heɓii mesaas jokkondiral Hello Verify Request bettuɗo.
ssl-error-feature-not-supported-for-version = Gollirgel SSL ngel tammbaaka wonande yamre portokol ndee.
ssl-error-rx-unexpected-cert-status = SSL heɓii mesaas jokkondiral Certificate Status bettuɗo.
ssl-error-unsupported-hash-algorithm = Hash algoritma mo tammbaaka, mo peer TLS huutortoo.
ssl-error-digest-failure = Gollirgel digest gallii.
ssl-error-incorrect-signature-algorithm = Algoritma siifannde ñawɗo sifaama nder geɗel ciifrangel limoore.
ssl-error-next-protocol-no-callback = Jokkel portokol jokkondiral garonwel ngel ko kurminangel kono noddital ngal momtaama hoto sokleede.
ssl-error-next-protocol-no-protocol = Carwo oo tammbaaki portokol gooto mo kiliyaan oo saaktata nder jokkel ALPN.
ssl-error-inappropriate-fallback-alert = Carwo oo riiwtii jokkondiral ngal sibu kiliyaan oon ruttiima e yamre jaasnde TLS nde carwo oo tammbii.
ssl-error-weak-server-cert-key = Sartifikaa carwo oo ina waɗnoo coktirgal peeñcu leefngal no feewi.
ssl-error-rx-short-dtls-read = Boowal ina ŋakki nder tampon hee ngam daɗndugol DTLS.
ssl-error-no-supported-signature-algorithm = Alaa algoritma siifannde TLS tammbaaɗo teeltaa ɗoo.
ssl-error-unsupported-signature-algorithm = Peer oo huutorii ko nawdugol ngol tambmbaaka siifannde e algoritma hashgol.
ssl-error-missing-extended-master-secret = Peer etiima ɓamtude ko aldaa e jokkel moƴƴel extended_master_secret.
ssl-error-unexpected-extended-master-secret = Peer etiima ɓamtude wondude e jokkel moƴƴel extended_master_secret.
sec-error-io = Juumre I/O kewii tuma jamirgol kisal.
sec-error-library-failure = juumre faawru kisal.
sec-error-bad-data = faawru kisal: keɓe ɗe moƴƴaani keɓaama.
sec-error-output-len = faawru kisal: juumre juuteendi jaltal.
sec-error-input-len = faawru kisal hawrii e juumre njuuteendi naatal.
sec-error-invalid-args = faawru kisal: bannannɗe ɗe moƴƴaani.
sec-error-invalid-algorithm = faawru kisal: algoritma mo moƴƴaani.
sec-error-invalid-ava = faawru kisal: AVA mo moƴƴaani.
sec-error-invalid-time = Callalal sahaa ngal teeltaaka.
sec-error-bad-der = faawru kisal: mesaas DER ganaaɗo mo teeltiraaka no moƴƴi.
sec-error-bad-signature = Siifannde sartifikaa peer ndee moƴƴaani.
sec-error-expired-certificate = Sartifikaa peer buntii.
sec-error-revoked-certificate = Sartifikaa peer oo ko jedditaaɗo.
sec-error-unknown-issuer = Jaltinɗo sartifikaa peer oo heɓtinaaka.
sec-error-bad-key = Coktirgal peeñcu peer ngal moƴƴaani.
sec-error-bad-password = Finnde kisal naatnaande ndee sellaani.
sec-error-retry-password = Finnde hesere naatnaande ndee feewaani. Enndit kadi.
sec-error-no-nodelock = faawru kisal: nodelock woodaani.
sec-error-bad-database = faawru kisal: duttorgal keɓe moƴƴaani.
sec-error-no-memory = faawru kisal: juumre taƴnal teskorde.
sec-error-untrusted-issuer = Jaltinɗo sartifikaa peer oo ko jelaaɗo kuutoro oo yamiraani ɗum.
sec-error-untrusted-cert = Sartifikaa peer oo ko jelaaɗo kuutoro oo yamiraani ɗum.
sec-error-duplicate-cert = Sartifikaa oo ina woodi nder faawru keɓe.
sec-error-duplicate-cert-name = Innde sartifikaa gawtaaɗo oo ina jogii nanndo mum e nder faawru keɓe maa.
sec-error-adding-cert = Juumre ɓeydugol sartifikaa e faawru keɓe.
sec-error-filing-key = Juumre tuma dennditgol oo sartifikaa.
sec-error-no-key = Coktirgal keeringal wonande oo sartifikaa yiytotaako e faawru keɓecoktirɗe ɗee
sec-error-cert-valid = Oo sartifikaa ina moƴƴi.
sec-error-cert-not-valid = Oo sartifikaa moƴƴaani.
sec-error-cert-no-response = Faawru Cert: Alaa jaabawol
sec-error-expired-issuer-certificate = Sartifikaa jaltinɗoo oo sartifikaa buntii. Hoolkiso ñalngu e waktu yuɓɓo maa.
sec-error-crl-expired = Doggol CRL jaltinɗo sartifikaa oo ko buntungol. Hesɗitin ngol koolkiso-ɗaa ñalngu e waktu yuɓɓo maa.
sec-error-crl-bad-signature = Siifannde doggol CRL jaltinɗo sartifikaa oo ina moƴƴi.
sec-error-crl-invalid = CRL keso oo jogii ko formaa ñawɗo.
sec-error-extension-value-invalid = Njaru jokkel sartifikaa oo ina moƴƴi.
sec-error-extension-not-found = Jokkel sartifikaa oo yiytaaka.
sec-error-ca-cert-invalid = Sartifikaa jaltinɗo oo ina moƴƴi.
sec-error-path-len-constraint-invalid = Baawnal njuuteendi ñiiɓirde sartifikaa kaa inaa moƴƴi.
sec-error-cert-usages-invalid = Gallol kuutore sartifikaa kaa moƴƴaani.
sec-internal-only = **Wulnde ndernderde ONLY**
sec-error-invalid-key = Coktirgal ngal jaɓataa gollal ɗaɓɓangal ngal.
sec-error-unknown-critical-extension = Sartifikaa oo ina waɗi jokkel ngel anndaaka paaynowel.
sec-error-old-crl = Ñalnde CRL ndee ɓuri wonaande ndee lawɗude.
sec-error-no-email-cert = Anaaka walla siifaaka : a alaa tawo sartifikaa iimeel.
sec-error-no-recipient-certs-query = Anaaka: a alaa gooto e jaaƴorɓe ɓee kala sartifikaa.
sec-error-not-a-recipient = Waawa antude: a wonaa jaaƴoro, walla tawa sartifikaa jahdoowo e coktirgal keeringal yiytaaka.
sec-error-pkcs7-keyalg-mismatch = Waawaa antude: algoritma gangol coktirgal ngal tolnondiraani e sartifikaa maa.
sec-error-pkcs7-bad-signature = Koolkisagol siifannde gallii: alaa ciifɗo yiytaa, ciifanɗe jiyaaɗe ɗee ina ukki walla keɓe ɗee peewaani maa ko pirɗe.
sec-error-unsupported-keyalg = Algoritma coktirgal tammbaaka walla anndaaka.
sec-error-decryption-disallowed = Waawaa antude: anraa ko algoritma mo yamiraaka walla mawneeki coktiragal.
xp-sec-fortezza-bad-card = Kartal Fortezza hurminiraaka no moƴƴi. Ittu ngal neltiraa ngal peewnunooɗo oo.
xp-sec-fortezza-no-card = Karat Fortezza yiytaaka
xp-sec-fortezza-none-selected = Alaa kartal Fortezza suɓaa
xp-sec-fortezza-more-info = Suɓo neɗɗo ngam heɓde heen kabaruuji ɓurɗi heewde
xp-sec-fortezza-person-not-found = Neɗɗo yiytaaka
xp-sec-fortezza-no-more-info = Kabaruuji ngoodanaani oo neɗɗo
xp-sec-fortezza-bad-pin = Pin ñawɗo
xp-sec-fortezza-person-error = Waawaa hurminde yimɓe Fortezza.
sec-error-no-krl = Alaa KRL wonande sartifikaa ndee lowre yiytaa.
sec-error-krl-expired = KRL wonande oo sartifikaa ko buntuɗo.
sec-error-krl-bad-signature = KRL sartifikaa ndee lowre ina jogii siifannde nde moƴƴaani.
sec-error-revoked-key = Coktirgal sartifikaa ndee lowre ko diiwtangal.
sec-error-krl-invalid = Mbayka doggol kesol kele diiwtaaɗe ɗee moƴƴaani.
sec-error-need-random = faawru kisal: sokli keɓe kaytooje.
sec-error-no-module = faawru kisal: alaa wulnde kisal waawi waɗde gollal ɗaɓɓangal ngal.
sec-error-no-token = Kartal walla seede kisal woodaani, ina foti hurmineede walla momteede.
sec-error-read-only = faawru kisal: faawru keɓe janngotoondu fat.
sec-error-no-slot-selected = Alaa nokku walla seede suɓaa.
sec-error-cert-nickname-collision = Sartifikaa ina woodi jogiiɗo hono ndee waccoore.
sec-error-key-nickname-collision = Coktirgal ina woodi jogingal hono ndee waccoore.
sec-error-safe-not-created = juumre tuma cosgol geɗel kisnangel
sec-error-baggage-not-created = juumre tuma cosgol geɗel bagaas
xp-java-remove-principal-error = Waawaa momtude dowrowel ngel
xp-java-delete-privilege-error = Waawaa momtude ɓurnaari ndii
xp-java-cert-not-exists-error = Dowrowel ngel waawaa jogaade sartifikaa
sec-error-bad-export-algorithm = Algoritma coklaaɗo oo yamiraaka.
sec-error-exporting-certificates = Juumre e etagol jiggitaade seedamfaaje.
sec-error-importing-certificates = Juumre e etagol jiggaade seedamfaaje.
sec-error-pkcs12-decoding-pfx = Horiima jiggaade. Juumre dokkitagol. Fiildee dagnaaka.
sec-error-pkcs12-invalid-mac = Horiima jiggaade. MAC dagnaaka. Finnde moƴƴaani walla fiilde jiiɓnde.
sec-error-pkcs12-unsupported-mac-algorithm = Horiima jiggaade. Algoritm MAC oo tammbitaaka.
sec-error-pkcs12-unsupported-transport-mode = Horiima jiggaade. Ko mbaykaaji kuuɓol finndel e suturo tan tammbitaa.
sec-error-pkcs12-corrupt-pfx-structure = Horiima jiggaade. Cañgu fiilde ko jiibngu.
sec-error-pkcs12-unsupported-pbe-algorithm = Horiima jiggaade. Algoritm Gannugol oo tammbitaaka.
sec-error-pkcs12-unsupported-version = Horiima jiggaade. Yamre fiilde ndee tammbitaaka.
sec-error-pkcs12-privacy-password-incorrect = Horiima jiggaade. Finnde suturo moƴƴaani.
sec-error-pkcs12-cert-collision = Horiima jiggaade. Hono ndee waccoore ena woodi kisa e diiñorde keɓe ndee.
sec-error-user-cancelled = Kuutoro oo ñoƴƴii e niilnu.
sec-error-pkcs12-duplicate-data = Jiggaaka, ina woodnoo e faawru keɓe.
sec-error-message-send-aborted = Mesaas neldaaka.
sec-error-inadequate-key-usage = Kuutoragol coktirgal sartifikaa soklaani ngam enndude gollal ngal.
sec-error-inadequate-cert-type = Jaaɓngal ngal heɓtinaani sifaa sartifikaa kaa.
sec-error-cert-addr-mismatch = Ñiiɓirde wonnde e sartifikaa siifannde ndee tolnondiraani e ñiiɓirde wonnde e meetele mesaas oo.
sec-error-pkcs12-unable-to-import-key = Horiima jiggaade. Juumre e etagol jiggaade kelal cuuringal.
sec-error-pkcs12-importing-cert-chain = Horiima jiggaade. Juumre e etagol jiggaade calol seedamfaagu.
sec-error-pkcs12-unable-to-locate-object-by-name = Horiima jiggitaade. Horiima yiyrude seedamfaagu walla kelal hutoraade wawwoore.
sec-error-pkcs12-unable-to-export-key = Horiima jiggitaade. Kelal cuuringal horiima yiyteede e jiggiteede.
sec-error-pkcs12-unable-to-write = Taccintaako. Aaɓnotaako winndude e fiilde taccingol.
sec-error-pkcs12-unable-to-read = Horiima jiggaade. Horiima tarde fiilde jiggol.
sec-error-pkcs12-key-database-not-initialized = Waawaa taccinde. Coktirgal faawru keɓe nduu ko pirngal walla ko momtangal.
sec-error-keygen-fail = Waawaa feewnude coktirɗe ɗiɗi jahdiije peeñcu/keeringal
sec-error-invalid-password = Finnde naatnaande ndee moƴƴaani. Suɓo woɗnde.
sec-error-retry-old-password = Finnde ɓooynde naatniraama no feewaan. Enndit.
sec-error-bad-nickname = Waccoore sartifikaa ina huutortenoo.
sec-error-not-fortezza-issuer = Callalal peer FORTEZZA ina jogii sartifikaa non-FORTEZZA.
sec-error-cannot-move-sensitive-key = Coktirgal parwungal ngal waawaa dirtineede e eeɓol ɗo ngal hatojinaa ɗoo.
sec-error-js-invalid-module-name = Innde wulnde moƴƴaani.
sec-error-js-invalid-dll = Bolol keɓrugol//filename nde moƴƴaani
sec-error-js-add-mod-failure = Horiima ɓeydude wulnde
sec-error-js-del-mod-failure = Horiima momtude wulnde
sec-error-old-krl = Ñalngu doggol kesol kele diiwtaaɗe ɗee sakkitii ñalngu ngonaangu nduu.
sec-error-ckl-conflict = CKL keso ina jogii jaltinoowo goɗɗo mo jiidaa e CKL jooni oo. Momtu CKL jooni oo.
sec-error-cert-not-in-name-space = Jogiiɗo mbaawka sartifikaa yamiraaka rokkude sartifikaa jogiiɗo ndee innde.
sec-error-krl-not-yet-valid = Doggol ɓoordugol coktirɗe wonande kaa sartifikaa gollataa tawo.
sec-error-crl-not-yet-valid = Doggol ɓoordugol sartifikaaji wonande kaa sartifikaa gollataa tawo.
sec-error-unknown-cert = Sartifikaa ɗaɓɓaaɗo oo yiytaaka.
sec-error-unknown-signer = Sartifikaa ciifgol yiytaaka.
sec-error-cert-bad-access-location = Nokku carwo ngonka sartifikaa kaa ina jogii mbaadi ñawndi.
sec-error-ocsp-unknown-response-type = Jaabtol OCSP ngol waawaa dokkiteede e timmal; ko o fannu mo anndaaka.
sec-error-ocsp-bad-http-response = Sarworde OCSP ndee ruttinii keɓe HTTP ɗee tijjaaka/ndagnaaka.
sec-error-ocsp-malformed-request = Sarworde OCSP ndee yiytii ɗaɓɓitannde ndee koko.
sec-error-ocsp-server-error = Carwo OCSP hawrii e juumre ndernderde.
sec-error-ocsp-try-server-later = Carwo OCSP wagginii ennditoyde yeeso.
sec-error-ocsp-request-needs-sig = Carwo OCSP ina ɗaɓɓi siifannde e ndee ɗaɓɓaande.
sec-error-ocsp-unauthorized-request = Carwo OCSP saliima ndee ɗaɓɓaande sibu nde yamiraaka.
sec-error-ocsp-unknown-response-status = Carwo OCSP yaltinii ngonka ka heɓtintaako.
sec-error-ocsp-unknown-cert = Carwo OCSP alanaa sartifikaa kaa hay ngonka ngoota.
sec-error-ocsp-not-enabled = Aɗa foti hurminde OCSP hade maa waɗde ngal gollal.
sec-error-ocsp-no-default-responder = Aɗa foti toɗɗaade jaabotoongel gaadorangel OCSP hade maa waɗde ngal gollal.
sec-error-ocsp-malformed-response = Jaabagol carwo OCSP ko pirngol walla feewaani.
sec-error-ocsp-unauthorized-response = Ciifɗo jaabawol OCSP ngol yamiraaka rokkude ngonka wonande kaa sartifikaa.
sec-error-ocsp-future-response = Jaabawol OCSP ngol dagaaki tawo (ina waɗi ñalngu ngu yettaaki).
sec-error-ocsp-old-response = Jaabawol OCSP ngol ina waɗi kabaruuji buntuɗi.
sec-error-digest-not-found = Digest CMS walla PKCS #7 yiytaaka nder mesaas ciifaaɗo oo.
sec-error-unsupported-message-type = Sifaa mesaas CMS walla PKCS #7 tammbaaka tawo.
sec-error-module-stuck = Wulnde PKCS #11 ndee ronkii momteede sibu ina huutoree tawo.
sec-error-bad-template = Keɓe ASN.1 ngantotaako. Model cifaaɗo oo moƴƴaani.
sec-error-crl-not-found = Alaa doggol CRL woodi.
sec-error-reused-issuer-and-serial = Ngon-ɗaa ko e enndude faggitaade sartifikaa nannduka e sartifikaa ngoodka iwdi, kono sartikaaji ɗiɗi ɗii ina ceerti.
sec-error-busy = NSS ronkii dartinde. Geɗe ɗee ina kuutoree haa hannde.
sec-error-extra-input = Mesaas ganiraaɗo DER oo ina waɗnoo geɗe goɗɗe ɗe kuutoraaka.
sec-error-unsupported-elliptic-curve = Kofol ommbol tammbaaka.
sec-error-unsupported-ec-point-form = Mbaadi toɓɓere ommbol ngol tammbaaka.
sec-error-unrecognized-oid = Keɓtinirgel geɗel ngel heɓtinaaka.
sec-error-ocsp-invalid-signing-cert = Siifannde sartifikaa OCSP nde moƴƴaani nder jaabawol OCSP ngol.
sec-error-revoked-certificate-crl = Sartifikaa kaa ko ittaaka e doggol sartifikaaji jaltinɗo oo.
sec-error-revoked-certificate-ocsp = Sartifikaa jaabotoongel OCSP jaltinɗo oo ko diiwtaaɗo.
sec-error-crl-invalid-version = Doggol sartifikaaji jaltinoowo diiwtaaɗi ina waɗi tonngoode yamre nde anndaaka.
sec-error-crl-v1-critical-extension = Doggol diiwtugol sartifikaaji jaltinoowo V1 ina waɗi jokkel paaynungel.
sec-error-crl-unknown-critical-extension = Doggol diiwtugol sartifikaaji jaltinoowo V2 ina waɗi jokkel paaynungel ngel heɓtinaaka.
sec-error-unknown-object-type = Sifaa geɗel majjangel toɗaama.
sec-error-incompatible-pkcs11 = Pilot PKCS #11 oo ina luutondiri e cifol ngol e mbaadi ŋakkundi.
sec-error-no-event = Alaa kewu keso slot woodi e oo sahaa.
sec-error-crl-already-exists = CRL ina lutti woodde.
sec-error-not-initialized = NSS hurminaaka.
sec-error-token-not-logged-in = Gollal ngal gallii sibu seede PKCS#11 oo seŋaaki.
sec-error-ocsp-responder-cert-invalid = Sartifikaa jaabotoongel OCSP teeltaaka kaa moƴƴaani.
sec-error-ocsp-bad-signature = Jaabawol OCSP ngol ina waɗi siifannde nde moƴƴaani.
sec-error-out-of-search-limits = Njiylawu jaɓgol Cert yaltii keeri njiylawu
sec-error-invalid-policy-mapping = Yahdino peeje ina waɗi ko anii
sec-error-policy-validation-failed = Callalal sartifikaaji jaɓaaka
sec-error-unknown-aia-location-type = Sifaa nokku mo anndaaka nder jokkel AIA cert
sec-error-bad-http-response = Carwo oo neldii jaabawol HTTP ngol moƴƴaani
sec-error-bad-ldap-response = Carwo jaabtiima jaabawol LDAP ngol moƴƴaani
sec-error-failed-to-encode-data = Gallugol kodirgol keɓe ɗee kodoowel ASN1
sec-error-bad-info-access-location = Nokku keɓgol kabaruuji mo moƴƴaani nder jokkel cert
sec-error-libpkix-internal = Juurme ndernderde libpkix kewii tuma jaɓgol sartifikaa.
sec-error-pkcs11-general-error = Wulnde PKCS #11 yaltinii CKR_GENERAL_ERROR, maandinoore kewgol juumre nder safrotaako.
sec-error-pkcs11-function-failed = Wulnde PKCS #11 yaltinii CKR_FUNCTION_FAILED, maandinoore wonde gollirgel ɗaɓɓangel ngel ronkii gollineede. So a ennditii gollal ngal ina waawi yuumta.
sec-error-pkcs11-device-error = Wulnde PKCS #11 yaltinii CKR_DEVICE_ERROR, maandinoore wonde saɗri ina woodi e seede hee walla nokku hee.
sec-error-bad-info-access-method = Feere heɓrude kabaaru nde anndaaka nder jokkel kaa sartifikaa.
sec-error-crl-import-failed = Juumre kewii tuma etagol faggitaade CRL.
sec-error-expired-password = Finnde ndee buntii.
sec-error-locked-password = Finnde ndee ko sokaande.
sec-error-unknown-pkcs11-error = Juumre PKCS #11nde anndaaka.
sec-error-bad-crl-dp-url = URL mo moƴƴaani walla tammbaaka e nokku dokkirgol CRL.
sec-error-cert-signature-algorithm-disabled = Sartifikaa kaa siifiraa ko algoritma ciifgol ñifaaɗo sibu hisnaaka.
mozilla-pkix-error-key-pinning-failure = Carwo oo huutorii ko ɗisgol coktirɗe (HPKP) kono alaa callalal sartifikaaji koolningal waawi maheede ngam tolnondirde e pins ɗee. Luutndagol cokgol coktirɗe ɗee lomtintaako.
mozilla-pkix-error-ca-cert-used-as-end-entity = Carwo oo huutorii sartifikaa baɗɗo jokkel baawne leslese kollirooje omo jogii mbaawka yaltinde sartifikaaji. Wonaa noon fotnoo wonde wonande sartifikaa jaltirɗo laawol.
mozilla-pkix-error-inadequate-key-size = Carwo oo hollitii sartifikaa ka coktiragal pamaral no feewi ngam seŋol kisnangol.
mozilla-pkix-error-v1-cert-used-as-ca = Sartifikaa X.509 yamre 1 nde wonaa daasol hoolaare huutoraama ngam yaltinde sartifikaa carwo oo. Sartifikaaji X.509 yamre 1 ko buntuɗi tee mbaawaa huutoreede ngam siifde sartifikaaji goɗɗi.
mozilla-pkix-error-not-yet-valid-certificate = Carwo oo hollitii sartifikaa mo jaɓaaka tawo.
mozilla-pkix-error-not-yet-valid-issuer-certificate = Sartifikaa mo jaɓaaka tawo huutoraama ngam yaltinde sartifikaa carwo oo.
mozilla-pkix-error-signature-algorithm-mismatch = Algoritma ciifgol nder gallol ciifgol sartifikaa oo tolnondiraani e algoritma oo nder gallol mum signatureAlgorithm.
mozilla-pkix-error-ocsp-response-for-cert-missing = Jaabawol OCSP ngol waɗaani ngonka sartifikaa gonɗo e hoolkiseede.
mozilla-pkix-error-validity-too-long = Carwo oo hollitii sartifikaa jaɓaaɗo ko ɓooyi no feewi.
mozilla-pkix-error-required-tls-feature-missing = Gollirgel TLS katojinangal ina ŋakki.
mozilla-pkix-error-invalid-integer-encoding = Carwo oo hollitii sartifikaa baɗɗo kodgol limre timmunde ngol moƴƴaani. Sababuuji gaadoraaɗi ina mbaɗa tonngooɗe callalal uste, gulle RSA uste kam e kode ɓurɗe ko soklaa koo juutde.
mozilla-pkix-error-empty-issuer-name = Carwo oo hollitii sartifikaa baɗɗo innde seerndirde jaltinoowo mehre.
mozilla-pkix-error-self-signed-cert = Seedamfaagu nguu hoolaaka sabu ko siifnde hoore mayre.
