.\" dpkg manual page - dpkg-buildflags(1)
.\"
.\" Copyright © 2010-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011 Kees Cook <kees@debian.org>
.\" Copyright © 2011-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-buildflags 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-buildflags \- returns build flags to use during package build
.
.SH SYNOPSIS
.B dpkg\-buildflags
.RI [ option "...] [" command ]
.
.SH DESCRIPTION
\fBdpkg\-buildflags\fP is a tool to retrieve compilation flags to use during
build of Debian packages.
.
The default flags are defined by the vendor but they can be
extended/overridden in several ways:
.IP 1.
system-wide with \fB%PKGCONFDIR%/buildflags.conf\fP;
.IP 2.
for the current user with \fB$XDG_CONFIG_HOME/dpkg/buildflags.conf\fP
where \fB$XDG_CONFIG_HOME\fP defaults to \fB$HOME/.config\fP;
.IP 3.
temporarily by the user with environment variables (see section
\fBENVIRONMENT\fP);
.IP 4.
dynamically by the package maintainer with environment variables set via
\fBdebian/rules\fP (see section \fBENVIRONMENT\fP).
.P
The configuration files can contain four types of directives:
.TP
.BI SET " flag value"
Override the flag named \fIflag\fP to have the value \fIvalue\fP.
.TP
.BI STRIP " flag value"
Strip from the flag named \fIflag\fP all the build flags listed in \fIvalue\fP.
.TP
.BI APPEND " flag value"
Extend the flag named \fIflag\fP by appending the options given in \fIvalue\fP.
A space is prepended to the appended value if the flag's current value is non-empty.
.TP
.BI PREPEND " flag value"
Extend the flag named \fIflag\fP by prepending the options given in \fIvalue\fP.
A space is appended to the prepended value if the flag's current value is non-empty.
.P
The configuration files can contain comments on lines starting with a hash
(#). Empty lines are also ignored.
.SH COMMANDS
.TP
.BI \-\-dump
Print to standard output all compilation flags and their values. It prints
one flag per line separated from its value by an equal sign
(“\fIflag\fP=\fIvalue\fP”). This is the default action.
.TP
.BI \-\-list
Print the list of flags supported by the current vendor
(one per line). See the \fBSUPPORTED FLAGS\fP section for more
information about them.
.TP
.BI \-\-status
Display any information that can be useful to explain the behaviour of
\fBdpkg\-buildflags\fP (since dpkg 1.16.5): relevant environment variables,
current vendor, state of all feature flags.
Also print the resulting compiler flags with their origin.

This is intended to be run from \fBdebian/rules\fP, so that the build log
keeps a clear trace of the build flags used. This can be useful to diagnose
problems related to them.
.TP
.BI \-\-export= format
Print to standard output commands that can be used to export all the
compilation flags for some particular tool. If the \fIformat\fP value is not
given, \fBsh\fP is assumed. Only compilation flags starting with an
upper case character are included, others are assumed to not be suitable
for the environment. Supported formats:
.RS
.TP
.B sh
Shell commands to set and export all the compilation flags in the
environment. The flag values are quoted so the output is ready for
evaluation by a shell.
.TP
.B cmdline
Arguments to pass to a build program's command line to use all the
compilation flags (since dpkg 1.17.0). The flag values are quoted in
shell syntax.
.TP
.B configure
This is a legacy alias for \fBcmdline\fP.
.TP
.B make
Make directives to set and export all the compilation flags in the
environment. Output can be written to a Makefile fragment and
evaluated using an \fBinclude\fP directive.
.RE
.TP
.BI \-\-get " flag"
Print the value of the flag on standard output. Exits with 0
if the flag is known otherwise exits with 1.
.TP
.BI \-\-origin " flag"
Print the origin of the value that is returned by \fB\-\-get\fP. Exits
with 0 if the flag is known otherwise exits with 1. The origin can be one
of the following values:
.RS
.TP
.B vendor
the original flag set by the vendor is returned;
.TP
.B system
the flag is set/modified by a system-wide configuration;
.TP
.B user
the flag is set/modified by a user-specific configuration;
.TP
.B env
the flag is set/modified by an environment-specific configuration.
.RE
.TP
.BI \-\-query
Print any information that can be useful to explain the behaviour of the
program: current vendor, relevant environment variables, feature areas,
state of all feature flags, and the compiler flags with their origin
(since dpkg 1.19.0).
.IP
For example:
.nf
  Vendor: Debian
  Environment:
   DEB_CFLAGS_SET=-O0 -Wall

  Area: qa
  Features:
   bug=no
   canary=no

  Area: reproducible
  Features:
   timeless=no

  Flag: CFLAGS
  Value: -O0 -Wall
  Origin: env

  Flag: CPPFLAGS
  Value: -D_FORTIFY_SOURCE=2
  Origin: vendor
.fi
.TP
.BI \-\-query\-features " area"
Print the features enabled for a given area (since dpkg 1.16.2).
The only currently recognized
areas on Debian and derivatives are \fBfuture\fP, \fBqa\fP, \fBreproducible\fP,
\fBsanitize\fP and \fBhardening\fP, see the \fBFEATURE AREAS\fP
section for more details.
Exits with 0 if the area is known otherwise exits with 1.
.IP
The output is in RFC822 format, with one section per feature.
For example:
.IP
.nf
  Feature: pie
  Enabled: yes

  Feature: stackprotector
  Enabled: yes
.fi
.TP
.B \-\-help
Show the usage message and exit.
.TP
.B \-\-version
Show the version and exit.
.
.SH SUPPORTED FLAGS
.TP
.B CFLAGS
Options for the C compiler. The default value set by the vendor
includes \fB\-g\fP and the default optimization level (\fB\-O2\fP usually,
or \fB\-O0\fP if the \fBDEB_BUILD_OPTIONS\fP environment variable defines
\fInoopt\fP).
.TP
.B CPPFLAGS
Options for the C preprocessor. Default value: empty.
.TP
.B CXXFLAGS
Options for the C++ compiler. Same as \fBCFLAGS\fP.
.TP
.B OBJCFLAGS
Options for the Objective C compiler. Same as \fBCFLAGS\fP.
.TP
.B OBJCXXFLAGS
Options for the Objective C++ compiler. Same as \fBCXXFLAGS\fP.
.TP
.B GCJFLAGS
Options for the GNU Java compiler (gcj). A subset of \fBCFLAGS\fP.
.TP
.B FFLAGS
Options for the Fortran 77 compiler. A subset of \fBCFLAGS\fP.
.TP
.B FCFLAGS
Options for the Fortran 9x compiler. Same as \fBFFLAGS\fP.
.TP
.B LDFLAGS
Options passed to the compiler when linking executables or shared
objects (if the linker is called directly, then
.B \-Wl
and
.B ,
have to be stripped from these options). Default value: empty.
.PP
New flags might be added in the future if the need arises (for example
to support other languages).
.
.SH FEATURE AREAS
.P
Each area feature can be enabled and disabled in the \fBDEB_BUILD_OPTIONS\fP
and \fBDEB_BUILD_MAINT_OPTIONS\fP environment variable's area value with the
‘\fB+\fP’ and ‘\fB\-\fP’ modifier.
For example, to enable the \fBhardening\fP “pie” feature and disable the
“fortify” feature you can do this in \fBdebian/rules\fP:
.P
  export DEB_BUILD_MAINT_OPTIONS=hardening=+pie,\-fortify
.P
The special feature \fBall\fP (valid in any area) can be used to enable or
disable all area features at the same time.
Thus disabling everything in the \fBhardening\fP area and enabling only
“format” and “fortify” can be achieved with:
.P
  export DEB_BUILD_MAINT_OPTIONS=hardening=\-all,+format,+fortify
.
.SS future
Several compile-time options (detailed below) can be used to enable features
that should be enabled by default, but cannot due to backwards compatibility
reasons.
.TP
.B lfs
This setting (disabled by default) enables Large File Support on 32-bit
architectures where their ABI does not include LFS by default, by adding
\fB-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64\fP to \fBCPPFLAGS\fP.
.
.SS qa
Several compile-time options (detailed below) can be used to help detect
problems in the source code or build system.
.TP
.B bug
This setting (disabled by default) adds any warning option that reliably
detects problematic source code. The warnings are fatal.
The only currently supported flags are \fBCFLAGS\fP and \fBCXXFLAGS\fP
with flags set to \fB\-Werror=array\-bounds\fP, \fB\-Werror=clobbered\fP,
\fB\-Werror=implicit\-function\-declaration\fP and
\fB\-Werror=volatile\-register\-var\fP.
.
.TP
.B canary
This setting (disabled by default) adds dummy canary options to the build
flags, so that the build logs can be checked for how the build flags
propagate and to allow finding any omission of normal build flag settings.
The only currently supported flags are \fBCPPFLAGS\fP, \fBCFLAGS\fP,
\fBOBJCFLAGS\fP, \fBCXXFLAGS\fP and \fBOBJCXXFLAGS\fP with flags set
to \fB\-D__DEB_CANARY_\fP\fIflag\fP_\fIrandom-id\fP\fB__\fP, and
\fBLDFLAGS\fP set to \fB\-Wl,\-z,deb-canary\-\fP\fIrandom-id\fP.
.
.SS sanitize
Several compile-time options (detailed below) can be used to help sanitize
a resulting binary against memory corruptions, memory leaks, use after free,
threading data races and undefined behavior bugs.
\fBNote\fP: these options should \fBnot\fP be used for production builds
as they can reduce reliability for conformant code, reduce security or
even functionality.
.TP
.B address
This setting (disabled by default) adds \fB\-fsanitize=address\fP to
\fBLDFLAGS\fP and \fB\-fsanitize=address \-fno\-omit\-frame\-pointer\fP to
\fBCFLAGS\fP and \fBCXXFLAGS\fP.
.TP
.B thread
This setting (disabled by default) adds \fB\-fsanitize=thread\fP to
\fBCFLAGS\fP, \fBCXXFLAGS\fP and \fBLDFLAGS\fP.
.TP
.B leak
This setting (disabled by default) adds \fB\-fsanitize=leak\fP to
\fBLDFLAGS\fP. It gets automatically disabled if either the \fBaddress\fP
or the \fBthread\fP features are enabled, as they imply it.
.TP
.B undefined
This setting (disabled by default) adds \fB\-fsanitize=undefined\fP to
\fBCFLAGS\fP, \fBCXXFLAGS\fP and \fBLDFLAGS\fP.
.SS hardening
Several compile-time options (detailed below) can be used to help harden
a resulting binary against memory corruption attacks, or provide
additional warning messages during compilation.
Except as noted below, these are enabled by default for architectures
that support them.
.TP
.B format
This setting (enabled by default) adds
.B \-Wformat \-Werror=format\-security
to \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP and \fBOBJCXXFLAGS\fP.
This will warn about improper format
string uses, and will fail when format functions are used in a way
that represent possible security problems. At present, this warns about
calls to \fBprintf\fP and \fBscanf\fP functions where the format string is
not a string literal and there are no format arguments, as in
\fBprintf(foo);\fP instead of \fPprintf("%s", foo);\fP
This may be a security hole if the format string came from untrusted
input and contains ‘%n’.
.
.TP
.B fortify
This setting (enabled by default) adds
.B \-D_FORTIFY_SOURCE=2
to \fBCPPFLAGS\fP. During code generation the compiler
knows a great deal of information about buffer sizes (where possible), and
attempts to replace insecure unlimited length buffer function calls with
length-limited ones. This is especially useful for old, crufty code.
Additionally, format strings in writable memory that contain ‘%n’ are
blocked. If an application depends on such a format string, it will need
to be worked around.

Note that for this option to have any effect, the source must also
be compiled with \fB\-O1\fP or higher. If the environment variable
\fBDEB_BUILD_OPTIONS\fP contains \fInoopt\fP, then \fBfortify\fP
support will be disabled, due to new warnings being issued by
glibc 2.16 and later.
.TP
.B stackprotector
This setting (enabled by default if stackprotectorstrong is not in use) adds
.B \-fstack\-protector \-\-param=ssp\-buffer\-size=4
to \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP,
\fBGCJFLAGS\fP, \fBFFLAGS\fP and \fBFCFLAGS\fP.
This adds safety checks against stack
overwrites. This renders many potential code injection attacks into
aborting situations. In the best case this turns code injection
vulnerabilities into denial of service or into non-issues (depending on
the application).

This feature requires linking against glibc (or another provider of
\fB__stack_chk_fail\fP), so needs to be disabled when building with
\fB\-nostdlib\fP or \fB\-ffreestanding\fP or similar.
.
.TP
.B stackprotectorstrong
This setting (enabled by default) adds
.B \-fstack\-protector\-strong
to \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP,
\fBGCJFLAGS\fP, \fBFFLAGS\fP and \fBFCFLAGS\fP.
This is a stronger variant of \fBstackprotector\fP, but without significant
performance penalties.

Disabling \fBstackprotector\fP will also disable this setting.

This feature has the same requirements as \fBstackprotector\fP, and in
addition also requires gcc 4.9 and later.
.
.TP
.B relro
This setting (enabled by default) adds
.B \-Wl,\-z,relro
to \fBLDFLAGS\fP.  During program load, several ELF memory sections need
to be written to by the linker. This flags the loader to turn these
sections read-only before turning over control to the program. Most
notably this prevents GOT overwrite attacks. If this option is disabled,
\fBbindnow\fP will become disabled as well.
.
.TP
.B bindnow
This setting (disabled by default) adds
.B \-Wl,\-z,now
to \fBLDFLAGS\fP. During program load, all dynamic symbols are resolved,
allowing for the entire PLT to be marked read-only (due to \fBrelro\fP
above). The option cannot become enabled if \fBrelro\fP is not enabled.
.
.TP
.B pie
This setting (with no global default since dpkg 1.18.23, as it is enabled
by default now by gcc on the amd64, arm64, armel, armhf, hurd-i386, i386,
kfreebsd-amd64, kfreebsd-i386, mips, mipsel, mips64el, powerpc, ppc64,
ppc64el, riscv64, s390x, sparc and sparc64 Debian architectures) adds
the required options to enable or disable PIE via gcc specs files, if
needed, depending on whether gcc injects on that architecture the flags
by itself or not.
When the setting is enabled and gcc injects the flags, it adds nothing.
When the setting is enabled and gcc does not inject the flags, it adds
\fB\-fPIE\fP (via \fI%PKGDATADIR%/pie-compiler.specs\fP) to \fBCFLAGS\fP,
\fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP,
\fBFFLAGS\fP and \fBFCFLAGS\fP, and
\fB\-fPIE \-pie\fP (via \fI%PKGDATADIR%/pie-link.specs\fP) to \fBLDFLAGS\fP.
When the setting is disabled and gcc injects the flags, it adds
\fB\-fno\-PIE\fP (via \fI%PKGDATADIR%/no-pie-compile.specs\fP) to \fBCFLAGS\fP,
\fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP,
\fBFFLAGS\fP and \fBFCFLAGS\fP, and
\fB\-fno\-PIE \-no\-pie\fP (via \fI%PKGDATADIR%/no-pie-link.specs\fP) to
\fBLDFLAGS\fP.

Position Independent
Executable are needed to take advantage of Address Space Layout
Randomization, supported by some kernel versions. While ASLR can already
be enforced for data areas in the stack and heap (brk and mmap), the code
areas must be compiled as position-independent. Shared libraries already
do this (\fB\-fPIC\fP), so they gain ASLR automatically, but binary .text
regions need to be build PIE to gain ASLR. When this happens, ROP (Return
Oriented Programming) attacks are much harder since there are no static
locations to bounce off of during a memory corruption attack.

PIE is not compatible with \fB\-fPIC\fP, so in general care must be taken
when building shared objects. But because the PIE flags emitted get injected
via gcc specs files, it should always be safe to unconditionally set them
regardless of the object type being compiled or linked.

Static libraries can be used by programs or other shared libraries.
Depending on the flags used to compile all the objects within a static
library, these libraries will be usable by different sets of objects:

.RS
.TP
none
Cannot be linked into a PIE program, nor a shared library.
.TP
.B \-fPIE
Can be linked into any program, but not a shared library (recommended).
.TP
.B \-fPIC
Can be linked into any program and shared library.
.RE

.IP
If there is a need to set these flags manually, bypassing the gcc specs
injection, there are several things to take into account. Unconditionally
and explicitly passing \fB\-fPIE\fP, \fB\-fpie\fP or \fB\-pie\fP to a
build-system using libtool is safe as these flags will get stripped
when building shared libraries.
Otherwise on projects that build both programs and shared libraries you
might need to make sure that when building the shared libraries \fB\-fPIC\fP
is always passed last (so that it overrides any previous \fB\-PIE\fP) to
compilation flags such as \fBCFLAGS\fP, and \fB\-shared\fP is passed last
(so that it overrides any previous \fB\-pie\fP) to linking flags such as
\fBLDFLAGS\fP. \fBNote:\fP This should not be needed with the default
gcc specs machinery.

.IP
Additionally, since PIE is implemented via a general register, some
register starved architectures (but not including i386 anymore since
optimizations implemented in gcc >= 5) can see performance losses of up to
15% in very text-segment-heavy application workloads; most workloads
see less than 1%. Architectures with more general registers (e.g. amd64)
do not see as high a worst-case penalty.
.SS reproducible
The compile-time options detailed below can be used to help improve
build reproducibility or provide additional warning messages during
compilation. Except as noted below, these are enabled by default for
architectures that support them.
.TP
.B timeless
This setting (enabled by default) adds
.B \-Wdate\-time
to \fBCPPFLAGS\fP.
This will cause warnings when the \fB__TIME__\fP, \fB__DATE__\fP and
\fB__TIMESTAMP__\fP macros are used.
.
.TP
.B fixfilepath
This setting (disabled by default) adds
.BI \-ffile\-prefix\-map= BUILDPATH =.
to \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP,
\fBGCJFLAGS\fP, \fBFFLAGS\fP and \fBFCFLAGS\fP where \fBBUILDPATH\fP is
set to the top-level directory of the package being built.
This has the effect of removing the build path from any generated file.

If both \fBfixdebugpath\fP and \fBfixfilepath\fP are set, this option
takes precedence, because it is a superset of the former.
.TP
.B fixdebugpath
This setting (enabled by default) adds
.BI \-fdebug\-prefix\-map= BUILDPATH =.
to \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP,
\fBGCJFLAGS\fP, \fBFFLAGS\fP and \fBFCFLAGS\fP where \fBBUILDPATH\fP is
set to the top-level directory of the package being built.
This has the effect of removing the build path from any generated debug
symbols.
.
.SH ENVIRONMENT
There are 2 sets of environment variables doing the same operations, the
first one (DEB_\fIflag\fP_\fIop\fP) should never be used within
\fBdebian/rules\fP. It's meant for any user that wants to rebuild the
source package with different build flags. The second set
(DEB_\fIflag\fP_MAINT_\fIop\fP) should only be used in \fBdebian/rules\fP
by package maintainers to change the resulting build flags.
.TP
.BI DEB_ flag _SET
.TQ
.BI DEB_ flag _MAINT_SET
This variable can be used to force the value returned for the given
\fIflag\fP.
.TP
.BI DEB_ flag _STRIP
.TQ
.BI DEB_ flag _MAINT_STRIP
This variable can be used to provide a space separated list of options
that will be stripped from the set of flags returned for the given
\fIflag\fP.
.TP
.BI DEB_ flag _APPEND
.TQ
.BI DEB_ flag _MAINT_APPEND
This variable can be used to append supplementary options to the value
returned for the given \fIflag\fP.
.TP
.BI DEB_ flag _PREPEND
.TQ
.BI DEB_ flag _MAINT_PREPEND
This variable can be used to prepend supplementary options to the value
returned for the given \fIflag\fP.
.TP
.B DEB_BUILD_OPTIONS
.TQ
.B DEB_BUILD_MAINT_OPTIONS
These variables can be used by a user or maintainer to disable/enable
various area features that affect build flags.
The \fBDEB_BUILD_MAINT_OPTIONS\fP variable overrides any setting in the
\fBDEB_BUILD_OPTIONS\fP feature areas.
See the \fBFEATURE AREAS\fP section for details.
.TP
.B DEB_VENDOR
This setting defines the current vendor.
If not set, it will discover the current vendor by reading
\fB%PKGCONFDIR%/origins/default\fP.
.TP
.B DEB_BUILD_PATH
This variable sets the build path (since dpkg 1.18.8) to use in features
such as \fBfixdebugpath\fP so that they can be controlled by the caller.
This variable is currently Debian and derivatives-specific.
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B DPKG_NLS
If set, it will be used to decide whether to activate Native Language Support,
also known as internationalization (or i18n) support (since dpkg 1.19.0).
The accepted values are: \fB0\fP and \fB1\fP (default).
.
.SH FILES
.SS Configuration files
.TP
.B %PKGCONFDIR%/buildflags.conf
System wide configuration file.
.TP
.BR $XDG_CONFIG_HOME/dpkg/buildflags.conf " or "
.TQ
.BR $HOME/.config/dpkg/buildflags.conf
User configuration file.
.SS Packaging support
.TP
.B %PKGDATADIR%/buildflags.mk
Makefile snippet that will load (and optionally export) all flags
supported by \fBdpkg-buildflags\fP into variables (since dpkg 1.16.1).
.
.SH EXAMPLES
To pass build flags to a build command in a Makefile:
.PP
.RS 4
.nf
$(MAKE) $(shell dpkg\-buildflags \-\-export=cmdline)

\&./configure $(shell dpkg\-buildflags \-\-export=cmdline)
.fi
.RE
.PP
To set build flags in a shell script or shell fragment, \fBeval\fP can be
used to interpret the output and to export the flags in the environment:
.PP
.RS 4
.nf
eval "$(dpkg\-buildflags \-\-export=sh)" && make
.fi
.RE
.PP
or to set the positional parameters to pass to a command:
.PP
.RS 4
.nf
eval "set \-\- $(dpkg\-buildflags \-\-export=cmdline)"
for dir in a b c; do (cd $dir && ./configure "$@" && make); done
.fi
.RE
.
.SS Usage in debian/rules
You should call \fBdpkg\-buildflags\fP or include \fBbuildflags.mk\fP
from the \fBdebian/rules\fP file to obtain the needed build flags to
pass to the build system.
Note that older versions of \fBdpkg\-buildpackage\fP (before dpkg 1.16.1)
exported these flags automatically. However, you should not rely on this,
since this breaks manual invocation of \fBdebian/rules\fP.
.PP
For packages with autoconf-like build systems, you can pass the relevant
options to configure or \fBmake\fP(1) directly, as shown above.
.PP
For other build systems, or when you need more fine-grained control
about which flags are passed where, you can use \fB\-\-get\fP. Or you
can include \fBbuildflags.mk\fP instead, which takes care of calling
\fBdpkg\-buildflags\fP and storing the build flags in make variables.
.PP
If you want to export all buildflags into the environment (where they
can be picked up by your build system):
.PP
.RS 4
.nf
DPKG_EXPORT_BUILDFLAGS = 1
include %PKGDATADIR%/buildflags.mk
.fi
.RE
.PP
For some extra control over what is exported, you can manually export
the variables (as none are exported by default):
.PP
.RS 4
.nf
include %PKGDATADIR%/buildflags.mk
export CPPFLAGS CFLAGS LDFLAGS
.fi
.RE
.PP
And you can of course pass the flags to commands manually:
.PP
.RS 4
.nf
include %PKGDATADIR%/buildflags.mk
build\-arch:
\&	$(CC) \-o hello hello.c $(CPPFLAGS) $(CFLAGS) $(LDFLAGS)
.fi
.RE
