#!/usr/bin/python
# Copyright 2018 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""The diagrams included in the network stack documentation were
generated with Graphviz, and both source (.dot) and output (.svg) are
included in the repository.  If graphviz is installed, the output may
be regenerated by running this script."""

import glob
import os
import subprocess

def main():
  for dot_filename in glob.glob("*.dot"):
    svg_filename = os.path.splitext(dot_filename)[0] + ".svg"
    print "Generating %s from %s" % (svg_filename, dot_filename)
    subprocess.check_call(["dot", "-Tsvg", dot_filename, "-o", svg_filename])


if __name__ == "__main__":
  main()
