/*
 * Copyright 2013 The Native Client Authors.  All rights reserved.
 * Use of this source code is governed by a BSD-style license that can
 * be found in the LICENSE file.
 */

// DO NOT EDIT: GENERATED CODE

#ifndef NACL_TRUSTED_BUT_NOT_TCB
#error This file is not meant for use in the TCB
#endif


#ifndef NATIVE_CLIENT_SRC_TRUSTED_VALIDATOR_ARM_GEN_ARM32_DECODE_NAMED_DECODER_H_
#define NATIVE_CLIENT_SRC_TRUSTED_VALIDATOR_ARM_GEN_ARM32_DECODE_NAMED_DECODER_H_

#include "native_client/src/trusted/validator_arm/decode.h"
#include "native_client/src/trusted/validator_arm/gen/arm32_decode_named_classes.h"
#include "native_client/src/trusted/validator_arm/named_class_decoder.h"

namespace nacl_arm_test {

// Defines a (named) decoder class selector for instructions
class NamedArm32DecoderState : nacl_arm_dec::DecoderState {
 public:
  explicit NamedArm32DecoderState();

  // Parses the given instruction, returning the named class
  // decoder to use.
  const NamedClassDecoder& decode_named(
     const nacl_arm_dec::Instruction) const;

  // Parses the given instruction, returning the class decoder
  // to use.
  virtual const nacl_arm_dec::ClassDecoder& decode(
     const nacl_arm_dec::Instruction) const;

  // The following fields define the set of class decoders
  // that can be returned by the API function "decode_named". They
  // are created once as instance fields, and then returned
  // by the table methods above. This speeds up the code since
  // the class decoders need to only be bulit once (and reused
  // for each call to "decode_named").
  const NamedADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_0_ADC_immediate ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_0_ADC_immediate_instance_;
  const NamedADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_0_ADC_register ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_0_ADC_register_instance_;
  const NamedADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_0_ADC_register_shifted_register ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_0_ADC_register_shifted_register_instance_;
  const NamedADD_immediate_cccc0010100snnnnddddiiiiiiiiiiii_case_0_ADD_immediate ADD_immediate_cccc0010100snnnnddddiiiiiiiiiiii_case_0_ADD_immediate_instance_;
  const NamedADD_register_cccc0000100snnnnddddiiiiitt0mmmm_case_0_ADD_register ADD_register_cccc0000100snnnnddddiiiiitt0mmmm_case_0_ADD_register_instance_;
  const NamedADD_register_shifted_register_cccc0000100snnnnddddssss0tt1mmmm_case_0_ADD_register_shifted_register ADD_register_shifted_register_cccc0000100snnnnddddssss0tt1mmmm_case_0_ADD_register_shifted_register_instance_;
  const NamedADR_A1_cccc001010001111ddddiiiiiiiiiiii_case_0_ADR_A1 ADR_A1_cccc001010001111ddddiiiiiiiiiiii_case_0_ADR_A1_instance_;
  const NamedADR_A2_cccc001001001111ddddiiiiiiiiiiii_case_0_ADR_A2 ADR_A2_cccc001001001111ddddiiiiiiiiiiii_case_0_ADR_A2_instance_;
  const NamedAND_immediate_cccc0010000snnnnddddiiiiiiiiiiii_case_0_AND_immediate AND_immediate_cccc0010000snnnnddddiiiiiiiiiiii_case_0_AND_immediate_instance_;
  const NamedAND_register_cccc0000000snnnnddddiiiiitt0mmmm_case_0_AND_register AND_register_cccc0000000snnnnddddiiiiitt0mmmm_case_0_AND_register_instance_;
  const NamedAND_register_shifted_register_cccc0000000snnnnddddssss0tt1mmmm_case_0_AND_register_shifted_register AND_register_shifted_register_cccc0000000snnnnddddssss0tt1mmmm_case_0_AND_register_shifted_register_instance_;
  const NamedASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_0_ASR_immediate ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_0_ASR_immediate_instance_;
  const NamedASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_0_ASR_register ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_0_ASR_register_instance_;
  const NamedBFC_cccc0111110mmmmmddddlllll0011111_case_0_BFC BFC_cccc0111110mmmmmddddlllll0011111_case_0_BFC_instance_;
  const NamedBFI_cccc0111110mmmmmddddlllll001nnnn_case_0_BFI BFI_cccc0111110mmmmmddddlllll001nnnn_case_0_BFI_instance_;
  const NamedBIC_immediate_cccc0011110snnnnddddiiiiiiiiiiii_case_0_BIC_immediate BIC_immediate_cccc0011110snnnnddddiiiiiiiiiiii_case_0_BIC_immediate_instance_;
  const NamedBIC_register_cccc0001110snnnnddddiiiiitt0mmmm_case_0_BIC_register BIC_register_cccc0001110snnnnddddiiiiitt0mmmm_case_0_BIC_register_instance_;
  const NamedBIC_register_shifted_register_cccc0001110snnnnddddssss0tt1mmmm_case_0_BIC_register_shifted_register BIC_register_shifted_register_cccc0001110snnnnddddssss0tt1mmmm_case_0_BIC_register_shifted_register_instance_;
  const NamedBKPT_cccc00010010iiiiiiiiiiii0111iiii_case_0_BKPT BKPT_cccc00010010iiiiiiiiiiii0111iiii_case_0_BKPT_instance_;
  const NamedBLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_0_BLX_immediate BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_0_BLX_immediate_instance_;
  const NamedBLX_register_cccc000100101111111111110011mmmm_case_0_BLX_register BLX_register_cccc000100101111111111110011mmmm_case_0_BLX_register_instance_;
  const NamedBL_BLX_immediate_cccc1011iiiiiiiiiiiiiiiiiiiiiiii_case_0_BL_BLX_immediate BL_BLX_immediate_cccc1011iiiiiiiiiiiiiiiiiiiiiiii_case_0_BL_BLX_immediate_instance_;
  const NamedBXJ_cccc000100101111111111110010mmmm_case_0_BXJ BXJ_cccc000100101111111111110010mmmm_case_0_BXJ_instance_;
  const NamedB_cccc1010iiiiiiiiiiiiiiiiiiiiiiii_case_0_B B_cccc1010iiiiiiiiiiiiiiiiiiiiiiii_case_0_B_instance_;
  const NamedBx_cccc000100101111111111110001mmmm_case_0_Bx Bx_cccc000100101111111111110001mmmm_case_0_Bx_instance_;
  const NamedCDP2_11111110iiiiiiiiiiiiiiiiiii0iiii_case_0_CDP2 CDP2_11111110iiiiiiiiiiiiiiiiiii0iiii_case_0_CDP2_instance_;
  const NamedCDP_cccc1110oooonnnnddddccccooo0mmmm_case_0_CDP CDP_cccc1110oooonnnnddddccccooo0mmmm_case_0_CDP_instance_;
  const NamedCLREX_11110101011111111111000000011111_case_0_CLREX CLREX_11110101011111111111000000011111_case_0_CLREX_instance_;
  const NamedCLZ_cccc000101101111dddd11110001mmmm_case_0_CLZ CLZ_cccc000101101111dddd11110001mmmm_case_0_CLZ_instance_;
  const NamedCMN_immediate_cccc00110111nnnn0000iiiiiiiiiiii_case_0_CMN_immediate CMN_immediate_cccc00110111nnnn0000iiiiiiiiiiii_case_0_CMN_immediate_instance_;
  const NamedCMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_0_CMN_register CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_0_CMN_register_instance_;
  const NamedCMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_0_CMN_register_shifted_register CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_0_CMN_register_shifted_register_instance_;
  const NamedCMP_immediate_cccc00110101nnnn0000iiiiiiiiiiii_case_0_CMP_immediate CMP_immediate_cccc00110101nnnn0000iiiiiiiiiiii_case_0_CMP_immediate_instance_;
  const NamedCMP_register_cccc00010101nnnn0000iiiiitt0mmmm_case_0_CMP_register CMP_register_cccc00010101nnnn0000iiiiitt0mmmm_case_0_CMP_register_instance_;
  const NamedCMP_register_shifted_register_cccc00010101nnnn0000ssss0tt1mmmm_case_0_CMP_register_shifted_register CMP_register_shifted_register_cccc00010101nnnn0000ssss0tt1mmmm_case_0_CMP_register_shifted_register_instance_;
  const NamedCPS_111100010000iii00000000iii0iiiii_case_0_CPS CPS_111100010000iii00000000iii0iiiii_case_0_CPS_instance_;
  const NamedCVT_between_half_precision_and_single_precision_111100111d11ss10dddd011p00m0mmmm_case_0_CVT_between_half_precision_and_single_precision CVT_between_half_precision_and_single_precision_111100111d11ss10dddd011p00m0mmmm_case_0_CVT_between_half_precision_and_single_precision_instance_;
  const NamedDBG_cccc001100100000111100001111iiii_case_0_DBG DBG_cccc001100100000111100001111iiii_case_0_DBG_instance_;
  const NamedDMB_1111010101111111111100000101xxxx_case_0_DMB DMB_1111010101111111111100000101xxxx_case_0_DMB_instance_;
  const NamedDSB_1111010101111111111100000100xxxx_case_0_DSB DSB_1111010101111111111100000100xxxx_case_0_DSB_instance_;
  const NamedEOR_immediate_cccc0010001snnnnddddiiiiiiiiiiii_case_0_EOR_immediate EOR_immediate_cccc0010001snnnnddddiiiiiiiiiiii_case_0_EOR_immediate_instance_;
  const NamedEOR_register_cccc0000001snnnnddddiiiiitt0mmmm_case_0_EOR_register EOR_register_cccc0000001snnnnddddiiiiitt0mmmm_case_0_EOR_register_instance_;
  const NamedEOR_register_shifted_register_cccc0000001snnnnddddssss0tt1mmmm_case_0_EOR_register_shifted_register EOR_register_shifted_register_cccc0000001snnnnddddssss0tt1mmmm_case_0_EOR_register_shifted_register_instance_;
  const NamedERET_cccc0001011000000000000001101110_case_0_ERET ERET_cccc0001011000000000000001101110_case_0_ERET_instance_;
  const NamedFICTITIOUS_FIRST_case_0_FICTITIOUS_FIRST FICTITIOUS_FIRST_case_0_FICTITIOUS_FIRST_instance_;
  const NamedHVC_cccc00010100iiiiiiiiiiii0111iiii_case_0_HVC HVC_cccc00010100iiiiiiiiiiii0111iiii_case_0_HVC_instance_;
  const NamedISB_1111010101111111111100000110xxxx_case_0_ISB ISB_1111010101111111111100000110xxxx_case_0_ISB_instance_;
  const NamedLDC2_immediate_1111110pudw1nnnniiiiiiiiiiiiiiii_case_0_LDC2_immediate LDC2_immediate_1111110pudw1nnnniiiiiiiiiiiiiiii_case_0_LDC2_immediate_instance_;
  const NamedLDC2_literal_1111110pudw11111iiiiiiiiiiiiiiii_case_0_LDC2_literal LDC2_literal_1111110pudw11111iiiiiiiiiiiiiiii_case_0_LDC2_literal_instance_;
  const NamedLDC_immediate_cccc110pudw1nnnnddddcccciiiiiiii_case_0_LDC_immediate LDC_immediate_cccc110pudw1nnnnddddcccciiiiiiii_case_0_LDC_immediate_instance_;
  const NamedLDC_literal_cccc110pudw11111ddddcccciiiiiiii_case_0_LDC_literal LDC_literal_cccc110pudw11111ddddcccciiiiiiii_case_0_LDC_literal_instance_;
  const NamedLDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_0_LDMDA_LDMFA LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_0_LDMDA_LDMFA_instance_;
  const NamedLDMDB_LDMEA_cccc100100w1nnnnrrrrrrrrrrrrrrrr_case_0_LDMDB_LDMEA LDMDB_LDMEA_cccc100100w1nnnnrrrrrrrrrrrrrrrr_case_0_LDMDB_LDMEA_instance_;
  const NamedLDMIB_LDMED_cccc100110w1nnnnrrrrrrrrrrrrrrrr_case_0_LDMIB_LDMED LDMIB_LDMED_cccc100110w1nnnnrrrrrrrrrrrrrrrr_case_0_LDMIB_LDMED_instance_;
  const NamedLDM_LDMIA_LDMFD_cccc100010w1nnnnrrrrrrrrrrrrrrrr_case_0_LDM_LDMIA_LDMFD LDM_LDMIA_LDMFD_cccc100010w1nnnnrrrrrrrrrrrrrrrr_case_0_LDM_LDMIA_LDMFD_instance_;
  const NamedLDM_User_registers_cccc100pu101nnnn0rrrrrrrrrrrrrrr_case_0_LDM_User_registers LDM_User_registers_cccc100pu101nnnn0rrrrrrrrrrrrrrr_case_0_LDM_User_registers_instance_;
  const NamedLDM_exception_return_cccc100pu1w1nnnn1rrrrrrrrrrrrrrr_case_0_LDM_exception_return LDM_exception_return_cccc100pu1w1nnnn1rrrrrrrrrrrrrrr_case_0_LDM_exception_return_instance_;
  const NamedLDRBT_A1_cccc0100u111nnnnttttiiiiiiiiiiii_case_0_LDRBT_A1 LDRBT_A1_cccc0100u111nnnnttttiiiiiiiiiiii_case_0_LDRBT_A1_instance_;
  const NamedLDRBT_A2_cccc0110u111nnnnttttiiiiitt0mmmm_case_0_LDRBT_A2 LDRBT_A2_cccc0110u111nnnnttttiiiiitt0mmmm_case_0_LDRBT_A2_instance_;
  const NamedLDRB_immediate_cccc010pu1w1nnnnttttiiiiiiiiiiii_case_0_LDRB_immediate LDRB_immediate_cccc010pu1w1nnnnttttiiiiiiiiiiii_case_0_LDRB_immediate_instance_;
  const NamedLDRB_literal_cccc0101u1011111ttttiiiiiiiiiiii_case_0_LDRB_literal LDRB_literal_cccc0101u1011111ttttiiiiiiiiiiii_case_0_LDRB_literal_instance_;
  const NamedLDRB_register_cccc011pu1w1nnnnttttiiiiitt0mmmm_case_0_LDRB_register LDRB_register_cccc011pu1w1nnnnttttiiiiitt0mmmm_case_0_LDRB_register_instance_;
  const NamedLDRD_immediate_cccc000pu1w0nnnnttttiiii1101iiii_case_0_LDRD_immediate LDRD_immediate_cccc000pu1w0nnnnttttiiii1101iiii_case_0_LDRD_immediate_instance_;
  const NamedLDRD_literal_cccc0001u1001111ttttiiii1101iiii_case_0_LDRD_literal LDRD_literal_cccc0001u1001111ttttiiii1101iiii_case_0_LDRD_literal_instance_;
  const NamedLDRD_register_cccc000pu0w0nnnntttt00001101mmmm_case_0_LDRD_register LDRD_register_cccc000pu0w0nnnntttt00001101mmmm_case_0_LDRD_register_instance_;
  const NamedLDREXB_cccc00011101nnnntttt111110011111_case_0_LDREXB LDREXB_cccc00011101nnnntttt111110011111_case_0_LDREXB_instance_;
  const NamedLDREXD_cccc00011011nnnntttt111110011111_case_0_LDREXD LDREXD_cccc00011011nnnntttt111110011111_case_0_LDREXD_instance_;
  const NamedLDREX_cccc00011001nnnntttt111110011111_case_0_LDREX LDREX_cccc00011001nnnntttt111110011111_case_0_LDREX_instance_;
  const NamedLDRH_immediate_cccc000pu1w1nnnnttttiiii1011iiii_case_0_LDRH_immediate LDRH_immediate_cccc000pu1w1nnnnttttiiii1011iiii_case_0_LDRH_immediate_instance_;
  const NamedLDRH_literal_cccc000pu1w11111ttttiiii1011iiii_case_0_LDRH_literal LDRH_literal_cccc000pu1w11111ttttiiii1011iiii_case_0_LDRH_literal_instance_;
  const NamedLDRH_register_cccc000pu0w1nnnntttt00001011mmmm_case_0_LDRH_register LDRH_register_cccc000pu0w1nnnntttt00001011mmmm_case_0_LDRH_register_instance_;
  const NamedLDRSB_immediate_cccc000pu1w1nnnnttttiiii1101iiii_case_0_LDRSB_immediate LDRSB_immediate_cccc000pu1w1nnnnttttiiii1101iiii_case_0_LDRSB_immediate_instance_;
  const NamedLDRSB_literal_cccc0001u1011111ttttiiii1101iiii_case_0_LDRSB_literal LDRSB_literal_cccc0001u1011111ttttiiii1101iiii_case_0_LDRSB_literal_instance_;
  const NamedLDRSB_register_cccc000pu0w1nnnntttt00001101mmmm_case_0_LDRSB_register LDRSB_register_cccc000pu0w1nnnntttt00001101mmmm_case_0_LDRSB_register_instance_;
  const NamedLDRSH_immediate_cccc000pu1w1nnnnttttiiii1111iiii_case_0_LDRSH_immediate LDRSH_immediate_cccc000pu1w1nnnnttttiiii1111iiii_case_0_LDRSH_immediate_instance_;
  const NamedLDRSH_literal_cccc0001u1011111ttttiiii1111iiii_case_0_LDRSH_literal LDRSH_literal_cccc0001u1011111ttttiiii1111iiii_case_0_LDRSH_literal_instance_;
  const NamedLDRSH_register_cccc000pu0w1nnnntttt00001111mmmm_case_0_LDRSH_register LDRSH_register_cccc000pu0w1nnnntttt00001111mmmm_case_0_LDRSH_register_instance_;
  const NamedLDRT_A1_cccc0100u011nnnnttttiiiiiiiiiiii_case_0_LDRT_A1 LDRT_A1_cccc0100u011nnnnttttiiiiiiiiiiii_case_0_LDRT_A1_instance_;
  const NamedLDRT_A2_cccc0110u011nnnnttttiiiiitt0mmmm_case_0_LDRT_A2 LDRT_A2_cccc0110u011nnnnttttiiiiitt0mmmm_case_0_LDRT_A2_instance_;
  const NamedLDR_immediate_cccc010pu0w1nnnnttttiiiiiiiiiiii_case_0_LDR_immediate LDR_immediate_cccc010pu0w1nnnnttttiiiiiiiiiiii_case_0_LDR_immediate_instance_;
  const NamedLDR_literal_cccc0101u0011111ttttiiiiiiiiiiii_case_0_LDR_literal LDR_literal_cccc0101u0011111ttttiiiiiiiiiiii_case_0_LDR_literal_instance_;
  const NamedLDR_register_cccc011pu0w1nnnnttttiiiiitt0mmmm_case_0_LDR_register LDR_register_cccc011pu0w1nnnnttttiiiiitt0mmmm_case_0_LDR_register_instance_;
  const NamedLSL_immediate_cccc0001101s0000ddddiiiii000mmmm_case_0_LSL_immediate LSL_immediate_cccc0001101s0000ddddiiiii000mmmm_case_0_LSL_immediate_instance_;
  const NamedLSL_register_cccc0001101s0000ddddmmmm0001nnnn_case_0_LSL_register LSL_register_cccc0001101s0000ddddmmmm0001nnnn_case_0_LSL_register_instance_;
  const NamedLSR_immediate_cccc0001101s0000ddddiiiii010mmmm_case_0_LSR_immediate LSR_immediate_cccc0001101s0000ddddiiiii010mmmm_case_0_LSR_immediate_instance_;
  const NamedLSR_register_cccc0001101s0000ddddmmmm0011nnnn_case_0_LSR_register LSR_register_cccc0001101s0000ddddmmmm0011nnnn_case_0_LSR_register_instance_;
  const NamedMCR2_11111110iii0iiiittttiiiiiii1iiii_case_0_MCR2 MCR2_11111110iii0iiiittttiiiiiii1iiii_case_0_MCR2_instance_;
  const NamedMCRR2_111111000100ssssttttiiiiiiiiiiii_case_0_MCRR2 MCRR2_111111000100ssssttttiiiiiiiiiiii_case_0_MCRR2_instance_;
  const NamedMCRR_cccc11000100ttttttttccccoooommmm_case_0_MCRR MCRR_cccc11000100ttttttttccccoooommmm_case_0_MCRR_instance_;
  const NamedMCR_cccc1110ooo0nnnnttttccccooo1mmmm_case_0_MCR MCR_cccc1110ooo0nnnnttttccccooo1mmmm_case_0_MCR_instance_;
  const NamedMLA_A1_cccc0000001sddddaaaammmm1001nnnn_case_0_MLA_A1 MLA_A1_cccc0000001sddddaaaammmm1001nnnn_case_0_MLA_A1_instance_;
  const NamedMLS_A1_cccc00000110ddddaaaammmm1001nnnn_case_0_MLS_A1 MLS_A1_cccc00000110ddddaaaammmm1001nnnn_case_0_MLS_A1_instance_;
  const NamedMOVE_scalar_to_ARM_core_register_cccc1110iii1nnnntttt1011nii10000_case_0_MOVE_scalar_to_ARM_core_register MOVE_scalar_to_ARM_core_register_cccc1110iii1nnnntttt1011nii10000_case_0_MOVE_scalar_to_ARM_core_register_instance_;
  const NamedMOVT_cccc00110100iiiiddddiiiiiiiiiiii_case_0_MOVT MOVT_cccc00110100iiiiddddiiiiiiiiiiii_case_0_MOVT_instance_;
  const NamedMOVW_cccc00110000iiiiddddiiiiiiiiiiii_case_0_MOVW MOVW_cccc00110000iiiiddddiiiiiiiiiiii_case_0_MOVW_instance_;
  const NamedMOV_immediate_A1_cccc0011101s0000ddddiiiiiiiiiiii_case_0_MOV_immediate_A1 MOV_immediate_A1_cccc0011101s0000ddddiiiiiiiiiiii_case_0_MOV_immediate_A1_instance_;
  const NamedMOV_register_cccc0001101s0000dddd00000000mmmm_case_0_MOV_register MOV_register_cccc0001101s0000dddd00000000mmmm_case_0_MOV_register_instance_;
  const NamedMRC2_11111110iii1iiiittttiiiiiii1iiii_case_0_MRC2 MRC2_11111110iii1iiiittttiiiiiii1iiii_case_0_MRC2_instance_;
  const NamedMRC_cccc1110ooo1nnnnttttccccooo1mmmm_case_0_MRC MRC_cccc1110ooo1nnnnttttccccooo1mmmm_case_0_MRC_instance_;
  const NamedMRRC2_111111000101ssssttttiiiiiiiiiiii_case_0_MRRC2 MRRC2_111111000101ssssttttiiiiiiiiiiii_case_0_MRRC2_instance_;
  const NamedMRRC_cccc11000101ttttttttccccoooommmm_case_0_MRRC MRRC_cccc11000101ttttttttccccoooommmm_case_0_MRRC_instance_;
  const NamedMRS_Banked_register_cccc00010r00mmmmdddd001m00000000_case_0_MRS_Banked_register MRS_Banked_register_cccc00010r00mmmmdddd001m00000000_case_0_MRS_Banked_register_instance_;
  const NamedMRS_Banked_register_cccc00010r10mmmm1111001m0000nnnn_case_0_MRS_Banked_register MRS_Banked_register_cccc00010r10mmmm1111001m0000nnnn_case_0_MRS_Banked_register_instance_;
  const NamedMRS_cccc00010r001111dddd000000000000_case_0_MRS MRS_cccc00010r001111dddd000000000000_case_0_MRS_instance_;
  const NamedMSR_immediate_cccc00110010mm001111iiiiiiiiiiii_case_0_MSR_immediate MSR_immediate_cccc00110010mm001111iiiiiiiiiiii_case_0_MSR_immediate_instance_;
  const NamedMSR_immediate_cccc00110r10mmmm1111iiiiiiiiiiii_case_0_MSR_immediate MSR_immediate_cccc00110r10mmmm1111iiiiiiiiiiii_case_0_MSR_immediate_instance_;
  const NamedMSR_register_cccc00010010mm00111100000000nnnn_case_0_MSR_register MSR_register_cccc00010010mm00111100000000nnnn_case_0_MSR_register_instance_;
  const NamedMSR_register_cccc00010r10mmmm111100000000nnnn_case_0_MSR_register MSR_register_cccc00010r10mmmm111100000000nnnn_case_0_MSR_register_instance_;
  const NamedMUL_A1_cccc0000000sdddd0000mmmm1001nnnn_case_0_MUL_A1 MUL_A1_cccc0000000sdddd0000mmmm1001nnnn_case_0_MUL_A1_instance_;
  const NamedMVN_immediate_cccc0011111s0000ddddiiiiiiiiiiii_case_0_MVN_immediate MVN_immediate_cccc0011111s0000ddddiiiiiiiiiiii_case_0_MVN_immediate_instance_;
  const NamedMVN_register_cccc0001111s0000ddddiiiiitt0mmmm_case_0_MVN_register MVN_register_cccc0001111s0000ddddiiiiitt0mmmm_case_0_MVN_register_instance_;
  const NamedMVN_register_shifted_register_cccc0001111s0000ddddssss0tt1mmmm_case_0_MVN_register_shifted_register MVN_register_shifted_register_cccc0001111s0000ddddssss0tt1mmmm_case_0_MVN_register_shifted_register_instance_;
  const NamedNOP_cccc0011001000001111000000000000_case_0_NOP NOP_cccc0011001000001111000000000000_case_0_NOP_instance_;
  const NamedNOT_IMPLEMENTED_case_0_NOT_IMPLEMENTED NOT_IMPLEMENTED_case_0_NOT_IMPLEMENTED_instance_;
  const NamedORR_immediate_cccc0011100snnnnddddiiiiiiiiiiii_case_0_ORR_immediate ORR_immediate_cccc0011100snnnnddddiiiiiiiiiiii_case_0_ORR_immediate_instance_;
  const NamedORR_register_cccc0001100snnnnddddiiiiitt0mmmm_case_0_ORR_register ORR_register_cccc0001100snnnnddddiiiiitt0mmmm_case_0_ORR_register_instance_;
  const NamedORR_register_shifted_register_cccc0001100snnnnddddssss0tt1mmmm_case_0_ORR_register_shifted_register ORR_register_shifted_register_cccc0001100snnnnddddssss0tt1mmmm_case_0_ORR_register_shifted_register_instance_;
  const NamedPKH_cccc01101000nnnnddddiiiiit01mmmm_case_0_PKH PKH_cccc01101000nnnnddddiiiiit01mmmm_case_0_PKH_instance_;
  const NamedPLD_PLDW_immediate_11110101ur01nnnn1111iiiiiiiiiiii_case_0_PLD_PLDW_immediate PLD_PLDW_immediate_11110101ur01nnnn1111iiiiiiiiiiii_case_0_PLD_PLDW_immediate_instance_;
  const NamedPLD_PLDW_immediate_11110101ur01nnnn1111iiiiiiiiiiii_case_1_PLD_PLDW_immediate PLD_PLDW_immediate_11110101ur01nnnn1111iiiiiiiiiiii_case_1_PLD_PLDW_immediate_instance_;
  const NamedPLD_PLDW_register_11110111u001nnnn1111iiiiitt0mmmm_case_0_PLD_PLDW_register PLD_PLDW_register_11110111u001nnnn1111iiiiitt0mmmm_case_0_PLD_PLDW_register_instance_;
  const NamedPLD_PLDW_register_11110111u101nnnn1111iiiiitt0mmmm_case_0_PLD_PLDW_register PLD_PLDW_register_11110111u101nnnn1111iiiiitt0mmmm_case_0_PLD_PLDW_register_instance_;
  const NamedPLD_literal_11110101u10111111111iiiiiiiiiiii_case_0_PLD_literal PLD_literal_11110101u10111111111iiiiiiiiiiii_case_0_PLD_literal_instance_;
  const NamedPLI_immediate_literal_11110100u101nnnn1111iiiiiiiiiiii_case_0_PLI_immediate_literal PLI_immediate_literal_11110100u101nnnn1111iiiiiiiiiiii_case_0_PLI_immediate_literal_instance_;
  const NamedPLI_register_11110110u101nnnn1111iiiiitt0mmmm_case_0_PLI_register PLI_register_11110110u101nnnn1111iiiiitt0mmmm_case_0_PLI_register_instance_;
  const NamedQADD16_cccc01100010nnnndddd11110001mmmm_case_0_QADD16 QADD16_cccc01100010nnnndddd11110001mmmm_case_0_QADD16_instance_;
  const NamedQADD8_cccc01100010nnnndddd11111001mmmm_case_0_QADD8 QADD8_cccc01100010nnnndddd11111001mmmm_case_0_QADD8_instance_;
  const NamedQADD_cccc00010000nnnndddd00000101mmmm_case_0_QADD QADD_cccc00010000nnnndddd00000101mmmm_case_0_QADD_instance_;
  const NamedQASX_cccc01100010nnnndddd11110011mmmm_case_0_QASX QASX_cccc01100010nnnndddd11110011mmmm_case_0_QASX_instance_;
  const NamedQDADD_cccc00010100nnnndddd00000101mmmm_case_0_QDADD QDADD_cccc00010100nnnndddd00000101mmmm_case_0_QDADD_instance_;
  const NamedQDSUB_cccc00010110nnnndddd00000101mmmm_case_0_QDSUB QDSUB_cccc00010110nnnndddd00000101mmmm_case_0_QDSUB_instance_;
  const NamedQSAX_cccc01100010nnnndddd11110101mmmm_case_0_QSAX QSAX_cccc01100010nnnndddd11110101mmmm_case_0_QSAX_instance_;
  const NamedQSUB16_cccc01100010nnnndddd11110111mmmm_case_0_QSUB16 QSUB16_cccc01100010nnnndddd11110111mmmm_case_0_QSUB16_instance_;
  const NamedQSUB8_cccc01100010nnnndddd11111111mmmm_case_0_QSUB8 QSUB8_cccc01100010nnnndddd11111111mmmm_case_0_QSUB8_instance_;
  const NamedQSUB_cccc00010010nnnndddd00000101mmmm_case_0_QSUB QSUB_cccc00010010nnnndddd00000101mmmm_case_0_QSUB_instance_;
  const NamedRBIT_cccc011011111111dddd11110011mmmm_case_0_RBIT RBIT_cccc011011111111dddd11110011mmmm_case_0_RBIT_instance_;
  const NamedREV16_cccc011010111111dddd11111011mmmm_case_0_REV16 REV16_cccc011010111111dddd11111011mmmm_case_0_REV16_instance_;
  const NamedREVSH_cccc011011111111dddd11111011mmmm_case_0_REVSH REVSH_cccc011011111111dddd11111011mmmm_case_0_REVSH_instance_;
  const NamedREV_cccc011010111111dddd11110011mmmm_case_0_REV REV_cccc011010111111dddd11110011mmmm_case_0_REV_instance_;
  const NamedRFE_1111100pu0w1nnnn0000101000000000_case_0_RFE RFE_1111100pu0w1nnnn0000101000000000_case_0_RFE_instance_;
  const NamedROR_immediate_cccc0001101s0000ddddiiiii110mmmm_case_0_ROR_immediate ROR_immediate_cccc0001101s0000ddddiiiii110mmmm_case_0_ROR_immediate_instance_;
  const NamedROR_register_cccc0001101s0000ddddmmmm0111nnnn_case_0_ROR_register ROR_register_cccc0001101s0000ddddmmmm0111nnnn_case_0_ROR_register_instance_;
  const NamedRRX_cccc0001101s0000dddd00000110mmmm_case_0_RRX RRX_cccc0001101s0000dddd00000110mmmm_case_0_RRX_instance_;
  const NamedRSB_immediate_cccc0010011snnnnddddiiiiiiiiiiii_case_0_RSB_immediate RSB_immediate_cccc0010011snnnnddddiiiiiiiiiiii_case_0_RSB_immediate_instance_;
  const NamedRSB_register_cccc0000011snnnnddddiiiiitt0mmmm_case_0_RSB_register RSB_register_cccc0000011snnnnddddiiiiitt0mmmm_case_0_RSB_register_instance_;
  const NamedRSB_register_shfited_register_cccc0000011snnnnddddssss0tt1mmmm_case_0_RSB_register_shfited_register RSB_register_shfited_register_cccc0000011snnnnddddssss0tt1mmmm_case_0_RSB_register_shfited_register_instance_;
  const NamedRSC_immediate_cccc0010111snnnnddddiiiiiiiiiiii_case_0_RSC_immediate RSC_immediate_cccc0010111snnnnddddiiiiiiiiiiii_case_0_RSC_immediate_instance_;
  const NamedRSC_register_cccc0000111snnnnddddiiiiitt0mmmm_case_0_RSC_register RSC_register_cccc0000111snnnnddddiiiiitt0mmmm_case_0_RSC_register_instance_;
  const NamedRSC_register_shifted_register_cccc0000111snnnnddddssss0tt1mmmm_case_0_RSC_register_shifted_register RSC_register_shifted_register_cccc0000111snnnnddddssss0tt1mmmm_case_0_RSC_register_shifted_register_instance_;
  const NamedSADD16_cccc01100001nnnndddd11110001mmmm_case_0_SADD16 SADD16_cccc01100001nnnndddd11110001mmmm_case_0_SADD16_instance_;
  const NamedSADD8_cccc01100001nnnndddd11111001mmmm_case_0_SADD8 SADD8_cccc01100001nnnndddd11111001mmmm_case_0_SADD8_instance_;
  const NamedSASX_cccc01100001nnnndddd11110011mmmm_case_0_SASX SASX_cccc01100001nnnndddd11110011mmmm_case_0_SASX_instance_;
  const NamedSBC_immediate_cccc0010110snnnnddddiiiiiiiiiiii_case_0_SBC_immediate SBC_immediate_cccc0010110snnnnddddiiiiiiiiiiii_case_0_SBC_immediate_instance_;
  const NamedSBC_register_cccc0000110snnnnddddiiiiitt0mmmm_case_0_SBC_register SBC_register_cccc0000110snnnnddddiiiiitt0mmmm_case_0_SBC_register_instance_;
  const NamedSBC_register_shifted_register_cccc0000110snnnnddddssss0tt1mmmm_case_0_SBC_register_shifted_register SBC_register_shifted_register_cccc0000110snnnnddddssss0tt1mmmm_case_0_SBC_register_shifted_register_instance_;
  const NamedSBFX_cccc0111101wwwwwddddlllll101nnnn_case_0_SBFX SBFX_cccc0111101wwwwwddddlllll101nnnn_case_0_SBFX_instance_;
  const NamedSDIV_cccc01110001dddd1111mmmm0001nnnn_case_0_SDIV SDIV_cccc01110001dddd1111mmmm0001nnnn_case_0_SDIV_instance_;
  const NamedSEL_cccc01101000nnnndddd11111011mmmm_case_0_SEL SEL_cccc01101000nnnndddd11111011mmmm_case_0_SEL_instance_;
  const NamedSETEND_1111000100000001000000i000000000_case_0_SETEND SETEND_1111000100000001000000i000000000_case_0_SETEND_instance_;
  const NamedSEV_cccc0011001000001111000000000100_case_0_SEV SEV_cccc0011001000001111000000000100_case_0_SEV_instance_;
  const NamedSHADD16_cccc01100011nnnndddd11110001mmmm_case_0_SHADD16 SHADD16_cccc01100011nnnndddd11110001mmmm_case_0_SHADD16_instance_;
  const NamedSHADD8_cccc01100011nnnndddd11111001mmmm_case_0_SHADD8 SHADD8_cccc01100011nnnndddd11111001mmmm_case_0_SHADD8_instance_;
  const NamedSHASX_cccc01100011nnnndddd11110011mmmm_case_0_SHASX SHASX_cccc01100011nnnndddd11110011mmmm_case_0_SHASX_instance_;
  const NamedSHSAX_cccc01100011nnnndddd11110101mmmm_case_0_SHSAX SHSAX_cccc01100011nnnndddd11110101mmmm_case_0_SHSAX_instance_;
  const NamedSHSUB16_cccc01100011nnnndddd11110111mmmm_case_0_SHSUB16 SHSUB16_cccc01100011nnnndddd11110111mmmm_case_0_SHSUB16_instance_;
  const NamedSHSUB8_cccc01100011nnnndddd11111111mmmm_case_0_SHSUB8 SHSUB8_cccc01100011nnnndddd11111111mmmm_case_0_SHSUB8_instance_;
  const NamedSMC_cccc000101100000000000000111iiii_case_0_SMC SMC_cccc000101100000000000000111iiii_case_0_SMC_instance_;
  const NamedSMLABB_SMLABT_SMLATB_SMLATT_cccc00010000ddddaaaammmm1xx0nnnn_case_0_SMLABB_SMLABT_SMLATB_SMLATT SMLABB_SMLABT_SMLATB_SMLATT_cccc00010000ddddaaaammmm1xx0nnnn_case_0_SMLABB_SMLABT_SMLATB_SMLATT_instance_;
  const NamedSMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_0_SMLAD SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_0_SMLAD_instance_;
  const NamedSMLALBB_SMLALBT_SMLALTB_SMLALTT_cccc00010100hhhhllllmmmm1xx0nnnn_case_0_SMLALBB_SMLALBT_SMLALTB_SMLALTT SMLALBB_SMLALBT_SMLALTB_SMLALTT_cccc00010100hhhhllllmmmm1xx0nnnn_case_0_SMLALBB_SMLALBT_SMLALTB_SMLALTT_instance_;
  const NamedSMLALD_cccc01110100hhhhllllmmmm00m1nnnn_case_0_SMLALD SMLALD_cccc01110100hhhhllllmmmm00m1nnnn_case_0_SMLALD_instance_;
  const NamedSMLAL_A1_cccc0000111shhhhllllmmmm1001nnnn_case_0_SMLAL_A1 SMLAL_A1_cccc0000111shhhhllllmmmm1001nnnn_case_0_SMLAL_A1_instance_;
  const NamedSMLAWB_SMLAWT_cccc00010010ddddaaaammmm1x00nnnn_case_0_SMLAWB_SMLAWT SMLAWB_SMLAWT_cccc00010010ddddaaaammmm1x00nnnn_case_0_SMLAWB_SMLAWT_instance_;
  const NamedSMLSD_cccc01110000ddddaaaammmm01m1nnnn_case_0_SMLSD SMLSD_cccc01110000ddddaaaammmm01m1nnnn_case_0_SMLSD_instance_;
  const NamedSMLSLD_cccc01110100hhhhllllmmmm01m1nnnn_case_0_SMLSLD SMLSLD_cccc01110100hhhhllllmmmm01m1nnnn_case_0_SMLSLD_instance_;
  const NamedSMMLA_cccc01110101ddddaaaammmm00r1nnnn_case_0_SMMLA SMMLA_cccc01110101ddddaaaammmm00r1nnnn_case_0_SMMLA_instance_;
  const NamedSMMLS_cccc01110101ddddaaaammmm11r1nnnn_case_0_SMMLS SMMLS_cccc01110101ddddaaaammmm11r1nnnn_case_0_SMMLS_instance_;
  const NamedSMMUL_cccc01110101dddd1111mmmm00r1nnnn_case_0_SMMUL SMMUL_cccc01110101dddd1111mmmm00r1nnnn_case_0_SMMUL_instance_;
  const NamedSMUAD_cccc01110000dddd1111mmmm00m1nnnn_case_0_SMUAD SMUAD_cccc01110000dddd1111mmmm00m1nnnn_case_0_SMUAD_instance_;
  const NamedSMULBB_SMULBT_SMULTB_SMULTT_cccc00010110dddd0000mmmm1xx0nnnn_case_0_SMULBB_SMULBT_SMULTB_SMULTT SMULBB_SMULBT_SMULTB_SMULTT_cccc00010110dddd0000mmmm1xx0nnnn_case_0_SMULBB_SMULBT_SMULTB_SMULTT_instance_;
  const NamedSMULL_A1_cccc0000110shhhhllllmmmm1001nnnn_case_0_SMULL_A1 SMULL_A1_cccc0000110shhhhllllmmmm1001nnnn_case_0_SMULL_A1_instance_;
  const NamedSMULWB_SMULWT_cccc00010010dddd0000mmmm1x10nnnn_case_0_SMULWB_SMULWT SMULWB_SMULWT_cccc00010010dddd0000mmmm1x10nnnn_case_0_SMULWB_SMULWT_instance_;
  const NamedSMUSD_cccc01110000dddd1111mmmm01m1nnnn_case_0_SMUSD SMUSD_cccc01110000dddd1111mmmm01m1nnnn_case_0_SMUSD_instance_;
  const NamedSRS_1111100pu1w0110100000101000iiiii_case_0_SRS SRS_1111100pu1w0110100000101000iiiii_case_0_SRS_instance_;
  const NamedSSAT16_cccc01101010iiiidddd11110011nnnn_case_0_SSAT16 SSAT16_cccc01101010iiiidddd11110011nnnn_case_0_SSAT16_instance_;
  const NamedSSAT_cccc0110101iiiiiddddiiiiis01nnnn_case_0_SSAT SSAT_cccc0110101iiiiiddddiiiiis01nnnn_case_0_SSAT_instance_;
  const NamedSSAX_cccc01100001nnnndddd11110101mmmm_case_0_SSAX SSAX_cccc01100001nnnndddd11110101mmmm_case_0_SSAX_instance_;
  const NamedSSSUB16_cccc01100001nnnndddd11110111mmmm_case_0_SSSUB16 SSSUB16_cccc01100001nnnndddd11110111mmmm_case_0_SSSUB16_instance_;
  const NamedSSUB8_cccc01100001nnnndddd11111111mmmm_case_0_SSUB8 SSUB8_cccc01100001nnnndddd11111111mmmm_case_0_SSUB8_instance_;
  const NamedSTC2_1111110pudw0nnnniiiiiiiiiiiiiiii_case_0_STC2 STC2_1111110pudw0nnnniiiiiiiiiiiiiiii_case_0_STC2_instance_;
  const NamedSTC_cccc110pudw0nnnnddddcccciiiiiiii_case_0_STC STC_cccc110pudw0nnnnddddcccciiiiiiii_case_0_STC_instance_;
  const NamedSTMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_0_STMDA_STMED STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_0_STMDA_STMED_instance_;
  const NamedSTMDB_STMFD_cccc100100w0nnnnrrrrrrrrrrrrrrrr_case_0_STMDB_STMFD STMDB_STMFD_cccc100100w0nnnnrrrrrrrrrrrrrrrr_case_0_STMDB_STMFD_instance_;
  const NamedSTMIB_STMFA_cccc100110w0nnnnrrrrrrrrrrrrrrrr_case_0_STMIB_STMFA STMIB_STMFA_cccc100110w0nnnnrrrrrrrrrrrrrrrr_case_0_STMIB_STMFA_instance_;
  const NamedSTM_STMIA_STMEA_cccc100010w0nnnnrrrrrrrrrrrrrrrr_case_0_STM_STMIA_STMEA STM_STMIA_STMEA_cccc100010w0nnnnrrrrrrrrrrrrrrrr_case_0_STM_STMIA_STMEA_instance_;
  const NamedSTM_User_registers_cccc100pu100nnnnrrrrrrrrrrrrrrrr_case_0_STM_User_registers STM_User_registers_cccc100pu100nnnnrrrrrrrrrrrrrrrr_case_0_STM_User_registers_instance_;
  const NamedSTRBT_A1_cccc0100u110nnnnttttiiiiiiiiiiii_case_0_STRBT_A1 STRBT_A1_cccc0100u110nnnnttttiiiiiiiiiiii_case_0_STRBT_A1_instance_;
  const NamedSTRBT_A2_cccc0110u110nnnnttttiiiiitt0mmmm_case_0_STRBT_A2 STRBT_A2_cccc0110u110nnnnttttiiiiitt0mmmm_case_0_STRBT_A2_instance_;
  const NamedSTRB_immediate_cccc010pu1w0nnnnttttiiiiiiiiiiii_case_0_STRB_immediate STRB_immediate_cccc010pu1w0nnnnttttiiiiiiiiiiii_case_0_STRB_immediate_instance_;
  const NamedSTRB_register_cccc011pu1w0nnnnttttiiiiitt0mmmm_case_0_STRB_register STRB_register_cccc011pu1w0nnnnttttiiiiitt0mmmm_case_0_STRB_register_instance_;
  const NamedSTRD_immediate_cccc000pu1w0nnnnttttiiii1111iiii_case_0_STRD_immediate STRD_immediate_cccc000pu1w0nnnnttttiiii1111iiii_case_0_STRD_immediate_instance_;
  const NamedSTRD_register_cccc000pu0w0nnnntttt00001111mmmm_case_0_STRD_register STRD_register_cccc000pu0w0nnnntttt00001111mmmm_case_0_STRD_register_instance_;
  const NamedSTREXB_cccc00011100nnnndddd11111001tttt_case_0_STREXB STREXB_cccc00011100nnnndddd11111001tttt_case_0_STREXB_instance_;
  const NamedSTREXD_cccc00011010nnnndddd11111001tttt_case_0_STREXD STREXD_cccc00011010nnnndddd11111001tttt_case_0_STREXD_instance_;
  const NamedSTREXH_cccc00011110nnnndddd11111001tttt_case_0_STREXH STREXH_cccc00011110nnnndddd11111001tttt_case_0_STREXH_instance_;
  const NamedSTREXH_cccc00011111nnnntttt111110011111_case_0_STREXH STREXH_cccc00011111nnnntttt111110011111_case_0_STREXH_instance_;
  const NamedSTREX_cccc00011000nnnndddd11111001tttt_case_0_STREX STREX_cccc00011000nnnndddd11111001tttt_case_0_STREX_instance_;
  const NamedSTRH_immediate_cccc000pu1w0nnnnttttiiii1011iiii_case_0_STRH_immediate STRH_immediate_cccc000pu1w0nnnnttttiiii1011iiii_case_0_STRH_immediate_instance_;
  const NamedSTRH_register_cccc000pu0w0nnnntttt00001011mmmm_case_0_STRH_register STRH_register_cccc000pu0w0nnnntttt00001011mmmm_case_0_STRH_register_instance_;
  const NamedSTRT_A1_cccc0100u010nnnnttttiiiiiiiiiiii_case_0_STRT_A1 STRT_A1_cccc0100u010nnnnttttiiiiiiiiiiii_case_0_STRT_A1_instance_;
  const NamedSTRT_A2_cccc0110u010nnnnttttiiiiitt0mmmm_case_0_STRT_A2 STRT_A2_cccc0110u010nnnnttttiiiiitt0mmmm_case_0_STRT_A2_instance_;
  const NamedSTR_immediate_cccc010pu0w0nnnnttttiiiiiiiiiiii_case_0_STR_immediate STR_immediate_cccc010pu0w0nnnnttttiiiiiiiiiiii_case_0_STR_immediate_instance_;
  const NamedSTR_register_cccc011pd0w0nnnnttttiiiiitt0mmmm_case_0_STR_register STR_register_cccc011pd0w0nnnnttttiiiiitt0mmmm_case_0_STR_register_instance_;
  const NamedSUB_immediate_cccc0010010snnnnddddiiiiiiiiiiii_case_0_SUB_immediate SUB_immediate_cccc0010010snnnnddddiiiiiiiiiiii_case_0_SUB_immediate_instance_;
  const NamedSUB_register_cccc0000010snnnnddddiiiiitt0mmmm_case_0_SUB_register SUB_register_cccc0000010snnnnddddiiiiitt0mmmm_case_0_SUB_register_instance_;
  const NamedSUB_register_shifted_register_cccc0000010snnnnddddssss0tt1mmmm_case_0_SUB_register_shifted_register SUB_register_shifted_register_cccc0000010snnnnddddssss0tt1mmmm_case_0_SUB_register_shifted_register_instance_;
  const NamedSVC_cccc1111iiiiiiiiiiiiiiiiiiiiiiii_case_0_SVC SVC_cccc1111iiiiiiiiiiiiiiiiiiiiiiii_case_0_SVC_instance_;
  const NamedSWP_SWPB_cccc00010b00nnnntttt00001001tttt_case_0_SWP_SWPB SWP_SWPB_cccc00010b00nnnntttt00001001tttt_case_0_SWP_SWPB_instance_;
  const NamedSXTAB16_cccc01101000nnnnddddrr000111mmmm_case_0_SXTAB16 SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_0_SXTAB16_instance_;
  const NamedSXTAB_cccc01101010nnnnddddrr000111mmmm_case_0_SXTAB SXTAB_cccc01101010nnnnddddrr000111mmmm_case_0_SXTAB_instance_;
  const NamedSXTAH_cccc01101011nnnnddddrr000111mmmm_case_0_SXTAH SXTAH_cccc01101011nnnnddddrr000111mmmm_case_0_SXTAH_instance_;
  const NamedSXTB16_cccc011010001111ddddrr000111mmmm_case_0_SXTB16 SXTB16_cccc011010001111ddddrr000111mmmm_case_0_SXTB16_instance_;
  const NamedSXTB_cccc011010101111ddddrr000111mmmm_case_0_SXTB SXTB_cccc011010101111ddddrr000111mmmm_case_0_SXTB_instance_;
  const NamedSXTH_cccc011010111111ddddrr000111mmmm_case_0_SXTH SXTH_cccc011010111111ddddrr000111mmmm_case_0_SXTH_instance_;
  const NamedTEQ_immediate_cccc00110011nnnn0000iiiiiiiiiiii_case_0_TEQ_immediate TEQ_immediate_cccc00110011nnnn0000iiiiiiiiiiii_case_0_TEQ_immediate_instance_;
  const NamedTEQ_register_cccc00010011nnnn0000iiiiitt0mmmm_case_0_TEQ_register TEQ_register_cccc00010011nnnn0000iiiiitt0mmmm_case_0_TEQ_register_instance_;
  const NamedTEQ_register_shifted_register_cccc00010011nnnn0000ssss0tt1mmmm_case_0_TEQ_register_shifted_register TEQ_register_shifted_register_cccc00010011nnnn0000ssss0tt1mmmm_case_0_TEQ_register_shifted_register_instance_;
  const NamedTST_immediate_cccc00110001nnnn0000iiiiiiiiiiii_case_0_TST_immediate TST_immediate_cccc00110001nnnn0000iiiiiiiiiiii_case_0_TST_immediate_instance_;
  const NamedTST_register_cccc00010001nnnn0000iiiiitt0mmmm_case_0_TST_register TST_register_cccc00010001nnnn0000iiiiitt0mmmm_case_0_TST_register_instance_;
  const NamedTST_register_shifted_register_cccc00010001nnnn0000ssss0tt1mmmm_case_0_TST_register_shifted_register TST_register_shifted_register_cccc00010001nnnn0000ssss0tt1mmmm_case_0_TST_register_shifted_register_instance_;
  const NamedUADD16_cccc01100101nnnndddd11110001mmmm_case_0_UADD16 UADD16_cccc01100101nnnndddd11110001mmmm_case_0_UADD16_instance_;
  const NamedUADD8_cccc01100101nnnndddd11111001mmmm_case_0_UADD8 UADD8_cccc01100101nnnndddd11111001mmmm_case_0_UADD8_instance_;
  const NamedUASX_cccc01100101nnnndddd11110011mmmm_case_0_UASX UASX_cccc01100101nnnndddd11110011mmmm_case_0_UASX_instance_;
  const NamedUBFX_cccc0111111mmmmmddddlllll101nnnn_case_0_UBFX UBFX_cccc0111111mmmmmddddlllll101nnnn_case_0_UBFX_instance_;
  const NamedUDF_cccc01111111iiiiiiiiiiii1111iiii_case_0_UDF UDF_cccc01111111iiiiiiiiiiii1111iiii_case_0_UDF_instance_;
  const NamedUDIV_cccc01110011dddd1111mmmm0001nnnn_case_0_UDIV UDIV_cccc01110011dddd1111mmmm0001nnnn_case_0_UDIV_instance_;
  const NamedUHADD16_cccc01100111nnnndddd11110001mmmm_case_0_UHADD16 UHADD16_cccc01100111nnnndddd11110001mmmm_case_0_UHADD16_instance_;
  const NamedUHADD8_cccc01100111nnnndddd11111001mmmm_case_0_UHADD8 UHADD8_cccc01100111nnnndddd11111001mmmm_case_0_UHADD8_instance_;
  const NamedUHASX_cccc01100111nnnndddd11110011mmmm_case_0_UHASX UHASX_cccc01100111nnnndddd11110011mmmm_case_0_UHASX_instance_;
  const NamedUHSAX_cccc01100111nnnndddd11110101mmmm_case_0_UHSAX UHSAX_cccc01100111nnnndddd11110101mmmm_case_0_UHSAX_instance_;
  const NamedUHSUB16_cccc01100111nnnndddd11110111mmmm_case_0_UHSUB16 UHSUB16_cccc01100111nnnndddd11110111mmmm_case_0_UHSUB16_instance_;
  const NamedUHSUB8_cccc01100111nnnndddd11111111mmmm_case_0_UHSUB8 UHSUB8_cccc01100111nnnndddd11111111mmmm_case_0_UHSUB8_instance_;
  const NamedUMAAL_A1_cccc00000100hhhhllllmmmm1001nnnn_case_0_UMAAL_A1 UMAAL_A1_cccc00000100hhhhllllmmmm1001nnnn_case_0_UMAAL_A1_instance_;
  const NamedUMLAL_A1_cccc0000101shhhhllllmmmm1001nnnn_case_0_UMLAL_A1 UMLAL_A1_cccc0000101shhhhllllmmmm1001nnnn_case_0_UMLAL_A1_instance_;
  const NamedUMULL_A1_cccc0000100shhhhllllmmmm1001nnnn_case_0_UMULL_A1 UMULL_A1_cccc0000100shhhhllllmmmm1001nnnn_case_0_UMULL_A1_instance_;
  const NamedUQADD16_cccc01100110nnnndddd11110001mmmm_case_0_UQADD16 UQADD16_cccc01100110nnnndddd11110001mmmm_case_0_UQADD16_instance_;
  const NamedUQADD8_cccc01100110nnnndddd11111001mmmm_case_0_UQADD8 UQADD8_cccc01100110nnnndddd11111001mmmm_case_0_UQADD8_instance_;
  const NamedUQASX_cccc01100110nnnndddd11110011mmmm_case_0_UQASX UQASX_cccc01100110nnnndddd11110011mmmm_case_0_UQASX_instance_;
  const NamedUQSAX_cccc01100110nnnndddd11110101mmmm_case_0_UQSAX UQSAX_cccc01100110nnnndddd11110101mmmm_case_0_UQSAX_instance_;
  const NamedUQSUB16_cccc01100110nnnndddd11110111mmmm_case_0_UQSUB16 UQSUB16_cccc01100110nnnndddd11110111mmmm_case_0_UQSUB16_instance_;
  const NamedUQSUB8_cccc01100110nnnndddd11111111mmmm_case_0_UQSUB8 UQSUB8_cccc01100110nnnndddd11111111mmmm_case_0_UQSUB8_instance_;
  const NamedUSAD8_cccc01111000dddd1111mmmm0001nnnn_case_0_USAD8 USAD8_cccc01111000dddd1111mmmm0001nnnn_case_0_USAD8_instance_;
  const NamedUSADA8_cccc01111000ddddaaaammmm0001nnnn_case_0_USADA8 USADA8_cccc01111000ddddaaaammmm0001nnnn_case_0_USADA8_instance_;
  const NamedUSAT16_cccc01101110iiiidddd11110011nnnn_case_0_USAT16 USAT16_cccc01101110iiiidddd11110011nnnn_case_0_USAT16_instance_;
  const NamedUSAT_cccc0110111iiiiiddddiiiiis01nnnn_case_0_USAT USAT_cccc0110111iiiiiddddiiiiis01nnnn_case_0_USAT_instance_;
  const NamedUSAX_cccc01100101nnnndddd11110101mmmm_case_0_USAX USAX_cccc01100101nnnndddd11110101mmmm_case_0_USAX_instance_;
  const NamedUSUB16_cccc01100101nnnndddd11110111mmmm_case_0_USUB16 USUB16_cccc01100101nnnndddd11110111mmmm_case_0_USUB16_instance_;
  const NamedUSUB8_cccc01100101nnnndddd11111111mmmm_case_0_USUB8 USUB8_cccc01100101nnnndddd11111111mmmm_case_0_USUB8_instance_;
  const NamedUXTAB16_cccc01101100nnnnddddrr000111mmmm_case_0_UXTAB16 UXTAB16_cccc01101100nnnnddddrr000111mmmm_case_0_UXTAB16_instance_;
  const NamedUXTAB_cccc01101110nnnnddddrr000111mmmm_case_0_UXTAB UXTAB_cccc01101110nnnnddddrr000111mmmm_case_0_UXTAB_instance_;
  const NamedUXTAH_cccc01101111nnnnddddrr000111mmmm_case_0_UXTAH UXTAH_cccc01101111nnnnddddrr000111mmmm_case_0_UXTAH_instance_;
  const NamedUXTB16_cccc011011001111ddddrr000111mmmm_case_0_UXTB16 UXTB16_cccc011011001111ddddrr000111mmmm_case_0_UXTB16_instance_;
  const NamedUXTB_cccc011011101111ddddrr000111mmmm_case_0_UXTB UXTB_cccc011011101111ddddrr000111mmmm_case_0_UXTB_instance_;
  const NamedUXTH_cccc011011111111ddddrr000111mmmm_case_0_UXTH UXTH_cccc011011111111ddddrr000111mmmm_case_0_UXTH_instance_;
  const NamedUnnamed_11110100x001xxxxxxxxxxxxxxxxxxxx_case_0_None Unnamed_11110100x001xxxxxxxxxxxxxxxxxxxx_case_0_None_instance_;
  const NamedUnnamed_11110100xx11xxxxxxxxxxxxxxxxxxxx_case_0_None Unnamed_11110100xx11xxxxxxxxxxxxxxxxxxxx_case_0_None_instance_;
  const NamedUnnamed_111101010011xxxxxxxxxxxxxxxxxxxx_case_0_None Unnamed_111101010011xxxxxxxxxxxxxxxxxxxx_case_0_None_instance_;
  const NamedUnnamed_111101010111xxxxxxxxxxxx0000xxxx_case_0_None Unnamed_111101010111xxxxxxxxxxxx0000xxxx_case_0_None_instance_;
  const NamedUnnamed_111101010111xxxxxxxxxxxx001xxxxx_case_0_None Unnamed_111101010111xxxxxxxxxxxx001xxxxx_case_0_None_instance_;
  const NamedUnnamed_111101010111xxxxxxxxxxxx0111xxxx_case_0_None Unnamed_111101010111xxxxxxxxxxxx0111xxxx_case_0_None_instance_;
  const NamedUnnamed_111101010111xxxxxxxxxxxx1xxxxxxx_case_0_None Unnamed_111101010111xxxxxxxxxxxx1xxxxxxx_case_0_None_instance_;
  const NamedUnnamed_111101011x11xxxxxxxxxxxxxxxxxxxx_case_0_None Unnamed_111101011x11xxxxxxxxxxxxxxxxxxxx_case_0_None_instance_;
  const NamedUnnamed_11110101x001xxxxxxxxxxxxxxxxxxxx_case_0_None Unnamed_11110101x001xxxxxxxxxxxxxxxxxxxx_case_0_None_instance_;
  const NamedUnnamed_11110110x001xxxxxxxxxxxxxxx0xxxx_case_0_None Unnamed_11110110x001xxxxxxxxxxxxxxx0xxxx_case_0_None_instance_;
  const NamedUnnamed_1111011xxx11xxxxxxxxxxxxxxx0xxxx_case_0_None Unnamed_1111011xxx11xxxxxxxxxxxxxxx0xxxx_case_0_None_instance_;
  const NamedUnnamed_case_0_None Unnamed_case_0_None_instance_;
  const NamedUnnamed_case_1_None Unnamed_case_1_None_instance_;
  const NamedUnnamed_cccc00000101xxxxxxxxxxxx1001xxxx_case_0_None Unnamed_cccc00000101xxxxxxxxxxxx1001xxxx_case_0_None_instance_;
  const NamedUnnamed_cccc00000111xxxxxxxxxxxx1001xxxx_case_0_None Unnamed_cccc00000111xxxxxxxxxxxx1001xxxx_case_0_None_instance_;
  const NamedUnnamed_cccc1100000xnnnnxxxxccccxxxoxxxx_case_0_None Unnamed_cccc1100000xnnnnxxxxccccxxxoxxxx_case_0_None_instance_;
  const NamedVABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_0_VABAL_A2 VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_0_VABAL_A2_instance_;
  const NamedVABA_1111001u0dssnnnndddd0111nqm1mmmm_case_0_VABA VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_0_VABA_instance_;
  const NamedVABDL_integer_A2_1111001u1dssnnnndddd0111n0m0mmmm_case_0_VABDL_integer_A2 VABDL_integer_A2_1111001u1dssnnnndddd0111n0m0mmmm_case_0_VABDL_integer_A2_instance_;
  const NamedVABD_1111001u0dssnnnndddd0111nqm0mmmm_case_0_VABD VABD_1111001u0dssnnnndddd0111nqm0mmmm_case_0_VABD_instance_;
  const NamedVABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_0_VABD_floating_point VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_0_VABD_floating_point_instance_;
  const NamedVABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_0_VABS_A1 VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_0_VABS_A1_instance_;
  const NamedVABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VABS_A1 VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VABS_A1_instance_;
  const NamedVABS_cccc11101d110000dddd101s11m0mmmm_case_0_VABS VABS_cccc11101d110000dddd101s11m0mmmm_case_0_VABS_instance_;
  const NamedVACGE_111100110dssnnnndddd1110nqm1mmmm_case_0_VACGE VACGE_111100110dssnnnndddd1110nqm1mmmm_case_0_VACGE_instance_;
  const NamedVACGT_111100110dssnnnndddd1110nqm1mmmm_case_0_VACGT VACGT_111100110dssnnnndddd1110nqm1mmmm_case_0_VACGT_instance_;
  const NamedVADDHN_111100101dssnnnndddd0100n0m0mmmm_case_0_VADDHN VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_0_VADDHN_instance_;
  const NamedVADDL_VADDW_1111001u1dssnnnndddd000pn0m0mmmm_case_0_VADDL_VADDW VADDL_VADDW_1111001u1dssnnnndddd000pn0m0mmmm_case_0_VADDL_VADDW_instance_;
  const NamedVADD_floating_point_A1_111100100d0snnnndddd1101nqm0mmmm_case_0_VADD_floating_point_A1 VADD_floating_point_A1_111100100d0snnnndddd1101nqm0mmmm_case_0_VADD_floating_point_A1_instance_;
  const NamedVADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_0_VADD_floating_point VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_0_VADD_floating_point_instance_;
  const NamedVADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_0_VADD_integer VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_0_VADD_integer_instance_;
  const NamedVAND_register_111100100d00nnnndddd0001nqm1mmmm_case_0_VAND_register VAND_register_111100100d00nnnndddd0001nqm1mmmm_case_0_VAND_register_instance_;
  const NamedVBIC_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_0_VBIC_immediate VBIC_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_0_VBIC_immediate_instance_;
  const NamedVBIC_register_111100100d01nnnndddd0001nqm1mmmm_case_0_VBIC_register VBIC_register_111100100d01nnnndddd0001nqm1mmmm_case_0_VBIC_register_instance_;
  const NamedVBIF_111100110d11nnnndddd0001nqm1mmmm_case_0_VBIF VBIF_111100110d11nnnndddd0001nqm1mmmm_case_0_VBIF_instance_;
  const NamedVBIT_111100110d10nnnndddd0001nqm1mmmm_case_0_VBIT VBIT_111100110d10nnnndddd0001nqm1mmmm_case_0_VBIT_instance_;
  const NamedVBSL_111100110d01nnnndddd0001nqm1mmmm_case_0_VBSL VBSL_111100110d01nnnndddd0001nqm1mmmm_case_0_VBSL_instance_;
  const NamedVCEQ_immediate_0_111100111d11ss01dddd0f010qm0mmmm_case_0_VCEQ_immediate_0 VCEQ_immediate_0_111100111d11ss01dddd0f010qm0mmmm_case_0_VCEQ_immediate_0_instance_;
  const NamedVCEQ_immediate_0_111100111d11ss01dddd0f010qm0mmmm_case_1_VCEQ_immediate_0 VCEQ_immediate_0_111100111d11ss01dddd0f010qm0mmmm_case_1_VCEQ_immediate_0_instance_;
  const NamedVCEQ_register_A1_111100110dssnnnndddd1000nqm1mmmm_case_0_VCEQ_register_A1 VCEQ_register_A1_111100110dssnnnndddd1000nqm1mmmm_case_0_VCEQ_register_A1_instance_;
  const NamedVCEQ_register_A2_111100100d0snnnndddd1110nqm0mmmm_case_0_VCEQ_register_A2 VCEQ_register_A2_111100100d0snnnndddd1110nqm0mmmm_case_0_VCEQ_register_A2_instance_;
  const NamedVCGE_immediate_0_111100111d11ss01dddd0f001qm0mmmm_case_0_VCGE_immediate_0 VCGE_immediate_0_111100111d11ss01dddd0f001qm0mmmm_case_0_VCGE_immediate_0_instance_;
  const NamedVCGE_immediate_0_111100111d11ss01dddd0f001qm0mmmm_case_1_VCGE_immediate_0 VCGE_immediate_0_111100111d11ss01dddd0f001qm0mmmm_case_1_VCGE_immediate_0_instance_;
  const NamedVCGE_register_A1_1111001u0dssnnnndddd0011nqm1mmmm_case_0_VCGE_register_A1 VCGE_register_A1_1111001u0dssnnnndddd0011nqm1mmmm_case_0_VCGE_register_A1_instance_;
  const NamedVCGE_register_A2_111100110d0snnnndddd1110nqm0mmmm_case_0_VCGE_register_A2 VCGE_register_A2_111100110d0snnnndddd1110nqm0mmmm_case_0_VCGE_register_A2_instance_;
  const NamedVCGT_immediate_0_111100111d11ss01dddd0f000qm0mmmm_case_0_VCGT_immediate_0 VCGT_immediate_0_111100111d11ss01dddd0f000qm0mmmm_case_0_VCGT_immediate_0_instance_;
  const NamedVCGT_immediate_0_111100111d11ss01dddd0f000qm0mmmm_case_1_VCGT_immediate_0 VCGT_immediate_0_111100111d11ss01dddd0f000qm0mmmm_case_1_VCGT_immediate_0_instance_;
  const NamedVCGT_register_A1_1111001u0dssnnnndddd0011nqm0mmmm_case_0_VCGT_register_A1 VCGT_register_A1_1111001u0dssnnnndddd0011nqm0mmmm_case_0_VCGT_register_A1_instance_;
  const NamedVCGT_register_A2_111100110d1snnnndddd1110nqm0mmmm_case_0_VCGT_register_A2 VCGT_register_A2_111100110d1snnnndddd1110nqm0mmmm_case_0_VCGT_register_A2_instance_;
  const NamedVCLE_immediate_0_111100111d11ss01dddd0f011qm0mmmm_case_0_VCLE_immediate_0 VCLE_immediate_0_111100111d11ss01dddd0f011qm0mmmm_case_0_VCLE_immediate_0_instance_;
  const NamedVCLE_immediate_0_111100111d11ss01dddd0f011qm0mmmm_case_1_VCLE_immediate_0 VCLE_immediate_0_111100111d11ss01dddd0f011qm0mmmm_case_1_VCLE_immediate_0_instance_;
  const NamedVCLS_111100111d11ss00dddd01000qm0mmmm_case_0_VCLS VCLS_111100111d11ss00dddd01000qm0mmmm_case_0_VCLS_instance_;
  const NamedVCLT_immediate_0_111100111d11ss01dddd0f100qm0mmmm_case_0_VCLT_immediate_0 VCLT_immediate_0_111100111d11ss01dddd0f100qm0mmmm_case_0_VCLT_immediate_0_instance_;
  const NamedVCLT_immediate_0_111100111d11ss01dddd0f100qm0mmmm_case_1_VCLT_immediate_0 VCLT_immediate_0_111100111d11ss01dddd0f100qm0mmmm_case_1_VCLT_immediate_0_instance_;
  const NamedVCLZ_111100111d11ss00dddd01001qm0mmmm_case_0_VCLZ VCLZ_111100111d11ss00dddd01001qm0mmmm_case_0_VCLZ_instance_;
  const NamedVCMP_VCMPE_cccc11101d110100dddd101se1m0mmmm_case_0_VCMP_VCMPE VCMP_VCMPE_cccc11101d110100dddd101se1m0mmmm_case_0_VCMP_VCMPE_instance_;
  const NamedVCMP_VCMPE_cccc11101d110101dddd101se1000000_case_0_VCMP_VCMPE VCMP_VCMPE_cccc11101d110101dddd101se1000000_case_0_VCMP_VCMPE_instance_;
  const NamedVCNT_111100111d11ss00dddd01010qm0mmmm_case_0_VCNT VCNT_111100111d11ss00dddd01010qm0mmmm_case_0_VCNT_instance_;
  const NamedVCVTB_VCVTT_cccc11101d11001odddd1010t1m0mmmm_case_0_VCVTB_VCVTT VCVTB_VCVTT_cccc11101d11001odddd1010t1m0mmmm_case_0_VCVTB_VCVTT_instance_;
  const NamedVCVT_111100111d11ss11dddd011ppqm0mmmm_case_0_VCVT VCVT_111100111d11ss11dddd011ppqm0mmmm_case_0_VCVT_instance_;
  const NamedVCVT_VCVTR_between_floating_point_and_integer_Floating_point_cccc11101d111ooodddd101sp1m0mmmm_case_0_VCVT_VCVTR_between_floating_point_and_integer_Floating_point VCVT_VCVTR_between_floating_point_and_integer_Floating_point_cccc11101d111ooodddd101sp1m0mmmm_case_0_VCVT_VCVTR_between_floating_point_and_integer_Floating_point_instance_;
  const NamedVCVT_between_double_precision_and_single_precision_cccc11101d110111dddd101s11m0mmmm_case_0_VCVT_between_double_precision_and_single_precision VCVT_between_double_precision_and_single_precision_cccc11101d110111dddd101s11m0mmmm_case_0_VCVT_between_double_precision_and_single_precision_instance_;
  const NamedVCVT_between_floating_point_and_fixed_point_1111001u1diiiiiidddd111p0qm1mmmm_case_0_VCVT_between_floating_point_and_fixed_point VCVT_between_floating_point_and_fixed_point_1111001u1diiiiiidddd111p0qm1mmmm_case_0_VCVT_between_floating_point_and_fixed_point_instance_;
  const NamedVCVT_between_floating_point_and_fixed_point_Floating_point_cccc11101d111o1udddd101fx1i0iiii_case_0_VCVT_between_floating_point_and_fixed_point_Floating_point VCVT_between_floating_point_and_fixed_point_Floating_point_cccc11101d111o1udddd101fx1i0iiii_case_0_VCVT_between_floating_point_and_fixed_point_Floating_point_instance_;
  const NamedVDIV_cccc11101d00nnnndddd101sn0m0mmmm_case_0_VDIV VDIV_cccc11101d00nnnndddd101sn0m0mmmm_case_0_VDIV_instance_;
  const NamedVDUP_ARM_core_register_cccc11101bq0ddddtttt1011d0e10000_case_0_VDUP_ARM_core_register VDUP_ARM_core_register_cccc11101bq0ddddtttt1011d0e10000_case_0_VDUP_ARM_core_register_instance_;
  const NamedVDUP_scalar_111100111d11iiiidddd11000qm0mmmm_case_0_VDUP_scalar VDUP_scalar_111100111d11iiiidddd11000qm0mmmm_case_0_VDUP_scalar_instance_;
  const NamedVEOR_111100110d00nnnndddd0001nqm1mmmm_case_0_VEOR VEOR_111100110d00nnnndddd0001nqm1mmmm_case_0_VEOR_instance_;
  const NamedVEXT_111100101d11nnnnddddiiiinqm0mmmm_case_0_VEXT VEXT_111100101d11nnnnddddiiiinqm0mmmm_case_0_VEXT_instance_;
  const NamedVFMA_A1_111100100d00nnnndddd1100nqm1mmmm_case_0_VFMA_A1 VFMA_A1_111100100d00nnnndddd1100nqm1mmmm_case_0_VFMA_A1_instance_;
  const NamedVFMA_VFMS_cccc11101d10nnnndddd101snom0mmmm_case_0_VFMA_VFMS VFMA_VFMS_cccc11101d10nnnndddd101snom0mmmm_case_0_VFMA_VFMS_instance_;
  const NamedVFMS_A1_111100100d10nnnndddd1100nqm1mmmm_case_0_VFMS_A1 VFMS_A1_111100100d10nnnndddd1100nqm1mmmm_case_0_VFMS_A1_instance_;
  const NamedVFNMA_VFNMS_cccc11101d01nnnndddd101snom0mmmm_case_0_VFNMA_VFNMS VFNMA_VFNMS_cccc11101d01nnnndddd101snom0mmmm_case_0_VFNMA_VFNMS_instance_;
  const NamedVHADD_1111001u0dssnnnndddd0000nqm0mmmm_case_0_VHADD VHADD_1111001u0dssnnnndddd0000nqm0mmmm_case_0_VHADD_instance_;
  const NamedVHSUB_1111001u0dssnnnndddd0010nqm0mmmm_case_0_VHSUB VHSUB_1111001u0dssnnnndddd0010nqm0mmmm_case_0_VHSUB_instance_;
  const NamedVLD1_multiple_single_elements_111101000d10nnnnddddttttssaammmm_case_0_VLD1_multiple_single_elements VLD1_multiple_single_elements_111101000d10nnnnddddttttssaammmm_case_0_VLD1_multiple_single_elements_instance_;
  const NamedVLD1_single_element_to_all_lanes_111101001d10nnnndddd1100sstammmm_case_0_VLD1_single_element_to_all_lanes VLD1_single_element_to_all_lanes_111101001d10nnnndddd1100sstammmm_case_0_VLD1_single_element_to_all_lanes_instance_;
  const NamedVLD1_single_element_to_one_lane_111101001d10nnnnddddss00aaaammmm_case_0_VLD1_single_element_to_one_lane VLD1_single_element_to_one_lane_111101001d10nnnnddddss00aaaammmm_case_0_VLD1_single_element_to_one_lane_instance_;
  const NamedVLD2_multiple_2_element_structures_111101000d10nnnnddddttttssaammmm_case_0_VLD2_multiple_2_element_structures VLD2_multiple_2_element_structures_111101000d10nnnnddddttttssaammmm_case_0_VLD2_multiple_2_element_structures_instance_;
  const NamedVLD2_single_2_element_structure_to_all_lanes_111101001d10nnnndddd1101sstammmm_case_0_VLD2_single_2_element_structure_to_all_lanes VLD2_single_2_element_structure_to_all_lanes_111101001d10nnnndddd1101sstammmm_case_0_VLD2_single_2_element_structure_to_all_lanes_instance_;
  const NamedVLD2_single_2_element_structure_to_one_lane_111101001d10nnnnddddss01aaaammmm_case_0_VLD2_single_2_element_structure_to_one_lane VLD2_single_2_element_structure_to_one_lane_111101001d10nnnnddddss01aaaammmm_case_0_VLD2_single_2_element_structure_to_one_lane_instance_;
  const NamedVLD3_multiple_3_element_structures_111101000d10nnnnddddttttssaammmm_case_0_VLD3_multiple_3_element_structures VLD3_multiple_3_element_structures_111101000d10nnnnddddttttssaammmm_case_0_VLD3_multiple_3_element_structures_instance_;
  const NamedVLD3_single_3_element_structure_to_all_lanes_111101001d10nnnndddd1110sstammmm_case_0_VLD3_single_3_element_structure_to_all_lanes VLD3_single_3_element_structure_to_all_lanes_111101001d10nnnndddd1110sstammmm_case_0_VLD3_single_3_element_structure_to_all_lanes_instance_;
  const NamedVLD3_single_3_element_structure_to_one_lane_111101001d10nnnnddddss10aaaammmm_case_0_VLD3_single_3_element_structure_to_one_lane VLD3_single_3_element_structure_to_one_lane_111101001d10nnnnddddss10aaaammmm_case_0_VLD3_single_3_element_structure_to_one_lane_instance_;
  const NamedVLD4_multiple_4_element_structures_111101000d10nnnnddddttttssaammmm_case_0_VLD4_multiple_4_element_structures VLD4_multiple_4_element_structures_111101000d10nnnnddddttttssaammmm_case_0_VLD4_multiple_4_element_structures_instance_;
  const NamedVLD4_single_4_element_structure_to_all_lanes_111101001d10nnnndddd1111sstammmm_case_0_VLD4_single_4_element_structure_to_all_lanes VLD4_single_4_element_structure_to_all_lanes_111101001d10nnnndddd1111sstammmm_case_0_VLD4_single_4_element_structure_to_all_lanes_instance_;
  const NamedVLD4_single_4_element_structure_to_one_lane_111101001d10nnnnddddss11aaaammmm_case_0_VLD4_single_4_element_structure_to_one_lane VLD4_single_4_element_structure_to_one_lane_111101001d10nnnnddddss11aaaammmm_case_0_VLD4_single_4_element_structure_to_one_lane_instance_;
  const NamedVLDM_cccc110pudw1nnnndddd1010iiiiiiii_case_0_VLDM VLDM_cccc110pudw1nnnndddd1010iiiiiiii_case_0_VLDM_instance_;
  const NamedVLDM_cccc110pudw1nnnndddd1011iiiiiiii_case_0_VLDM VLDM_cccc110pudw1nnnndddd1011iiiiiiii_case_0_VLDM_instance_;
  const NamedVLDR_cccc1101ud01nnnndddd1010iiiiiiii_case_0_VLDR VLDR_cccc1101ud01nnnndddd1010iiiiiiii_case_0_VLDR_instance_;
  const NamedVLDR_cccc1101ud01nnnndddd1011iiiiiiii_case_0_VLDR VLDR_cccc1101ud01nnnndddd1011iiiiiiii_case_0_VLDR_instance_;
  const NamedVMAX_1111001u0dssnnnndddd0110nqm0mmmm_case_0_VMAX VMAX_1111001u0dssnnnndddd0110nqm0mmmm_case_0_VMAX_instance_;
  const NamedVMAX_floating_point_111100100dssnnnndddd1111nqm0mmmm_case_0_VMAX_floating_point VMAX_floating_point_111100100dssnnnndddd1111nqm0mmmm_case_0_VMAX_floating_point_instance_;
  const NamedVMIN_1111001u0dssnnnndddd0110nqm1mmmm_case_0_VMIN VMIN_1111001u0dssnnnndddd0110nqm1mmmm_case_0_VMIN_instance_;
  const NamedVMIN_floating_point_111100100dssnnnndddd1111nqm0mmmm_case_0_VMIN_floating_point VMIN_floating_point_111100100dssnnnndddd1111nqm0mmmm_case_0_VMIN_floating_point_instance_;
  const NamedVMLAL_VMLSL_integer_A2_1111001u1dssnnnndddd10p0n0m0mmmm_case_0_VMLAL_VMLSL_integer_A2 VMLAL_VMLSL_integer_A2_1111001u1dssnnnndddd10p0n0m0mmmm_case_0_VMLAL_VMLSL_integer_A2_instance_;
  const NamedVMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_0_VMLAL_by_scalar_A2 VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_0_VMLAL_by_scalar_A2_instance_;
  const NamedVMLA_VMLS_floating_point_cccc11100d00nnnndddd101snom0mmmm_case_0_VMLA_VMLS_floating_point VMLA_VMLS_floating_point_cccc11100d00nnnndddd101snom0mmmm_case_0_VMLA_VMLS_floating_point_instance_;
  const NamedVMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_0_VMLA_by_scalar_A1 VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_0_VMLA_by_scalar_A1_instance_;
  const NamedVMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMLA_by_scalar_A1 VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMLA_by_scalar_A1_instance_;
  const NamedVMLA_floating_point_A1_111100100dpsnnnndddd1101nqm1mmmm_case_0_VMLA_floating_point_A1 VMLA_floating_point_A1_111100100dpsnnnndddd1101nqm1mmmm_case_0_VMLA_floating_point_A1_instance_;
  const NamedVMLA_integer_A1_1111001u0dssnnnndddd1001nqm0mmmm_case_0_VMLA_integer_A1 VMLA_integer_A1_1111001u0dssnnnndddd1001nqm0mmmm_case_0_VMLA_integer_A1_instance_;
  const NamedVMLSL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_0_VMLSL_by_scalar_A2 VMLSL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_0_VMLSL_by_scalar_A2_instance_;
  const NamedVMLS_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_0_VMLS_by_scalar_A1 VMLS_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_0_VMLS_by_scalar_A1_instance_;
  const NamedVMLS_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMLS_by_scalar_A1 VMLS_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMLS_by_scalar_A1_instance_;
  const NamedVMLS_floating_point_A1_111100100dpsnnnndddd1101nqm1mmmm_case_0_VMLS_floating_point_A1 VMLS_floating_point_A1_111100100dpsnnnndddd1101nqm1mmmm_case_0_VMLS_floating_point_A1_instance_;
  const NamedVMLS_integer_A1_1111001u0dssnnnndddd1001nqm0mmmm_case_0_VMLS_integer_A1 VMLS_integer_A1_1111001u0dssnnnndddd1001nqm0mmmm_case_0_VMLS_integer_A1_instance_;
  const NamedVMOVN_111100111d11ss10dddd001000m0mmmm_case_0_VMOVN VMOVN_111100111d11ss10dddd001000m0mmmm_case_0_VMOVN_instance_;
  const NamedVMOV_ARM_core_register_to_scalar_cccc11100ii0ddddtttt1011dii10000_case_0_VMOV_ARM_core_register_to_scalar VMOV_ARM_core_register_to_scalar_cccc11100ii0ddddtttt1011dii10000_case_0_VMOV_ARM_core_register_to_scalar_instance_;
  const NamedVMOV_between_ARM_core_register_and_single_precision_register_cccc1110000onnnntttt1010n0010000_case_0_VMOV_between_ARM_core_register_and_single_precision_register VMOV_between_ARM_core_register_and_single_precision_register_cccc1110000onnnntttt1010n0010000_case_0_VMOV_between_ARM_core_register_and_single_precision_register_instance_;
  const NamedVMOV_between_ARM_core_register_and_single_precision_register_cccc1110000xnnnntttt1010n0010000_case_0_VMOV_between_ARM_core_register_and_single_precision_register VMOV_between_ARM_core_register_and_single_precision_register_cccc1110000xnnnntttt1010n0010000_case_0_VMOV_between_ARM_core_register_and_single_precision_register_instance_;
  const NamedVMOV_between_two_ARM_core_registers_and_a_doubleword_extension_register_cccc1100010otttttttt101100m1mmmm_case_0_VMOV_between_two_ARM_core_registers_and_a_doubleword_extension_register VMOV_between_two_ARM_core_registers_and_a_doubleword_extension_register_cccc1100010otttttttt101100m1mmmm_case_0_VMOV_between_two_ARM_core_registers_and_a_doubleword_extension_register_instance_;
  const NamedVMOV_between_two_ARM_core_registers_and_two_single_precision_registers_cccc1100010otttttttt101000m1mmmm_case_0_VMOV_between_two_ARM_core_registers_and_two_single_precision_registers VMOV_between_two_ARM_core_registers_and_two_single_precision_registers_cccc1100010otttttttt101000m1mmmm_case_0_VMOV_between_two_ARM_core_registers_and_two_single_precision_registers_instance_;
  const NamedVMOV_immediate_A1_1111001m1d000mmmddddcccc0qp1mmmm_case_0_VMOV_immediate_A1 VMOV_immediate_A1_1111001m1d000mmmddddcccc0qp1mmmm_case_0_VMOV_immediate_A1_instance_;
  const NamedVMOV_immediate_cccc11101d11iiiidddd101s0000iiii_case_0_VMOV_immediate VMOV_immediate_cccc11101d11iiiidddd101s0000iiii_case_0_VMOV_immediate_instance_;
  const NamedVMOV_register_cccc11101d110000dddd101s01m0mmmm_case_0_VMOV_register VMOV_register_cccc11101d110000dddd101s01m0mmmm_case_0_VMOV_register_instance_;
  const NamedVMRS_cccc111011110001tttt101000010000_case_0_VMRS VMRS_cccc111011110001tttt101000010000_case_0_VMRS_instance_;
  const NamedVMSR_cccc111011100001tttt101000010000_case_0_VMSR VMSR_cccc111011100001tttt101000010000_case_0_VMSR_instance_;
  const NamedVMULL_by_scalar_A2_1111001u1dssnnnndddd1010n1m0mmmm_case_0_VMULL_by_scalar_A2 VMULL_by_scalar_A2_1111001u1dssnnnndddd1010n1m0mmmm_case_0_VMULL_by_scalar_A2_instance_;
  const NamedVMULL_integer_A2_1111001u1dssnnnndddd11p0n0m0mmmm_case_0_VMULL_integer_A2 VMULL_integer_A2_1111001u1dssnnnndddd11p0n0m0mmmm_case_0_VMULL_integer_A2_instance_;
  const NamedVMULL_polynomial_A2_1111001u1dssnnnndddd11p0n0m0mmmm_case_0_VMULL_polynomial_A2 VMULL_polynomial_A2_1111001u1dssnnnndddd11p0n0m0mmmm_case_0_VMULL_polynomial_A2_instance_;
  const NamedVMUL_by_scalar_A1_1111001q1dssnnnndddd100fn1m0mmmm_case_0_VMUL_by_scalar_A1 VMUL_by_scalar_A1_1111001q1dssnnnndddd100fn1m0mmmm_case_0_VMUL_by_scalar_A1_instance_;
  const NamedVMUL_by_scalar_A1_1111001q1dssnnnndddd100fn1m0mmmm_case_1_VMUL_by_scalar_A1 VMUL_by_scalar_A1_1111001q1dssnnnndddd100fn1m0mmmm_case_1_VMUL_by_scalar_A1_instance_;
  const NamedVMUL_floating_point_A1_111100110d0snnnndddd1101nqm1mmmm_case_0_VMUL_floating_point_A1 VMUL_floating_point_A1_111100110d0snnnndddd1101nqm1mmmm_case_0_VMUL_floating_point_A1_instance_;
  const NamedVMUL_floating_point_cccc11100d10nnnndddd101sn0m0mmmm_case_0_VMUL_floating_point VMUL_floating_point_cccc11100d10nnnndddd101sn0m0mmmm_case_0_VMUL_floating_point_instance_;
  const NamedVMUL_integer_A1_1111001u0dssnnnndddd1001nqm1mmmm_case_0_VMUL_integer_A1 VMUL_integer_A1_1111001u0dssnnnndddd1001nqm1mmmm_case_0_VMUL_integer_A1_instance_;
  const NamedVMUL_polynomial_A1_1111001u0dssnnnndddd1001nqm1mmmm_case_0_VMUL_polynomial_A1 VMUL_polynomial_A1_1111001u0dssnnnndddd1001nqm1mmmm_case_0_VMUL_polynomial_A1_instance_;
  const NamedVMVN_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_0_VMVN_immediate VMVN_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_0_VMVN_immediate_instance_;
  const NamedVMVN_register_111100111d11ss00dddd01011qm0mmmm_case_0_VMVN_register VMVN_register_111100111d11ss00dddd01011qm0mmmm_case_0_VMVN_register_instance_;
  const NamedVNEG_111100111d11ss01dddd0f111qm0mmmm_case_0_VNEG VNEG_111100111d11ss01dddd0f111qm0mmmm_case_0_VNEG_instance_;
  const NamedVNEG_111100111d11ss01dddd0f111qm0mmmm_case_1_VNEG VNEG_111100111d11ss01dddd0f111qm0mmmm_case_1_VNEG_instance_;
  const NamedVNEG_cccc11101d110001dddd101s01m0mmmm_case_0_VNEG VNEG_cccc11101d110001dddd101s01m0mmmm_case_0_VNEG_instance_;
  const NamedVNMLA_VNMLS_cccc11100d01nnnndddd101snom0mmmm_case_0_VNMLA_VNMLS VNMLA_VNMLS_cccc11100d01nnnndddd101snom0mmmm_case_0_VNMLA_VNMLS_instance_;
  const NamedVNMUL_cccc11100d10nnnndddd101sn1m0mmmm_case_0_VNMUL VNMUL_cccc11100d10nnnndddd101sn1m0mmmm_case_0_VNMUL_instance_;
  const NamedVORN_register_111100100d11nnnndddd0001nqm1mmmm_case_0_VORN_register VORN_register_111100100d11nnnndddd0001nqm1mmmm_case_0_VORN_register_instance_;
  const NamedVORR_immediate_1111001i1d000mmmddddcccc0q01mmmm_case_0_VORR_immediate VORR_immediate_1111001i1d000mmmddddcccc0q01mmmm_case_0_VORR_immediate_instance_;
  const NamedVORR_register_or_VMOV_register_A1_111100100d10nnnndddd0001nqm1mmmm_case_0_VORR_register_or_VMOV_register_A1 VORR_register_or_VMOV_register_A1_111100100d10nnnndddd0001nqm1mmmm_case_0_VORR_register_or_VMOV_register_A1_instance_;
  const NamedVPADAL_111100111d11ss00dddd0110pqm0mmmm_case_0_VPADAL VPADAL_111100111d11ss00dddd0110pqm0mmmm_case_0_VPADAL_instance_;
  const NamedVPADDL_111100111d11ss00dddd0010pqm0mmmm_case_0_VPADDL VPADDL_111100111d11ss00dddd0010pqm0mmmm_case_0_VPADDL_instance_;
  const NamedVPADD_floating_point_111100110d0snnnndddd1101nqm0mmmm_case_0_VPADD_floating_point VPADD_floating_point_111100110d0snnnndddd1101nqm0mmmm_case_0_VPADD_floating_point_instance_;
  const NamedVPADD_integer_111100100dssnnnndddd1011n0m1mmmm_case_0_VPADD_integer VPADD_integer_111100100dssnnnndddd1011n0m1mmmm_case_0_VPADD_integer_instance_;
  const NamedVPMAX_111100110dssnnnndddd1111nqm0mmmm_case_0_VPMAX VPMAX_111100110dssnnnndddd1111nqm0mmmm_case_0_VPMAX_instance_;
  const NamedVPMAX_1111001u0dssnnnndddd1010n0m0mmmm_case_0_VPMAX VPMAX_1111001u0dssnnnndddd1010n0m0mmmm_case_0_VPMAX_instance_;
  const NamedVPMIN_111100110dssnnnndddd1111nqm0mmmm_case_0_VPMIN VPMIN_111100110dssnnnndddd1111nqm0mmmm_case_0_VPMIN_instance_;
  const NamedVPMIN_1111001u0dssnnnndddd1010n0m1mmmm_case_0_VPMIN VPMIN_1111001u0dssnnnndddd1010n0m1mmmm_case_0_VPMIN_instance_;
  const NamedVPOP_cccc11001d111101dddd1010iiiiiiii_case_0_VPOP VPOP_cccc11001d111101dddd1010iiiiiiii_case_0_VPOP_instance_;
  const NamedVPOP_cccc11001d111101dddd1011iiiiiiii_case_0_VPOP VPOP_cccc11001d111101dddd1011iiiiiiii_case_0_VPOP_instance_;
  const NamedVPUSH_cccc11010d101101dddd1010iiiiiiii_case_0_VPUSH VPUSH_cccc11010d101101dddd1010iiiiiiii_case_0_VPUSH_instance_;
  const NamedVPUSH_cccc11010d101101dddd1011iiiiiiii_case_0_VPUSH VPUSH_cccc11010d101101dddd1011iiiiiiii_case_0_VPUSH_instance_;
  const NamedVQABS_111100111d11ss00dddd01110qm0mmmm_case_0_VQABS VQABS_111100111d11ss00dddd01110qm0mmmm_case_0_VQABS_instance_;
  const NamedVQADD_1111001u0dssnnnndddd0000nqm1mmmm_case_0_VQADD VQADD_1111001u0dssnnnndddd0000nqm1mmmm_case_0_VQADD_instance_;
  const NamedVQDMLAL_A1_111100101dssnnnndddd0p11n1m0mmmm_case_0_VQDMLAL_A1 VQDMLAL_A1_111100101dssnnnndddd0p11n1m0mmmm_case_0_VQDMLAL_A1_instance_;
  const NamedVQDMLAL_VQDMLSL_A1_111100101dssnnnndddd10p1n0m0mmmm_case_0_VQDMLAL_VQDMLSL_A1 VQDMLAL_VQDMLSL_A1_111100101dssnnnndddd10p1n0m0mmmm_case_0_VQDMLAL_VQDMLSL_A1_instance_;
  const NamedVQDMLSL_A1_111100101dssnnnndddd0p11n1m0mmmm_case_0_VQDMLSL_A1 VQDMLSL_A1_111100101dssnnnndddd0p11n1m0mmmm_case_0_VQDMLSL_A1_instance_;
  const NamedVQDMULH_A1_111100100dssnnnndddd1011nqm0mmmm_case_0_VQDMULH_A1 VQDMULH_A1_111100100dssnnnndddd1011nqm0mmmm_case_0_VQDMULH_A1_instance_;
  const NamedVQDMULH_A2_1111001q1dssnnnndddd1100n1m0mmmm_case_0_VQDMULH_A2 VQDMULH_A2_1111001q1dssnnnndddd1100n1m0mmmm_case_0_VQDMULH_A2_instance_;
  const NamedVQDMULL_A1_111100101dssnnnndddd1101n0m0mmmm_case_0_VQDMULL_A1 VQDMULL_A1_111100101dssnnnndddd1101n0m0mmmm_case_0_VQDMULL_A1_instance_;
  const NamedVQDMULL_A2_111100101dssnnnndddd1011n1m0mmmm_case_0_VQDMULL_A2 VQDMULL_A2_111100101dssnnnndddd1011n1m0mmmm_case_0_VQDMULL_A2_instance_;
  const NamedVQMOVN_111100111d11ss10dddd0010ppm0mmmm_case_0_VQMOVN VQMOVN_111100111d11ss10dddd0010ppm0mmmm_case_0_VQMOVN_instance_;
  const NamedVQMOVUN_111100111d11ss10dddd0010ppm0mmmm_case_0_VQMOVUN VQMOVUN_111100111d11ss10dddd0010ppm0mmmm_case_0_VQMOVUN_instance_;
  const NamedVQNEG_111100111d11ss00dddd01111qm0mmmm_case_0_VQNEG VQNEG_111100111d11ss00dddd01111qm0mmmm_case_0_VQNEG_instance_;
  const NamedVQRDMULH_1111001q1dssnnnndddd1101n1m0mmmm_case_0_VQRDMULH VQRDMULH_1111001q1dssnnnndddd1101n1m0mmmm_case_0_VQRDMULH_instance_;
  const NamedVQRDMULH_A1_111100110dssnnnndddd1011nqm0mmmm_case_0_VQRDMULH_A1 VQRDMULH_A1_111100110dssnnnndddd1011nqm0mmmm_case_0_VQRDMULH_A1_instance_;
  const NamedVQRSHL_1111001u0dssnnnndddd0101nqm1mmmm_case_0_VQRSHL VQRSHL_1111001u0dssnnnndddd0101nqm1mmmm_case_0_VQRSHL_instance_;
  const NamedVQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_0_VQRSHRN VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_0_VQRSHRN_instance_;
  const NamedVQRSHRUN_1111001u1diiiiiidddd100p00m1mmmm_case_0_VQRSHRUN VQRSHRUN_1111001u1diiiiiidddd100p00m1mmmm_case_0_VQRSHRUN_instance_;
  const NamedVQRSHRUN_1111001u1diiiiiidddd100p01m1mmmm_case_0_VQRSHRUN VQRSHRUN_1111001u1diiiiiidddd100p01m1mmmm_case_0_VQRSHRUN_instance_;
  const NamedVQSHL_VQSHLU_immediate_1111001u1diiiiiidddd011plqm1mmmm_case_0_VQSHL_VQSHLU_immediate VQSHL_VQSHLU_immediate_1111001u1diiiiiidddd011plqm1mmmm_case_0_VQSHL_VQSHLU_immediate_instance_;
  const NamedVQSHL_register_1111001u0dssnnnndddd0100nqm1mmmm_case_0_VQSHL_register VQSHL_register_1111001u0dssnnnndddd0100nqm1mmmm_case_0_VQSHL_register_instance_;
  const NamedVQSHRN_1111001u1diiiiiidddd100p00m1mmmm_case_0_VQSHRN VQSHRN_1111001u1diiiiiidddd100p00m1mmmm_case_0_VQSHRN_instance_;
  const NamedVQSHRUN_1111001u1diiiiiidddd100p00m1mmmm_case_0_VQSHRUN VQSHRUN_1111001u1diiiiiidddd100p00m1mmmm_case_0_VQSHRUN_instance_;
  const NamedVQSUB_1111001u0dssnnnndddd0010nqm1mmmm_case_0_VQSUB VQSUB_1111001u0dssnnnndddd0010nqm1mmmm_case_0_VQSUB_instance_;
  const NamedVRADDHN_111100111dssnnnndddd0100n0m0mmmm_case_0_VRADDHN VRADDHN_111100111dssnnnndddd0100n0m0mmmm_case_0_VRADDHN_instance_;
  const NamedVRECPE_111100111d11ss11dddd010f0qm0mmmm_case_0_VRECPE VRECPE_111100111d11ss11dddd010f0qm0mmmm_case_0_VRECPE_instance_;
  const NamedVRECPS_111100100d0snnnndddd1111nqm1mmmm_case_0_VRECPS VRECPS_111100100d0snnnndddd1111nqm1mmmm_case_0_VRECPS_instance_;
  const NamedVREV16_111100111d11ss00dddd000ppqm0mmmm_case_0_VREV16 VREV16_111100111d11ss00dddd000ppqm0mmmm_case_0_VREV16_instance_;
  const NamedVREV32_111100111d11ss00dddd000ppqm0mmmm_case_0_VREV32 VREV32_111100111d11ss00dddd000ppqm0mmmm_case_0_VREV32_instance_;
  const NamedVREV64_111100111d11ss00dddd000ppqm0mmmm_case_0_VREV64 VREV64_111100111d11ss00dddd000ppqm0mmmm_case_0_VREV64_instance_;
  const NamedVRHADD_1111001u0dssnnnndddd0001nqm0mmmm_case_0_VRHADD VRHADD_1111001u0dssnnnndddd0001nqm0mmmm_case_0_VRHADD_instance_;
  const NamedVRSHL_1111001u0dssnnnndddd0101nqm0mmmm_case_0_VRSHL VRSHL_1111001u0dssnnnndddd0101nqm0mmmm_case_0_VRSHL_instance_;
  const NamedVRSHRN_111100101diiiiiidddd100001m1mmmm_case_0_VRSHRN VRSHRN_111100101diiiiiidddd100001m1mmmm_case_0_VRSHRN_instance_;
  const NamedVRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_0_VRSHR VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_0_VRSHR_instance_;
  const NamedVRSQRTE_111100111d11ss11dddd010f1qm0mmmm_case_0_VRSQRTE VRSQRTE_111100111d11ss11dddd010f1qm0mmmm_case_0_VRSQRTE_instance_;
  const NamedVRSQRTS_111100100d1snnnndddd1111nqm1mmmm_case_0_VRSQRTS VRSQRTS_111100100d1snnnndddd1111nqm1mmmm_case_0_VRSQRTS_instance_;
  const NamedVRSRA_1111001u1diiiiiidddd0011lqm1mmmm_case_0_VRSRA VRSRA_1111001u1diiiiiidddd0011lqm1mmmm_case_0_VRSRA_instance_;
  const NamedVRSUBHN_111100111dssnnnndddd0110n0m0mmmm_case_0_VRSUBHN VRSUBHN_111100111dssnnnndddd0110n0m0mmmm_case_0_VRSUBHN_instance_;
  const NamedVSHLL_A1_or_VMOVL_1111001u1diiiiiidddd101000m1mmmm_case_0_VSHLL_A1_or_VMOVL VSHLL_A1_or_VMOVL_1111001u1diiiiiidddd101000m1mmmm_case_0_VSHLL_A1_or_VMOVL_instance_;
  const NamedVSHLL_A2_111100111d11ss10dddd001100m0mmmm_case_0_VSHLL_A2 VSHLL_A2_111100111d11ss10dddd001100m0mmmm_case_0_VSHLL_A2_instance_;
  const NamedVSHL_immediate_111100101diiiiiidddd0101lqm1mmmm_case_0_VSHL_immediate VSHL_immediate_111100101diiiiiidddd0101lqm1mmmm_case_0_VSHL_immediate_instance_;
  const NamedVSHL_register_1111001u0dssnnnndddd0100nqm0mmmm_case_0_VSHL_register VSHL_register_1111001u0dssnnnndddd0100nqm0mmmm_case_0_VSHL_register_instance_;
  const NamedVSHRN_111100101diiiiiidddd100000m1mmmm_case_0_VSHRN VSHRN_111100101diiiiiidddd100000m1mmmm_case_0_VSHRN_instance_;
  const NamedVSHR_1111001u1diiiiiidddd0000lqm1mmmm_case_0_VSHR VSHR_1111001u1diiiiiidddd0000lqm1mmmm_case_0_VSHR_instance_;
  const NamedVSLI_111100111diiiiiidddd0101lqm1mmmm_case_0_VSLI VSLI_111100111diiiiiidddd0101lqm1mmmm_case_0_VSLI_instance_;
  const NamedVSQRT_cccc11101d110001dddd101s11m0mmmm_case_0_VSQRT VSQRT_cccc11101d110001dddd101s11m0mmmm_case_0_VSQRT_instance_;
  const NamedVSRA_1111001u1diiiiiidddd0001lqm1mmmm_case_0_VSRA VSRA_1111001u1diiiiiidddd0001lqm1mmmm_case_0_VSRA_instance_;
  const NamedVSRI_111100111diiiiiidddd0100lqm1mmmm_case_0_VSRI VSRI_111100111diiiiiidddd0100lqm1mmmm_case_0_VSRI_instance_;
  const NamedVST1_multiple_single_elements_111101000d00nnnnddddttttssaammmm_case_0_VST1_multiple_single_elements VST1_multiple_single_elements_111101000d00nnnnddddttttssaammmm_case_0_VST1_multiple_single_elements_instance_;
  const NamedVST1_single_element_from_one_lane_111101001d00nnnnddddss00aaaammmm_case_0_VST1_single_element_from_one_lane VST1_single_element_from_one_lane_111101001d00nnnnddddss00aaaammmm_case_0_VST1_single_element_from_one_lane_instance_;
  const NamedVST2_multiple_2_element_structures_111101000d00nnnnddddttttssaammmm_case_0_VST2_multiple_2_element_structures VST2_multiple_2_element_structures_111101000d00nnnnddddttttssaammmm_case_0_VST2_multiple_2_element_structures_instance_;
  const NamedVST2_single_2_element_structure_from_one_lane_111101001d00nnnnddddss01aaaammmm_case_0_VST2_single_2_element_structure_from_one_lane VST2_single_2_element_structure_from_one_lane_111101001d00nnnnddddss01aaaammmm_case_0_VST2_single_2_element_structure_from_one_lane_instance_;
  const NamedVST3_multiple_3_element_structures_111101000d00nnnnddddttttssaammmm_case_0_VST3_multiple_3_element_structures VST3_multiple_3_element_structures_111101000d00nnnnddddttttssaammmm_case_0_VST3_multiple_3_element_structures_instance_;
  const NamedVST3_single_3_element_structure_from_one_lane_111101001d00nnnnddddss10aaaammmm_case_0_VST3_single_3_element_structure_from_one_lane VST3_single_3_element_structure_from_one_lane_111101001d00nnnnddddss10aaaammmm_case_0_VST3_single_3_element_structure_from_one_lane_instance_;
  const NamedVST4_multiple_4_element_structures_111101000d00nnnnddddttttssaammmm_case_0_VST4_multiple_4_element_structures VST4_multiple_4_element_structures_111101000d00nnnnddddttttssaammmm_case_0_VST4_multiple_4_element_structures_instance_;
  const NamedVST4_single_4_element_structure_form_one_lane_111101001d00nnnnddddss11aaaammmm_case_0_VST4_single_4_element_structure_form_one_lane VST4_single_4_element_structure_form_one_lane_111101001d00nnnnddddss11aaaammmm_case_0_VST4_single_4_element_structure_form_one_lane_instance_;
  const NamedVSTM_cccc110pudw0nnnndddd1010iiiiiiii_case_0_VSTM VSTM_cccc110pudw0nnnndddd1010iiiiiiii_case_0_VSTM_instance_;
  const NamedVSTM_cccc110pudw0nnnndddd1011iiiiiiii_case_0_VSTM VSTM_cccc110pudw0nnnndddd1011iiiiiiii_case_0_VSTM_instance_;
  const NamedVSTR_cccc1101ud00nnnndddd1010iiiiiiii_case_0_VSTR VSTR_cccc1101ud00nnnndddd1010iiiiiiii_case_0_VSTR_instance_;
  const NamedVSTR_cccc1101ud00nnnndddd1011iiiiiiii_case_0_VSTR VSTR_cccc1101ud00nnnndddd1011iiiiiiii_case_0_VSTR_instance_;
  const NamedVSUBHN_111100101dssnnnndddd0110n0m0mmmm_case_0_VSUBHN VSUBHN_111100101dssnnnndddd0110n0m0mmmm_case_0_VSUBHN_instance_;
  const NamedVSUBL_VSUBW_1111001u1dssnnnndddd001pn0m0mmmm_case_0_VSUBL_VSUBW VSUBL_VSUBW_1111001u1dssnnnndddd001pn0m0mmmm_case_0_VSUBL_VSUBW_instance_;
  const NamedVSUB_floating_point_A1_111100100d1snnnndddd1101nqm0mmmm_case_0_VSUB_floating_point_A1 VSUB_floating_point_A1_111100100d1snnnndddd1101nqm0mmmm_case_0_VSUB_floating_point_A1_instance_;
  const NamedVSUB_floating_point_cccc11100d11nnnndddd101sn1m0mmmm_case_0_VSUB_floating_point VSUB_floating_point_cccc11100d11nnnndddd101sn1m0mmmm_case_0_VSUB_floating_point_instance_;
  const NamedVSUB_integer_111100110dssnnnndddd1000nqm0mmmm_case_0_VSUB_integer VSUB_integer_111100110dssnnnndddd1000nqm0mmmm_case_0_VSUB_integer_instance_;
  const NamedVSWP_111100111d11ss10dddd00000qm0mmmm_case_0_VSWP VSWP_111100111d11ss10dddd00000qm0mmmm_case_0_VSWP_instance_;
  const NamedVTBL_VTBX_111100111d11nnnndddd10ccnpm0mmmm_case_0_VTBL_VTBX VTBL_VTBX_111100111d11nnnndddd10ccnpm0mmmm_case_0_VTBL_VTBX_instance_;
  const NamedVTRN_111100111d11ss10dddd00001qm0mmmm_case_0_VTRN VTRN_111100111d11ss10dddd00001qm0mmmm_case_0_VTRN_instance_;
  const NamedVTST_111100100dssnnnndddd1000nqm1mmmm_case_0_VTST VTST_111100100dssnnnndddd1000nqm1mmmm_case_0_VTST_instance_;
  const NamedVUZP_111100111d11ss10dddd00010qm0mmmm_case_0_VUZP VUZP_111100111d11ss10dddd00010qm0mmmm_case_0_VUZP_instance_;
  const NamedVZIP_111100111d11ss10dddd00011qm0mmmm_case_0_VZIP VZIP_111100111d11ss10dddd00011qm0mmmm_case_0_VZIP_instance_;
  const NamedWFE_cccc0011001000001111000000000010_case_0_WFE WFE_cccc0011001000001111000000000010_case_0_WFE_instance_;
  const NamedWFI_cccc0011001000001111000000000011_case_0_WFI WFI_cccc0011001000001111000000000011_case_0_WFI_instance_;
  const NamedYIELD_cccc0011001000001111000000000001_case_0_YIELD YIELD_cccc0011001000001111000000000001_case_0_YIELD_instance_;
  const Namedextra_load_store_instructions_unpriviledged_cccc0000xx1xxxxxxxxxxxxx1xx1xxxx_case_0_extra_load_store_instructions_unpriviledged extra_load_store_instructions_unpriviledged_cccc0000xx1xxxxxxxxxxxxx1xx1xxxx_case_0_extra_load_store_instructions_unpriviledged_instance_;
  const NamedActual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_ADC_immediate Actual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_ADC_immediate_instance_;
  const NamedActual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_AND_immediate Actual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_AND_immediate_instance_;
  const NamedActual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_EOR_immediate Actual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_EOR_immediate_instance_;
  const NamedActual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_RSB_immediate Actual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_RSB_immediate_instance_;
  const NamedActual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_RSC_immediate Actual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_RSC_immediate_instance_;
  const NamedActual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_SBC_immediate Actual_ADC_immediate_cccc0010101snnnnddddiiiiiiiiiiii_case_1_SBC_immediate_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_ADC_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_ADC_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_ADD_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_ADD_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_AND_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_AND_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_BIC_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_BIC_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_EOR_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_EOR_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_ORR_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_ORR_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_RSB_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_RSB_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_RSC_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_RSC_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_SBC_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_SBC_register_instance_;
  const NamedActual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_SUB_register Actual_ADC_register_cccc0000101snnnnddddiiiiitt0mmmm_case_1_SUB_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_ADC_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_ADC_register_shifted_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_ADD_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_ADD_register_shifted_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_AND_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_AND_register_shifted_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_BIC_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_BIC_register_shifted_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_EOR_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_EOR_register_shifted_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_ORR_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_ORR_register_shifted_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_RSB_register_shfited_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_RSB_register_shfited_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_RSC_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_RSC_register_shifted_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_SBC_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_SBC_register_shifted_register_instance_;
  const NamedActual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_SUB_register_shifted_register Actual_ADC_register_shifted_register_cccc0000101snnnnddddssss0tt1mmmm_case_1_SUB_register_shifted_register_instance_;
  const NamedActual_ADD_immediate_cccc0010100snnnnddddiiiiiiiiiiii_case_1_ADD_immediate Actual_ADD_immediate_cccc0010100snnnnddddiiiiiiiiiiii_case_1_ADD_immediate_instance_;
  const NamedActual_ADD_immediate_cccc0010100snnnnddddiiiiiiiiiiii_case_1_SUB_immediate Actual_ADD_immediate_cccc0010100snnnnddddiiiiiiiiiiii_case_1_SUB_immediate_instance_;
  const NamedActual_ADR_A1_cccc001010001111ddddiiiiiiiiiiii_case_1_ADR_A1 Actual_ADR_A1_cccc001010001111ddddiiiiiiiiiiii_case_1_ADR_A1_instance_;
  const NamedActual_ADR_A1_cccc001010001111ddddiiiiiiiiiiii_case_1_ADR_A2 Actual_ADR_A1_cccc001010001111ddddiiiiiiiiiiii_case_1_ADR_A2_instance_;
  const NamedActual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_ASR_immediate Actual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_ASR_immediate_instance_;
  const NamedActual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_LSR_immediate Actual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_LSR_immediate_instance_;
  const NamedActual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_MOV_register Actual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_MOV_register_instance_;
  const NamedActual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_MVN_register Actual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_MVN_register_instance_;
  const NamedActual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_RRX Actual_ASR_immediate_cccc0001101s0000ddddiiiii100mmmm_case_1_RRX_instance_;
  const NamedActual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_ASR_register Actual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_ASR_register_instance_;
  const NamedActual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_LSL_register Actual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_LSL_register_instance_;
  const NamedActual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_LSR_register Actual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_LSR_register_instance_;
  const NamedActual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_MVN_register_shifted_register Actual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_MVN_register_shifted_register_instance_;
  const NamedActual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_ROR_register Actual_ASR_register_cccc0001101s0000ddddmmmm0101nnnn_case_1_ROR_register_instance_;
  const NamedActual_BFC_cccc0111110mmmmmddddlllll0011111_case_1_BFC Actual_BFC_cccc0111110mmmmmddddlllll0011111_case_1_BFC_instance_;
  const NamedActual_BFI_cccc0111110mmmmmddddlllll001nnnn_case_1_BFI Actual_BFI_cccc0111110mmmmmddddlllll001nnnn_case_1_BFI_instance_;
  const NamedActual_BIC_immediate_cccc0011110snnnnddddiiiiiiiiiiii_case_1_BIC_immediate Actual_BIC_immediate_cccc0011110snnnnddddiiiiiiiiiiii_case_1_BIC_immediate_instance_;
  const NamedActual_BKPT_cccc00010010iiiiiiiiiiii0111iiii_case_1_BKPT Actual_BKPT_cccc00010010iiiiiiiiiiii0111iiii_case_1_BKPT_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_BLX_immediate Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_BLX_immediate_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_BXJ Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_BXJ_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_CDP Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_CDP_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_CDP2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_CDP2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_CLREX Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_CLREX_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_CPS Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_CPS_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_DBG Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_DBG_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_ERET Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_ERET_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_FICTITIOUS_FIRST Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_FICTITIOUS_FIRST_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_HVC Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_HVC_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDC2_immediate Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDC2_immediate_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDC2_literal Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDC2_literal_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDC_immediate Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDC_immediate_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDC_literal Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDC_literal_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDM_User_registers Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDM_User_registers_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDM_exception_return Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDM_exception_return_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDRBT_A1 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDRBT_A1_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDRBT_A2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDRBT_A2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDRT_A1 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDRT_A1_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDRT_A2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_LDRT_A2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MCR2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MCR2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MCRR Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MCRR_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MCRR2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MCRR2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRC Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRC_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRC2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRC2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRRC Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRRC_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRRC2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRRC2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRS_Banked_register Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MRS_Banked_register_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MSR_immediate Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MSR_immediate_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MSR_register Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_MSR_register_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_RFE Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_RFE_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SETEND Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SETEND_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SEV Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SEV_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SMC Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SMC_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SRS Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SRS_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STC Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STC_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STC2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STC2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STM_User_registers Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STM_User_registers_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STRBT_A1 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STRBT_A1_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STRBT_A2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STRBT_A2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STRT_A1 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STRT_A1_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STRT_A2 Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_STRT_A2_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SVC Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_SVC_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_WFE Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_WFE_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_WFI Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_WFI_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_extra_load_store_instructions_unpriviledged Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_extra_load_store_instructions_unpriviledged_instance_;
  const NamedActual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_None Actual_BLX_immediate_1111101hiiiiiiiiiiiiiiiiiiiiiiii_case_1_None_instance_;
  const NamedActual_BLX_register_cccc000100101111111111110011mmmm_case_1_BLX_register Actual_BLX_register_cccc000100101111111111110011mmmm_case_1_BLX_register_instance_;
  const NamedActual_BL_BLX_immediate_cccc1011iiiiiiiiiiiiiiiiiiiiiiii_case_1_BL_BLX_immediate Actual_BL_BLX_immediate_cccc1011iiiiiiiiiiiiiiiiiiiiiiii_case_1_BL_BLX_immediate_instance_;
  const NamedActual_B_cccc1010iiiiiiiiiiiiiiiiiiiiiiii_case_1_B Actual_B_cccc1010iiiiiiiiiiiiiiiiiiiiiiii_case_1_B_instance_;
  const NamedActual_Bx_cccc000100101111111111110001mmmm_case_1_Bx Actual_Bx_cccc000100101111111111110001mmmm_case_1_Bx_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_CLZ Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_CLZ_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_RBIT Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_RBIT_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_REV Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_REV_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_REV16 Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_REV16_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_REVSH Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_REVSH_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SSAT Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SSAT_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SSAT16 Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SSAT16_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SXTB Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SXTB_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SXTB16 Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SXTB16_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SXTH Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_SXTH_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_USAT Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_USAT_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_USAT16 Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_USAT16_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_UXTB Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_UXTB_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_UXTB16 Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_UXTB16_instance_;
  const NamedActual_CLZ_cccc000101101111dddd11110001mmmm_case_1_UXTH Actual_CLZ_cccc000101101111dddd11110001mmmm_case_1_UXTH_instance_;
  const NamedActual_CMN_immediate_cccc00110111nnnn0000iiiiiiiiiiii_case_1_CMN_immediate Actual_CMN_immediate_cccc00110111nnnn0000iiiiiiiiiiii_case_1_CMN_immediate_instance_;
  const NamedActual_CMN_immediate_cccc00110111nnnn0000iiiiiiiiiiii_case_1_CMP_immediate Actual_CMN_immediate_cccc00110111nnnn0000iiiiiiiiiiii_case_1_CMP_immediate_instance_;
  const NamedActual_CMN_immediate_cccc00110111nnnn0000iiiiiiiiiiii_case_1_TEQ_immediate Actual_CMN_immediate_cccc00110111nnnn0000iiiiiiiiiiii_case_1_TEQ_immediate_instance_;
  const NamedActual_CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_1_CMN_register Actual_CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_1_CMN_register_instance_;
  const NamedActual_CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_1_CMP_register Actual_CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_1_CMP_register_instance_;
  const NamedActual_CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_1_TEQ_register Actual_CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_1_TEQ_register_instance_;
  const NamedActual_CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_1_TST_register Actual_CMN_register_cccc00010111nnnn0000iiiiitt0mmmm_case_1_TST_register_instance_;
  const NamedActual_CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_1_CMN_register_shifted_register Actual_CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_1_CMN_register_shifted_register_instance_;
  const NamedActual_CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_1_CMP_register_shifted_register Actual_CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_1_CMP_register_shifted_register_instance_;
  const NamedActual_CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_1_TEQ_register_shifted_register Actual_CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_1_TEQ_register_shifted_register_instance_;
  const NamedActual_CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_1_TST_register_shifted_register Actual_CMN_register_shifted_register_cccc00010111nnnn0000ssss0tt1mmmm_case_1_TST_register_shifted_register_instance_;
  const NamedActual_CVT_between_half_precision_and_single_precision_111100111d11ss10dddd011p00m0mmmm_case_1_CVT_between_half_precision_and_single_precision Actual_CVT_between_half_precision_and_single_precision_111100111d11ss10dddd011p00m0mmmm_case_1_CVT_between_half_precision_and_single_precision_instance_;
  const NamedActual_DMB_1111010101111111111100000101xxxx_case_1_DMB Actual_DMB_1111010101111111111100000101xxxx_case_1_DMB_instance_;
  const NamedActual_DMB_1111010101111111111100000101xxxx_case_1_DSB Actual_DMB_1111010101111111111100000101xxxx_case_1_DSB_instance_;
  const NamedActual_ISB_1111010101111111111100000110xxxx_case_1_ISB Actual_ISB_1111010101111111111100000110xxxx_case_1_ISB_instance_;
  const NamedActual_LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_1_LDMDA_LDMFA Actual_LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_1_LDMDA_LDMFA_instance_;
  const NamedActual_LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_1_LDMDB_LDMEA Actual_LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_1_LDMDB_LDMEA_instance_;
  const NamedActual_LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_1_LDMIB_LDMED Actual_LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_1_LDMIB_LDMED_instance_;
  const NamedActual_LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_1_LDM_LDMIA_LDMFD Actual_LDMDA_LDMFA_cccc100000w1nnnnrrrrrrrrrrrrrrrr_case_1_LDM_LDMIA_LDMFD_instance_;
  const NamedActual_LDRB_immediate_cccc010pu1w1nnnnttttiiiiiiiiiiii_case_1_LDRB_immediate Actual_LDRB_immediate_cccc010pu1w1nnnnttttiiiiiiiiiiii_case_1_LDRB_immediate_instance_;
  const NamedActual_LDRB_literal_cccc0101u1011111ttttiiiiiiiiiiii_case_1_LDRB_literal Actual_LDRB_literal_cccc0101u1011111ttttiiiiiiiiiiii_case_1_LDRB_literal_instance_;
  const NamedActual_LDRB_register_cccc011pu1w1nnnnttttiiiiitt0mmmm_case_1_LDRB_register Actual_LDRB_register_cccc011pu1w1nnnnttttiiiiitt0mmmm_case_1_LDRB_register_instance_;
  const NamedActual_LDRD_immediate_cccc000pu1w0nnnnttttiiii1101iiii_case_1_LDRD_immediate Actual_LDRD_immediate_cccc000pu1w0nnnnttttiiii1101iiii_case_1_LDRD_immediate_instance_;
  const NamedActual_LDRD_literal_cccc0001u1001111ttttiiii1101iiii_case_1_LDRD_literal Actual_LDRD_literal_cccc0001u1001111ttttiiii1101iiii_case_1_LDRD_literal_instance_;
  const NamedActual_LDRD_register_cccc000pu0w0nnnntttt00001101mmmm_case_1_LDRD_register Actual_LDRD_register_cccc000pu0w0nnnntttt00001101mmmm_case_1_LDRD_register_instance_;
  const NamedActual_LDREXB_cccc00011101nnnntttt111110011111_case_1_LDREX Actual_LDREXB_cccc00011101nnnntttt111110011111_case_1_LDREX_instance_;
  const NamedActual_LDREXB_cccc00011101nnnntttt111110011111_case_1_LDREXB Actual_LDREXB_cccc00011101nnnntttt111110011111_case_1_LDREXB_instance_;
  const NamedActual_LDREXB_cccc00011101nnnntttt111110011111_case_1_STREXH Actual_LDREXB_cccc00011101nnnntttt111110011111_case_1_STREXH_instance_;
  const NamedActual_LDREXD_cccc00011011nnnntttt111110011111_case_1_LDREXD Actual_LDREXD_cccc00011011nnnntttt111110011111_case_1_LDREXD_instance_;
  const NamedActual_LDRH_immediate_cccc000pu1w1nnnnttttiiii1011iiii_case_1_LDRH_immediate Actual_LDRH_immediate_cccc000pu1w1nnnnttttiiii1011iiii_case_1_LDRH_immediate_instance_;
  const NamedActual_LDRH_immediate_cccc000pu1w1nnnnttttiiii1011iiii_case_1_LDRSB_immediate Actual_LDRH_immediate_cccc000pu1w1nnnnttttiiii1011iiii_case_1_LDRSB_immediate_instance_;
  const NamedActual_LDRH_immediate_cccc000pu1w1nnnnttttiiii1011iiii_case_1_LDRSH_immediate Actual_LDRH_immediate_cccc000pu1w1nnnnttttiiii1011iiii_case_1_LDRSH_immediate_instance_;
  const NamedActual_LDRH_literal_cccc000pu1w11111ttttiiii1011iiii_case_1_LDRH_literal Actual_LDRH_literal_cccc000pu1w11111ttttiiii1011iiii_case_1_LDRH_literal_instance_;
  const NamedActual_LDRH_literal_cccc000pu1w11111ttttiiii1011iiii_case_1_LDRSB_literal Actual_LDRH_literal_cccc000pu1w11111ttttiiii1011iiii_case_1_LDRSB_literal_instance_;
  const NamedActual_LDRH_literal_cccc000pu1w11111ttttiiii1011iiii_case_1_LDRSH_literal Actual_LDRH_literal_cccc000pu1w11111ttttiiii1011iiii_case_1_LDRSH_literal_instance_;
  const NamedActual_LDRH_register_cccc000pu0w1nnnntttt00001011mmmm_case_1_LDRH_register Actual_LDRH_register_cccc000pu0w1nnnntttt00001011mmmm_case_1_LDRH_register_instance_;
  const NamedActual_LDRH_register_cccc000pu0w1nnnntttt00001011mmmm_case_1_LDRSB_register Actual_LDRH_register_cccc000pu0w1nnnntttt00001011mmmm_case_1_LDRSB_register_instance_;
  const NamedActual_LDRH_register_cccc000pu0w1nnnntttt00001011mmmm_case_1_LDRSH_register Actual_LDRH_register_cccc000pu0w1nnnntttt00001011mmmm_case_1_LDRSH_register_instance_;
  const NamedActual_LDR_immediate_cccc010pu0w1nnnnttttiiiiiiiiiiii_case_1_LDR_immediate Actual_LDR_immediate_cccc010pu0w1nnnnttttiiiiiiiiiiii_case_1_LDR_immediate_instance_;
  const NamedActual_LDR_literal_cccc0101u0011111ttttiiiiiiiiiiii_case_1_LDR_literal Actual_LDR_literal_cccc0101u0011111ttttiiiiiiiiiiii_case_1_LDR_literal_instance_;
  const NamedActual_LDR_register_cccc011pu0w1nnnnttttiiiiitt0mmmm_case_1_LDR_register Actual_LDR_register_cccc011pu0w1nnnnttttiiiiitt0mmmm_case_1_LDR_register_instance_;
  const NamedActual_LSL_immediate_cccc0001101s0000ddddiiiii000mmmm_case_1_LSL_immediate Actual_LSL_immediate_cccc0001101s0000ddddiiiii000mmmm_case_1_LSL_immediate_instance_;
  const NamedActual_LSL_immediate_cccc0001101s0000ddddiiiii000mmmm_case_1_ROR_immediate Actual_LSL_immediate_cccc0001101s0000ddddiiiii000mmmm_case_1_ROR_immediate_instance_;
  const NamedActual_MCR_cccc1110ooo0nnnnttttccccooo1mmmm_case_1_MCR Actual_MCR_cccc1110ooo0nnnnttttccccooo1mmmm_case_1_MCR_instance_;
  const NamedActual_MLA_A1_cccc0000001sddddaaaammmm1001nnnn_case_1_MLA_A1 Actual_MLA_A1_cccc0000001sddddaaaammmm1001nnnn_case_1_MLA_A1_instance_;
  const NamedActual_MLS_A1_cccc00000110ddddaaaammmm1001nnnn_case_1_MLS_A1 Actual_MLS_A1_cccc00000110ddddaaaammmm1001nnnn_case_1_MLS_A1_instance_;
  const NamedActual_MLS_A1_cccc00000110ddddaaaammmm1001nnnn_case_1_SMLABB_SMLABT_SMLATB_SMLATT Actual_MLS_A1_cccc00000110ddddaaaammmm1001nnnn_case_1_SMLABB_SMLABT_SMLATB_SMLATT_instance_;
  const NamedActual_MLS_A1_cccc00000110ddddaaaammmm1001nnnn_case_1_SMLAWB_SMLAWT Actual_MLS_A1_cccc00000110ddddaaaammmm1001nnnn_case_1_SMLAWB_SMLAWT_instance_;
  const NamedActual_MOVE_scalar_to_ARM_core_register_cccc1110iii1nnnntttt1011nii10000_case_1_MOVE_scalar_to_ARM_core_register Actual_MOVE_scalar_to_ARM_core_register_cccc1110iii1nnnntttt1011nii10000_case_1_MOVE_scalar_to_ARM_core_register_instance_;
  const NamedActual_MOVT_cccc00110100iiiiddddiiiiiiiiiiii_case_1_MOVT Actual_MOVT_cccc00110100iiiiddddiiiiiiiiiiii_case_1_MOVT_instance_;
  const NamedActual_MOVT_cccc00110100iiiiddddiiiiiiiiiiii_case_1_MOVW Actual_MOVT_cccc00110100iiiiddddiiiiiiiiiiii_case_1_MOVW_instance_;
  const NamedActual_MOV_immediate_A1_cccc0011101s0000ddddiiiiiiiiiiii_case_1_MOV_immediate_A1 Actual_MOV_immediate_A1_cccc0011101s0000ddddiiiiiiiiiiii_case_1_MOV_immediate_A1_instance_;
  const NamedActual_MOV_immediate_A1_cccc0011101s0000ddddiiiiiiiiiiii_case_1_MVN_immediate Actual_MOV_immediate_A1_cccc0011101s0000ddddiiiiiiiiiiii_case_1_MVN_immediate_instance_;
  const NamedActual_MRS_cccc00010r001111dddd000000000000_case_1_MRS Actual_MRS_cccc00010r001111dddd000000000000_case_1_MRS_instance_;
  const NamedActual_MSR_immediate_cccc00110010mm001111iiiiiiiiiiii_case_1_MSR_immediate Actual_MSR_immediate_cccc00110010mm001111iiiiiiiiiiii_case_1_MSR_immediate_instance_;
  const NamedActual_MSR_register_cccc00010010mm00111100000000nnnn_case_1_MSR_register Actual_MSR_register_cccc00010010mm00111100000000nnnn_case_1_MSR_register_instance_;
  const NamedActual_MUL_A1_cccc0000000sdddd0000mmmm1001nnnn_case_1_MUL_A1 Actual_MUL_A1_cccc0000000sdddd0000mmmm1001nnnn_case_1_MUL_A1_instance_;
  const NamedActual_NOP_cccc0011001000001111000000000000_case_1_NOP Actual_NOP_cccc0011001000001111000000000000_case_1_NOP_instance_;
  const NamedActual_NOP_cccc0011001000001111000000000000_case_1_YIELD Actual_NOP_cccc0011001000001111000000000000_case_1_YIELD_instance_;
  const NamedActual_NOT_IMPLEMENTED_case_1_NOT_IMPLEMENTED Actual_NOT_IMPLEMENTED_case_1_NOT_IMPLEMENTED_instance_;
  const NamedActual_ORR_immediate_cccc0011100snnnnddddiiiiiiiiiiii_case_1_ORR_immediate Actual_ORR_immediate_cccc0011100snnnnddddiiiiiiiiiiii_case_1_ORR_immediate_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_PKH Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_PKH_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QADD Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QADD_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QADD16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QADD16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QADD8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QADD8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QASX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QASX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QDADD Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QDADD_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QDSUB Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QDSUB_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QSAX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QSAX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QSUB Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QSUB_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QSUB16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QSUB16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QSUB8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_QSUB8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SADD16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SADD16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SADD8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SADD8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SASX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SASX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SEL Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SEL_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHADD16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHADD16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHADD8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHADD8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHASX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHASX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHSAX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHSAX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHSUB16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHSUB16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHSUB8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SHSUB8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SSAX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SSAX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SSSUB16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SSSUB16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SSUB8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_SSUB8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UADD16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UADD16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UADD8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UADD8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UASX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UASX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHADD16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHADD16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHADD8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHADD8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHASX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHASX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHSAX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHSAX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHSUB16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHSUB16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHSUB8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UHSUB8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQADD16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQADD16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQADD8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQADD8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQASX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQASX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQSAX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQSAX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQSUB16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQSUB16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQSUB8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_UQSUB8_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_USAX Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_USAX_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_USUB16 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_USUB16_instance_;
  const NamedActual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_USUB8 Actual_PKH_cccc01101000nnnnddddiiiiit01mmmm_case_1_USUB8_instance_;
  const NamedActual_PLD_PLDW_immediate_11110101ur01nnnn1111iiiiiiiiiiii_case_1_PLD_PLDW_immediate Actual_PLD_PLDW_immediate_11110101ur01nnnn1111iiiiiiiiiiii_case_1_PLD_PLDW_immediate_instance_;
  const NamedActual_PLD_PLDW_register_11110111u001nnnn1111iiiiitt0mmmm_case_1_PLD_PLDW_register Actual_PLD_PLDW_register_11110111u001nnnn1111iiiiitt0mmmm_case_1_PLD_PLDW_register_instance_;
  const NamedActual_PLD_literal_11110101u10111111111iiiiiiiiiiii_case_1_PLD_literal Actual_PLD_literal_11110101u10111111111iiiiiiiiiiii_case_1_PLD_literal_instance_;
  const NamedActual_PLI_immediate_literal_11110100u101nnnn1111iiiiiiiiiiii_case_1_PLI_immediate_literal Actual_PLI_immediate_literal_11110100u101nnnn1111iiiiiiiiiiii_case_1_PLI_immediate_literal_instance_;
  const NamedActual_PLI_register_11110110u101nnnn1111iiiiitt0mmmm_case_1_PLI_register Actual_PLI_register_11110110u101nnnn1111iiiiitt0mmmm_case_1_PLI_register_instance_;
  const NamedActual_SBFX_cccc0111101wwwwwddddlllll101nnnn_case_1_SBFX Actual_SBFX_cccc0111101wwwwwddddlllll101nnnn_case_1_SBFX_instance_;
  const NamedActual_SBFX_cccc0111101wwwwwddddlllll101nnnn_case_1_UBFX Actual_SBFX_cccc0111101wwwwwddddlllll101nnnn_case_1_UBFX_instance_;
  const NamedActual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_SDIV Actual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_SDIV_instance_;
  const NamedActual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_SMMUL Actual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_SMMUL_instance_;
  const NamedActual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_SMUAD Actual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_SMUAD_instance_;
  const NamedActual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_SMUSD Actual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_SMUSD_instance_;
  const NamedActual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_UDIV Actual_SDIV_cccc01110001dddd1111mmmm0001nnnn_case_1_UDIV_instance_;
  const NamedActual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_SMLAD Actual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_SMLAD_instance_;
  const NamedActual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_SMLSD Actual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_SMLSD_instance_;
  const NamedActual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_SMMLA Actual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_SMMLA_instance_;
  const NamedActual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_SMMLS Actual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_SMMLS_instance_;
  const NamedActual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_USADA8 Actual_SMLAD_cccc01110000ddddaaaammmm00m1nnnn_case_1_USADA8_instance_;
  const NamedActual_SMLALBB_SMLALBT_SMLALTB_SMLALTT_cccc00010100hhhhllllmmmm1xx0nnnn_case_1_SMLALBB_SMLALBT_SMLALTB_SMLALTT Actual_SMLALBB_SMLALBT_SMLALTB_SMLALTT_cccc00010100hhhhllllmmmm1xx0nnnn_case_1_SMLALBB_SMLALBT_SMLALTB_SMLALTT_instance_;
  const NamedActual_SMLALBB_SMLALBT_SMLALTB_SMLALTT_cccc00010100hhhhllllmmmm1xx0nnnn_case_1_UMAAL_A1 Actual_SMLALBB_SMLALBT_SMLALTB_SMLALTT_cccc00010100hhhhllllmmmm1xx0nnnn_case_1_UMAAL_A1_instance_;
  const NamedActual_SMLALD_cccc01110100hhhhllllmmmm00m1nnnn_case_1_SMLALD Actual_SMLALD_cccc01110100hhhhllllmmmm00m1nnnn_case_1_SMLALD_instance_;
  const NamedActual_SMLALD_cccc01110100hhhhllllmmmm00m1nnnn_case_1_SMLSLD Actual_SMLALD_cccc01110100hhhhllllmmmm00m1nnnn_case_1_SMLSLD_instance_;
  const NamedActual_SMLAL_A1_cccc0000111shhhhllllmmmm1001nnnn_case_1_SMLAL_A1 Actual_SMLAL_A1_cccc0000111shhhhllllmmmm1001nnnn_case_1_SMLAL_A1_instance_;
  const NamedActual_SMLAL_A1_cccc0000111shhhhllllmmmm1001nnnn_case_1_UMLAL_A1 Actual_SMLAL_A1_cccc0000111shhhhllllmmmm1001nnnn_case_1_UMLAL_A1_instance_;
  const NamedActual_SMULBB_SMULBT_SMULTB_SMULTT_cccc00010110dddd0000mmmm1xx0nnnn_case_1_SMULBB_SMULBT_SMULTB_SMULTT Actual_SMULBB_SMULBT_SMULTB_SMULTT_cccc00010110dddd0000mmmm1xx0nnnn_case_1_SMULBB_SMULBT_SMULTB_SMULTT_instance_;
  const NamedActual_SMULBB_SMULBT_SMULTB_SMULTT_cccc00010110dddd0000mmmm1xx0nnnn_case_1_SMULWB_SMULWT Actual_SMULBB_SMULBT_SMULTB_SMULTT_cccc00010110dddd0000mmmm1xx0nnnn_case_1_SMULWB_SMULWT_instance_;
  const NamedActual_SMULBB_SMULBT_SMULTB_SMULTT_cccc00010110dddd0000mmmm1xx0nnnn_case_1_USAD8 Actual_SMULBB_SMULBT_SMULTB_SMULTT_cccc00010110dddd0000mmmm1xx0nnnn_case_1_USAD8_instance_;
  const NamedActual_SMULL_A1_cccc0000110shhhhllllmmmm1001nnnn_case_1_SMULL_A1 Actual_SMULL_A1_cccc0000110shhhhllllmmmm1001nnnn_case_1_SMULL_A1_instance_;
  const NamedActual_SMULL_A1_cccc0000110shhhhllllmmmm1001nnnn_case_1_UMULL_A1 Actual_SMULL_A1_cccc0000110shhhhllllmmmm1001nnnn_case_1_UMULL_A1_instance_;
  const NamedActual_STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_1_STMDA_STMED Actual_STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_1_STMDA_STMED_instance_;
  const NamedActual_STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_1_STMDB_STMFD Actual_STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_1_STMDB_STMFD_instance_;
  const NamedActual_STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_1_STMIB_STMFA Actual_STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_1_STMIB_STMFA_instance_;
  const NamedActual_STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_1_STM_STMIA_STMEA Actual_STMDA_STMED_cccc100000w0nnnnrrrrrrrrrrrrrrrr_case_1_STM_STMIA_STMEA_instance_;
  const NamedActual_STRB_immediate_cccc010pu1w0nnnnttttiiiiiiiiiiii_case_1_STRB_immediate Actual_STRB_immediate_cccc010pu1w0nnnnttttiiiiiiiiiiii_case_1_STRB_immediate_instance_;
  const NamedActual_STRB_register_cccc011pu1w0nnnnttttiiiiitt0mmmm_case_1_STRB_register Actual_STRB_register_cccc011pu1w0nnnnttttiiiiitt0mmmm_case_1_STRB_register_instance_;
  const NamedActual_STRD_immediate_cccc000pu1w0nnnnttttiiii1111iiii_case_1_STRD_immediate Actual_STRD_immediate_cccc000pu1w0nnnnttttiiii1111iiii_case_1_STRD_immediate_instance_;
  const NamedActual_STRD_register_cccc000pu0w0nnnntttt00001111mmmm_case_1_STRD_register Actual_STRD_register_cccc000pu0w0nnnntttt00001111mmmm_case_1_STRD_register_instance_;
  const NamedActual_STREXB_cccc00011100nnnndddd11111001tttt_case_1_STREX Actual_STREXB_cccc00011100nnnndddd11111001tttt_case_1_STREX_instance_;
  const NamedActual_STREXB_cccc00011100nnnndddd11111001tttt_case_1_STREXB Actual_STREXB_cccc00011100nnnndddd11111001tttt_case_1_STREXB_instance_;
  const NamedActual_STREXB_cccc00011100nnnndddd11111001tttt_case_1_STREXH Actual_STREXB_cccc00011100nnnndddd11111001tttt_case_1_STREXH_instance_;
  const NamedActual_STREXD_cccc00011010nnnndddd11111001tttt_case_1_STREXD Actual_STREXD_cccc00011010nnnndddd11111001tttt_case_1_STREXD_instance_;
  const NamedActual_STRH_immediate_cccc000pu1w0nnnnttttiiii1011iiii_case_1_STRH_immediate Actual_STRH_immediate_cccc000pu1w0nnnnttttiiii1011iiii_case_1_STRH_immediate_instance_;
  const NamedActual_STRH_register_cccc000pu0w0nnnntttt00001011mmmm_case_1_STRH_register Actual_STRH_register_cccc000pu0w0nnnntttt00001011mmmm_case_1_STRH_register_instance_;
  const NamedActual_STR_immediate_cccc010pu0w0nnnnttttiiiiiiiiiiii_case_1_STR_immediate Actual_STR_immediate_cccc010pu0w0nnnnttttiiiiiiiiiiii_case_1_STR_immediate_instance_;
  const NamedActual_STR_register_cccc011pd0w0nnnnttttiiiiitt0mmmm_case_1_STR_register Actual_STR_register_cccc011pd0w0nnnnttttiiiiitt0mmmm_case_1_STR_register_instance_;
  const NamedActual_SWP_SWPB_cccc00010b00nnnntttt00001001tttt_case_1_SWP_SWPB Actual_SWP_SWPB_cccc00010b00nnnntttt00001001tttt_case_1_SWP_SWPB_instance_;
  const NamedActual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_SXTAB Actual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_SXTAB_instance_;
  const NamedActual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_SXTAB16 Actual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_SXTAB16_instance_;
  const NamedActual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_SXTAH Actual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_SXTAH_instance_;
  const NamedActual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_UXTAB Actual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_UXTAB_instance_;
  const NamedActual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_UXTAB16 Actual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_UXTAB16_instance_;
  const NamedActual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_UXTAH Actual_SXTAB16_cccc01101000nnnnddddrr000111mmmm_case_1_UXTAH_instance_;
  const NamedActual_TST_immediate_cccc00110001nnnn0000iiiiiiiiiiii_case_1_TST_immediate Actual_TST_immediate_cccc00110001nnnn0000iiiiiiiiiiii_case_1_TST_immediate_instance_;
  const NamedActual_UDF_cccc01111111iiiiiiiiiiii1111iiii_case_1_UDF Actual_UDF_cccc01111111iiiiiiiiiiii1111iiii_case_1_UDF_instance_;
  const NamedActual_Unnamed_11110100xx11xxxxxxxxxxxxxxxxxxxx_case_1_None Actual_Unnamed_11110100xx11xxxxxxxxxxxxxxxxxxxx_case_1_None_instance_;
  const NamedActual_Unnamed_case_1_None Actual_Unnamed_case_1_None_instance_;
  const NamedActual_VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_1_VABAL_A2 Actual_VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_1_VABAL_A2_instance_;
  const NamedActual_VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_1_VABDL_integer_A2 Actual_VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_1_VABDL_integer_A2_instance_;
  const NamedActual_VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_1_VMLAL_VMLSL_integer_A2 Actual_VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_1_VMLAL_VMLSL_integer_A2_instance_;
  const NamedActual_VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_1_VMULL_integer_A2 Actual_VABAL_A2_1111001u1dssnnnndddd0101n0m0mmmm_case_1_VMULL_integer_A2_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VABA Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VABA_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VABD Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VABD_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VCEQ_register_A1 Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VCEQ_register_A1_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VCGE_register_A1 Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VCGE_register_A1_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VCGT_register_A1 Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VCGT_register_A1_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VHADD Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VHADD_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VHSUB Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VHSUB_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMAX Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMAX_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMIN Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMIN_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMLA_integer_A1 Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMLA_integer_A1_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMLS_integer_A1 Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMLS_integer_A1_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMUL_integer_A1 Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VMUL_integer_A1_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VRHADD Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VRHADD_instance_;
  const NamedActual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VTST Actual_VABA_1111001u0dssnnnndddd0111nqm1mmmm_case_1_VTST_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VABD_floating_point Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VABD_floating_point_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VACGE Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VACGE_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VACGT Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VACGT_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VADD_floating_point_A1 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VADD_floating_point_A1_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VCEQ_register_A2 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VCEQ_register_A2_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VCGE_register_A2 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VCGE_register_A2_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VCGT_register_A2 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VCGT_register_A2_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VFMA_A1 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VFMA_A1_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VFMS_A1 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VFMS_A1_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMAX_floating_point Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMAX_floating_point_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMIN_floating_point Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMIN_floating_point_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMLA_floating_point_A1 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMLA_floating_point_A1_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMLS_floating_point_A1 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMLS_floating_point_A1_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMUL_floating_point_A1 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VMUL_floating_point_A1_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VRECPS Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VRECPS_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VRSQRTS Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VRSQRTS_instance_;
  const NamedActual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VSUB_floating_point_A1 Actual_VABD_floating_point_111100110d1snnnndddd1101nqm0mmmm_case_1_VSUB_floating_point_A1_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VABS_A1 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VABS_A1_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCEQ_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCEQ_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCGE_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCGE_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCGT_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCGT_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCLE_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCLE_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCLS Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCLS_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCLT_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCLT_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCLZ Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VCLZ_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VNEG Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VNEG_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VPADAL Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VPADAL_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VPADDL Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VPADDL_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VQABS Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VQABS_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VQNEG Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_1_VQNEG_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VABS_A1 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VABS_A1_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCEQ_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCEQ_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCGE_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCGE_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCGT_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCGT_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCLE_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCLE_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCLT_immediate_0 Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCLT_immediate_0_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCVT Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VCVT_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VNEG Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VNEG_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VRECPE Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VRECPE_instance_;
  const NamedActual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VRSQRTE Actual_VABS_A1_111100111d11ss01dddd0f110qm0mmmm_case_2_VRSQRTE_instance_;
  const NamedActual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VABS Actual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VABS_instance_;
  const NamedActual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VCMP_VCMPE Actual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VCMP_VCMPE_instance_;
  const NamedActual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VCVTB_VCVTT Actual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VCVTB_VCVTT_instance_;
  const NamedActual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VCVT_between_double_precision_and_single_precision Actual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VCVT_between_double_precision_and_single_precision_instance_;
  const NamedActual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VMOV_immediate Actual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VMOV_immediate_instance_;
  const NamedActual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VMOV_register Actual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VMOV_register_instance_;
  const NamedActual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VNEG Actual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VNEG_instance_;
  const NamedActual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VSQRT Actual_VABS_cccc11101d110000dddd101s11m0mmmm_case_1_VSQRT_instance_;
  const NamedActual_VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_1_VADDHN Actual_VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_1_VADDHN_instance_;
  const NamedActual_VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_1_VRADDHN Actual_VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_1_VRADDHN_instance_;
  const NamedActual_VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_1_VRSUBHN Actual_VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_1_VRSUBHN_instance_;
  const NamedActual_VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_1_VSUBHN Actual_VADDHN_111100101dssnnnndddd0100n0m0mmmm_case_1_VSUBHN_instance_;
  const NamedActual_VADDL_VADDW_1111001u1dssnnnndddd000pn0m0mmmm_case_1_VADDL_VADDW Actual_VADDL_VADDW_1111001u1dssnnnndddd000pn0m0mmmm_case_1_VADDL_VADDW_instance_;
  const NamedActual_VADDL_VADDW_1111001u1dssnnnndddd000pn0m0mmmm_case_1_VSUBL_VSUBW Actual_VADDL_VADDW_1111001u1dssnnnndddd000pn0m0mmmm_case_1_VSUBL_VSUBW_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VADD_floating_point Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VADD_floating_point_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VDIV Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VDIV_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VFMA_VFMS Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VFMA_VFMS_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VFNMA_VFNMS Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VFNMA_VFNMS_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VMLA_VMLS_floating_point Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VMLA_VMLS_floating_point_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VMUL_floating_point Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VMUL_floating_point_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VNMLA_VNMLS Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VNMLA_VNMLS_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VNMUL Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VNMUL_instance_;
  const NamedActual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VSUB_floating_point Actual_VADD_floating_point_cccc11100d11nnnndddd101sn0m0mmmm_case_1_VSUB_floating_point_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VADD_integer Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VADD_integer_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VAND_register Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VAND_register_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VBIC_register Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VBIC_register_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VBIF Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VBIF_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VBIT Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VBIT_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VBSL Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VBSL_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VEOR Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VEOR_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VORN_register Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VORN_register_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VORR_register_or_VMOV_register_A1 Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VORR_register_or_VMOV_register_A1_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VQADD Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VQADD_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VQRSHL Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VQRSHL_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VQSHL_register Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VQSHL_register_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VQSUB Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VQSUB_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VRSHL Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VRSHL_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VSHL_register Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VSHL_register_instance_;
  const NamedActual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VSUB_integer Actual_VADD_integer_111100100dssnnnndddd1000nqm0mmmm_case_1_VSUB_integer_instance_;
  const NamedActual_VBIC_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_1_VBIC_immediate Actual_VBIC_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_1_VBIC_immediate_instance_;
  const NamedActual_VBIC_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_1_VORR_immediate Actual_VBIC_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_1_VORR_immediate_instance_;
  const NamedActual_VCNT_111100111d11ss00dddd01010qm0mmmm_case_1_VCNT Actual_VCNT_111100111d11ss00dddd01010qm0mmmm_case_1_VCNT_instance_;
  const NamedActual_VCNT_111100111d11ss00dddd01010qm0mmmm_case_1_VMVN_register Actual_VCNT_111100111d11ss00dddd01010qm0mmmm_case_1_VMVN_register_instance_;
  const NamedActual_VCVT_VCVTR_between_floating_point_and_integer_Floating_point_cccc11101d111ooodddd101sp1m0mmmm_case_1_VCVT_VCVTR_between_floating_point_and_integer_Floating_point Actual_VCVT_VCVTR_between_floating_point_and_integer_Floating_point_cccc11101d111ooodddd101sp1m0mmmm_case_1_VCVT_VCVTR_between_floating_point_and_integer_Floating_point_instance_;
  const NamedActual_VCVT_between_floating_point_and_fixed_point_1111001u1diiiiiidddd111p0qm1mmmm_case_1_VCVT_between_floating_point_and_fixed_point Actual_VCVT_between_floating_point_and_fixed_point_1111001u1diiiiiidddd111p0qm1mmmm_case_1_VCVT_between_floating_point_and_fixed_point_instance_;
  const NamedActual_VCVT_between_floating_point_and_fixed_point_Floating_point_cccc11101d111o1udddd101fx1i0iiii_case_1_VCVT_between_floating_point_and_fixed_point_Floating_point Actual_VCVT_between_floating_point_and_fixed_point_Floating_point_cccc11101d111o1udddd101fx1i0iiii_case_1_VCVT_between_floating_point_and_fixed_point_Floating_point_instance_;
  const NamedActual_VDUP_ARM_core_register_cccc11101bq0ddddtttt1011d0e10000_case_1_VDUP_ARM_core_register Actual_VDUP_ARM_core_register_cccc11101bq0ddddtttt1011d0e10000_case_1_VDUP_ARM_core_register_instance_;
  const NamedActual_VDUP_scalar_111100111d11iiiidddd11000qm0mmmm_case_1_VDUP_scalar Actual_VDUP_scalar_111100111d11iiiidddd11000qm0mmmm_case_1_VDUP_scalar_instance_;
  const NamedActual_VEXT_111100101d11nnnnddddiiiinqm0mmmm_case_1_VEXT Actual_VEXT_111100101d11nnnnddddiiiinqm0mmmm_case_1_VEXT_instance_;
  const NamedActual_VLD1_multiple_single_elements_111101000d10nnnnddddttttssaammmm_case_1_VLD1_multiple_single_elements Actual_VLD1_multiple_single_elements_111101000d10nnnnddddttttssaammmm_case_1_VLD1_multiple_single_elements_instance_;
  const NamedActual_VLD1_multiple_single_elements_111101000d10nnnnddddttttssaammmm_case_1_VST1_multiple_single_elements Actual_VLD1_multiple_single_elements_111101000d10nnnnddddttttssaammmm_case_1_VST1_multiple_single_elements_instance_;
  const NamedActual_VLD1_single_element_to_all_lanes_111101001d10nnnndddd1100sstammmm_case_1_VLD1_single_element_to_all_lanes Actual_VLD1_single_element_to_all_lanes_111101001d10nnnndddd1100sstammmm_case_1_VLD1_single_element_to_all_lanes_instance_;
  const NamedActual_VLD1_single_element_to_one_lane_111101001d10nnnnddddss00aaaammmm_case_1_VLD1_single_element_to_one_lane Actual_VLD1_single_element_to_one_lane_111101001d10nnnnddddss00aaaammmm_case_1_VLD1_single_element_to_one_lane_instance_;
  const NamedActual_VLD1_single_element_to_one_lane_111101001d10nnnnddddss00aaaammmm_case_1_VST1_single_element_from_one_lane Actual_VLD1_single_element_to_one_lane_111101001d10nnnnddddss00aaaammmm_case_1_VST1_single_element_from_one_lane_instance_;
  const NamedActual_VLD2_multiple_2_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VLD2_multiple_2_element_structures Actual_VLD2_multiple_2_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VLD2_multiple_2_element_structures_instance_;
  const NamedActual_VLD2_multiple_2_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VST2_multiple_2_element_structures Actual_VLD2_multiple_2_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VST2_multiple_2_element_structures_instance_;
  const NamedActual_VLD2_single_2_element_structure_to_all_lanes_111101001d10nnnndddd1101sstammmm_case_1_VLD2_single_2_element_structure_to_all_lanes Actual_VLD2_single_2_element_structure_to_all_lanes_111101001d10nnnndddd1101sstammmm_case_1_VLD2_single_2_element_structure_to_all_lanes_instance_;
  const NamedActual_VLD2_single_2_element_structure_to_one_lane_111101001d10nnnnddddss01aaaammmm_case_1_VLD2_single_2_element_structure_to_one_lane Actual_VLD2_single_2_element_structure_to_one_lane_111101001d10nnnnddddss01aaaammmm_case_1_VLD2_single_2_element_structure_to_one_lane_instance_;
  const NamedActual_VLD2_single_2_element_structure_to_one_lane_111101001d10nnnnddddss01aaaammmm_case_1_VST2_single_2_element_structure_from_one_lane Actual_VLD2_single_2_element_structure_to_one_lane_111101001d10nnnnddddss01aaaammmm_case_1_VST2_single_2_element_structure_from_one_lane_instance_;
  const NamedActual_VLD3_multiple_3_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VLD3_multiple_3_element_structures Actual_VLD3_multiple_3_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VLD3_multiple_3_element_structures_instance_;
  const NamedActual_VLD3_multiple_3_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VST3_multiple_3_element_structures Actual_VLD3_multiple_3_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VST3_multiple_3_element_structures_instance_;
  const NamedActual_VLD3_single_3_element_structure_to_all_lanes_111101001d10nnnndddd1110sstammmm_case_1_VLD3_single_3_element_structure_to_all_lanes Actual_VLD3_single_3_element_structure_to_all_lanes_111101001d10nnnndddd1110sstammmm_case_1_VLD3_single_3_element_structure_to_all_lanes_instance_;
  const NamedActual_VLD3_single_3_element_structure_to_one_lane_111101001d10nnnnddddss10aaaammmm_case_1_VLD3_single_3_element_structure_to_one_lane Actual_VLD3_single_3_element_structure_to_one_lane_111101001d10nnnnddddss10aaaammmm_case_1_VLD3_single_3_element_structure_to_one_lane_instance_;
  const NamedActual_VLD3_single_3_element_structure_to_one_lane_111101001d10nnnnddddss10aaaammmm_case_1_VST3_single_3_element_structure_from_one_lane Actual_VLD3_single_3_element_structure_to_one_lane_111101001d10nnnnddddss10aaaammmm_case_1_VST3_single_3_element_structure_from_one_lane_instance_;
  const NamedActual_VLD4_multiple_4_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VLD4_multiple_4_element_structures Actual_VLD4_multiple_4_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VLD4_multiple_4_element_structures_instance_;
  const NamedActual_VLD4_multiple_4_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VST4_multiple_4_element_structures Actual_VLD4_multiple_4_element_structures_111101000d10nnnnddddttttssaammmm_case_1_VST4_multiple_4_element_structures_instance_;
  const NamedActual_VLD4_single_4_element_structure_to_all_lanes_111101001d10nnnndddd1111sstammmm_case_1_VLD4_single_4_element_structure_to_all_lanes Actual_VLD4_single_4_element_structure_to_all_lanes_111101001d10nnnndddd1111sstammmm_case_1_VLD4_single_4_element_structure_to_all_lanes_instance_;
  const NamedActual_VLD4_single_4_element_structure_to_one_lane_111101001d10nnnnddddss11aaaammmm_case_1_VLD4_single_4_element_structure_to_one_lane Actual_VLD4_single_4_element_structure_to_one_lane_111101001d10nnnnddddss11aaaammmm_case_1_VLD4_single_4_element_structure_to_one_lane_instance_;
  const NamedActual_VLD4_single_4_element_structure_to_one_lane_111101001d10nnnnddddss11aaaammmm_case_1_VST4_single_4_element_structure_form_one_lane Actual_VLD4_single_4_element_structure_to_one_lane_111101001d10nnnnddddss11aaaammmm_case_1_VST4_single_4_element_structure_form_one_lane_instance_;
  const NamedActual_VLDM_cccc110pudw1nnnndddd1010iiiiiiii_case_1_VLDM Actual_VLDM_cccc110pudw1nnnndddd1010iiiiiiii_case_1_VLDM_instance_;
  const NamedActual_VLDM_cccc110pudw1nnnndddd1011iiiiiiii_case_1_VLDM Actual_VLDM_cccc110pudw1nnnndddd1011iiiiiiii_case_1_VLDM_instance_;
  const NamedActual_VLDR_cccc1101ud01nnnndddd1010iiiiiiii_case_1_VLDR Actual_VLDR_cccc1101ud01nnnndddd1010iiiiiiii_case_1_VLDR_instance_;
  const NamedActual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VMLAL_by_scalar_A2 Actual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VMLAL_by_scalar_A2_instance_;
  const NamedActual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VMLSL_by_scalar_A2 Actual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VMLSL_by_scalar_A2_instance_;
  const NamedActual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VMULL_by_scalar_A2 Actual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VMULL_by_scalar_A2_instance_;
  const NamedActual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VQDMLAL_A1 Actual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VQDMLAL_A1_instance_;
  const NamedActual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VQDMLSL_A1 Actual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VQDMLSL_A1_instance_;
  const NamedActual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VQDMULL_A2 Actual_VMLAL_by_scalar_A2_1111001u1dssnnnndddd0p10n1m0mmmm_case_1_VQDMULL_A2_instance_;
  const NamedActual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMLA_by_scalar_A1 Actual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMLA_by_scalar_A1_instance_;
  const NamedActual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMLS_by_scalar_A1 Actual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMLS_by_scalar_A1_instance_;
  const NamedActual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMUL_by_scalar_A1 Actual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_1_VMUL_by_scalar_A1_instance_;
  const NamedActual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VMLA_by_scalar_A1 Actual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VMLA_by_scalar_A1_instance_;
  const NamedActual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VMLS_by_scalar_A1 Actual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VMLS_by_scalar_A1_instance_;
  const NamedActual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VMUL_by_scalar_A1 Actual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VMUL_by_scalar_A1_instance_;
  const NamedActual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VQDMULH_A2 Actual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VQDMULH_A2_instance_;
  const NamedActual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VQRDMULH Actual_VMLA_by_scalar_A1_1111001q1dssnnnndddd0p0fn1m0mmmm_case_2_VQRDMULH_instance_;
  const NamedActual_VMOVN_111100111d11ss10dddd001000m0mmmm_case_1_VMOVN Actual_VMOVN_111100111d11ss10dddd001000m0mmmm_case_1_VMOVN_instance_;
  const NamedActual_VMOV_ARM_core_register_to_scalar_cccc11100ii0ddddtttt1011dii10000_case_1_VMOV_ARM_core_register_to_scalar Actual_VMOV_ARM_core_register_to_scalar_cccc11100ii0ddddtttt1011dii10000_case_1_VMOV_ARM_core_register_to_scalar_instance_;
  const NamedActual_VMOV_between_ARM_core_register_and_single_precision_register_cccc1110000onnnntttt1010n0010000_case_1_VMOV_between_ARM_core_register_and_single_precision_register Actual_VMOV_between_ARM_core_register_and_single_precision_register_cccc1110000onnnntttt1010n0010000_case_1_VMOV_between_ARM_core_register_and_single_precision_register_instance_;
  const NamedActual_VMOV_between_two_ARM_core_registers_and_a_doubleword_extension_register_cccc1100010otttttttt101100m1mmmm_case_1_VMOV_between_two_ARM_core_registers_and_a_doubleword_extension_register Actual_VMOV_between_two_ARM_core_registers_and_a_doubleword_extension_register_cccc1100010otttttttt101100m1mmmm_case_1_VMOV_between_two_ARM_core_registers_and_a_doubleword_extension_register_instance_;
  const NamedActual_VMOV_between_two_ARM_core_registers_and_two_single_precision_registers_cccc1100010otttttttt101000m1mmmm_case_1_VMOV_between_two_ARM_core_registers_and_two_single_precision_registers Actual_VMOV_between_two_ARM_core_registers_and_two_single_precision_registers_cccc1100010otttttttt101000m1mmmm_case_1_VMOV_between_two_ARM_core_registers_and_two_single_precision_registers_instance_;
  const NamedActual_VMOV_immediate_A1_1111001m1d000mmmddddcccc0qp1mmmm_case_1_VMOV_immediate_A1 Actual_VMOV_immediate_A1_1111001m1d000mmmddddcccc0qp1mmmm_case_1_VMOV_immediate_A1_instance_;
  const NamedActual_VMRS_cccc111011110001tttt101000010000_case_1_VMRS Actual_VMRS_cccc111011110001tttt101000010000_case_1_VMRS_instance_;
  const NamedActual_VMSR_cccc111011100001tttt101000010000_case_1_VMSR Actual_VMSR_cccc111011100001tttt101000010000_case_1_VMSR_instance_;
  const NamedActual_VMULL_polynomial_A2_1111001u1dssnnnndddd11p0n0m0mmmm_case_1_VMULL_polynomial_A2 Actual_VMULL_polynomial_A2_1111001u1dssnnnndddd11p0n0m0mmmm_case_1_VMULL_polynomial_A2_instance_;
  const NamedActual_VMUL_polynomial_A1_1111001u0dssnnnndddd1001nqm1mmmm_case_1_VMUL_polynomial_A1 Actual_VMUL_polynomial_A1_1111001u0dssnnnndddd1001nqm1mmmm_case_1_VMUL_polynomial_A1_instance_;
  const NamedActual_VMVN_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_1_VMVN_immediate Actual_VMVN_immediate_1111001i1d000mmmddddcccc0q11mmmm_case_1_VMVN_immediate_instance_;
  const NamedActual_VPADD_floating_point_111100110d0snnnndddd1101nqm0mmmm_case_1_VPADD_floating_point Actual_VPADD_floating_point_111100110d0snnnndddd1101nqm0mmmm_case_1_VPADD_floating_point_instance_;
  const NamedActual_VPADD_floating_point_111100110d0snnnndddd1101nqm0mmmm_case_1_VPMAX Actual_VPADD_floating_point_111100110d0snnnndddd1101nqm0mmmm_case_1_VPMAX_instance_;
  const NamedActual_VPADD_floating_point_111100110d0snnnndddd1101nqm0mmmm_case_1_VPMIN Actual_VPADD_floating_point_111100110d0snnnndddd1101nqm0mmmm_case_1_VPMIN_instance_;
  const NamedActual_VPADD_integer_111100100dssnnnndddd1011n0m1mmmm_case_1_VPADD_integer Actual_VPADD_integer_111100100dssnnnndddd1011n0m1mmmm_case_1_VPADD_integer_instance_;
  const NamedActual_VPADD_integer_111100100dssnnnndddd1011n0m1mmmm_case_1_VPMAX Actual_VPADD_integer_111100100dssnnnndddd1011n0m1mmmm_case_1_VPMAX_instance_;
  const NamedActual_VPADD_integer_111100100dssnnnndddd1011n0m1mmmm_case_1_VPMIN Actual_VPADD_integer_111100100dssnnnndddd1011n0m1mmmm_case_1_VPMIN_instance_;
  const NamedActual_VPOP_cccc11001d111101dddd1010iiiiiiii_case_1_VPOP Actual_VPOP_cccc11001d111101dddd1010iiiiiiii_case_1_VPOP_instance_;
  const NamedActual_VPOP_cccc11001d111101dddd1010iiiiiiii_case_1_VPUSH Actual_VPOP_cccc11001d111101dddd1010iiiiiiii_case_1_VPUSH_instance_;
  const NamedActual_VPOP_cccc11001d111101dddd1011iiiiiiii_case_1_VPOP Actual_VPOP_cccc11001d111101dddd1011iiiiiiii_case_1_VPOP_instance_;
  const NamedActual_VPOP_cccc11001d111101dddd1011iiiiiiii_case_1_VPUSH Actual_VPOP_cccc11001d111101dddd1011iiiiiiii_case_1_VPUSH_instance_;
  const NamedActual_VQDMLAL_VQDMLSL_A1_111100101dssnnnndddd10p1n0m0mmmm_case_1_VQDMLAL_VQDMLSL_A1 Actual_VQDMLAL_VQDMLSL_A1_111100101dssnnnndddd10p1n0m0mmmm_case_1_VQDMLAL_VQDMLSL_A1_instance_;
  const NamedActual_VQDMLAL_VQDMLSL_A1_111100101dssnnnndddd10p1n0m0mmmm_case_1_VQDMULL_A1 Actual_VQDMLAL_VQDMLSL_A1_111100101dssnnnndddd10p1n0m0mmmm_case_1_VQDMULL_A1_instance_;
  const NamedActual_VQDMULH_A1_111100100dssnnnndddd1011nqm0mmmm_case_1_VQDMULH_A1 Actual_VQDMULH_A1_111100100dssnnnndddd1011nqm0mmmm_case_1_VQDMULH_A1_instance_;
  const NamedActual_VQDMULH_A1_111100100dssnnnndddd1011nqm0mmmm_case_1_VQRDMULH_A1 Actual_VQDMULH_A1_111100100dssnnnndddd1011nqm0mmmm_case_1_VQRDMULH_A1_instance_;
  const NamedActual_VQMOVN_111100111d11ss10dddd0010ppm0mmmm_case_1_VQMOVN Actual_VQMOVN_111100111d11ss10dddd0010ppm0mmmm_case_1_VQMOVN_instance_;
  const NamedActual_VQMOVN_111100111d11ss10dddd0010ppm0mmmm_case_1_VQMOVUN Actual_VQMOVN_111100111d11ss10dddd0010ppm0mmmm_case_1_VQMOVUN_instance_;
  const NamedActual_VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_1_VQRSHRN Actual_VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_1_VQRSHRN_instance_;
  const NamedActual_VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_1_VQRSHRUN Actual_VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_1_VQRSHRUN_instance_;
  const NamedActual_VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_1_VQSHRN Actual_VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_1_VQSHRN_instance_;
  const NamedActual_VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_1_VQSHRUN Actual_VQRSHRN_1111001u1diiiiiidddd100p01m1mmmm_case_1_VQSHRUN_instance_;
  const NamedActual_VQSHL_VQSHLU_immediate_1111001u1diiiiiidddd011plqm1mmmm_case_1_VQSHL_VQSHLU_immediate Actual_VQSHL_VQSHLU_immediate_1111001u1diiiiiidddd011plqm1mmmm_case_1_VQSHL_VQSHLU_immediate_instance_;
  const NamedActual_VREV16_111100111d11ss00dddd000ppqm0mmmm_case_1_VREV16 Actual_VREV16_111100111d11ss00dddd000ppqm0mmmm_case_1_VREV16_instance_;
  const NamedActual_VREV16_111100111d11ss00dddd000ppqm0mmmm_case_1_VREV32 Actual_VREV16_111100111d11ss00dddd000ppqm0mmmm_case_1_VREV32_instance_;
  const NamedActual_VREV16_111100111d11ss00dddd000ppqm0mmmm_case_1_VREV64 Actual_VREV16_111100111d11ss00dddd000ppqm0mmmm_case_1_VREV64_instance_;
  const NamedActual_VRSHRN_111100101diiiiiidddd100001m1mmmm_case_1_VRSHRN Actual_VRSHRN_111100101diiiiiidddd100001m1mmmm_case_1_VRSHRN_instance_;
  const NamedActual_VRSHRN_111100101diiiiiidddd100001m1mmmm_case_1_VSHRN Actual_VRSHRN_111100101diiiiiidddd100001m1mmmm_case_1_VSHRN_instance_;
  const NamedActual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VRSHR Actual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VRSHR_instance_;
  const NamedActual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VRSRA Actual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VRSRA_instance_;
  const NamedActual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSHL_immediate Actual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSHL_immediate_instance_;
  const NamedActual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSHR Actual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSHR_instance_;
  const NamedActual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSLI Actual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSLI_instance_;
  const NamedActual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSRA Actual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSRA_instance_;
  const NamedActual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSRI Actual_VRSHR_1111001u1diiiiiidddd0010lqm1mmmm_case_1_VSRI_instance_;
  const NamedActual_VSHLL_A1_or_VMOVL_1111001u1diiiiiidddd101000m1mmmm_case_1_VSHLL_A1_or_VMOVL Actual_VSHLL_A1_or_VMOVL_1111001u1diiiiiidddd101000m1mmmm_case_1_VSHLL_A1_or_VMOVL_instance_;
  const NamedActual_VSHLL_A2_111100111d11ss10dddd001100m0mmmm_case_1_VSHLL_A2 Actual_VSHLL_A2_111100111d11ss10dddd001100m0mmmm_case_1_VSHLL_A2_instance_;
  const NamedActual_VSTM_cccc110pudw0nnnndddd1010iiiiiiii_case_1_VSTM Actual_VSTM_cccc110pudw0nnnndddd1010iiiiiiii_case_1_VSTM_instance_;
  const NamedActual_VSTM_cccc110pudw0nnnndddd1011iiiiiiii_case_1_VSTM Actual_VSTM_cccc110pudw0nnnndddd1011iiiiiiii_case_1_VSTM_instance_;
  const NamedActual_VSTR_cccc1101ud00nnnndddd1010iiiiiiii_case_1_VSTR Actual_VSTR_cccc1101ud00nnnndddd1010iiiiiiii_case_1_VSTR_instance_;
  const NamedActual_VSWP_111100111d11ss10dddd00000qm0mmmm_case_1_VSWP Actual_VSWP_111100111d11ss10dddd00000qm0mmmm_case_1_VSWP_instance_;
  const NamedActual_VTBL_VTBX_111100111d11nnnndddd10ccnpm0mmmm_case_1_VTBL_VTBX Actual_VTBL_VTBX_111100111d11nnnndddd10ccnpm0mmmm_case_1_VTBL_VTBX_instance_;
  const NamedActual_VTRN_111100111d11ss10dddd00001qm0mmmm_case_1_VTRN Actual_VTRN_111100111d11ss10dddd00001qm0mmmm_case_1_VTRN_instance_;
  const NamedActual_VUZP_111100111d11ss10dddd00010qm0mmmm_case_1_VUZP Actual_VUZP_111100111d11ss10dddd00010qm0mmmm_case_1_VUZP_instance_;
  const NamedActual_VUZP_111100111d11ss10dddd00010qm0mmmm_case_1_VZIP Actual_VUZP_111100111d11ss10dddd00010qm0mmmm_case_1_VZIP_instance_;
 private:

  // The following list of methods correspond to each decoder table,
  // and implements the pattern matching of the corresponding bit
  // patterns. After matching the corresponding bit patterns, they
  // either call other methods in this list (corresponding to another
  // decoder table), or they return the instance field that implements
  // the class decoder that should be used to decode the particular
  // instruction.
  inline const NamedClassDecoder& decode_ARMv7(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_advanced_simd_data_processing_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_advanced_simd_element_or_structure_load_store_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_branch_branch_with_link_and_block_data_transfer(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_coprocessor_instructions_and_supervisor_call(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_data_processing_and_miscellaneous_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_data_processing_immediate(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_data_processing_register(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_data_processing_register_shifted_register(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_extension_register_load_store_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_extra_load_store_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_floating_point_data_processing_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_halfword_multiply_and_multiply_accumulate(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_load_store_word_and_unsigned_byte(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_media_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_memory_hints_advanced_simd_instructions_and_miscellaneous_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_miscellaneous_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_msr_immediate_and_hints(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_multiply_and_multiply_accumulate(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_other_floating_point_data_processing_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_packing_unpacking_saturation_and_reversal(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_parallel_addition_and_subtraction_signed(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_parallel_addition_and_subtraction_unsigned(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_saturating_addition_and_subtraction(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_signed_multiply_signed_and_unsigned_divide(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_1imm(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_2misc(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_2scalar(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_2shift(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_3diff(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_3same(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_synchronization_primitives(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_transfer_between_arm_core_and_extension_register_8_16_and_32_bit(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_transfer_between_arm_core_and_extension_registers_64_bit(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_unconditional_instructions(
      const nacl_arm_dec::Instruction inst) const;
};

} // namespace nacl_arm_test
#endif  // NATIVE_CLIENT_SRC_TRUSTED_VALIDATOR_ARM_GEN_ARM32_DECODE_NAMED_DECODER_H_
