/*
integrit - file integrity verification system
Copyright (C) 2001 Ed Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include	<config.h>
#include	<stdlib.h>
#include	"cdb.h"
#include	"buffer.h"
#include	"cdb_make.h"
#include	"uint32.h"

int cdb_put(struct cdb_make *c,
	    unsigned char *key, size_t klen, void *val, size_t vlen)
{
    int			i;
    uint32		h;

    if (cdb_make_addbegin(c, klen, vlen) == -1)
      return -1;
    buffer_put(&c->b, key, klen);
    for (i = 0, h = CDB_HASHSTART; i < klen; ++i)
      h	 = cdb_hashadd(h, key[i]);
    buffer_put(&c->b, val, vlen);
    if (cdb_make_addend(c, klen, vlen, h) == -1)
      return -1;

    return 0;
}

