/*
 * NB:  This file is machine generated, DO NOT EDIT!
 *
 * Edit builtin.vcl instead and run make
 *
 */

 "/*-\n"
 " * Copyright (c) 2006 Verdens Gang AS\n"
 " * Copyright (c) 2006-2015 Varnish Software AS\n"
 " * All rights reserved.\n"
 " *\n"
 " * Author: Poul-Henning Kamp <phk@phk.freebsd.dk>\n"
 " *\n"
 " * Redistribution and use in source and binary forms, with or without\n"
 " * modification, are permitted provided that the following conditions\n"
 " * are met:\n"
 " * 1. Redistributions of source code must retain the above copyright\n"
 " *    notice, this list of conditions and the following disclaimer.\n"
 " * 2. Redistributions in binary form must reproduce the above copyright\n"
 " *    notice, this list of conditions and the following disclaimer in the\n"
 " *    documentation and/or other materials provided with the distribution.\n"
 " *\n"
 " * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND\n"
 " * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
 " * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
 " * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE\n"
 " * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
 " * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS\n"
 " * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
 " * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\n"
 " * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\n"
 " * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n"
 " * SUCH DAMAGE.\n"
 " *\n"
 "\n"
 " *\n"
 " * The built-in (previously called default) VCL code.\n"
 " *\n"
 " * NB! You do NOT need to copy & paste all of these functions into your\n"
 " * own vcl code, if you do not provide a definition of one of these\n"
 " * functions, the compiler will automatically fall back to the default\n"
 " * code from this file.\n"
 " *\n"
 " * This code will be prefixed with a backend declaration built from the\n"
 " * -b argument.\n"
 " */\n"
 "\n"
 "vcl 4.0;\n"
 "\n"
 "#######################################################################\n"
 "# Client side\n"
 "\n"
 "sub vcl_recv {\n"
 "    if (req.method == \"PRI\") {\n"
 "	/* We do not support SPDY or HTTP/2.0 */\n"
 "	return (synth(405));\n"
 "    }\n"
 "    if (req.method != \"GET\" &&\n"
 "      req.method != \"HEAD\" &&\n"
 "      req.method != \"PUT\" &&\n"
 "      req.method != \"POST\" &&\n"
 "      req.method != \"TRACE\" &&\n"
 "      req.method != \"OPTIONS\" &&\n"
 "      req.method != \"DELETE\" &&\n"
 "      req.method != \"PATCH\") {\n"
 "        /* Non-RFC2616 or CONNECT which is weird. */\n"
 "        return (pipe);\n"
 "    }\n"
 "\n"
 "    if (req.method != \"GET\" && req.method != \"HEAD\") {\n"
 "        /* We only deal with GET and HEAD by default */\n"
 "        return (pass);\n"
 "    }\n"
 "    if (req.http.Authorization || req.http.Cookie) {\n"
 "        /* Not cacheable by default */\n"
 "        return (pass);\n"
 "    }\n"
 "    return (hash);\n"
 "}\n"
 "\n"
 "sub vcl_pipe {\n"
 "    # By default Connection: close is set on all piped requests, to stop\n"
 "    # connection reuse from sending future requests directly to the\n"
 "    # (potentially) wrong backend. If you do want this to happen, you can undo\n"
 "    # it here.\n"
 "    # unset bereq.http.connection;\n"
 "    return (pipe);\n"
 "}\n"
 "\n"
 "sub vcl_pass {\n"
 "    return (fetch);\n"
 "}\n"
 "\n"
 "sub vcl_hash {\n"
 "    hash_data(req.url);\n"
 "    if (req.http.host) {\n"
 "        hash_data(req.http.host);\n"
 "    } else {\n"
 "        hash_data(server.ip);\n"
 "    }\n"
 "    return (lookup);\n"
 "}\n"
 "\n"
 "sub vcl_purge {\n"
 "    return (synth(200, \"Purged\"));\n"
 "}\n"
 "\n"
 "sub vcl_hit {\n"
 "    if (obj.ttl >= 0s) {\n"
 "        // A pure unadultered hit, deliver it\n"
 "        return (deliver);\n"
 "    }\n"
 "    if (obj.ttl + obj.grace > 0s) {\n"
 "        // Object is in grace, deliver it\n"
 "        // Automatically triggers a background fetch\n"
 "        return (deliver);\n"
 "    }\n"
 "    // fetch & deliver once we get the result\n"
 "    return (miss);\n"
 "}\n"
 "\n"
 "sub vcl_miss {\n"
 "    return (fetch);\n"
 "}\n"
 "\n"
 "sub vcl_deliver {\n"
 "    return (deliver);\n"
 "}\n"
 "\n"
 "/*\n"
 " * We can come here \"invisibly\" with the following errors: 500 & 503\n"
 " */\n"
 "sub vcl_synth {\n"
 "    set resp.http.Content-Type = \"text/html; charset=utf-8\";\n"
 "    set resp.http.Retry-After = \"5\";\n"
 "    set resp.body = {\"<!DOCTYPE html>\n"
 "<html>\n"
 "  <head>\n"
 "    <title>\"} + resp.status + \" \" + resp.reason + {\"</title>\n"
 "  </head>\n"
 "  <body>\n"
 "    <h1>Error \"} + resp.status + \" \" + resp.reason + {\"</h1>\n"
 "    <p>\"} + resp.reason + {\"</p>\n"
 "    <h3>Guru Meditation:</h3>\n"
 "    <p>XID: \"} + req.xid + {\"</p>\n"
 "    <hr>\n"
 "    <p>Varnish cache server</p>\n"
 "  </body>\n"
 "</html>\n"
 "\"};\n"
 "    return (deliver);\n"
 "}\n"
 "\n"
 "#######################################################################\n"
 "# Backend Fetch\n"
 "\n"
 "sub vcl_backend_fetch {\n"
 "    if (bereq.method == \"GET\") {\n"
 "        unset bereq.body;\n"
 "    }\n"
 "    return (fetch);\n"
 "}\n"
 "\n"
 "sub vcl_backend_response {\n"
 "    if (bereq.uncacheable) {\n"
 "        return (deliver);\n"
 "    } else if (beresp.ttl <= 0s ||\n"
 "      beresp.http.Set-Cookie ||\n"
 "      beresp.http.Surrogate-control ~ \"no-store\" ||\n"
 "      (!beresp.http.Surrogate-Control &&\n"
 "        beresp.http.Cache-Control ~ \"no-cache|no-store|private\") ||\n"
 "      beresp.http.Vary == \"*\") {\n"
 "        # Mark as \"Hit-For-Pass\" for the next 2 minutes\n"
 "        set beresp.ttl = 120s;\n"
 "        set beresp.uncacheable = true;\n"
 "    }\n"
 "    return (deliver);\n"
 "}\n"
 "\n"
 "sub vcl_backend_error {\n"
 "    set beresp.http.Content-Type = \"text/html; charset=utf-8\";\n"
 "    set beresp.http.Retry-After = \"5\";\n"
 "    set beresp.body = {\"<!DOCTYPE html>\n"
 "<html>\n"
 "  <head>\n"
 "    <title>\"} + beresp.status + \" \" + beresp.reason + {\"</title>\n"
 "  </head>\n"
 "  <body>\n"
 "    <h1>Error \"} + beresp.status + \" \" + beresp.reason + {\"</h1>\n"
 "    <p>\"} + beresp.reason + {\"</p>\n"
 "    <h3>Guru Meditation:</h3>\n"
 "    <p>XID: \"} + bereq.xid + {\"</p>\n"
 "    <hr>\n"
 "    <p>Varnish cache server</p>\n"
 "  </body>\n"
 "</html>\n"
 "\"};\n"
 "    return (deliver);\n"
 "}\n"
 "\n"
 "#######################################################################\n"
 "# Housekeeping\n"
 "\n"
 "sub vcl_init {\n"
 "}\n"
 "\n"
 "sub vcl_fini {\n"
 "    return (ok);\n"
 "}\n"
