///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include <iostream>
#include <vector>
#include <ginac/ginac.h>
using namespace std;
using namespace GiNaC;

ex div(ex ux,ex uy,symbol x,symbol y) { return diff(ux,x) + diff(uy,y); }
ex form_div_div(ex ux,ex uy,ex vx,ex vy,symbol x,symbol y) {
    ex a = 0, b = 1;
    ex f = div(ux,uy,x,y)*div(vx,vy,x,y);
    ex ix = integral(x,a,b,f).eval_integ();
    ex iy = integral(y,a,b,ix).eval_integ();
    return iy;
}
int main() {
    symbol x("x"), y("y");
    vector<ex> monom(6);
    monom[0] = 1;
    monom[1] = x;
    monom[2] = y;
    monom[3] = x*x;
    monom[4] = x*y;
    monom[5] = y*y;
    cout << "// file automatiocally generated by form_div_div_symbolic.cc" << endl
	 << "/// =========================================================================" << endl
	 << "/// This file is part of Rheolef." << endl
	 << "///" << endl
	 << "/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>" << endl
	 << "///" << endl
	 << "/// Rheolef is free software; you can redistribute it and/or modify" << endl
	 << "/// it under the terms of the GNU General Public License as published by" << endl
	 << "/// the Free Software Foundation; either version 2 of the License, or" << endl
	 << "/// (at your option) any later version." << endl
	 << "///" << endl
	 << "/// Rheolef is distributed in the hope that it will be useful," << endl
	 << "/// but WITHOUT ANY WARRANTY; without even the implied warranty of" << endl
	 << "/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the" << endl
	 << "/// GNU General Public License for more details." << endl
	 << "///" << endl
	 << "/// You should have received a copy of the GNU General Public License" << endl
	 << "/// along with Rheolef; if not, write to the Free Software" << endl
	 << "/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA" << endl
	 << "/// " << endl
	 << "/// =========================================================================" << endl
         << "void init_expect_form_div_div (Float t[6][6][6][6]) {" << endl;
    for (size_t iux = 0; iux < 6; iux++) {
    for (size_t iuy = 0; iuy < 6; iuy++) {
    for (size_t ivx = 0; ivx < 6; ivx++) {
    for (size_t ivy = 0; ivy < 6; ivy++) {
	ex ux = monom[iux];
	ex uy = monom[iuy];
	ex vx = monom[ivx];
	ex vy = monom[ivy];
	ex value = form_div_div(ux,uy,vx,vy,x,y);
	cout << "	t["<<iux<<"]["<<iuy<<"]["<<ivx<<"]["<<ivy<<"]=";
	value.print(print_csrc_double(cout));
	cout << ";" << endl;
    }}}}
    cout << "}" << endl;
    return 0;
}
