#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
TOP_SRCDIR=${TOP_SRCDIR-"../../../rheolef"}
SRCDIR=${SRCDIR-"$TOP_SRCDIR/doc/pexamples"}
GEODIR=${GEODIR-"$TOP_SRCDIR/nfem/ptst"}
SBINDIR=${SBINDIR-"../../nfem/sbin"}
BINDIR=${BINDIR-"../../nfem/pbin"}
NPROC_MAX=${NPROC_MAX-"1"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

# geo                   err_P1 	err_P2	err_P3
L="
circle-10-fix           4e-2   	8e-3    2e-2
"

while test "$L" != ""; do
  geo=`echo $L | awk '{print $1}'`
  L=`echo $L | awk '{for (i=2; i <= NF; i++) print $i}'`
  for Pk in P1 P2 P3; do
    tol=`echo $L | awk '{print $1}'`
    L=`echo $L | awk '{for (i=2; i <= NF; i++) print $i}'`
    loop_mpirun "./mosolov_augmented_lagrangian $GEODIR/$geo-$Pk $Pk 0.2 1 2>/dev/null && zcat $geo-$Pk.field.gz | RHEOPATH=$GEODIR \$RUN ./mosolov_error_yield_surface $tol 2>/dev/null >/dev/null"
    if test $? -ne 0; then status=1; fi
    run "rm -f $geo-$Pk.field.gz"
  done
done

exit $status
