/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms;

import javax.jms.JMSException;
import org.springframework.core.NestedRuntimeException;

public abstract class JmsException
extends NestedRuntimeException {
    public JmsException(String msg) {
        super(msg);
    }

    public JmsException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public JmsException(Throwable cause) {
        super(cause != null ? cause.getMessage() : null, cause);
    }

    public String getErrorCode() {
        if (this.getCause() instanceof JMSException) {
            return ((JMSException)this.getCause()).getErrorCode();
        }
        return null;
    }

    public String getMessage() {
        Exception linkedEx;
        String message = super.getMessage();
        Throwable cause = this.getCause();
        if (cause instanceof JMSException && (linkedEx = ((JMSException)cause).getLinkedException()) != null) {
            message = message + "; nested exception is " + linkedEx;
        }
        return message;
    }
}

