/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.in.SDTInfo;

public class SDTReader
extends FormatReader {
    protected SDTInfo info;
    protected int off;
    protected int timeBins;
    protected int channels;
    protected boolean intensity = true;

    public SDTReader() {
        super("SPCImage Data", "sdt");
    }

    public void setIntensity(boolean intensity) {
        FormatTools.assertId(this.currentId, false, 1);
        this.intensity = intensity;
    }

    public boolean isIntensity() {
        return this.intensity;
    }

    public int getTimeBinCount() {
        return this.timeBins;
    }

    public int getChannelCount() {
        return this.channels;
    }

    public SDTInfo getInfo() {
        return this.info;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public int[] getChannelDimLengths() {
        int[] nArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.intensity) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.channels;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = this.timeBins;
            nArray = nArray3;
            nArray3[1] = this.channels;
        }
        return nArray;
    }

    public String[] getChannelDimTypes() {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.intensity) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Spectra";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "Lifetime";
            stringArray = stringArray3;
            stringArray3[1] = "Spectra";
        }
        return stringArray;
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return !this.intensity && subC == 0;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        if (this.intensity) {
            this.in.seek(this.off + 2 * this.core.sizeX[this.series] * this.core.sizeY[this.series] * this.timeBins * no);
            byte[] timeBin = new byte[this.timeBins * 2];
            for (int y = 0; y < this.core.sizeY[this.series]; ++y) {
                for (int x = 0; x < this.core.sizeX[this.series]; ++x) {
                    short sum = 0;
                    this.in.read(timeBin);
                    for (int t = 0; t < this.timeBins; ++t) {
                        sum = (short)(sum + DataTools.bytesToShort(timeBin, t * 2, true));
                    }
                    int ndx = 2 * (this.core.sizeX[0] * y + x);
                    buf[ndx] = (byte)(sum & 0xFF);
                    buf[ndx + 1] = (byte)(sum >> 8 & 0xFF);
                }
            }
        } else {
            this.in.seek(this.off + 2 * this.core.sizeX[this.series] * this.core.sizeY[this.series] * this.timeBins * no);
            for (int y = 0; y < this.core.sizeY[this.series]; ++y) {
                for (int x = 0; x < this.core.sizeX[this.series]; ++x) {
                    for (int t = 0; t < this.timeBins; ++t) {
                        int ndx = 2 * (this.timeBins * this.core.sizeX[0] * y + this.timeBins * x + t);
                        this.in.readFully(buf, ndx, 2);
                    }
                }
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("SDTReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        this.status("Reading header");
        this.info = new SDTInfo(this.in, this.metadata);
        this.off = this.info.dataBlockOffs + 22;
        this.timeBins = this.info.timeBins;
        this.channels = this.info.channels;
        this.addMeta("time bins", new Integer(this.timeBins));
        this.addMeta("channels", new Integer(this.channels));
        this.status("Populating metadata");
        this.core.sizeX[0] = this.info.width;
        this.core.sizeY[0] = this.info.height;
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = this.intensity ? this.channels : this.timeBins * this.channels;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYZTC";
        this.core.pixelType[0] = 3;
        this.core.rgb[0] = !this.intensity;
        this.core.littleEndian[0] = true;
        this.core.imageCount[0] = this.channels;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }

    public int getTimeBinCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getTimeBinCount();
    }

    public int getChannelCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getChannelCount();
    }

    public SDTInfo getInfo(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getInfo();
    }
}

