/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means:
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.

             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program.

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program.

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution.

             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.

             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.

             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations.

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.

             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive.

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.

             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation.


*/

/* (C) COPYRIGHT International Business Machines Corp. 2013          */

%{
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdarg.h>
#include "pkcs11types.h"
#include "icsf_config.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"
#include "trace.h"

/* Global vars used as parameter to bison/flex parser. */
extern FILE *yyin;
CK_SLOT_ID in_slot_id;
int expected_slot;
struct icsf_config out_config;
char out_str_mech[64] = "";
int out_rc;

/* Function used to report error. */
void yyerror(const char *str);

extern int yylex();

/* */
struct ref {
	char *key;
	char *addr;
	size_t len;
	int required;
};
struct ref refs[] = {
	{ "token_name",		out_config.name,	sizeof(out_config.name),	1 },
	{ "token_manufacture",	out_config.manuf,	sizeof(out_config.manuf),	1 },
	{ "token_model",	out_config.model,	sizeof(out_config.model),	1 },
	{ "token_serial",	out_config.serial,	sizeof(out_config.serial),	1 },
	{ "mech",		out_str_mech,		sizeof(out_str_mech),		1 },
	{ "uri",		out_config.uri,		sizeof(out_config.uri),		0 },
	{ "binddn",		out_config.dn,		sizeof(out_config.dn),		0 },
	{ "cacert",		out_config.ca_file,	sizeof(out_config.ca_file),	0 },
	{ "cert",		out_config.cert_file,	sizeof(out_config.cert_file),	0 },
	{ "key",		out_config.key_file,	sizeof(out_config.key_file),	0 },
};
size_t refs_len = sizeof(refs)/sizeof(*refs);
%}

%union {
	unsigned int num;
	char *str;
};

%token <str> STRING
%token <num> INTEGER
%token SLOT
%token BEGIN_DEF
%token END_DEF
%token EQUAL

%%

slots:
	slots slot
	|
	;

slot:
	SLOT INTEGER
	{
		expected_slot = ($2 == in_slot_id);
	}
	BEGIN_DEF key_values END_DEF
	;

key_values:
	key_values key_value
	|	
	;

key_value:
	STRING EQUAL STRING
	{
		char *key = $1;
		char *value = $3;
		size_t i;

		/* Check if this keyword belongs to the expected slot. */
		if (!expected_slot || out_rc)
			goto done;

		/* Check key and value */
		if (!key || !value) {
			out_rc = 1;
			TRACE_ERROR("Null %s found.\n", (!key) ? "key" : "value");
			goto done;
		}

		/* Check if this keyword is expected. */
		for (i = 0; i < strlen(key); i++)
			key[i] = tolower(key[i]);

		for(i = 0; i < refs_len; i++) {
			if (!strcmp(refs[i].key, key)) {
				strncpy(refs[i].addr, value, refs[i].len);
				refs[i].addr[refs[i].len - 1] = '\0';
				goto done;
			}
		}

		out_rc = 1;
		TRACE_ERROR("Invalid keyword: %s\n", key);

	done:
		if (key)
			free(key);
		if (value)
			free(value);
	}
	;

%%

void
yyerror(const char *str)
{
	out_rc = 1;
	fprintf(stderr,"Error: %s\n", str);
	TRACE_DEBUG("Failed to parse config file. %s\n", str);
}

static int
check_keys(const char *conf_name)
{
	size_t i;

	for (i = 0; i < refs_len; i++) {
		if (refs[i].required && *refs[i].addr == '\0') {
			TRACE_ERROR("Missing required key \"%s\" in \"%s\".\n",
				      refs[i].key, conf_name);
			return -1;
		}
	}

	return 0;
}

/*
 * Parse config file using yacc.
 */
CK_RV
parse_config_file(const char *conf_name, CK_SLOT_ID slot_id,
		  struct icsf_config *data)
{
	CK_RV rc;
	struct stat stat_info;

	/* Check is file exists. */
	if (stat(conf_name, &stat_info) || !S_ISREG(stat_info.st_mode)) {
		TRACE_ERROR("File \"%s\" does not exist or is invalid.\n",
			      conf_name);
		return CKR_FUNCTION_FAILED;
	}

	/* Set parameters used by the parser */
	in_slot_id = slot_id;
	out_rc = 0;
	memset(&out_config, 0, sizeof(*data));
	expected_slot = FALSE;

	/* Open config file */
	yyin = fopen(conf_name, "r");
	if (yyin == NULL) {
		TRACE_ERROR("Failed to open \"%s\".\n", conf_name);
		return CKR_FUNCTION_FAILED;
	}

	/* Parse config file */
	rc = yyparse();
	fclose(yyin);
	if (rc || out_rc) {
		TRACE_ERROR("Failed to parser file \"%s\" (%lu:%d).\n",
			      conf_name, rc, out_rc);
		return CKR_FUNCTION_FAILED;
	}

	/* Check required keys*/
	if (check_keys(conf_name))
		return CKR_FUNCTION_FAILED;

	/* Parse mechanism type */
	if (!strcmp(out_str_mech, "SIMPLE")) {
		out_config.mech = ICSF_CFG_MECH_SIMPLE;
	} else if (!strcmp(out_str_mech, "SASL")) {
		out_config.mech = ICSF_CFG_MECH_SASL;
	} else {
		TRACE_ERROR("Unknown mechanism type found: %s\n", out_str_mech);
		return CKR_FUNCTION_FAILED;
	}

	/* Copy output data. */
	memcpy(data, &out_config, sizeof(*data));

	#if DEBUG
	{
		size_t i;
		TRACE_DEVEL("ICSF configs for slot %lu.\n", slot_id);
		for (i = 0; i < refs_len; i++) {
			TRACE_DEVEL(" %s = \"%s\"\n", refs[i].key,
				      refs[i].addr);
		}
	}
	#endif

	return CKR_OK;
}
