open Curl

let count1 = 200
let leak1 = 1024 * 1024

let test1 () =
  let h = init () in
  let s1 = String.make leak1 'd' in
  set_private h s1;
  let s2 = String.make leak1 'c' in
  set_httppost h [CURLFORM_CONTENT ("part", s2, DEFAULT)];
  assert (get_private h = s1);
  cleanup h

let rss () =
  let path = Printf.sprintf "/proc/%d/statm" (Unix.getpid ()) in
  try
    let ch = open_in path in
    let n = Scanf.fscanf ch "%_d %d" (fun x -> 4*1024*x) in close_in_noerr ch; n
  with exn -> Printf.eprintf "Error opening %s (%s), ignoring\n%!" path (Printexc.to_string exn); 0

let () =
  let rss1 = rss () in
  for i = 0 to count1 do
    test1 ();
    Gc.compact ();
  done;
  let rss2 = rss () in
  Printf.printf "RSS %d -> %d %s\n%!" rss1 rss2 (if rss2 - rss1 < count1 * leak1 / 10 then "OK" else "LEAKING")
