/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <stdio.h>

#ifndef __GLUE_GUI_GTK_POTENTIOMETER_H_INCLUDED
#define __GLUE_GUI_GTK_POTENTIOMETER_H_INCLUDED

typedef struct {
	GtkHBox parent;

	GtkWidget *label;
	GtkAdjustment *adj;
	GtkWidget *scale;
} GuiGtkPotentiometer;

#define GUI_GTK_TYPE_POTENTIOMETER	(gui_gtk_potentiometer_get_type())
#define GUI_GTK_POTENTIOMETER(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), GUI_GTK_TYPE_POTENTIOMETER, GuiGtkPotentiometer))

extern GType
gui_gtk_potentiometer_get_type(void);

extern GtkWidget *
gui_gtk_potentiometer_new(const char *desc);

extern void
gui_gtk_potentiometer_adj_sim(void *_potentiometer, int val);

#endif /* __GLUE_GUI_GTK_POTENTIOMETER_H_INCLUDED */
