# Copyright (C) 2004-2017 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.

# usage: AC_USE_LIB(VARIABLE, LIB, FUNC)
# will add to <VARIABLE>_LIBS or undef HAVE_<VARIABLE>
# Martin Waitz <tali@admingilde.org>
AC_DEFUN([AC_USE_LIB], [
	AC_CHECK_LIB($2, $3, [
		$1_LIBS="-l$2 $$1_LIBS"
	], [HAVE_$1=], "$$1_LIBS")
])

# usage: AC_PROG_CC_OPTION(--compiler-option, if-supported, if-unsupported)
# add this option to $(CC) if it is supported by the compiler
# if no sc
# Martin Waitz <tali@admingilde.org>
AC_DEFUN([AC_PROG_CC_OPTION], [
	AC_MSG_CHECKING([whether $CC supports $1])
	ac_save_CC="$CC"
	CC="$CC $1"
	AC_COMPILE_IFELSE([AC_LANG_PROGRAM([])],[
		AC_MSG_RESULT([yes])
		ifelse($2, , [], [
		CC="$ac_save_CC"
		$2])
	], [
		AC_MSG_RESULT([no])
		CC="$ac_save_CC"
		$3
	])
])


dnl check for macosx core audio

AC_DEFUN([CHECK_MACOSX_AUDIO],
[
	AC_ARG_ENABLE(macosx, [  --enable-macosx         include MAC OS X audio output plugin ],
	[ BUILD_MACOSX_AUDIO="$enableval" ], [ BUILD_MACOSX_AUDIO="yes" ])

	if test "$BUILD_MACOSX_AUDIO" = "yes"; then
		AC_MSG_CHECKING([for macosx audio])

		case ${host} in
			*-apple-darwin*)
				macosx_version=yes
				;;
			*)
				macosx_version=no
				;;
		esac

		ao_macosx=no
		if test "$macosx_version" = "yes"; then
			AC_DEFINE([USE_MACOSX_AUDIO],[1],[support macosx])
			ao_macosx=yes
			LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -framework Carbon -framework CoreAudio -framework AudioUnit"
		fi

		AM_CONDITIONAL(AO_MACOSX, test $ao_macosx = yes)
		AC_SUBST([LIBAO_DEP_LIBS])

		AC_MSG_RESULT($macosx_version)
	fi

])

dnl check for installed oss

dnl JOSEF FIXME ... test with correct dyn. inc
dnl	#include ${oss_inc}]],[[int arg = SNDCTL_DSP_SETFRAGMENT;

AC_DEFUN([CHECK_OSS],
[
	AC_ARG_ENABLE(oss, [  --enable-oss            include OSS output plugin ],
	[ BUILD_OSS="$enableval" ], [ BUILD_OSS="yes" ])

	if test "$BUILD_OSS" = "yes"; then
		AC_CHECK_HEADERS(sys/soundcard.h,[oss_inc="#include<sys/soundcard.h>"])
		if test "$ac_cv_header_sys_soundcard_h" != "yes"; then
			AC_CHECK_HEADERS(soundcard.h,[oss_inc="#include<soundcard.h>"])
		fi
		AC_MSG_CHECKING([for oss])
		AC_CACHE_VAL(faum_cv_oss_version,
			[
			AC_LINK_IFELSE(
				[AC_LANG_PROGRAM([[
					#include <sys/ioctl.h>
					#include <sys/soundcard.h>]],[[int arg = SNDCTL_DSP_SETFRAGMENT;
					exit(0);
					]])
				],
				faum_cv_oss_version=yes,
				faum_cv_oss_version=no)

		])

		ao_oss=no
		if test "$faum_cv_oss_version" = "yes"; then
			AC_DEFINE([USE_OSS_AUDIO],[1],[support oss])
			ao_oss=yes
			AC_DEFINE([PATH_DEV_DSP],
				["/dev/dsp"],
				[dsp sound device])
			AC_DEFINE([PATH_DEV_MIXER],
				["/dev/mixer"],
				[sound mixer device])
		fi

		AM_CONDITIONAL(AO_OSS, test $ao_oss = yes)

		AC_MSG_RESULT($faum_cv_oss_version)
	fi

])

dnl checks for alsa version between 0.5 and 1.0

AC_DEFUN([CHECK_ALSA],
[
	AC_ARG_ENABLE(alsa, [  --enable-alsa           include appropriate alsa output plugin ],
		[ BUILD_ALSA="$enableval" ],[ BUILD_ALSA="yes" ])

	if test "$BUILD_ALSA" = "yes"; then
		AC_CHECK_HEADERS(alsa/asoundlib.h sys/asoundlib.h)
		AC_MSG_CHECKING([for alsa version >= 0.5])
		AC_CACHE_VAL(faum_cv_alsa_version,
		[
			save_libs="$LIBS"
			LIBS="-lasound $LIBS"
			AC_RUN_IFELSE(
				[AC_LANG_PROGRAM(
					[[#include <sys/asoundlib.h>]],
					[[exit(!(SND_LIB_MAJOR==0 &&
					SND_LIB_MINOR==5));]])],
				faum_cv_alsa_version=0.5.x,
				faum_cv_alsa_version=no)
			LIBS="$save_LIBS"
			
			if test "$faum_cv_alsa_version" = "no"; then
				save_libs="$LIBS"
				LIBS="-lasound $LIBS"
				AC_RUN_IFELSE(
					[AC_LANG_PROGRAM(
						[[#include <alsa/asoundlib.h>]],
						[[exit(!(SND_LIB_MAJOR==0 &&
						SND_LIB_MINOR==9));]])],
					faum_cv_alsa_version=0.9.x-alsa,
					faum_cv_alsa_version=no)
				LIBS="$save_LIBS"
			fi
			
			if test "$faum_cv_alsa_version" = "no"; then
				save_libs="$LIBS"
				LIBS="-lasound $LIBS"
				AC_RUN_IFELSE(
					[AC_LANG_PROGRAM(
						[[#include <sys/asoundlib.h>]],
						[[exit(!(SND_LIB_MAJOR==0 &&
						SND_LIB_MINOR==9));]])],
					faum_cv_alsa_version=0.9.x-sys,
					faum_cv_alsa_version=no)
				LIBS="$save_LIBS"
			fi
			
			if test "$faum_cv_alsa_version" = "no"; then
				save_libs="$LIBS"
				LIBS="-lasound $LIBS"
				AC_RUN_IFELSE(
					[AC_LANG_PROGRAM(
						[[#include <alsa/asoundlib.h>]],
						[[exit(!(SND_LIB_MAJOR==1 &&
						SND_LIB_MINOR==0));]])],
					faum_cv_alsa_version=1.0.x-alsa,
					faum_cv_alsa_version=no)
				LIBS="$save_LIBS"
			fi
			
			if test "$faum_cv_alsa_version" = "no"; then
				save_libs="$LIBS"
				LIBS="-lasound $LIBS"
				AC_RUN_IFELSE(
					[AC_LANG_PROGRAM(
						[[#include <sys/asoundlib.h>]],
						[[exit(!(SND_LIB_MAJOR==1 &&
						SND_LIB_MINOR==0));]])],
					faum_cv_alsa_version=1.0.x-sys,
					faum_cv_alsa_version=no)
				LIBS="$save_LIBS"
			fi
		])

		ao_alsa1x="no"

		if test "$faum_cv_alsa_version" != "no" ; then
			if test "$faum_cv_alsa_version" = "1.0.x-sys" ; then
				AC_DEFINE([HAVE_ALSA1X],[1],[using alsa 1.x])
				ao_alsa1x="yes"
				echo "yes (using alsa 1.0.x and sys/asoundlib.h)"
			elif test "$faum_cv_alsa_version" = "1.0.x-alsa" ; then
				AC_DEFINE([HAVE_ALSA1X],[1],[using alsa 1.x])
				ao_alsa1x="yes"
				echo "yes (using alsa 1.0.x and alsa/asoundlib.h)"
			fi
dnl			LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -lasound -ldl -lpthread"
			LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -ldl"
			AC_DEFINE(MAX_OUTBURST, 65536, [ set up max. outburst. use 65536 for ALSA0.5, for others 16384 is enough])
			AC_DEFINE(OUTBURST, 512, [audio outburst, no clue what this means])

		else 
			AC_MSG_RESULT($faum_cv_alsa_version)
		fi
	fi

	AC_SUBST([LIBAO_DEP_LIBS])
	AM_CONDITIONAL(AO_ALSA1X, test "$ao_alsa1x" = "yes")
])

dnl Check for PulseAudio

AC_DEFUN([CHECK_PULSE],
[
	AC_ARG_ENABLE(pulse, [  --enable-pulse          include PulseAudio output plugin ],
	        [ BUILD_PULSE="$enableval" ], [ BUILD_PULSE="yes" ])
	
	ao_pulse="no"

	if test "$BUILD_PULSE" = "yes"; then
		AC_CHECK_HEADERS(pulse/pulseaudio.h)
		AC_MSG_CHECKING([for pulse])
		if test "$ac_cv_header_pulse_pulseaudio_h" = "yes"; then
		   ao_pulse="yes"
		   LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -ldl"
dnl		   LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -lpulse"
		   AC_DEFINE([USE_PULSE],[1],[pulse plugin])
		   AC_MSG_RESULT($ao_pulse)
		fi
	fi

	AC_SUBST([LIBAO_DEP_LIBS])
	AM_CONDITIONAL(AO_PULSE, test "$ao_pulse" = "yes")
])

dnl Check for eSound

AC_DEFUN([CHECK_ESD],
[
	AC_ARG_ENABLE(esd, [  --enable-esd            include eSound output plugin ],
	        [ BUILD_ESD="$enableval" ], [ BUILD_ESD="yes" ])
	
	ao_esd="no"

	if test "$BUILD_ESD" = "yes"; then
		AC_CHECK_HEADERS(esd.h)
		AC_MSG_CHECKING([for esd])
		if test "$ac_cv_header_esd_h" = "yes"; then
		   ao_esd="yes"
		   LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -ldl"
dnl		   LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -lesd -laudiofile -lm"
		   AC_DEFINE([USE_ESD],[1],[esd plugin])
		   AC_MSG_RESULT($ao_esd)
		fi
	fi

	AC_SUBST([LIBAO_DEP_LIBS])
	AM_CONDITIONAL(AO_ESD, test "$ao_esd" = "yes")
])
