# $Id: nice.m4 2885 2016-05-16 23:48:04Z brachman $

dnl Repeatedly resolve the contents of the second argument until
dnl interpolation offers no new result. The final result is assigned
dnl the first argument.  Example:
dnl
dnl foo=a
dnl bar='${foo}/b'
dnl baz='${bar}/c'
dnl DACS_EXPAND_VAR(xxx, $baz)
dnl   $xxx is now "a/b/c"
dnl 
AC_DEFUN(DACS_EXPAND_VAR,[
  expand_var_last=
  expand_var_current="$2"
  while test "x${expand_var_current}" != "x${expand_var_last}";
  do
    expand_var_last="${expand_var_current}"
    expand_var_current=`eval "echo ${expand_var_current}"`
  done
  $1="${expand_var_current}"
])

dnl Save the command line arguments to configure to the given filename
dnl (conventionally "config.nice") so that configure can easily be reinvoked
dnl later in the same way.
dnl XXX Note that we may not save all significant environment variables
dnl
AC_DEFUN(DACS_CONFIG_NICE,[
  echo creating $1
  rm -f $1
  cat >$1<<EOF
#! /bin/sh
#
# Created by configure
EOF

  echo "# On `date`" >> $1
  echo "" >> $1

  echo "# Environment:" >> $1
  if test -n "$CC"; then
    echo "# C compiler command" >> $1
    echo "CC=\"$CC\"; export CC" >> $1
  fi

  if test -n "$CPP"; then
    echo "# C preprocessor" >> $1
    echo "CPP=\"$CPP\"; export CPP" >> $1
  fi

  if test -n "$LN"; then
    echo "# The ln command, used to make hard links" >> $1
    echo "LN=\"$LN\"; export LN" >> $1
  fi
  if test -n "$CFLAGS"; then
    echo "# C compiler flags" >> $1
    echo "CFLAGS=\"$CFLAGS\"; export CFLAGS" >> $1
  fi

  if test -n "$CPPFLAGS"; then
    echo "# C/C++ preprocessor flags, e.g. -I<include dir> if you have" >> $1
    echo "# headers in a nonstandard directory <include dir>" >> $1
    echo "CPPFLAGS=\"$CPPFLAGS\"; export CPPFLAGS" >> $1
  fi

  if test -n "$LDFLAGS"; then
    echo "# linker flags, e.g. -L<lib dir> if you have libraries in a" >> $1
    echo "# nonstandard directory <lib dir>" >> $1
    echo "LDFLAGS=\"$LDFLAGS\"; export LDFLAGS" >> $1
  fi

  echo "" >> $1

  for arg in [$]0 "[$]@"; do
    DACS_EXPAND_VAR(exarg, $arg)
    echo "\"[$]exarg\" \\" >> $1
  done
  echo '"[$]@"' >> $1
  chmod +x $1
])

