// Copyright 2013 Blender Foundation. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
// Author: Sergey Sharybin

#ifndef OPENSUBDIV_GL_MESH_DRAW_H_
#define OPENSUBDIV_GL_MESH_DRAW_H_

#include <stdint.h>  // for bool

struct OpenSubdiv_GLMesh;

namespace opensubdiv_capi {

void GLMeshDisplayPrepare(struct OpenSubdiv_GLMesh *gl_mesh,
                          const bool use_osd_glsl,
                          const int active_uv_index);

void GLMeshDisplayDrawPatches(OpenSubdiv_GLMesh *gl_mesh,
                              const bool fill_quads,
                              const int start_patch,
                              const int num_patches);

}  // namespace opensubdiv_capi

#endif  // OPENSUBDIV_GL_MESH_DRAW_H_
