// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package apigateway_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/apigateway"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleAPIGateway_CreateApiKey() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateApiKeyInput{
		CustomerId:         aws.String("String"),
		Description:        aws.String("String"),
		Enabled:            aws.Bool(true),
		GenerateDistinctId: aws.Bool(true),
		Name:               aws.String("String"),
		StageKeys: []*apigateway.StageKey{
			{ // Required
				RestApiId: aws.String("String"),
				StageName: aws.String("String"),
			},
			// More values...
		},
		Value: aws.String("String"),
	}
	resp, err := svc.CreateApiKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateAuthorizer() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateAuthorizerInput{
		IdentitySource:               aws.String("String"),         // Required
		Name:                         aws.String("String"),         // Required
		RestApiId:                    aws.String("String"),         // Required
		Type:                         aws.String("AuthorizerType"), // Required
		AuthType:                     aws.String("String"),
		AuthorizerCredentials:        aws.String("String"),
		AuthorizerResultTtlInSeconds: aws.Int64(1),
		AuthorizerUri:                aws.String("String"),
		IdentityValidationExpression: aws.String("String"),
		ProviderARNs: []*string{
			aws.String("ProviderARN"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateAuthorizer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateBasePathMapping() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateBasePathMappingInput{
		DomainName: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		BasePath:   aws.String("String"),
		Stage:      aws.String("String"),
	}
	resp, err := svc.CreateBasePathMapping(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateDeployment() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateDeploymentInput{
		RestApiId:           aws.String("String"), // Required
		CacheClusterEnabled: aws.Bool(true),
		CacheClusterSize:    aws.String("CacheClusterSize"),
		Description:         aws.String("String"),
		StageDescription:    aws.String("String"),
		StageName:           aws.String("String"),
		Variables: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateDocumentationPart() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateDocumentationPartInput{
		Location: &apigateway.DocumentationPartLocation{ // Required
			Type:       aws.String("DocumentationPartType"), // Required
			Method:     aws.String("String"),
			Name:       aws.String("String"),
			Path:       aws.String("String"),
			StatusCode: aws.String("DocumentationPartLocationStatusCode"),
		},
		Properties: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.CreateDocumentationPart(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateDocumentationVersion() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateDocumentationVersionInput{
		DocumentationVersion: aws.String("String"), // Required
		RestApiId:            aws.String("String"), // Required
		Description:          aws.String("String"),
		StageName:            aws.String("String"),
	}
	resp, err := svc.CreateDocumentationVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateDomainName() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateDomainNameInput{
		DomainName:            aws.String("String"), // Required
		CertificateArn:        aws.String("String"),
		CertificateBody:       aws.String("String"),
		CertificateChain:      aws.String("String"),
		CertificateName:       aws.String("String"),
		CertificatePrivateKey: aws.String("String"),
	}
	resp, err := svc.CreateDomainName(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateModel() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateModelInput{
		ContentType: aws.String("String"), // Required
		Name:        aws.String("String"), // Required
		RestApiId:   aws.String("String"), // Required
		Description: aws.String("String"),
		Schema:      aws.String("String"),
	}
	resp, err := svc.CreateModel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateResource() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateResourceInput{
		ParentId:  aws.String("String"), // Required
		PathPart:  aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.CreateResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateRestApi() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateRestApiInput{
		Name: aws.String("String"), // Required
		BinaryMediaTypes: []*string{
			aws.String("String"), // Required
			// More values...
		},
		CloneFrom:   aws.String("String"),
		Description: aws.String("String"),
		Version:     aws.String("String"),
	}
	resp, err := svc.CreateRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateStage() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateStageInput{
		DeploymentId:         aws.String("String"), // Required
		RestApiId:            aws.String("String"), // Required
		StageName:            aws.String("String"), // Required
		CacheClusterEnabled:  aws.Bool(true),
		CacheClusterSize:     aws.String("CacheClusterSize"),
		Description:          aws.String("String"),
		DocumentationVersion: aws.String("String"),
		Variables: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateStage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateUsagePlan() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateUsagePlanInput{
		Name: aws.String("String"), // Required
		ApiStages: []*apigateway.ApiStage{
			{ // Required
				ApiId: aws.String("String"),
				Stage: aws.String("String"),
			},
			// More values...
		},
		Description: aws.String("String"),
		Quota: &apigateway.QuotaSettings{
			Limit:  aws.Int64(1),
			Offset: aws.Int64(1),
			Period: aws.String("QuotaPeriodType"),
		},
		Throttle: &apigateway.ThrottleSettings{
			BurstLimit: aws.Int64(1),
			RateLimit:  aws.Float64(1.0),
		},
	}
	resp, err := svc.CreateUsagePlan(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateUsagePlanKey() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.CreateUsagePlanKeyInput{
		KeyId:       aws.String("String"), // Required
		KeyType:     aws.String("String"), // Required
		UsagePlanId: aws.String("String"), // Required
	}
	resp, err := svc.CreateUsagePlanKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteApiKey() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteApiKeyInput{
		ApiKey: aws.String("String"), // Required
	}
	resp, err := svc.DeleteApiKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteAuthorizer() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteAuthorizerInput{
		AuthorizerId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
	}
	resp, err := svc.DeleteAuthorizer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteBasePathMapping() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteBasePathMappingInput{
		BasePath:   aws.String("String"), // Required
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteBasePathMapping(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteClientCertificate() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteClientCertificateInput{
		ClientCertificateId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteDeployment() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteDeploymentInput{
		DeploymentId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
	}
	resp, err := svc.DeleteDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteDocumentationPart() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteDocumentationPartInput{
		DocumentationPartId: aws.String("String"), // Required
		RestApiId:           aws.String("String"), // Required
	}
	resp, err := svc.DeleteDocumentationPart(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteDocumentationVersion() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteDocumentationVersionInput{
		DocumentationVersion: aws.String("String"), // Required
		RestApiId:            aws.String("String"), // Required
	}
	resp, err := svc.DeleteDocumentationVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteDomainName() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteDomainNameInput{
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDomainName(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteIntegration() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteIntegrationInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.DeleteIntegration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteIntegrationResponse() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteIntegrationResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
	}
	resp, err := svc.DeleteIntegrationResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteMethod() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteMethodInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.DeleteMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteMethodResponse() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteMethodResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
	}
	resp, err := svc.DeleteMethodResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteModel() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteModelInput{
		ModelName: aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteModel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteResource() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteResourceInput{
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.DeleteResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteRestApi() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteRestApiInput{
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteStage() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteStageInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteStage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteUsagePlan() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteUsagePlanInput{
		UsagePlanId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteUsagePlan(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteUsagePlanKey() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.DeleteUsagePlanKeyInput{
		KeyId:       aws.String("String"), // Required
		UsagePlanId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteUsagePlanKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_FlushStageAuthorizersCache() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.FlushStageAuthorizersCacheInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
	}
	resp, err := svc.FlushStageAuthorizersCache(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_FlushStageCache() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.FlushStageCacheInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
	}
	resp, err := svc.FlushStageCache(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GenerateClientCertificate() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GenerateClientCertificateInput{
		Description: aws.String("String"),
	}
	resp, err := svc.GenerateClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetAccount() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	var params *apigateway.GetAccountInput
	resp, err := svc.GetAccount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetApiKey() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetApiKeyInput{
		ApiKey:       aws.String("String"), // Required
		IncludeValue: aws.Bool(true),
	}
	resp, err := svc.GetApiKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetApiKeys() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetApiKeysInput{
		CustomerId:    aws.String("String"),
		IncludeValues: aws.Bool(true),
		Limit:         aws.Int64(1),
		NameQuery:     aws.String("String"),
		Position:      aws.String("String"),
	}
	resp, err := svc.GetApiKeys(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetAuthorizer() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetAuthorizerInput{
		AuthorizerId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
	}
	resp, err := svc.GetAuthorizer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetAuthorizers() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetAuthorizersInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		Position:  aws.String("String"),
	}
	resp, err := svc.GetAuthorizers(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetBasePathMapping() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetBasePathMappingInput{
		BasePath:   aws.String("String"), // Required
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.GetBasePathMapping(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetBasePathMappings() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetBasePathMappingsInput{
		DomainName: aws.String("String"), // Required
		Limit:      aws.Int64(1),
		Position:   aws.String("String"),
	}
	resp, err := svc.GetBasePathMappings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetClientCertificate() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetClientCertificateInput{
		ClientCertificateId: aws.String("String"), // Required
	}
	resp, err := svc.GetClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetClientCertificates() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetClientCertificatesInput{
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetClientCertificates(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDeployment() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetDeploymentInput{
		DeploymentId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
	}
	resp, err := svc.GetDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDeployments() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetDeploymentsInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		Position:  aws.String("String"),
	}
	resp, err := svc.GetDeployments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDocumentationPart() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetDocumentationPartInput{
		DocumentationPartId: aws.String("String"), // Required
		RestApiId:           aws.String("String"), // Required
	}
	resp, err := svc.GetDocumentationPart(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDocumentationParts() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetDocumentationPartsInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		NameQuery: aws.String("String"),
		Path:      aws.String("String"),
		Position:  aws.String("String"),
		Type:      aws.String("DocumentationPartType"),
	}
	resp, err := svc.GetDocumentationParts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDocumentationVersion() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetDocumentationVersionInput{
		DocumentationVersion: aws.String("String"), // Required
		RestApiId:            aws.String("String"), // Required
	}
	resp, err := svc.GetDocumentationVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDocumentationVersions() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetDocumentationVersionsInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		Position:  aws.String("String"),
	}
	resp, err := svc.GetDocumentationVersions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDomainName() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetDomainNameInput{
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.GetDomainName(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDomainNames() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetDomainNamesInput{
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetDomainNames(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetExport() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetExportInput{
		ExportType: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		StageName:  aws.String("String"), // Required
		Accepts:    aws.String("String"),
		Parameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.GetExport(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetIntegration() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetIntegrationInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.GetIntegration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetIntegrationResponse() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetIntegrationResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
	}
	resp, err := svc.GetIntegrationResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetMethod() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetMethodInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.GetMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetMethodResponse() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetMethodResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
	}
	resp, err := svc.GetMethodResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetModel() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetModelInput{
		ModelName: aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
		Flatten:   aws.Bool(true),
	}
	resp, err := svc.GetModel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetModelTemplate() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetModelTemplateInput{
		ModelName: aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.GetModelTemplate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetModels() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetModelsInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		Position:  aws.String("String"),
	}
	resp, err := svc.GetModels(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetResource() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetResourceInput{
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.GetResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetResources() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetResourcesInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		Position:  aws.String("String"),
	}
	resp, err := svc.GetResources(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetRestApi() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetRestApiInput{
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.GetRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetRestApis() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetRestApisInput{
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetRestApis(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetSdk() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetSdkInput{
		RestApiId: aws.String("String"), // Required
		SdkType:   aws.String("String"), // Required
		StageName: aws.String("String"), // Required
		Parameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.GetSdk(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetSdkType() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetSdkTypeInput{
		Id: aws.String("String"), // Required
	}
	resp, err := svc.GetSdkType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetSdkTypes() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetSdkTypesInput{
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetSdkTypes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetStage() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetStageInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
	}
	resp, err := svc.GetStage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetStages() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetStagesInput{
		RestApiId:    aws.String("String"), // Required
		DeploymentId: aws.String("String"),
	}
	resp, err := svc.GetStages(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetUsage() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetUsageInput{
		EndDate:     aws.String("String"), // Required
		StartDate:   aws.String("String"), // Required
		UsagePlanId: aws.String("String"), // Required
		KeyId:       aws.String("String"),
		Limit:       aws.Int64(1),
		Position:    aws.String("String"),
	}
	resp, err := svc.GetUsage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetUsagePlan() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetUsagePlanInput{
		UsagePlanId: aws.String("String"), // Required
	}
	resp, err := svc.GetUsagePlan(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetUsagePlanKey() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetUsagePlanKeyInput{
		KeyId:       aws.String("String"), // Required
		UsagePlanId: aws.String("String"), // Required
	}
	resp, err := svc.GetUsagePlanKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetUsagePlanKeys() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetUsagePlanKeysInput{
		UsagePlanId: aws.String("String"), // Required
		Limit:       aws.Int64(1),
		NameQuery:   aws.String("String"),
		Position:    aws.String("String"),
	}
	resp, err := svc.GetUsagePlanKeys(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetUsagePlans() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.GetUsagePlansInput{
		KeyId:    aws.String("String"),
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetUsagePlans(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_ImportApiKeys() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.ImportApiKeysInput{
		Body:           []byte("PAYLOAD"),           // Required
		Format:         aws.String("ApiKeysFormat"), // Required
		FailOnWarnings: aws.Bool(true),
	}
	resp, err := svc.ImportApiKeys(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_ImportDocumentationParts() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.ImportDocumentationPartsInput{
		Body:           []byte("PAYLOAD"),    // Required
		RestApiId:      aws.String("String"), // Required
		FailOnWarnings: aws.Bool(true),
		Mode:           aws.String("PutMode"),
	}
	resp, err := svc.ImportDocumentationParts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_ImportRestApi() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.ImportRestApiInput{
		Body:           []byte("PAYLOAD"), // Required
		FailOnWarnings: aws.Bool(true),
		Parameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ImportRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutIntegration() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.PutIntegrationInput{
		HttpMethod: aws.String("String"),          // Required
		ResourceId: aws.String("String"),          // Required
		RestApiId:  aws.String("String"),          // Required
		Type:       aws.String("IntegrationType"), // Required
		CacheKeyParameters: []*string{
			aws.String("String"), // Required
			// More values...
		},
		CacheNamespace:        aws.String("String"),
		ContentHandling:       aws.String("ContentHandlingStrategy"),
		Credentials:           aws.String("String"),
		IntegrationHttpMethod: aws.String("String"),
		PassthroughBehavior:   aws.String("String"),
		RequestParameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		RequestTemplates: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		Uri: aws.String("String"),
	}
	resp, err := svc.PutIntegration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutIntegrationResponse() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.PutIntegrationResponseInput{
		HttpMethod:      aws.String("String"),     // Required
		ResourceId:      aws.String("String"),     // Required
		RestApiId:       aws.String("String"),     // Required
		StatusCode:      aws.String("StatusCode"), // Required
		ContentHandling: aws.String("ContentHandlingStrategy"),
		ResponseParameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		ResponseTemplates: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		SelectionPattern: aws.String("String"),
	}
	resp, err := svc.PutIntegrationResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutMethod() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.PutMethodInput{
		AuthorizationType: aws.String("String"), // Required
		HttpMethod:        aws.String("String"), // Required
		ResourceId:        aws.String("String"), // Required
		RestApiId:         aws.String("String"), // Required
		ApiKeyRequired:    aws.Bool(true),
		AuthorizerId:      aws.String("String"),
		OperationName:     aws.String("String"),
		RequestModels: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		RequestParameters: map[string]*bool{
			"Key": aws.Bool(true), // Required
			// More values...
		},
	}
	resp, err := svc.PutMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutMethodResponse() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.PutMethodResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
		ResponseModels: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		ResponseParameters: map[string]*bool{
			"Key": aws.Bool(true), // Required
			// More values...
		},
	}
	resp, err := svc.PutMethodResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutRestApi() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.PutRestApiInput{
		Body:           []byte("PAYLOAD"),    // Required
		RestApiId:      aws.String("String"), // Required
		FailOnWarnings: aws.Bool(true),
		Mode:           aws.String("PutMode"),
		Parameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.PutRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_TestInvokeAuthorizer() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.TestInvokeAuthorizerInput{
		AuthorizerId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
		AdditionalContext: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		Body: aws.String("String"),
		Headers: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		PathWithQueryString: aws.String("String"),
		StageVariables: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.TestInvokeAuthorizer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_TestInvokeMethod() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.TestInvokeMethodInput{
		HttpMethod:          aws.String("String"), // Required
		ResourceId:          aws.String("String"), // Required
		RestApiId:           aws.String("String"), // Required
		Body:                aws.String("String"),
		ClientCertificateId: aws.String("String"),
		Headers: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		PathWithQueryString: aws.String("String"),
		StageVariables: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.TestInvokeMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateAccount() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateAccountInput{
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateAccount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateApiKey() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateApiKeyInput{
		ApiKey: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateApiKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateAuthorizer() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateAuthorizerInput{
		AuthorizerId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateAuthorizer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateBasePathMapping() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateBasePathMappingInput{
		BasePath:   aws.String("String"), // Required
		DomainName: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateBasePathMapping(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateClientCertificate() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateClientCertificateInput{
		ClientCertificateId: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateDeployment() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateDeploymentInput{
		DeploymentId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateDocumentationPart() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateDocumentationPartInput{
		DocumentationPartId: aws.String("String"), // Required
		RestApiId:           aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateDocumentationPart(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateDocumentationVersion() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateDocumentationVersionInput{
		DocumentationVersion: aws.String("String"), // Required
		RestApiId:            aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateDocumentationVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateDomainName() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateDomainNameInput{
		DomainName: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateDomainName(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateIntegration() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateIntegrationInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateIntegration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateIntegrationResponse() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateIntegrationResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateIntegrationResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateMethod() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateMethodInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateMethodResponse() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateMethodResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateMethodResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateModel() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateModelInput{
		ModelName: aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateModel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateResource() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateResourceInput{
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateRestApi() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateRestApiInput{
		RestApiId: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateStage() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateStageInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateStage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateUsage() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateUsageInput{
		KeyId:       aws.String("String"), // Required
		UsagePlanId: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateUsage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateUsagePlan() {
	sess := session.Must(session.NewSession())

	svc := apigateway.New(sess)

	params := &apigateway.UpdateUsagePlanInput{
		UsagePlanId: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("Op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateUsagePlan(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
