from StringIO import StringIO
from Acquisition import aq_base

from Products.CMFCore.utils import getToolByName
from Products.CMFCore.DirectoryView import addDirectoryViews

from Products.Archetypes import listTypes
from Products.Archetypes.Extensions.utils import installTypes

from Products.LinguaPlone import config

def installSkins(self, out):
    skins_tool = getToolByName(self, 'portal_skins')
    addDirectoryViews(skins_tool, 'skins', config.GLOBALS)
    for layer_name in config.SKIN_LAYERS:
        for skin_name in skins_tool.getSkinSelections():
            path = skins_tool.getSkinPath(skin_name)
            path = filter(None, [i.strip() for i in path.split(',')])
            if layer_name not in path:
                if 'custom' in path:
                    path.insert(path.index('custom') + 1, layer_name)
                else:
                    path.append(layer_name)
                print >> out, 'Layer %s added to skin %s.' % (layer_name,
                                                              skin_name)
            path = ','.join(path)
            skins_tool.addSkinSelection(skin_name, path)

def switchPathIndex(portal, out):
    """Changes the 'path' index to ExtendedPathIndex."""
    catalog = getToolByName(portal, 'portal_catalog', None)
    if catalog is not None:
        try:
            index = catalog._catalog.getIndex('path')
        except KeyError:
            pass
        else:
            indextype = index.__class__.__name__
            if indextype == 'ExtendedPathIndex':
                return
            catalog.delIndex('path')
            print >> out, "Deleted %s 'path' from portal_catalog." % indextype

        catalog.addIndex('path', 'ExtendedPathIndex')
        print >> out, "Added ExtendedPathIndex 'path' to portal_catalog."
        catalog.reindexIndex('path', None)

def addWFStateFilteringToNavTree(portal, out):
    """ Adds enable_wf_state_filtering and wf_states_to_show properties to the
        navtree_properties
    """
    props = getToolByName(portal, 'portal_properties', None)
    propSheet = getattr(props, 'navtree_properties', None)
    if propSheet is not None:
        if not propSheet.hasProperty('enable_wf_state_filtering'):
            propSheet.manage_addProperty('enable_wf_state_filtering', 0, 'boolean')
        print >> out, "Added 'enable_wf_state_filtering' property to navtree_properties."
        if not propSheet.hasProperty('wf_states_to_show'):
            propSheet.manage_addProperty('wf_states_to_show', [], 'lines')
        print >> out, "Added 'wf_states_to_show' property to navtree_properties."

def updateNavTreeProperties(portal, out):
    """Updates navtree_properties for new NavTree."""
    # Plone setup has changed because of the new NavTree implementation.
    # StatelessTreeNav had a createNavTreePropertySheet method which is now
    # in Portal.py (including the new properties).
    # If typesTolist is not there we're dealing with a real migration:
    propTool = getToolByName(portal, 'portal_properties', None)
    if propTool is not None:
        propSheet = getattr(aq_base(propTool), 'navtree_properties', None)
        if propSheet is not None:
            if not propSheet.hasProperty('typesToList'):
                propSheet._setProperty('typesToList', ['Folder', 'Large Plone Folder', 'Topic'], 'lines')
                # Changed sortAttribute to empty string. Plone 2.0
                # didn't had orderable stuff.
                propSheet._setProperty('sortAttribute', '', 'string')
                propSheet._setProperty('sortOrder', 'asc', 'string')
                propSheet._setProperty('sitemapDepth', 3, 'int')
            if not propSheet.hasProperty('showAllParents'):
                propSheet._setProperty('showAllParents', 1, 'boolean')
            print >> out, 'Updated navtree_properties.'

def addTypesUseViewActionInListingsProperty(portal, out):
    # Adds a typesUseViewActionInListings list property to site_properties
    # which is used to determine which types should use not immediate_view
    # in folder listings (and batch mode).  This is important for types like
    # Image and File.
    propTool = getToolByName(portal, 'portal_properties', None)
    if propTool is not None:
        propSheet = getattr(propTool, 'site_properties', None)
        if propSheet is not None:
            if not propSheet.hasProperty('typesUseViewActionInListings'):
                propSheet.manage_addProperty('typesUseViewActionInListings',
                                             ['Image','File'],
                                             'lines')
            print >> out, "Added 'typesUseViewActionInListings' property to site_properties."


def updateParentMetaTypesNotToQuery(portal, out):
    """Add Large Plone Folder to the list of types not to query"""
    props = getattr(portal, 'portal_properties', None)
    if props is not None:
        ntp = getattr(props, 'navtree_properties', None)
        if ntp is not None:
            val = ntp.getProperty('parentMetaTypesNotToQuery',None)
            if val is None:
                ntp.manage_addProperty('parentMetaTypesNotToQuery',
                                            ['Large Plone Folder'], 'lines')
                print >> out, "Added missing 'parentMetaTypesNotToQuery' property to navtree_properties"
            elif 'Large Plone Folder' not in val:
                ntp.manage_changeProperties(parentMetaTypesNotToQuery=list(val)+['Large Plone Folder'])
                print >> out, "Added 'Large Plone Folder' to 'parentMetaTypesNotToQuery' in navtree_properties"


def setupPlone20Compat(portal, out):
    switchPathIndex(portal, out)
    updateParentMetaTypesNotToQuery(portal, out)
    updateNavTreeProperties(portal, out)
    addWFStateFilteringToNavTree(portal, out)
    addTypesUseViewActionInListingsProperty(portal, out)

def install(self):
    out = StringIO()

    if not hasattr(self, '_isPortalRoot'):
        print >> out, 'Must be installed in a CMF Site (read Plone)'
        return out.getvalue()

    qi = getToolByName(self, 'portal_quickinstaller', None)

    if not qi.isProductInstalled('PloneLanguageTool'):
        print >> out, 'Installed PloneLanguageTool product.'
        qi.installProduct('PloneLanguageTool')

    installSkins(self, out)

    types = listTypes(config.PKG_NAME)
    if types:
        installTypes(self, out, types, config.PKG_NAME)
        print >> out, 'Successfully installed types.'

    catalogtool = getToolByName(self, 'portal_catalog')
    if 'Language' not in catalogtool.indexes():
        catalogtool.addIndex('Language', 'FieldIndex')
        print >> out, 'Added Language to portal catalogs indexes.'
        catalogtool.reindexIndex('Language', None)
        print >> out, 'Reindexed Language index.'

    if 'Language' not in catalogtool.schema():
        catalogtool.addColumn('Language')
        print >> out, 'Added Language to portal catalogs columns.'

    if config.IS_PLONE_2_0:
        setupPlone20Compat(self, out)

    return out.getvalue()
