/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;

public class ConvwatchGUI
extends JFrame {
    private ImageIcon[] m_aImageIcon;
    private String m_sInifile;
    private int m_nMaxPages;
    private int m_nCurrentPage;
    private boolean bAdd = false;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabelCurrentPage;
    private JLabel jLabelDifferenceImage;
    private JLabel jLabelDocumentName;
    private JLabel jLabelOriginalImage;
    private JLabel jLabelReferenceImage;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanelDifference;
    private JPanel jPanelOriginal;
    private JPanel jPanelReference;

    private ConvwatchGUI(String[] args) {
        String sVersion;
        Float f;
        if (args.length > 0) {
            if (args[0].endsWith(".ini")) {
                this.m_sInifile = args[0];
                this.fillImageIconsFromInifile();
            } else {
                this.fillImageIcons(args);
            }
        }
        if ((f = Float.valueOf((sVersion = System.getProperty("java.version")).substring(0, 3))).floatValue() < 1.6f) {
            System.out.println("You need at least Java version 1.6");
            System.exit(1);
        }
        this.initComponents();
        this.jLabelDocumentName.setText("Document: " + this.m_sInifile);
    }

    void fillImageIconsFromInifile() {
        IniFile aIniFile;
        int nPages;
        File aFile = new File(this.m_sInifile);
        if (!aFile.exists()) {
            GlobalLogWriter.println("Inifile '" + this.m_sInifile + "' not found.");
            this.printUsage();
            System.exit(1);
        }
        if ((nPages = (aIniFile = new IniFile(aFile)).getIntValue("global", "pages", 0)) < 1) {
            System.out.println("No pages found.");
        }
        this.m_nMaxPages = nPages;
        this.m_nCurrentPage = 1;
        this.fillImageIcons();
    }

    private void fillImageIcons() {
        File aFile = new File(this.m_sInifile);
        IniFile aIniFile = new IniFile(aFile);
        String sSection = "page" + this.m_nCurrentPage;
        String[] files = new String[]{aIniFile.getValue(sSection, "newgfx"), aIniFile.getValue(sSection, "oldgfx"), aIniFile.getValue(sSection, "diffgfx")};
        this.fillImageIcons(files);
    }

    private void fillImageIcons(String[] args) {
        boolean bLoadImages = false;
        this.m_aImageIcon = new ImageIcon[3];
        for (int i = 0; i < 3; ++i) {
            if (args.length > i && args[i] != null) {
                File aFile = new File(args[i]);
                if (aFile.exists()) {
                    this.m_aImageIcon[i] = new ImageIcon(args[i]);
                    if (this.m_aImageIcon[i] == null) continue;
                    bLoadImages = true;
                    continue;
                }
                System.out.println("Can't read file: " + aFile.getName());
                bLoadImages = false;
                continue;
            }
            System.out.println("There is no #" + (i + 1) + " image given.");
            bLoadImages = false;
        }
    }

    private void printUsage() {
        System.out.println("Usage:");
        System.out.println("   ConvwatchGUI <pic1> <pic2> <pic3>");
        System.out.println("or ConvwatchGUI <inifile>");
    }

    private void initComponents() {
        this.jPanelOriginal = new JPanel();
        this.jLabelOriginalImage = new JLabel();
        this.jPanelReference = new JPanel();
        this.jLabelReferenceImage = new JLabel();
        this.jPanelDifference = new JPanel();
        this.jLabelDifferenceImage = new JLabel();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLabelCurrentPage = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabelDocumentName = new JLabel();
        this.setDefaultCloseOperation(3);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ConvwatchGUI.this.formComponentResized(evt);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ConvwatchGUI.this.formPropertyChange(evt);
            }
        });
        this.jPanelOriginal.setBorder(BorderFactory.createTitledBorder("Picture"));
        GroupLayout jPanelOriginalLayout = new GroupLayout(this.jPanelOriginal);
        this.jPanelOriginal.setLayout(jPanelOriginalLayout);
        jPanelOriginalLayout.setHorizontalGroup(jPanelOriginalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOriginalLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelOriginalImage, -1, 299, Short.MAX_VALUE).addContainerGap()));
        jPanelOriginalLayout.setVerticalGroup(jPanelOriginalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOriginalLayout.createSequentialGroup().addComponent(this.jLabelOriginalImage, -1, 514, Short.MAX_VALUE).addContainerGap()));
        this.jPanelReference.setBorder(BorderFactory.createTitledBorder("Reference Picture"));
        GroupLayout jPanelReferenceLayout = new GroupLayout(this.jPanelReference);
        this.jPanelReference.setLayout(jPanelReferenceLayout);
        jPanelReferenceLayout.setHorizontalGroup(jPanelReferenceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelReferenceLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelReferenceImage, -1, 299, Short.MAX_VALUE).addContainerGap()));
        jPanelReferenceLayout.setVerticalGroup(jPanelReferenceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelReferenceLayout.createSequentialGroup().addComponent(this.jLabelReferenceImage, -1, 514, Short.MAX_VALUE).addContainerGap()));
        this.jPanelDifference.setBorder(BorderFactory.createTitledBorder("Difference"));
        this.jLabelDifferenceImage.setName("DifferenceImage");
        GroupLayout jPanelDifferenceLayout = new GroupLayout(this.jPanelDifference);
        this.jPanelDifference.setLayout(jPanelDifferenceLayout);
        jPanelDifferenceLayout.setHorizontalGroup(jPanelDifferenceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDifferenceLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelDifferenceImage, -1, 298, Short.MAX_VALUE).addContainerGap()));
        jPanelDifferenceLayout.setVerticalGroup(jPanelDifferenceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDifferenceLayout.createSequentialGroup().addComponent(this.jLabelDifferenceImage, -1, 514, Short.MAX_VALUE).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Action"));
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvwatchGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setLabel("prev page");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvwatchGUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setLabel("next page");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvwatchGUI.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabelCurrentPage.setText("Current page: 1");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addGap(18, 18, 18).addComponent(this.jLabelCurrentPage, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 614, Short.MAX_VALUE).addComponent(this.jButton1).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jButton3).addComponent(this.jLabelCurrentPage)).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Information"));
        this.jLabel1.setText("<html>Here you see a graphical compare by pictures created with a current running office, a stored reference picture and the difference between those both pictures created by ImageMagicks 'composite'.\n</html>");
        this.jLabelDocumentName.setText("jLabel2");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, 972, Short.MAX_VALUE).addComponent(this.jLabelDocumentName, GroupLayout.Alignment.LEADING, -1, 972, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel1, -1, 50, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDocumentName, -2, 19, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanelOriginal, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelReference, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelDifference, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelReference, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelOriginal, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelDifference, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.initialiseImages();
    }

    private void initialiseImages() {
        if (this.jLabelOriginalImage.getIcon() != null) {
            this.jLabelOriginalImage.setIcon(null);
            this.jLabelReferenceImage.setIcon(null);
            this.jLabelDifferenceImage.setIcon(null);
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.bAdd) {
                this.setSize(w, h + 1);
                this.bAdd = false;
            } else {
                this.setSize(w, h - 1);
                this.bAdd = true;
            }
        } else {
            new ResizeImage(this.jLabelOriginalImage, this.m_aImageIcon[0]).execute();
            new ResizeImage(this.jLabelReferenceImage, this.m_aImageIcon[1]).execute();
            new ResizeImage(this.jLabelDifferenceImage, this.m_aImageIcon[2]).execute();
        }
        boolean dummy = false;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        System.exit(1);
    }

    private void formPropertyChange(PropertyChangeEvent evt) {
        boolean dummy = false;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int nOldPage = this.m_nCurrentPage;
        if (this.m_nCurrentPage > 1) {
            --this.m_nCurrentPage;
        }
        if (nOldPage != this.m_nCurrentPage) {
            this.jLabelCurrentPage.setText("Current page: " + this.m_nCurrentPage);
            this.fillImageIcons();
            this.initialiseImages();
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        int nOldPage = this.m_nCurrentPage;
        if (this.m_nCurrentPage < this.m_nMaxPages) {
            ++this.m_nCurrentPage;
        }
        if (nOldPage != this.m_nCurrentPage) {
            this.jLabelCurrentPage.setText("Current page: " + this.m_nCurrentPage);
            this.fillImageIcons();
            this.initialiseImages();
        }
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ConvwatchGUI aGUI = new ConvwatchGUI(args);
                aGUI.setTitle("Graphical Compare");
                aGUI.setPreferredSize(new Dimension(1024, 768));
                aGUI.setVisible(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResizeImage
    extends SwingWorker<ImageIcon, Object> {
        private JLabel m_jLabel;
        private ImageIcon m_aImageIcon;
        private int w;
        private int h;

        public ResizeImage(JLabel _aLabel, ImageIcon _aImageIcon) {
            this.m_jLabel = _aLabel;
            this.m_aImageIcon = _aImageIcon;
            this.w = _aLabel.getWidth();
            this.h = _aLabel.getHeight();
        }

        @Override
        public ImageIcon doInBackground() {
            Image aImage = this.m_aImageIcon.getImage().getScaledInstance(this.w, this.h, 16);
            ImageIcon aIcon = new ImageIcon(aImage);
            return aIcon;
        }

        @Override
        protected void done() {
            try {
                this.m_jLabel.setIcon((Icon)this.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

