// -*- C++ -*-
/**
 * \file math_phantominset.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Georg Baum
 *
 * Full author contact details are available in file CREDITS.
 */

#ifndef MATH_PHANTOMINSET_H
#define MATH_PHANTOMINSET_H

#include "math_nestinset.h"

class MathPhantomInset : public MathNestInset {
public:
	///
	enum Kind {
		phantom,
		vphantom,
		hphantom
	};
	///
	explicit MathPhantomInset(Kind);
	///
	void metrics(MetricsInfo & mi, Dimension & dim) const;
	///
	void draw(PainterInfo & pi, int x, int y) const;
	///
	void write(WriteStream & os) const;
	/// write normalized content
	void normalize(NormalStream & ns) const;
	///
	void infoize(std::ostream & os) const;
private:
	///
	virtual std::auto_ptr<InsetBase> doClone() const;
	///
	Kind kind_;
};

#endif
