#!/bin/sh

die() {
    echo "$@"
    exit 1
}

# Try to locate a program by using which, and verify that the file is an
# executable
locate_binary() {
  for f in $@
  do
    file=`which $f 2>/dev/null | grep -v '^no '`
    if test -n "$file" -a -x "$file"; then
      echo $file
      return 0
    fi
  done

  echo ""
  return 1
}

autogen() {

  echo "libtoolize..."
  if test x$LIBTOOLIZE = x; then
    LIBTOOLIZE=`locate_binary libtoolize glibtoolize`
    if test x$LIBTOOLIZE = x; then
      die "Did not find a supported libtoolize"
    fi
  fi
  $LIBTOOLIZE --force || exit 1

  echo "aclocal..."
  if test x$ACLOCAL = x; then
    ACLOCAL=`locate_binary aclocal aclocal-1.11 aclocal-1.10 aclocal-1.9 aclocal19 aclocal-1.7 aclocal17 aclocal-1.5 aclocal15`
    if test x$ACLOCAL = x; then
      die "Did not find a supported aclocal"
    fi
  fi
  $ACLOCAL || exit 1

  echo "autoheader..."
  AUTOHEADER=${AUTOHEADER:-autoheader}
  $AUTOHEADER || exit 1

  echo "automake..."
  if test x$AUTOMAKE = x; then
    AUTOMAKE=`locate_binary automake automake-1.14 automake-1.13 automake-1.12 automake-1.11 automake-1.10 automake-1.9 automake-1.7`
    if test x$AUTOMAKE = x; then
      die "Did not find a supported automake"
    fi
  fi
  $AUTOMAKE --foreign --add-missing || $AUTOMAKE --gnu --add-missing || exit 1

  echo "autoconf..."
  AUTOCONF=${AUTOCONF:-autoconf}
  $AUTOCONF || exit 1

}

echo "== bootstraping yara"

if [ ! -d m4 ]; then
  echo "mkdir m4..."
  mkdir m4
fi

autogen
