/*
                               Sound Server IO
 */

#ifndef SOUND_H
#define SOUND_H


#include <sys/types.h>


/*
 *	Sound flags type:
 */
#define snd_flags_t	unsigned int


/*
 *	Sound play options:
 */
#define SND_PLAY_OPTION_MUTE		(1 << 0)
#define SND_PLAY_OPTION_REPEATING	(1 << 1)


/*
 *	Recorder )sound server) structure:
 */
typedef struct {

#define SNDSERV_TYPE_NONE	0
#define SNDSERV_TYPE_Y		1

	/* Sound server type, one of SNDSERV_TYPE_*. */
	int type;

	/* Pointer to connection to sound server. */
	void *con;

	/* Current Audio parameters. */
	int sample_rate;
	int sample_size;
	int channels;
	int bytes_per_cycle;

	/* Current music sound object being played (NULL for none). */
	void *cur_music_sndobj;

	/* Our code to indicate what background music is being played
	 * (see SAR_MUSIC_CODE_* in sar.h).
	 * -1 is reserved to indicate none or undefined.
	 */
	int cur_music_code;

} snd_recorder_struct;


/*
 *	Sound object play structure:
 */
typedef struct {

	/* Pointer to sound server specific play id. */
	void *data;

	/* Last set volume (from 0.0 to 1.0). This is used to check
	 * if sound play values actually need to be adjusted when
	 * requested.
	 */
	double volume_left, volume_right;

	/* Applied sample rate. */
	int sample_rate;

	/* Play options. */
	snd_flags_t options;

} snd_play_struct;



extern snd_recorder_struct *SoundInit(
	int type,
        const char *connect_arg,
        const char *start_arg
);
extern int SoundManageEvents(snd_recorder_struct *recorder);
extern void SoundShutdown(snd_recorder_struct *recorder);

extern int SoundChangeMode(
	snd_recorder_struct *recorder,
	const char *arg
);

extern snd_play_struct *SoundStartPlay(
	snd_recorder_struct *recorder,
	const char *object,	/* Full path to object. */
	double volume_left,	/* Volume, from 0.0 to 1.0. */
	double volume_right,
	int sample_rate,	/* Applied sample rate, can be 0. */
	snd_flags_t options	/* Any of SND_PLAY_OPTION_*. */
);
extern void SoundStartPlayVoid(
        snd_recorder_struct *recorder,
        const char *object,	/* Full path to object. */
        double volume_left,     /* Volume, from 0.0 to 1.0. */
        double volume_right,
        int sample_rate,        /* Applied sample rate, can be 0. */
        snd_flags_t options     /* Any of SND_PLAY_OPTION_*. */
);
extern void SoundPlayMute(
        snd_recorder_struct *recorder,
        snd_play_struct *snd_play,
        int mute  
);
extern void SoundChangePlayVolume(
	snd_recorder_struct *recorder,
	snd_play_struct *snd_play,
	double volume_left,	/* Volume, from 0.0 to 1.0. */
        double volume_right
);
extern void SoundChangePlaySampleRate(
        snd_recorder_struct *recorder,
        snd_play_struct *snd_play,
	int sample_rate		/* Applied sample rate, can be 0. */
);
extern void SoundStopPlay(
	snd_recorder_struct *recorder,
	snd_play_struct *snd_play
);

extern int SoundChangeBackgroundMusic(
	snd_recorder_struct *recorder,
	const char *object,
	snd_flags_t options
);
extern void SoundStopBackgroundMusic(
	snd_recorder_struct *recorder
);

#endif	/* SOUND_H */
