/*
                    SAR Simulation Utility Functions
 */

#ifndef SIMUTILS_H
#define SIMUTILS_H

#include <sys/types.h>
#include "sfm.h"
#include "obj.h"
#include "sar.h"

extern double SARSimGetFlatContactRadius(sar_object_struct *obj_ptr);
extern sar_object_struct *SARSimMatchObjectFromFDM(
        sar_object_struct **list, int total,
        SFMModelStruct *fdm, int *index
);
extern double SARSimThrottleOutputCoeff(
        int flight_model_type,
        double throttle,
        double collective, double collective_range
);

extern void SARSimWarpObjectRelative(   
        sar_scene_struct *scene, sar_object_struct *obj_ptr,
        sar_object_struct **ptr, int total, int ref_obj_num,
        sar_position_struct *offset_pos,
        sar_direction_struct *offset_dir
);
extern void SARSimWarpObject(
        sar_scene_struct *scene, sar_object_struct *obj_ptr,
        sar_position_struct *new_pos,
        sar_direction_struct *new_dir
);
extern int SARSimGetLandingGearState(sar_object_struct *obj_ptr);
extern void SARSimUpdateLandingGear(sar_obj_landing_gear_struct *lgear_ptr);
extern void SARSimOpLandingGear(
	sar_scene_struct *scene,
        sar_object_struct ***ptr,
        int *total,
	sar_object_struct *obj_ptr,
	int gear_state
);
extern void SARSimUpdateDoor(sar_obj_door_struct *door_ptr);
extern void SARSimOpDoor(
        sar_scene_struct *scene,
        sar_object_struct ***ptr,
        int *total,
        sar_object_struct *obj_ptr,
        int state
);

extern void SARSimRotorUpdateControls(
        sar_obj_rotor_struct *rotor_ptr,
        double pitch, double bank
);

extern int SARSimGetEngineState(sar_object_struct *obj_ptr);
extern void SARSimOpEngine(
	sar_scene_struct *scene,
	sar_object_struct ***ptr, 
        int *total,
	sar_object_struct *obj_ptr,
        int engine_state
);

extern int SARSimGetLightsState(sar_object_struct *obj_ptr);
extern void SARSimOpLights( 
        sar_scene_struct *scene,
        sar_object_struct ***ptr,
        int *total,
        sar_object_struct *obj_ptr,
        int state
);
extern int SARSimGetStrobesState(sar_object_struct *obj_ptr);
extern void SARSimOpStrobes(
        sar_scene_struct *scene,
        sar_object_struct ***ptr,
        int *total,
        sar_object_struct *obj_ptr,
        int state
);
extern int SARSimGetAttenuate(sar_object_struct *obj_ptr);
extern void SARSimOpAttenuate(
        sar_scene_struct *scene,
        sar_object_struct ***ptr, 
        int *total,
        sar_object_struct *obj_ptr,
        int state
);

extern int SARSimOpRepair(
        sar_scene_struct *scene, sar_object_struct *obj_ptr
);
extern int SARSimOpRefuel(
        sar_scene_struct *scene, sar_object_struct *obj_ptr
);

extern int SARSimOpPassengersSetLeave(
        sar_scene_struct *scene, sar_object_struct *obj_ptr,
        int passengers_leave_pending, int passengers_drop_pending
);
extern int SARSimOpPassengersUnloadAll(
        sar_scene_struct *scene, sar_object_struct *obj_ptr
);

extern double SARSimOpTransferFuelFromTanks(
        sar_scene_struct *scene, sar_object_struct *obj_ptr
);

extern int SARSimOpDropFuelTankNext(  
        sar_scene_struct *scene,
        sar_object_struct ***ptr, int *total,
        int obj_num, sar_object_struct *obj_ptr
);

extern void SARSimSmokeSpawn(
        sar_core_struct *core_ptr, sar_object_struct *obj_ptr
);

extern int SARSimIsSlew(sar_object_struct *obj_ptr);
extern void SARSimSetSlew(
	sar_object_struct *obj_ptr, int enter_slew
);

extern int SARSimDoPickUpHuman(
	sar_scene_struct *scene,
        sar_object_struct *obj_ptr,
	sar_object_human_struct *obj_human_ptr,
	int human_obj_num
);
extern int SARSimDoHoistIn(
        sar_core_struct *core_ptr,
        sar_object_struct *obj_ptr 
);
extern int SARSimBoardObject(
        sar_core_struct *core_ptr,
        sar_object_struct *tar_obj_ptr, int src_obj_num
);

extern void SARSimSetFlyByPosition(
        sar_scene_struct *scene,
        sar_object_struct ***ptr,   
        int *total,
        sar_object_struct *obj_ptr,
        sar_position_struct *pos_result
);


#endif	/* SIMUTILS_H */
