/*
                              Image Structure
 */

#ifndef IMAGE_H
#define IMAGE_H

#include <sys/types.h>

/*
 *	Image structure:
 */
typedef struct {

#define SAR_IMAGE_TYPE_RGBA		0
#define SAR_IMAGE_TYPE_RGB		1
#define SAR_IMAGE_TYPE_LUMINANCE	2
	int type;	/* One of SAR_IMAGE_TYPE_*. */

	int width, height;

	u_int8_t *data;

} sar_image_struct;


/* In image.c */
extern sar_image_struct *SARImageLoadFromFile(const char *file);
extern void SARImageDestroy(sar_image_struct *image);

extern void SARImageDraw(
	gw_display_struct *display,
	const sar_image_struct *image,
	int x, int y,
	int width, int height
);



#endif	/* IMAGE_H */
