/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.3:
 *   smidump -f scli CISCO-DOT11-ASSOCIATION-MIB
 *
 * Derived from CISCO-DOT11-ASSOCIATION-MIB:
 *   This MIB module provides network management 
 *   information on IEEE 802.11 wireless device 
 *   association management and data packet forwarding 
 *   configuration and statistics.  This MIB is an
 *   extension to the IEEE802dot11-MIB and provides
 *   per client based information.  
 *   
 *   The IEEE802dot11-MIB is defined in the IEEE Std 
 *   802.11-Jan 14 1999, Wireless LAN Medium Access 
 *   Control and Physical Layer Specifications, by the
 *   LAN MAN Standards Committee of the IEEE Computer
 *   Society.
 *   
 *   
 *             GLOSSARY and ACRONYMS 
 *   
 *   Access point (AP)   
 *       Transmitter/receiver (transceiver) device
 *       that commonly connects and transports data 
 *       between a wireless network and a wired network.
 *   
 *   Association
 *       The service used to establish access point
 *       or station mapping and enable STA invocation
 *       of the distribution system serivces.
 *       (Wireless clients attempt to connect to 
 *       access points.)
 *   
 *   Bridge    
 *       Device that connects two or more segments 
 *       and reduces traffic by analyzing the 
 *       destination address, filtering the frame,
 *       and forwarding the frame to all connected 
 *       segments.
 *   
 *   Bridge AP 
 *       It is an AP that functions as a transparent 
 *       bridge between 2 wired LAN segments.  
 *   
 *   Bridge Host     
 *       This is also known as Work Group Bridge.  This
 *       is a non-root bridge that is connected to a
 *       remote LAN segment and will only communicate 
 *       with repeaters or root bridges.  It does not 
 *       accept association from other wireless devices.
 *   
 *   BSS	
 *       IEEE 802.11 Basic Service Set (Radio Cell).  The
 *       BSS of an AP comprises of the stations directly 
 *       associated with the AP.
 *   
 *   Client (Client Station)    
 *       A wireless device in a wireless network 
 *       associated with an access point.
 *   
 *   IEEE 802.11    
 *       Standard to encourage interoperability among 
 *       wireless networking equipment.
 *   
 *   MIC	
 *       Message Integrity Check.  A MIC can, optionally, 
 *       be added to WEP-encrypted 802.11 frames.
 *   
 *   Non-Root Bridge   
 *       This wireless bridge does not connect to the main
 *       wired LAN segment.  It connects to a remote wired 
 *       LAN segment and can associate to root bridges and
 *       other non-root bridges that accept client 
 *       associations.  It also can accept associations 
 *       from other non-root bridges, repeater access 
 *       points, and client devices.
 *   
 *   Repeater    
 *       Device that connects multiple segments, listening 
 *       to each and repeating signal on one to every other 
 *       connected one; regenerates each transmission 
 *       so that it can travel farther.
 *   
 *   Repeater or Non-root Access Point    
 *       The repeater access point is not connected 
 *       to the wired LAN.  The Repeater is a wireless 
 *       LAN transceiver that transfers data between 
 *       a client and another access point, another 
 *       repeater, or between two bridges.  The repeater 
 *       is placed within radio range of an access point 
 *       connected to the wired LAN, another repeater, or 
 *       an non-root bridge to extend the range of the 
 *       infrastructure.
 *   
 *   Root Access Point    
 *       This access point connects clients to the main 
 *       wired LAN.
 *   
 *   Root Wireless Bridge    
 *       This wireless bridge is connected to the main 
 *       wired LAN.  This wireless bridge can communicate
 *       with non-root wireless bridges, repeater access
 *       points, and client devices but not with another 
 *       wireless root bridge.  Only one wireless bridge
 *       in a wireless LAN can be set as the wireless 
 *       root bridge.  
 *   
 *   SSID
 *       Radio Service Set ID.  It is used for identification
 *       during association.
 *   
 *   STA (WSTA)	
 *       A non-AP 802.11 wireless station.
 *   
 *   WEP	
 *       Wired Equivalent Privacy.  'WEP' is generally used
 *       to refer to 802.11 encryption.
 *   
 *   Work Group Bridges (WGB)
 *       See bridge host.
 *
 * Revision 2003-07-27 00:00:
 *   Added new IEEE 802.11g radio type to 
 *   CDot11ClientRadioType and new AP device type to 
 *   CDot11ClientDevType.
 *
 * Revision 2003-04-11 00:00:
 *   Added new objects for client software version, IP 
 *   address, name, and association or autentication state.
 *
 * Revision 2003-01-29 00:00:
 *   Added new 5GHz radio type to CDot11ClientRadioType
 *   and new client types to CDot11ClientDevType.
 *
 * Revision 2002-07-15 00:00:
 *   Corrected the unit of cDot11ClientBytesReceived.
 *
 * Revision 2002-04-17 00:00:
 *   Added a new index cd11IfAuxSsid and a new object 
 *   cDot11ClientParentAddress to the 
 *   cDot11ClientConfigInfoTable.
 *
 * Revision 2002-03-06 00:00:
 *   Initial version of this MIB module.
 *
 * $Id: cisco-dot11-association-mib.c 1994 2006-08-22 21:57:59Z schoenw $
 */

#include "cisco-dot11-association-mib.h"

GNetSnmpEnum const cisco_dot11_association_mib_enums_cDot11ClientPowerSaveMode[] = {
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPOWERSAVEMODE_ACTIVE,    "active" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPOWERSAVEMODE_POWERSAVE, "powersave" },
    { 0, NULL }
};

GNetSnmpEnum const cisco_dot11_association_mib_enums_cDot11ClientAssociationState[] = {
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE_INITIAL,                "initial" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE_AUTHENNOTASSOCIATED,    "authenNotAssociated" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE_ASSOCANDAUTHENTICATED,  "assocAndAuthenticated" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE_ASSOCNOTANUTHENTICATED, "assocNotAnuthenticated" },
    { 0, NULL }
};

GNetSnmpEnum const cisco_dot11_association_mib_enums_CDot11ClientRoleClassType[] = {
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_CLIENTSTATION,  "clientStation" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_REPEATER,       "repeater" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_ACCESSPOINT,    "accessPoint" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_BRIDGEHOST,     "bridgeHost" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_BRIDGE,         "bridge" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_BRIDGEROOT,     "bridgeRoot" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_ETHERNETCLIENT, "ethernetClient" },
    { 0, NULL }
};

GNetSnmpEnum const cisco_dot11_association_mib_enums_CDot11ClientDevType[] = {
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_ETHERNETAP,         "ethernetAP" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_ETHERNETBRIDGE,     "ethernetBridge" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC3000CLIENT,       "pc3000Client" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_SERIALUC,           "serialUC" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_ETHERNETUC,         "ethernetUC" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC3500CLIENT,       "pc3500Client" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC4500CLIENT,       "pc4500Client" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_GENERIC80211CLIENT, "generic80211Client" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC4800CLIENT,       "pc4800Client" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC3100CLIENT,       "pc3100Client" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_MC,                 "mc" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_ETHERNETCLIENT,     "ethernetClient" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC4800BCLIENT,      "pc4800bClient" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_WGBNODIVERSITY,     "wgbNoDiversity" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_WGB,                "wgb" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_SERIES350CLIENT,    "series350Client" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_SERIES370CLIENT,    "series370Client" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_C1100SERIESAP,      "c1100SeriesAP" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_C1410SERIESBRIDGE,  "c1410SeriesBridge" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_C1200SERIESAP,      "c1200SeriesAP" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_MP2XCLIENT,         "mp2xClient" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_C350SERIESAP,       "c350SeriesAP" },
    { 0, NULL }
};

GNetSnmpEnum const cisco_dot11_association_mib_enums_CDot11ClientRadioType[] = {
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC3500,     "pc3500" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC3000,     "pc3000" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC4500,     "pc4500" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC4800,     "pc4800" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC3100,     "pc3100" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_SERIES340,  "series340" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_SERIES350,  "series350" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_SERIES370,  "series370" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_BRIDGE1410, "bridge1410" },
    { CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_MP2XSERIES, "mp2xSeries" },
    { 0, NULL }
};


static guint16 cDot11ParentAddress_constraints[] = {6U, 6U, 0, 0};
static guint32 cDot11ActiveWirelessClients_constraints[] = {0UL, 2007UL, 0, 0};
static guint32 cDot11ActiveBridges_constraints[] = {0UL, 2007UL, 0, 0};
static guint32 cDot11ActiveRepeaters_constraints[] = {0UL, 2007UL, 0, 0};
static guint16 cDot11ClientParentAddress_constraints[] = {6U, 6U, 0, 0};
static guint32 cDot11ClientAid_constraints[] = {0UL, 2008UL, 0, 0};
static guint16 cDot11ClientDataRateSet_constraints[] = {1U, 126U, 0, 0};
static guint16 cDot11ClientSoftwareVersion_constraints[] = {0U, 255U, 0, 0};
static guint16 cDot11ClientName_constraints[] = {0U, 255U, 0, 0};
static guint16 cDot11ClientIpAddress_constraints[] = {0U, 255U, 0, 0};
static guint16 cDot11ClientCurrentTxRateSet_constraints[] = {1U, 126U, 0, 0};
static gint32 cDot11ClientSignalStrength_constraints[] = {-100L, 0L, 0, 0};
static guint32 cDot11ClientSigQuality_constraints[] = {0UL, 100UL, 0, 0};


static guint32 const cDot11AssociationGlobal_oid[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 1};

static GNetSnmpAttribute cDot11AssociationGlobal_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11PARENTADDRESS, "cDot11ParentAddress",
       cDot11ParentAddress_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11AssociationGlobal_t, cDot11ParentAddress),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const cDot11ActiveDevicesEntry_oid[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 1, 2, 1};

static GNetSnmpAttribute cDot11ActiveDevicesEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ACTIVEWIRELESSCLIENTS, "cDot11ActiveWirelessClients",
       cDot11ActiveWirelessClients_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t, cDot11ActiveWirelessClients),
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ACTIVEBRIDGES, "cDot11ActiveBridges",
       cDot11ActiveBridges_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t, cDot11ActiveBridges),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ACTIVEREPEATERS, "cDot11ActiveRepeaters",
       cDot11ActiveRepeaters_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t, cDot11ActiveRepeaters),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const cDot11AssociationStatsEntry_oid[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 1, 3, 1};

static GNetSnmpAttribute cDot11AssociationStatsEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSASSOCIATED, "cDot11AssStatsAssociated",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t, cDot11AssStatsAssociated),
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSAUTHENTICATED, "cDot11AssStatsAuthenticated",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t, cDot11AssStatsAuthenticated),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSROAMEDIN, "cDot11AssStatsRoamedIn",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t, cDot11AssStatsRoamedIn),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSROAMEDAWAY, "cDot11AssStatsRoamedAway",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t, cDot11AssStatsRoamedAway),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSDEAUTHENTICATED, "cDot11AssStatsDeauthenticated",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t, cDot11AssStatsDeauthenticated),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSDISASSOCIATED, "cDot11AssStatsDisassociated",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t, cDot11AssStatsDisassociated),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const cDot11ClientConfigInfoEntry_oid[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 2, 1, 1};

static GNetSnmpAttribute cDot11ClientConfigInfoEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPARENTADDRESS, "cDot11ClientParentAddress",
       cDot11ClientParentAddress_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientParentAddress),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE, "cDot11ClientRoleClassType",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientRoleClassType),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE, "cDot11ClientDevType",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientDevType),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE, "cDot11ClientRadioType",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientRadioType),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTWEPENABLED, "cDot11ClientWepEnabled",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientWepEnabled),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTWEPKEYMIXENABLED, "cDot11ClientWepKeyMixEnabled",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientWepKeyMixEnabled),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMICENABLED, "cDot11ClientMicEnabled",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientMicEnabled),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPOWERSAVEMODE, "cDot11ClientPowerSaveMode",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientPowerSaveMode),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTAID, "cDot11ClientAid",
       cDot11ClientAid_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientAid),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDATARATESET, "cDot11ClientDataRateSet",
       cDot11ClientDataRateSet_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientDataRateSet),
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, _cDot11ClientDataRateSetLength),
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTSOFTWAREVERSION, "cDot11ClientSoftwareVersion",
       cDot11ClientSoftwareVersion_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientSoftwareVersion),
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, _cDot11ClientSoftwareVersionLength),
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTNAME, "cDot11ClientName",
       cDot11ClientName_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientName),
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, _cDot11ClientNameLength),
      0 },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE, "cDot11ClientAssociationState",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientAssociationState),
      0,
      0 },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTIPADDRESSTYPE, "cDot11ClientIpAddressType",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientIpAddressType),
      0,
      0 },
    { 16, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTIPADDRESS, "cDot11ClientIpAddress",
       cDot11ClientIpAddress_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, cDot11ClientIpAddress),
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t, _cDot11ClientIpAddressLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const cDot11ClientStatisticEntry_oid[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 3, 1, 1};

static GNetSnmpAttribute cDot11ClientStatisticEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTCURRENTTXRATESET, "cDot11ClientCurrentTxRateSet",
       cDot11ClientCurrentTxRateSet_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientCurrentTxRateSet),
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, _cDot11ClientCurrentTxRateSetLength),
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTUPTIME, "cDot11ClientUpTime",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientUpTime),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTSIGNALSTRENGTH, "cDot11ClientSignalStrength",
       cDot11ClientSignalStrength_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientSignalStrength),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTSIGQUALITY, "cDot11ClientSigQuality",
       cDot11ClientSigQuality_constraints,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientSigQuality),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTAGINGLEFT, "cDot11ClientAgingLeft",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientAgingLeft),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPACKETSRECEIVED, "cDot11ClientPacketsReceived",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientPacketsReceived),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTBYTESRECEIVED, "cDot11ClientBytesReceived",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientBytesReceived),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPACKETSSENT, "cDot11ClientPacketsSent",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientPacketsSent),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTBYTESSENT, "cDot11ClientBytesSent",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientBytesSent),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDUPLICATES, "cDot11ClientDuplicates",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientDuplicates),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMSDURETRIES, "cDot11ClientMsduRetries",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientMsduRetries),
      0,
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMSDUFAILS, "cDot11ClientMsduFails",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientMsduFails),
      0,
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTWEPERRORS, "cDot11ClientWepErrors",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientWepErrors),
      0,
      0 },
    { 14, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMICERRORS, "cDot11ClientMicErrors",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientMicErrors),
      0,
      0 },
    { 15, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMICMISSINGFRAMES, "cDot11ClientMicMissingFrames",
       NULL,
      G_STRUCT_OFFSET(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t, cDot11ClientMicMissingFrames),
      0,
      0 },
    { 0, 0, 0, NULL }
};


cisco_dot11_association_mib_cDot11AssociationGlobal_t *
cisco_dot11_association_mib_new_cDot11AssociationGlobal()
{
    cisco_dot11_association_mib_cDot11AssociationGlobal_t *cDot11AssociationGlobal;

    cDot11AssociationGlobal = (cisco_dot11_association_mib_cDot11AssociationGlobal_t *) g_malloc0(sizeof(cisco_dot11_association_mib_cDot11AssociationGlobal_t) + sizeof(gpointer));
    return cDot11AssociationGlobal;
}

static inline cisco_dot11_association_mib_cDot11AssociationGlobal_t *
assign_cDot11AssociationGlobal(GList *vbl)
{
    cisco_dot11_association_mib_cDot11AssociationGlobal_t *cDot11AssociationGlobal;
    char *p;

    cDot11AssociationGlobal = cisco_dot11_association_mib_new_cDot11AssociationGlobal();
    p = (char *) cDot11AssociationGlobal + sizeof(cisco_dot11_association_mib_cDot11AssociationGlobal_t);
    * (GList **) p = vbl;

    gnet_snmp_attr_assign(vbl, cDot11AssociationGlobal_oid, G_N_ELEMENTS(cDot11AssociationGlobal_oid),
                      cDot11AssociationGlobal_attr, cDot11AssociationGlobal);

    return cDot11AssociationGlobal;
}

void
cisco_dot11_association_mib_get_cDot11AssociationGlobal(GNetSnmp *s, cisco_dot11_association_mib_cDot11AssociationGlobal_t **cDot11AssociationGlobal, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 1, 0};

    *cDot11AssociationGlobal = NULL;

    gnet_snmp_attr_get(s, &in, base, 12, 11, cDot11AssociationGlobal_attr, mask);

    out = gnet_snmp_sync_getnext(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *cDot11AssociationGlobal = assign_cDot11AssociationGlobal(out);
    }
}

void
cisco_dot11_association_mib_free_cDot11AssociationGlobal(cisco_dot11_association_mib_cDot11AssociationGlobal_t *cDot11AssociationGlobal)
{
    GList *vbl;
    char *p;

    if (cDot11AssociationGlobal) {
        p = (char *) cDot11AssociationGlobal + sizeof(cisco_dot11_association_mib_cDot11AssociationGlobal_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(cDot11AssociationGlobal);
    }
}

cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *
cisco_dot11_association_mib_new_cDot11ActiveDevicesEntry()
{
    cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *cDot11ActiveDevicesEntry;

    cDot11ActiveDevicesEntry = (cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *) g_malloc0(sizeof(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t) + sizeof(gpointer));
    return cDot11ActiveDevicesEntry;
}

static inline int
unpack_cDot11ActiveDevicesEntry(GNetSnmpVarBind *vb, cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *cDot11ActiveDevicesEntry)
{
    guint8 idx = 14;

    if (vb->oid_len < idx) return -1;
    cDot11ActiveDevicesEntry->ifIndex = vb->oid[idx++];
    if ((cDot11ActiveDevicesEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_cDot11ActiveDevicesEntry(guint32 *base, gint32 ifIndex)
{
    guint8 idx = 14;

    base[idx++] = ifIndex;
    return idx;
}

static inline cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *
assign_cDot11ActiveDevicesEntry(GList *vbl)
{
    cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *cDot11ActiveDevicesEntry;
    char *p;

    cDot11ActiveDevicesEntry = cisco_dot11_association_mib_new_cDot11ActiveDevicesEntry();
    p = (char *) cDot11ActiveDevicesEntry + sizeof(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t);
    * (GList **) p = vbl;

    if (unpack_cDot11ActiveDevicesEntry((GNetSnmpVarBind *) vbl->data, cDot11ActiveDevicesEntry) < 0) {
        g_warning("%s: invalid instance identifier", "cDot11ActiveDevicesEntry");
        g_free(cDot11ActiveDevicesEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, cDot11ActiveDevicesEntry_oid, G_N_ELEMENTS(cDot11ActiveDevicesEntry_oid),
                      cDot11ActiveDevicesEntry_attr, cDot11ActiveDevicesEntry);

    return cDot11ActiveDevicesEntry;
}

void
cisco_dot11_association_mib_get_cDot11ActiveDevicesTable(GNetSnmp *s, cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t ***cDot11ActiveDevicesEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 1, 2, 1, 0};

    *cDot11ActiveDevicesEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 14, 13, cDot11ActiveDevicesEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *cDot11ActiveDevicesEntry = (cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*cDot11ActiveDevicesEntry)[i] = assign_cDot11ActiveDevicesEntry(row->data);
        }
    }
}

void
cisco_dot11_association_mib_get_cDot11ActiveDevicesEntry(GNetSnmp *s, cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t **cDot11ActiveDevicesEntry, gint32 ifIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, cDot11ActiveDevicesEntry_oid, sizeof(cDot11ActiveDevicesEntry_oid));
    len = pack_cDot11ActiveDevicesEntry(base, ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "cDot11ActiveDevicesEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *cDot11ActiveDevicesEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 13, cDot11ActiveDevicesEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *cDot11ActiveDevicesEntry = assign_cDot11ActiveDevicesEntry(out);
    }
}

void
cisco_dot11_association_mib_free_cDot11ActiveDevicesEntry(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *cDot11ActiveDevicesEntry)
{
    GList *vbl;
    char *p;

    if (cDot11ActiveDevicesEntry) {
        p = (char *) cDot11ActiveDevicesEntry + sizeof(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(cDot11ActiveDevicesEntry);
    }
}

void
cisco_dot11_association_mib_free_cDot11ActiveDevicesTable(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t **cDot11ActiveDevicesEntry)
{
    int i;

    if (cDot11ActiveDevicesEntry) {
        for (i = 0; cDot11ActiveDevicesEntry[i]; i++) {
            cisco_dot11_association_mib_free_cDot11ActiveDevicesEntry(cDot11ActiveDevicesEntry[i]);
        }
        g_free(cDot11ActiveDevicesEntry);
    }
}

cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *
cisco_dot11_association_mib_new_cDot11AssociationStatsEntry()
{
    cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *cDot11AssociationStatsEntry;

    cDot11AssociationStatsEntry = (cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *) g_malloc0(sizeof(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t) + sizeof(gpointer));
    return cDot11AssociationStatsEntry;
}

static inline int
unpack_cDot11AssociationStatsEntry(GNetSnmpVarBind *vb, cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *cDot11AssociationStatsEntry)
{
    guint8 idx = 14;

    if (vb->oid_len < idx) return -1;
    cDot11AssociationStatsEntry->ifIndex = vb->oid[idx++];
    if ((cDot11AssociationStatsEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_cDot11AssociationStatsEntry(guint32 *base, gint32 ifIndex)
{
    guint8 idx = 14;

    base[idx++] = ifIndex;
    return idx;
}

static inline cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *
assign_cDot11AssociationStatsEntry(GList *vbl)
{
    cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *cDot11AssociationStatsEntry;
    char *p;

    cDot11AssociationStatsEntry = cisco_dot11_association_mib_new_cDot11AssociationStatsEntry();
    p = (char *) cDot11AssociationStatsEntry + sizeof(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t);
    * (GList **) p = vbl;

    if (unpack_cDot11AssociationStatsEntry((GNetSnmpVarBind *) vbl->data, cDot11AssociationStatsEntry) < 0) {
        g_warning("%s: invalid instance identifier", "cDot11AssociationStatsEntry");
        g_free(cDot11AssociationStatsEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, cDot11AssociationStatsEntry_oid, G_N_ELEMENTS(cDot11AssociationStatsEntry_oid),
                      cDot11AssociationStatsEntry_attr, cDot11AssociationStatsEntry);

    return cDot11AssociationStatsEntry;
}

void
cisco_dot11_association_mib_get_cDot11AssociationStatsTable(GNetSnmp *s, cisco_dot11_association_mib_cDot11AssociationStatsEntry_t ***cDot11AssociationStatsEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 1, 3, 1, 0};

    *cDot11AssociationStatsEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 14, 13, cDot11AssociationStatsEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *cDot11AssociationStatsEntry = (cisco_dot11_association_mib_cDot11AssociationStatsEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*cDot11AssociationStatsEntry)[i] = assign_cDot11AssociationStatsEntry(row->data);
        }
    }
}

void
cisco_dot11_association_mib_get_cDot11AssociationStatsEntry(GNetSnmp *s, cisco_dot11_association_mib_cDot11AssociationStatsEntry_t **cDot11AssociationStatsEntry, gint32 ifIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, cDot11AssociationStatsEntry_oid, sizeof(cDot11AssociationStatsEntry_oid));
    len = pack_cDot11AssociationStatsEntry(base, ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "cDot11AssociationStatsEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *cDot11AssociationStatsEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 13, cDot11AssociationStatsEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *cDot11AssociationStatsEntry = assign_cDot11AssociationStatsEntry(out);
    }
}

void
cisco_dot11_association_mib_free_cDot11AssociationStatsEntry(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *cDot11AssociationStatsEntry)
{
    GList *vbl;
    char *p;

    if (cDot11AssociationStatsEntry) {
        p = (char *) cDot11AssociationStatsEntry + sizeof(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(cDot11AssociationStatsEntry);
    }
}

void
cisco_dot11_association_mib_free_cDot11AssociationStatsTable(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t **cDot11AssociationStatsEntry)
{
    int i;

    if (cDot11AssociationStatsEntry) {
        for (i = 0; cDot11AssociationStatsEntry[i]; i++) {
            cisco_dot11_association_mib_free_cDot11AssociationStatsEntry(cDot11AssociationStatsEntry[i]);
        }
        g_free(cDot11AssociationStatsEntry);
    }
}

cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *
cisco_dot11_association_mib_new_cDot11ClientConfigInfoEntry()
{
    cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *cDot11ClientConfigInfoEntry;

    cDot11ClientConfigInfoEntry = (cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *) g_malloc0(sizeof(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t) + sizeof(gpointer));
    return cDot11ClientConfigInfoEntry;
}

static inline int
unpack_cDot11ClientConfigInfoEntry(GNetSnmpVarBind *vb, cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *cDot11ClientConfigInfoEntry)
{
    guint8 idx = 14;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    cDot11ClientConfigInfoEntry->ifIndex = vb->oid[idx++];
    if ((cDot11ClientConfigInfoEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        cDot11ClientConfigInfoEntry->cd11IfAuxSsid[i] = vb->oid[idx++];
    }
    cDot11ClientConfigInfoEntry->_cd11IfAuxSsidLength = len;
    len = 6;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        cDot11ClientConfigInfoEntry->cDot11ClientAddress[i] = vb->oid[idx++];
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_cDot11ClientConfigInfoEntry(guint32 *base, gint32 ifIndex, guchar *cd11IfAuxSsid, guint16 _cd11IfAuxSsidLength, guchar *cDot11ClientAddress)
{
    guint8 idx = 14;
    guint16 i, len;

    base[idx++] = ifIndex;
    len = _cd11IfAuxSsidLength;
    base[idx++] = len;
    if (len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = cd11IfAuxSsid[i];
        if (idx >= 128) return -1;
    }
    len = 6;
    if (len != 6) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = cDot11ClientAddress[i];
        if (idx >= 128) return -1;
    }
    return idx;
}

static inline cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *
assign_cDot11ClientConfigInfoEntry(GList *vbl)
{
    cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *cDot11ClientConfigInfoEntry;
    char *p;

    cDot11ClientConfigInfoEntry = cisco_dot11_association_mib_new_cDot11ClientConfigInfoEntry();
    p = (char *) cDot11ClientConfigInfoEntry + sizeof(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t);
    * (GList **) p = vbl;

    if (unpack_cDot11ClientConfigInfoEntry((GNetSnmpVarBind *) vbl->data, cDot11ClientConfigInfoEntry) < 0) {
        g_warning("%s: invalid instance identifier", "cDot11ClientConfigInfoEntry");
        g_free(cDot11ClientConfigInfoEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, cDot11ClientConfigInfoEntry_oid, G_N_ELEMENTS(cDot11ClientConfigInfoEntry_oid),
                      cDot11ClientConfigInfoEntry_attr, cDot11ClientConfigInfoEntry);

    return cDot11ClientConfigInfoEntry;
}

void
cisco_dot11_association_mib_get_cDot11ClientConfigInfoTable(GNetSnmp *s, cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t ***cDot11ClientConfigInfoEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 2, 1, 1, 0};

    *cDot11ClientConfigInfoEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 14, 13, cDot11ClientConfigInfoEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *cDot11ClientConfigInfoEntry = (cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*cDot11ClientConfigInfoEntry)[i] = assign_cDot11ClientConfigInfoEntry(row->data);
        }
    }
}

void
cisco_dot11_association_mib_get_cDot11ClientConfigInfoEntry(GNetSnmp *s, cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t **cDot11ClientConfigInfoEntry, gint32 ifIndex, guchar *cd11IfAuxSsid, guint16 _cd11IfAuxSsidLength, guchar *cDot11ClientAddress, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, cDot11ClientConfigInfoEntry_oid, sizeof(cDot11ClientConfigInfoEntry_oid));
    len = pack_cDot11ClientConfigInfoEntry(base, ifIndex, cd11IfAuxSsid, _cd11IfAuxSsidLength, cDot11ClientAddress);
    if (len < 0) {
        g_warning("%s: invalid index values", "cDot11ClientConfigInfoEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *cDot11ClientConfigInfoEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 13, cDot11ClientConfigInfoEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *cDot11ClientConfigInfoEntry = assign_cDot11ClientConfigInfoEntry(out);
    }
}

void
cisco_dot11_association_mib_free_cDot11ClientConfigInfoEntry(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *cDot11ClientConfigInfoEntry)
{
    GList *vbl;
    char *p;

    if (cDot11ClientConfigInfoEntry) {
        p = (char *) cDot11ClientConfigInfoEntry + sizeof(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(cDot11ClientConfigInfoEntry);
    }
}

void
cisco_dot11_association_mib_free_cDot11ClientConfigInfoTable(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t **cDot11ClientConfigInfoEntry)
{
    int i;

    if (cDot11ClientConfigInfoEntry) {
        for (i = 0; cDot11ClientConfigInfoEntry[i]; i++) {
            cisco_dot11_association_mib_free_cDot11ClientConfigInfoEntry(cDot11ClientConfigInfoEntry[i]);
        }
        g_free(cDot11ClientConfigInfoEntry);
    }
}

cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *
cisco_dot11_association_mib_new_cDot11ClientStatisticEntry()
{
    cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *cDot11ClientStatisticEntry;

    cDot11ClientStatisticEntry = (cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *) g_malloc0(sizeof(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t) + sizeof(gpointer));
    return cDot11ClientStatisticEntry;
}

static inline int
unpack_cDot11ClientStatisticEntry(GNetSnmpVarBind *vb, cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *cDot11ClientStatisticEntry)
{
    guint8 idx = 14;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    cDot11ClientStatisticEntry->ifIndex = vb->oid[idx++];
    if ((cDot11ClientStatisticEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        cDot11ClientStatisticEntry->cd11IfAuxSsid[i] = vb->oid[idx++];
    }
    cDot11ClientStatisticEntry->_cd11IfAuxSsidLength = len;
    len = 6;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        cDot11ClientStatisticEntry->cDot11ClientAddress[i] = vb->oid[idx++];
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_cDot11ClientStatisticEntry(guint32 *base, gint32 ifIndex, guchar *cd11IfAuxSsid, guint16 _cd11IfAuxSsidLength, guchar *cDot11ClientAddress)
{
    guint8 idx = 14;
    guint16 i, len;

    base[idx++] = ifIndex;
    len = _cd11IfAuxSsidLength;
    base[idx++] = len;
    if (len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = cd11IfAuxSsid[i];
        if (idx >= 128) return -1;
    }
    len = 6;
    if (len != 6) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = cDot11ClientAddress[i];
        if (idx >= 128) return -1;
    }
    return idx;
}

static inline cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *
assign_cDot11ClientStatisticEntry(GList *vbl)
{
    cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *cDot11ClientStatisticEntry;
    char *p;

    cDot11ClientStatisticEntry = cisco_dot11_association_mib_new_cDot11ClientStatisticEntry();
    p = (char *) cDot11ClientStatisticEntry + sizeof(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t);
    * (GList **) p = vbl;

    if (unpack_cDot11ClientStatisticEntry((GNetSnmpVarBind *) vbl->data, cDot11ClientStatisticEntry) < 0) {
        g_warning("%s: invalid instance identifier", "cDot11ClientStatisticEntry");
        g_free(cDot11ClientStatisticEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, cDot11ClientStatisticEntry_oid, G_N_ELEMENTS(cDot11ClientStatisticEntry_oid),
                      cDot11ClientStatisticEntry_attr, cDot11ClientStatisticEntry);

    return cDot11ClientStatisticEntry;
}

void
cisco_dot11_association_mib_get_cDot11ClientStatisticTable(GNetSnmp *s, cisco_dot11_association_mib_cDot11ClientStatisticEntry_t ***cDot11ClientStatisticEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 4, 1, 9, 9, 273, 1, 3, 1, 1, 0};

    *cDot11ClientStatisticEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 14, 13, cDot11ClientStatisticEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *cDot11ClientStatisticEntry = (cisco_dot11_association_mib_cDot11ClientStatisticEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*cDot11ClientStatisticEntry)[i] = assign_cDot11ClientStatisticEntry(row->data);
        }
    }
}

void
cisco_dot11_association_mib_get_cDot11ClientStatisticEntry(GNetSnmp *s, cisco_dot11_association_mib_cDot11ClientStatisticEntry_t **cDot11ClientStatisticEntry, gint32 ifIndex, guchar *cd11IfAuxSsid, guint16 _cd11IfAuxSsidLength, guchar *cDot11ClientAddress, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, cDot11ClientStatisticEntry_oid, sizeof(cDot11ClientStatisticEntry_oid));
    len = pack_cDot11ClientStatisticEntry(base, ifIndex, cd11IfAuxSsid, _cd11IfAuxSsidLength, cDot11ClientAddress);
    if (len < 0) {
        g_warning("%s: invalid index values", "cDot11ClientStatisticEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *cDot11ClientStatisticEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 13, cDot11ClientStatisticEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *cDot11ClientStatisticEntry = assign_cDot11ClientStatisticEntry(out);
    }
}

void
cisco_dot11_association_mib_free_cDot11ClientStatisticEntry(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *cDot11ClientStatisticEntry)
{
    GList *vbl;
    char *p;

    if (cDot11ClientStatisticEntry) {
        p = (char *) cDot11ClientStatisticEntry + sizeof(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(cDot11ClientStatisticEntry);
    }
}

void
cisco_dot11_association_mib_free_cDot11ClientStatisticTable(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t **cDot11ClientStatisticEntry)
{
    int i;

    if (cDot11ClientStatisticEntry) {
        for (i = 0; cDot11ClientStatisticEntry[i]; i++) {
            cisco_dot11_association_mib_free_cDot11ClientStatisticEntry(cDot11ClientStatisticEntry[i]);
        }
        g_free(cDot11ClientStatisticEntry);
    }
}


