/*							-- DO NOT EDIT --
 * This file has been generated by smidump
 * version 0.3.1 for the scli package.
 *
 * Options:
 *   --scli-exclude='ifTestEntry'
 *
 * Derived from IF-MIB:
 *   The MIB module to describe generic objects for network
 *   interface sub-layers.  This MIB is an updated version of
 *   MIB-II's ifTable, and incorporates the extensions defined in
 *   RFC 1229.
 *
 * Revision 2000-06-14 00:00:
 *   Clarifications agreed upon by the Interfaces MIB WG, and
 *   published as RFC 2863.
 *
 * Revision 1996-02-28 21:55:
 *   Revisions made by the Interfaces MIB WG, and published in
 *   RFC 2233.
 *
 * Revision 1993-11-08 21:55:
 *   Initial revision, published as part of RFC 1573.
 *
 * $Id: if-mib.c,v 1.27 2002/07/22 16:52:07 schoenw Exp $
 */

#include "if-mib.h"

GSnmpEnum const if_mib_enums_ifType[] = {
    { IF_MIB_IFTYPE_OTHER,                         "other" },
    { IF_MIB_IFTYPE_REGULAR1822,                   "regular1822" },
    { IF_MIB_IFTYPE_HDH1822,                       "hdh1822" },
    { IF_MIB_IFTYPE_DDNX25,                        "ddnX25" },
    { IF_MIB_IFTYPE_RFC877X25,                     "rfc877x25" },
    { IF_MIB_IFTYPE_ETHERNETCSMACD,                "ethernetCsmacd" },
    { IF_MIB_IFTYPE_ISO88023CSMACD,                "iso88023Csmacd" },
    { IF_MIB_IFTYPE_ISO88024TOKENBUS,              "iso88024TokenBus" },
    { IF_MIB_IFTYPE_ISO88025TOKENRING,             "iso88025TokenRing" },
    { IF_MIB_IFTYPE_ISO88026MAN,                   "iso88026Man" },
    { IF_MIB_IFTYPE_STARLAN,                       "starLan" },
    { IF_MIB_IFTYPE_PROTEON10MBIT,                 "proteon10Mbit" },
    { IF_MIB_IFTYPE_PROTEON80MBIT,                 "proteon80Mbit" },
    { IF_MIB_IFTYPE_HYPERCHANNEL,                  "hyperchannel" },
    { IF_MIB_IFTYPE_FDDI,                          "fddi" },
    { IF_MIB_IFTYPE_LAPB,                          "lapb" },
    { IF_MIB_IFTYPE_SDLC,                          "sdlc" },
    { IF_MIB_IFTYPE_DS1,                           "ds1" },
    { IF_MIB_IFTYPE_E1,                            "e1" },
    { IF_MIB_IFTYPE_BASICISDN,                     "basicISDN" },
    { IF_MIB_IFTYPE_PRIMARYISDN,                   "primaryISDN" },
    { IF_MIB_IFTYPE_PROPPOINTTOPOINTSERIAL,        "propPointToPointSerial" },
    { IF_MIB_IFTYPE_PPP,                           "ppp" },
    { IF_MIB_IFTYPE_SOFTWARELOOPBACK,              "softwareLoopback" },
    { IF_MIB_IFTYPE_EON,                           "eon" },
    { IF_MIB_IFTYPE_ETHERNET3MBIT,                 "ethernet3Mbit" },
    { IF_MIB_IFTYPE_NSIP,                          "nsip" },
    { IF_MIB_IFTYPE_SLIP,                          "slip" },
    { IF_MIB_IFTYPE_ULTRA,                         "ultra" },
    { IF_MIB_IFTYPE_DS3,                           "ds3" },
    { IF_MIB_IFTYPE_SIP,                           "sip" },
    { IF_MIB_IFTYPE_FRAMERELAY,                    "frameRelay" },
    { IF_MIB_IFTYPE_RS232,                         "rs232" },
    { IF_MIB_IFTYPE_PARA,                          "para" },
    { IF_MIB_IFTYPE_ARCNET,                        "arcnet" },
    { IF_MIB_IFTYPE_ARCNETPLUS,                    "arcnetPlus" },
    { IF_MIB_IFTYPE_ATM,                           "atm" },
    { IF_MIB_IFTYPE_MIOX25,                        "miox25" },
    { IF_MIB_IFTYPE_SONET,                         "sonet" },
    { IF_MIB_IFTYPE_X25PLE,                        "x25ple" },
    { IF_MIB_IFTYPE_ISO88022LLC,                   "iso88022llc" },
    { IF_MIB_IFTYPE_LOCALTALK,                     "localTalk" },
    { IF_MIB_IFTYPE_SMDSDXI,                       "smdsDxi" },
    { IF_MIB_IFTYPE_FRAMERELAYSERVICE,             "frameRelayService" },
    { IF_MIB_IFTYPE_V35,                           "v35" },
    { IF_MIB_IFTYPE_HSSI,                          "hssi" },
    { IF_MIB_IFTYPE_HIPPI,                         "hippi" },
    { IF_MIB_IFTYPE_MODEM,                         "modem" },
    { IF_MIB_IFTYPE_AAL5,                          "aal5" },
    { IF_MIB_IFTYPE_SONETPATH,                     "sonetPath" },
    { IF_MIB_IFTYPE_SONETVT,                       "sonetVT" },
    { IF_MIB_IFTYPE_SMDSICIP,                      "smdsIcip" },
    { IF_MIB_IFTYPE_PROPVIRTUAL,                   "propVirtual" },
    { IF_MIB_IFTYPE_PROPMULTIPLEXOR,               "propMultiplexor" },
    { IF_MIB_IFTYPE_IEEE80212,                     "ieee80212" },
    { IF_MIB_IFTYPE_FIBRECHANNEL,                  "fibreChannel" },
    { IF_MIB_IFTYPE_HIPPIINTERFACE,                "hippiInterface" },
    { IF_MIB_IFTYPE_FRAMERELAYINTERCONNECT,        "frameRelayInterconnect" },
    { IF_MIB_IFTYPE_AFLANE8023,                    "aflane8023" },
    { IF_MIB_IFTYPE_AFLANE8025,                    "aflane8025" },
    { IF_MIB_IFTYPE_CCTEMUL,                       "cctEmul" },
    { IF_MIB_IFTYPE_FASTETHER,                     "fastEther" },
    { IF_MIB_IFTYPE_ISDN,                          "isdn" },
    { IF_MIB_IFTYPE_V11,                           "v11" },
    { IF_MIB_IFTYPE_V36,                           "v36" },
    { IF_MIB_IFTYPE_G703AT64K,                     "g703at64k" },
    { IF_MIB_IFTYPE_G703AT2MB,                     "g703at2mb" },
    { IF_MIB_IFTYPE_QLLC,                          "qllc" },
    { IF_MIB_IFTYPE_FASTETHERFX,                   "fastEtherFX" },
    { IF_MIB_IFTYPE_CHANNEL,                       "channel" },
    { IF_MIB_IFTYPE_IEEE80211,                     "ieee80211" },
    { IF_MIB_IFTYPE_IBM370PARCHAN,                 "ibm370parChan" },
    { IF_MIB_IFTYPE_ESCON,                         "escon" },
    { IF_MIB_IFTYPE_DLSW,                          "dlsw" },
    { IF_MIB_IFTYPE_ISDNS,                         "isdns" },
    { IF_MIB_IFTYPE_ISDNU,                         "isdnu" },
    { IF_MIB_IFTYPE_LAPD,                          "lapd" },
    { IF_MIB_IFTYPE_IPSWITCH,                      "ipSwitch" },
    { IF_MIB_IFTYPE_RSRB,                          "rsrb" },
    { IF_MIB_IFTYPE_ATMLOGICAL,                    "atmLogical" },
    { IF_MIB_IFTYPE_DS0,                           "ds0" },
    { IF_MIB_IFTYPE_DS0BUNDLE,                     "ds0Bundle" },
    { IF_MIB_IFTYPE_BSC,                           "bsc" },
    { IF_MIB_IFTYPE_ASYNC,                         "async" },
    { IF_MIB_IFTYPE_CNR,                           "cnr" },
    { IF_MIB_IFTYPE_ISO88025DTR,                   "iso88025Dtr" },
    { IF_MIB_IFTYPE_EPLRS,                         "eplrs" },
    { IF_MIB_IFTYPE_ARAP,                          "arap" },
    { IF_MIB_IFTYPE_PROPCNLS,                      "propCnls" },
    { IF_MIB_IFTYPE_HOSTPAD,                       "hostPad" },
    { IF_MIB_IFTYPE_TERMPAD,                       "termPad" },
    { IF_MIB_IFTYPE_FRAMERELAYMPI,                 "frameRelayMPI" },
    { IF_MIB_IFTYPE_X213,                          "x213" },
    { IF_MIB_IFTYPE_ADSL,                          "adsl" },
    { IF_MIB_IFTYPE_RADSL,                         "radsl" },
    { IF_MIB_IFTYPE_SDSL,                          "sdsl" },
    { IF_MIB_IFTYPE_VDSL,                          "vdsl" },
    { IF_MIB_IFTYPE_ISO88025CRFPINT,               "iso88025CRFPInt" },
    { IF_MIB_IFTYPE_MYRINET,                       "myrinet" },
    { IF_MIB_IFTYPE_VOICEEM,                       "voiceEM" },
    { IF_MIB_IFTYPE_VOICEFXO,                      "voiceFXO" },
    { IF_MIB_IFTYPE_VOICEFXS,                      "voiceFXS" },
    { IF_MIB_IFTYPE_VOICEENCAP,                    "voiceEncap" },
    { IF_MIB_IFTYPE_VOICEOVERIP,                   "voiceOverIp" },
    { IF_MIB_IFTYPE_ATMDXI,                        "atmDxi" },
    { IF_MIB_IFTYPE_ATMFUNI,                       "atmFuni" },
    { IF_MIB_IFTYPE_ATMIMA,                        "atmIma" },
    { IF_MIB_IFTYPE_PPPMULTILINKBUNDLE,            "pppMultilinkBundle" },
    { IF_MIB_IFTYPE_IPOVERCDLC,                    "ipOverCdlc" },
    { IF_MIB_IFTYPE_IPOVERCLAW,                    "ipOverClaw" },
    { IF_MIB_IFTYPE_STACKTOSTACK,                  "stackToStack" },
    { IF_MIB_IFTYPE_VIRTUALIPADDRESS,              "virtualIpAddress" },
    { IF_MIB_IFTYPE_MPC,                           "mpc" },
    { IF_MIB_IFTYPE_IPOVERATM,                     "ipOverAtm" },
    { IF_MIB_IFTYPE_ISO88025FIBER,                 "iso88025Fiber" },
    { IF_MIB_IFTYPE_TDLC,                          "tdlc" },
    { IF_MIB_IFTYPE_GIGABITETHERNET,               "gigabitEthernet" },
    { IF_MIB_IFTYPE_HDLC,                          "hdlc" },
    { IF_MIB_IFTYPE_LAPF,                          "lapf" },
    { IF_MIB_IFTYPE_V37,                           "v37" },
    { IF_MIB_IFTYPE_X25MLP,                        "x25mlp" },
    { IF_MIB_IFTYPE_X25HUNTGROUP,                  "x25huntGroup" },
    { IF_MIB_IFTYPE_TRASNPHDLC,                    "trasnpHdlc" },
    { IF_MIB_IFTYPE_INTERLEAVE,                    "interleave" },
    { IF_MIB_IFTYPE_FAST,                          "fast" },
    { IF_MIB_IFTYPE_IP,                            "ip" },
    { IF_MIB_IFTYPE_DOCSCABLEMACLAYER,             "docsCableMaclayer" },
    { IF_MIB_IFTYPE_DOCSCABLEDOWNSTREAM,           "docsCableDownstream" },
    { IF_MIB_IFTYPE_DOCSCABLEUPSTREAM,             "docsCableUpstream" },
    { IF_MIB_IFTYPE_A12MPPSWITCH,                  "a12MppSwitch" },
    { IF_MIB_IFTYPE_TUNNEL,                        "tunnel" },
    { IF_MIB_IFTYPE_COFFEE,                        "coffee" },
    { IF_MIB_IFTYPE_CES,                           "ces" },
    { IF_MIB_IFTYPE_ATMSUBINTERFACE,               "atmSubInterface" },
    { IF_MIB_IFTYPE_L2VLAN,                        "l2vlan" },
    { IF_MIB_IFTYPE_L3IPVLAN,                      "l3ipvlan" },
    { IF_MIB_IFTYPE_L3IPXVLAN,                     "l3ipxvlan" },
    { IF_MIB_IFTYPE_DIGITALPOWERLINE,              "digitalPowerline" },
    { IF_MIB_IFTYPE_MEDIAMAILOVERIP,               "mediaMailOverIp" },
    { IF_MIB_IFTYPE_DTM,                           "dtm" },
    { IF_MIB_IFTYPE_DCN,                           "dcn" },
    { IF_MIB_IFTYPE_IPFORWARD,                     "ipForward" },
    { IF_MIB_IFTYPE_MSDSL,                         "msdsl" },
    { IF_MIB_IFTYPE_IEEE1394,                      "ieee1394" },
    { IF_MIB_IFTYPE_IF_GSN,                        "if-gsn" },
    { IF_MIB_IFTYPE_DVBRCCMACLAYER,                "dvbRccMacLayer" },
    { IF_MIB_IFTYPE_DVBRCCDOWNSTREAM,              "dvbRccDownstream" },
    { IF_MIB_IFTYPE_DVBRCCUPSTREAM,                "dvbRccUpstream" },
    { IF_MIB_IFTYPE_ATMVIRTUAL,                    "atmVirtual" },
    { IF_MIB_IFTYPE_MPLSTUNNEL,                    "mplsTunnel" },
    { IF_MIB_IFTYPE_SRP,                           "srp" },
    { IF_MIB_IFTYPE_VOICEOVERATM,                  "voiceOverAtm" },
    { IF_MIB_IFTYPE_VOICEOVERFRAMERELAY,           "voiceOverFrameRelay" },
    { IF_MIB_IFTYPE_IDSL,                          "idsl" },
    { IF_MIB_IFTYPE_COMPOSITELINK,                 "compositeLink" },
    { IF_MIB_IFTYPE_SS7SIGLINK,                    "ss7SigLink" },
    { IF_MIB_IFTYPE_PROPWIRELESSP2P,               "propWirelessP2P" },
    { IF_MIB_IFTYPE_FRFORWARD,                     "frForward" },
    { IF_MIB_IFTYPE_RFC1483,                       "rfc1483" },
    { IF_MIB_IFTYPE_USB,                           "usb" },
    { IF_MIB_IFTYPE_IEEE8023ADLAG,                 "ieee8023adLag" },
    { IF_MIB_IFTYPE_BGPPOLICYACCOUNTING,           "bgppolicyaccounting" },
    { IF_MIB_IFTYPE_FRF16MFRBUNDLE,                "frf16MfrBundle" },
    { IF_MIB_IFTYPE_H323GATEKEEPER,                "h323Gatekeeper" },
    { IF_MIB_IFTYPE_H323PROXY,                     "h323Proxy" },
    { IF_MIB_IFTYPE_MPLS,                          "mpls" },
    { IF_MIB_IFTYPE_MFSIGLINK,                     "mfSigLink" },
    { IF_MIB_IFTYPE_HDSL2,                         "hdsl2" },
    { IF_MIB_IFTYPE_SHDSL,                         "shdsl" },
    { IF_MIB_IFTYPE_DS1FDL,                        "ds1FDL" },
    { IF_MIB_IFTYPE_POS,                           "pos" },
    { IF_MIB_IFTYPE_DVBASILN,                      "dvbAsiln" },
    { IF_MIB_IFTYPE_DVBASIOUT,                     "dvbAsiOut" },
    { IF_MIB_IFTYPE_PLC,                           "plc" },
    { IF_MIB_IFTYPE_NFAS,                          "nfas" },
    { IF_MIB_IFTYPE_TR008,                         "tr008" },
    { IF_MIB_IFTYPE_GR303RDT,                      "gr303RDT" },
    { IF_MIB_IFTYPE_GR303IDT,                      "gr303IDT" },
    { IF_MIB_IFTYPE_ISUP,                          "isup" },
    { IF_MIB_IFTYPE_PROPDOCSWIRELESSMACLAYER,      "propDocsWirelessMaclayer" },
    { IF_MIB_IFTYPE_PROPDOCSWIRELESSDOWNSTREAM,    "propDocsWirelessDownstream" },
    { IF_MIB_IFTYPE_PROPDOCSWIRELESSUPSTREAM,      "propDocsWirelessUpstream" },
    { IF_MIB_IFTYPE_HIPERLAN2,                     "hiperlan2" },
    { IF_MIB_IFTYPE_PROPBWAP2MP,                   "propBWAp2Mp" },
    { IF_MIB_IFTYPE_SONETOVERHEADCHANNEL,          "sonetOverheadChannel" },
    { IF_MIB_IFTYPE_DIGITALWRAPPEROVERHEADCHANNEL, "digitalWrapperOverheadChannel" },
    { IF_MIB_IFTYPE_AAL2,                          "aal2" },
    { IF_MIB_IFTYPE_RADIOMAC,                      "radioMAC" },
    { IF_MIB_IFTYPE_ATMRADIO,                      "atmRadio" },
    { 0, NULL }
};

GSnmpEnum const if_mib_enums_ifAdminStatus[] = {
    { IF_MIB_IFADMINSTATUS_UP,      "up" },
    { IF_MIB_IFADMINSTATUS_DOWN,    "down" },
    { IF_MIB_IFADMINSTATUS_TESTING, "testing" },
    { 0, NULL }
};

GSnmpEnum const if_mib_enums_ifOperStatus[] = {
    { IF_MIB_IFOPERSTATUS_UP,             "up" },
    { IF_MIB_IFOPERSTATUS_DOWN,           "down" },
    { IF_MIB_IFOPERSTATUS_TESTING,        "testing" },
    { IF_MIB_IFOPERSTATUS_UNKNOWN,        "unknown" },
    { IF_MIB_IFOPERSTATUS_DORMANT,        "dormant" },
    { IF_MIB_IFOPERSTATUS_NOTPRESENT,     "notPresent" },
    { IF_MIB_IFOPERSTATUS_LOWERLAYERDOWN, "lowerLayerDown" },
    { 0, NULL }
};

GSnmpEnum const if_mib_enums_ifLinkUpDownTrapEnable[] = {
    { IF_MIB_IFLINKUPDOWNTRAPENABLE_ENABLED,  "enabled" },
    { IF_MIB_IFLINKUPDOWNTRAPENABLE_DISABLED, "disabled" },
    { 0, NULL }
};

GSnmpEnum const if_mib_enums_ifPromiscuousMode[] = {
    { IF_MIB_IFPROMISCUOUSMODE_TRUE,  "true" },
    { IF_MIB_IFPROMISCUOUSMODE_FALSE, "false" },
    { 0, NULL }
};

GSnmpEnum const if_mib_enums_ifConnectorPresent[] = {
    { IF_MIB_IFCONNECTORPRESENT_TRUE,  "true" },
    { IF_MIB_IFCONNECTORPRESENT_FALSE, "false" },
    { 0, NULL }
};

GSnmpEnum const if_mib_enums_ifStackStatus[] = {
    { IF_MIB_IFSTACKSTATUS_ACTIVE,        "active" },
    { IF_MIB_IFSTACKSTATUS_NOTINSERVICE,  "notInService" },
    { IF_MIB_IFSTACKSTATUS_NOTREADY,      "notReady" },
    { IF_MIB_IFSTACKSTATUS_CREATEANDGO,   "createAndGo" },
    { IF_MIB_IFSTACKSTATUS_CREATEANDWAIT, "createAndWait" },
    { IF_MIB_IFSTACKSTATUS_DESTROY,       "destroy" },
    { 0, NULL }
};

GSnmpEnum const if_mib_enums_ifRcvAddressStatus[] = {
    { IF_MIB_IFRCVADDRESSSTATUS_ACTIVE,        "active" },
    { IF_MIB_IFRCVADDRESSSTATUS_NOTINSERVICE,  "notInService" },
    { IF_MIB_IFRCVADDRESSSTATUS_NOTREADY,      "notReady" },
    { IF_MIB_IFRCVADDRESSSTATUS_CREATEANDGO,   "createAndGo" },
    { IF_MIB_IFRCVADDRESSSTATUS_CREATEANDWAIT, "createAndWait" },
    { IF_MIB_IFRCVADDRESSSTATUS_DESTROY,       "destroy" },
    { 0, NULL }
};

GSnmpEnum const if_mib_enums_ifRcvAddressType[] = {
    { IF_MIB_IFRCVADDRESSTYPE_OTHER,       "other" },
    { IF_MIB_IFRCVADDRESSTYPE_VOLATILE,    "volatile" },
    { IF_MIB_IFRCVADDRESSTYPE_NONVOLATILE, "nonVolatile" },
    { 0, NULL }
};


static guint16 ifDescr_constraints[] = {0, 255, 0, 0};
static guint16 ifName_constraints[] = {0, 255, 0, 0};
static guint16 ifAlias_constraints[] = {0, 64, 0, 0};


static guint32 const interfaces_oid[] = {1, 3, 6, 1, 2, 1, 2};

static GSnmpAttribute interfaces_attr[] = {
    { 1, G_SNMP_INTEGER32,
      IF_MIB_IFNUMBER, "ifNumber",
       NULL,
      G_STRUCT_OFFSET(if_mib_interfaces_t, ifNumber),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifEntry_oid[] = {1, 3, 6, 1, 2, 1, 2, 2, 1};

static GSnmpAttribute ifEntry_attr[] = {
    { 2, G_SNMP_OCTETSTRING,
      IF_MIB_IFDESCR, "ifDescr",
       ifDescr_constraints,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifDescr),
      G_STRUCT_OFFSET(if_mib_ifEntry_t, _ifDescrLength),
      0 },
    { 3, G_SNMP_INTEGER32,
      IF_MIB_IFTYPE, "ifType",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifType),
      0,
      0 },
    { 4, G_SNMP_INTEGER32,
      IF_MIB_IFMTU, "ifMtu",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifMtu),
      0,
      0 },
    { 5, G_SNMP_UNSIGNED32,
      IF_MIB_IFSPEED, "ifSpeed",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifSpeed),
      0,
      0 },
    { 6, G_SNMP_OCTETSTRING,
      IF_MIB_IFPHYSADDRESS, "ifPhysAddress",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifPhysAddress),
      G_STRUCT_OFFSET(if_mib_ifEntry_t, _ifPhysAddressLength),
      0 },
    { 7, G_SNMP_INTEGER32,
      IF_MIB_IFADMINSTATUS, "ifAdminStatus",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, G_SNMP_INTEGER32,
      IF_MIB_IFOPERSTATUS, "ifOperStatus",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifOperStatus),
      0,
      0 },
    { 9, G_SNMP_TIMETICKS,
      IF_MIB_IFLASTCHANGE, "ifLastChange",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifLastChange),
      0,
      0 },
    { 10, G_SNMP_COUNTER32,
      IF_MIB_IFINOCTETS, "ifInOctets",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifInOctets),
      0,
      0 },
    { 11, G_SNMP_COUNTER32,
      IF_MIB_IFINUCASTPKTS, "ifInUcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifInUcastPkts),
      0,
      0 },
    { 12, G_SNMP_COUNTER32,
      IF_MIB_IFINNUCASTPKTS, "ifInNUcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifInNUcastPkts),
      0,
      0 },
    { 13, G_SNMP_COUNTER32,
      IF_MIB_IFINDISCARDS, "ifInDiscards",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifInDiscards),
      0,
      0 },
    { 14, G_SNMP_COUNTER32,
      IF_MIB_IFINERRORS, "ifInErrors",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifInErrors),
      0,
      0 },
    { 15, G_SNMP_COUNTER32,
      IF_MIB_IFINUNKNOWNPROTOS, "ifInUnknownProtos",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifInUnknownProtos),
      0,
      0 },
    { 16, G_SNMP_COUNTER32,
      IF_MIB_IFOUTOCTETS, "ifOutOctets",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifOutOctets),
      0,
      0 },
    { 17, G_SNMP_COUNTER32,
      IF_MIB_IFOUTUCASTPKTS, "ifOutUcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifOutUcastPkts),
      0,
      0 },
    { 18, G_SNMP_COUNTER32,
      IF_MIB_IFOUTNUCASTPKTS, "ifOutNUcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifOutNUcastPkts),
      0,
      0 },
    { 19, G_SNMP_COUNTER32,
      IF_MIB_IFOUTDISCARDS, "ifOutDiscards",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifOutDiscards),
      0,
      0 },
    { 20, G_SNMP_COUNTER32,
      IF_MIB_IFOUTERRORS, "ifOutErrors",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifOutErrors),
      0,
      0 },
    { 21, G_SNMP_UNSIGNED32,
      IF_MIB_IFOUTQLEN, "ifOutQLen",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifOutQLen),
      0,
      0 },
    { 22, G_SNMP_OBJECTID,
      IF_MIB_IFSPECIFIC, "ifSpecific",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifEntry_t, ifSpecific),
      G_STRUCT_OFFSET(if_mib_ifEntry_t, _ifSpecificLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifMIBObjects_oid[] = {1, 3, 6, 1, 2, 1, 31, 1};

static GSnmpAttribute ifMIBObjects_attr[] = {
    { 5, G_SNMP_TIMETICKS,
      IF_MIB_IFTABLELASTCHANGE, "ifTableLastChange",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifMIBObjects_t, ifTableLastChange),
      0,
      0 },
    { 6, G_SNMP_TIMETICKS,
      IF_MIB_IFSTACKLASTCHANGE, "ifStackLastChange",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifMIBObjects_t, ifStackLastChange),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifXEntry_oid[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1};

static GSnmpAttribute ifXEntry_attr[] = {
    { 1, G_SNMP_OCTETSTRING,
      IF_MIB_IFNAME, "ifName",
       ifName_constraints,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifName),
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, _ifNameLength),
      0 },
    { 2, G_SNMP_COUNTER32,
      IF_MIB_IFINMULTICASTPKTS, "ifInMulticastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifInMulticastPkts),
      0,
      0 },
    { 3, G_SNMP_COUNTER32,
      IF_MIB_IFINBROADCASTPKTS, "ifInBroadcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifInBroadcastPkts),
      0,
      0 },
    { 4, G_SNMP_COUNTER32,
      IF_MIB_IFOUTMULTICASTPKTS, "ifOutMulticastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifOutMulticastPkts),
      0,
      0 },
    { 5, G_SNMP_COUNTER32,
      IF_MIB_IFOUTBROADCASTPKTS, "ifOutBroadcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifOutBroadcastPkts),
      0,
      0 },
    { 6, G_SNMP_COUNTER64,
      IF_MIB_IFHCINOCTETS, "ifHCInOctets",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHCInOctets),
      0,
      0 },
    { 7, G_SNMP_COUNTER64,
      IF_MIB_IFHCINUCASTPKTS, "ifHCInUcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHCInUcastPkts),
      0,
      0 },
    { 8, G_SNMP_COUNTER64,
      IF_MIB_IFHCINMULTICASTPKTS, "ifHCInMulticastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHCInMulticastPkts),
      0,
      0 },
    { 9, G_SNMP_COUNTER64,
      IF_MIB_IFHCINBROADCASTPKTS, "ifHCInBroadcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHCInBroadcastPkts),
      0,
      0 },
    { 10, G_SNMP_COUNTER64,
      IF_MIB_IFHCOUTOCTETS, "ifHCOutOctets",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHCOutOctets),
      0,
      0 },
    { 11, G_SNMP_COUNTER64,
      IF_MIB_IFHCOUTUCASTPKTS, "ifHCOutUcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHCOutUcastPkts),
      0,
      0 },
    { 12, G_SNMP_COUNTER64,
      IF_MIB_IFHCOUTMULTICASTPKTS, "ifHCOutMulticastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHCOutMulticastPkts),
      0,
      0 },
    { 13, G_SNMP_COUNTER64,
      IF_MIB_IFHCOUTBROADCASTPKTS, "ifHCOutBroadcastPkts",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHCOutBroadcastPkts),
      0,
      0 },
    { 14, G_SNMP_INTEGER32,
      IF_MIB_IFLINKUPDOWNTRAPENABLE, "ifLinkUpDownTrapEnable",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifLinkUpDownTrapEnable),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 15, G_SNMP_UNSIGNED32,
      IF_MIB_IFHIGHSPEED, "ifHighSpeed",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifHighSpeed),
      0,
      0 },
    { 16, G_SNMP_INTEGER32,
      IF_MIB_IFPROMISCUOUSMODE, "ifPromiscuousMode",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifPromiscuousMode),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 17, G_SNMP_INTEGER32,
      IF_MIB_IFCONNECTORPRESENT, "ifConnectorPresent",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifConnectorPresent),
      0,
      0 },
    { 18, G_SNMP_OCTETSTRING,
      IF_MIB_IFALIAS, "ifAlias",
       ifAlias_constraints,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifAlias),
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, _ifAliasLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 19, G_SNMP_TIMETICKS,
      IF_MIB_IFCOUNTERDISCONTINUITYTIME, "ifCounterDiscontinuityTime",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifXEntry_t, ifCounterDiscontinuityTime),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifStackEntry_oid[] = {1, 3, 6, 1, 2, 1, 31, 1, 2, 1};

static GSnmpAttribute ifStackEntry_attr[] = {
    { 3, G_SNMP_INTEGER32,
      IF_MIB_IFSTACKSTATUS, "ifStackStatus",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifStackEntry_t, ifStackStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const ifRcvAddressEntry_oid[] = {1, 3, 6, 1, 2, 1, 31, 1, 4, 1};

static GSnmpAttribute ifRcvAddressEntry_attr[] = {
    { 2, G_SNMP_INTEGER32,
      IF_MIB_IFRCVADDRESSSTATUS, "ifRcvAddressStatus",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifRcvAddressEntry_t, ifRcvAddressStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, G_SNMP_INTEGER32,
      IF_MIB_IFRCVADDRESSTYPE, "ifRcvAddressType",
       NULL,
      G_STRUCT_OFFSET(if_mib_ifRcvAddressEntry_t, ifRcvAddressType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};


if_mib_interfaces_t *
if_mib_new_interfaces()
{
    if_mib_interfaces_t *interfaces;

    interfaces = (if_mib_interfaces_t *) g_malloc0(sizeof(if_mib_interfaces_t) + sizeof(gpointer));
    return interfaces;
}

static inline if_mib_interfaces_t *
assign_interfaces(GSList *vbl)
{
    if_mib_interfaces_t *interfaces;
    char *p;

    interfaces = if_mib_new_interfaces();
    if (! interfaces) {
        return NULL;
    }

    p = (char *) interfaces + sizeof(if_mib_interfaces_t);
    * (GSList **) p = vbl;

    gsnmp_attr_assign(vbl, interfaces_oid, sizeof(interfaces_oid)/sizeof(guint32),
                      interfaces_attr, interfaces);

    return interfaces;
}

void
if_mib_get_interfaces(GSnmpSession *s, if_mib_interfaces_t **interfaces, gint mask)
{
    GSList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 2, 0};

    *interfaces = NULL;

    gsnmp_attr_get(s, &in, base, 8, 7, interfaces_attr, mask);

    out = g_snmp_session_sync_getnext(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *interfaces = assign_interfaces(out);
    }
}

void
if_mib_free_interfaces(if_mib_interfaces_t *interfaces)
{
    GSList *vbl;
    char *p;

    if (interfaces) {
        p = (char *) interfaces + sizeof(if_mib_interfaces_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(interfaces);
    }
}

if_mib_ifEntry_t *
if_mib_new_ifEntry()
{
    if_mib_ifEntry_t *ifEntry;

    ifEntry = (if_mib_ifEntry_t *) g_malloc0(sizeof(if_mib_ifEntry_t) + sizeof(gpointer));
    return ifEntry;
}

static inline int
unpack_ifEntry(GSnmpVarBind *vb, if_mib_ifEntry_t *ifEntry)
{
    guint8 idx = 10;

    if (vb->id_len < idx) return -1;
    ifEntry->ifIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifEntry(guint32 *base, gint32 ifIndex)
{
    guint8 idx = 10;

    base[idx++] = ifIndex;
    return idx;
}

static inline if_mib_ifEntry_t *
assign_ifEntry(GSList *vbl)
{
    if_mib_ifEntry_t *ifEntry;
    char *p;

    ifEntry = if_mib_new_ifEntry();
    if (! ifEntry) {
        return NULL;
    }

    p = (char *) ifEntry + sizeof(if_mib_ifEntry_t);
    * (GSList **) p = vbl;

    if (unpack_ifEntry((GSnmpVarBind *) vbl->data, ifEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifEntry");
        g_free(ifEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, ifEntry_oid, sizeof(ifEntry_oid)/sizeof(guint32),
                      ifEntry_attr, ifEntry);

    return ifEntry;
}

void
if_mib_get_ifTable(GSnmpSession *s, if_mib_ifEntry_t ***ifEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 0};

    *ifEntry = NULL;

    gsnmp_attr_get(s, &in, base, 10, 9, ifEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *ifEntry = (if_mib_ifEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(if_mib_ifEntry_t *));
        if (! *ifEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*ifEntry)[i] = assign_ifEntry(row->data);
        }
    }
}

void
if_mib_get_ifEntry(GSnmpSession *s, if_mib_ifEntry_t **ifEntry, gint32 ifIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifEntry_oid, sizeof(ifEntry_oid));
    len = pack_ifEntry(base, ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *ifEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 9, ifEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *ifEntry = assign_ifEntry(out);
    }
}

void
if_mib_set_ifEntry(GSnmpSession *s, if_mib_ifEntry_t *ifEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifEntry_oid, sizeof(ifEntry_oid));
    len = pack_ifEntry(base, ifEntry->ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 9, ifEntry_attr, mask, ifEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
if_mib_free_ifEntry(if_mib_ifEntry_t *ifEntry)
{
    GSList *vbl;
    char *p;

    if (ifEntry) {
        p = (char *) ifEntry + sizeof(if_mib_ifEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(ifEntry);
    }
}

void
if_mib_free_ifTable(if_mib_ifEntry_t **ifEntry)
{
    int i;

    if (ifEntry) {
        for (i = 0; ifEntry[i]; i++) {
            if_mib_free_ifEntry(ifEntry[i]);
        }
        g_free(ifEntry);
    }
}

void
if_mib_set_ifAdminStatus(GSnmpSession *s, gint32 ifIndex, gint32 ifAdminStatus)
{
    if_mib_ifEntry_t *ifEntry;

    if_mib_get_ifEntry(s, &ifEntry, ifIndex, IF_MIB_IFADMINSTATUS);
    if (s->error_status || !ifEntry) return;
    ifEntry->ifAdminStatus = &ifAdminStatus;
    if_mib_set_ifEntry(s, ifEntry, IF_MIB_IFADMINSTATUS);
    if_mib_free_ifEntry(ifEntry);
}

if_mib_ifMIBObjects_t *
if_mib_new_ifMIBObjects()
{
    if_mib_ifMIBObjects_t *ifMIBObjects;

    ifMIBObjects = (if_mib_ifMIBObjects_t *) g_malloc0(sizeof(if_mib_ifMIBObjects_t) + sizeof(gpointer));
    return ifMIBObjects;
}

static inline if_mib_ifMIBObjects_t *
assign_ifMIBObjects(GSList *vbl)
{
    if_mib_ifMIBObjects_t *ifMIBObjects;
    char *p;

    ifMIBObjects = if_mib_new_ifMIBObjects();
    if (! ifMIBObjects) {
        return NULL;
    }

    p = (char *) ifMIBObjects + sizeof(if_mib_ifMIBObjects_t);
    * (GSList **) p = vbl;

    gsnmp_attr_assign(vbl, ifMIBObjects_oid, sizeof(ifMIBObjects_oid)/sizeof(guint32),
                      ifMIBObjects_attr, ifMIBObjects);

    return ifMIBObjects;
}

void
if_mib_get_ifMIBObjects(GSnmpSession *s, if_mib_ifMIBObjects_t **ifMIBObjects, gint mask)
{
    GSList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 31, 1, 0};

    *ifMIBObjects = NULL;

    gsnmp_attr_get(s, &in, base, 9, 8, ifMIBObjects_attr, mask);

    out = g_snmp_session_sync_getnext(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *ifMIBObjects = assign_ifMIBObjects(out);
    }
}

void
if_mib_free_ifMIBObjects(if_mib_ifMIBObjects_t *ifMIBObjects)
{
    GSList *vbl;
    char *p;

    if (ifMIBObjects) {
        p = (char *) ifMIBObjects + sizeof(if_mib_ifMIBObjects_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(ifMIBObjects);
    }
}

if_mib_ifXEntry_t *
if_mib_new_ifXEntry()
{
    if_mib_ifXEntry_t *ifXEntry;

    ifXEntry = (if_mib_ifXEntry_t *) g_malloc0(sizeof(if_mib_ifXEntry_t) + sizeof(gpointer));
    return ifXEntry;
}

static inline int
unpack_ifXEntry(GSnmpVarBind *vb, if_mib_ifXEntry_t *ifXEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    ifXEntry->ifIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifXEntry(guint32 *base, gint32 ifIndex)
{
    guint8 idx = 11;

    base[idx++] = ifIndex;
    return idx;
}

static inline if_mib_ifXEntry_t *
assign_ifXEntry(GSList *vbl)
{
    if_mib_ifXEntry_t *ifXEntry;
    char *p;

    ifXEntry = if_mib_new_ifXEntry();
    if (! ifXEntry) {
        return NULL;
    }

    p = (char *) ifXEntry + sizeof(if_mib_ifXEntry_t);
    * (GSList **) p = vbl;

    if (unpack_ifXEntry((GSnmpVarBind *) vbl->data, ifXEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifXEntry");
        g_free(ifXEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, ifXEntry_oid, sizeof(ifXEntry_oid)/sizeof(guint32),
                      ifXEntry_attr, ifXEntry);

    return ifXEntry;
}

void
if_mib_get_ifXTable(GSnmpSession *s, if_mib_ifXEntry_t ***ifXEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 0};

    *ifXEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, ifXEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *ifXEntry = (if_mib_ifXEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(if_mib_ifXEntry_t *));
        if (! *ifXEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*ifXEntry)[i] = assign_ifXEntry(row->data);
        }
    }
}

void
if_mib_get_ifXEntry(GSnmpSession *s, if_mib_ifXEntry_t **ifXEntry, gint32 ifIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifXEntry_oid, sizeof(ifXEntry_oid));
    len = pack_ifXEntry(base, ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifXEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *ifXEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, ifXEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *ifXEntry = assign_ifXEntry(out);
    }
}

void
if_mib_set_ifXEntry(GSnmpSession *s, if_mib_ifXEntry_t *ifXEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifXEntry_oid, sizeof(ifXEntry_oid));
    len = pack_ifXEntry(base, ifXEntry->ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifXEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, ifXEntry_attr, mask, ifXEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
if_mib_free_ifXEntry(if_mib_ifXEntry_t *ifXEntry)
{
    GSList *vbl;
    char *p;

    if (ifXEntry) {
        p = (char *) ifXEntry + sizeof(if_mib_ifXEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(ifXEntry);
    }
}

void
if_mib_free_ifXTable(if_mib_ifXEntry_t **ifXEntry)
{
    int i;

    if (ifXEntry) {
        for (i = 0; ifXEntry[i]; i++) {
            if_mib_free_ifXEntry(ifXEntry[i]);
        }
        g_free(ifXEntry);
    }
}

void
if_mib_set_ifLinkUpDownTrapEnable(GSnmpSession *s, gint32 ifIndex, gint32 ifLinkUpDownTrapEnable)
{
    if_mib_ifXEntry_t *ifXEntry;

    if_mib_get_ifXEntry(s, &ifXEntry, ifIndex, IF_MIB_IFLINKUPDOWNTRAPENABLE);
    if (s->error_status || !ifXEntry) return;
    ifXEntry->ifLinkUpDownTrapEnable = &ifLinkUpDownTrapEnable;
    if_mib_set_ifXEntry(s, ifXEntry, IF_MIB_IFLINKUPDOWNTRAPENABLE);
    if_mib_free_ifXEntry(ifXEntry);
}

void
if_mib_set_ifPromiscuousMode(GSnmpSession *s, gint32 ifIndex, gint32 ifPromiscuousMode)
{
    if_mib_ifXEntry_t *ifXEntry;

    if_mib_get_ifXEntry(s, &ifXEntry, ifIndex, IF_MIB_IFPROMISCUOUSMODE);
    if (s->error_status || !ifXEntry) return;
    ifXEntry->ifPromiscuousMode = &ifPromiscuousMode;
    if_mib_set_ifXEntry(s, ifXEntry, IF_MIB_IFPROMISCUOUSMODE);
    if_mib_free_ifXEntry(ifXEntry);
}

void
if_mib_set_ifAlias(GSnmpSession *s, gint32 ifIndex, guchar *ifAlias, guint16 _ifAliasLength)
{
    if_mib_ifXEntry_t *ifXEntry;

    if_mib_get_ifXEntry(s, &ifXEntry, ifIndex, IF_MIB_IFALIAS);
    if (s->error_status || !ifXEntry) return;
    ifXEntry->ifAlias = ifAlias;
    ifXEntry->_ifAliasLength = _ifAliasLength;
    if_mib_set_ifXEntry(s, ifXEntry, IF_MIB_IFALIAS);
    if_mib_free_ifXEntry(ifXEntry);
}

if_mib_ifStackEntry_t *
if_mib_new_ifStackEntry()
{
    if_mib_ifStackEntry_t *ifStackEntry;

    ifStackEntry = (if_mib_ifStackEntry_t *) g_malloc0(sizeof(if_mib_ifStackEntry_t) + sizeof(gpointer));
    return ifStackEntry;
}

static inline int
unpack_ifStackEntry(GSnmpVarBind *vb, if_mib_ifStackEntry_t *ifStackEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    ifStackEntry->ifStackHigherLayer = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    ifStackEntry->ifStackLowerLayer = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifStackEntry(guint32 *base, gint32 ifStackHigherLayer, gint32 ifStackLowerLayer)
{
    guint8 idx = 11;

    base[idx++] = ifStackHigherLayer;
    base[idx++] = ifStackLowerLayer;
    return idx;
}

static inline if_mib_ifStackEntry_t *
assign_ifStackEntry(GSList *vbl)
{
    if_mib_ifStackEntry_t *ifStackEntry;
    char *p;

    ifStackEntry = if_mib_new_ifStackEntry();
    if (! ifStackEntry) {
        return NULL;
    }

    p = (char *) ifStackEntry + sizeof(if_mib_ifStackEntry_t);
    * (GSList **) p = vbl;

    if (unpack_ifStackEntry((GSnmpVarBind *) vbl->data, ifStackEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifStackEntry");
        g_free(ifStackEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, ifStackEntry_oid, sizeof(ifStackEntry_oid)/sizeof(guint32),
                      ifStackEntry_attr, ifStackEntry);

    return ifStackEntry;
}

void
if_mib_get_ifStackTable(GSnmpSession *s, if_mib_ifStackEntry_t ***ifStackEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 0};

    *ifStackEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, ifStackEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *ifStackEntry = (if_mib_ifStackEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(if_mib_ifStackEntry_t *));
        if (! *ifStackEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*ifStackEntry)[i] = assign_ifStackEntry(row->data);
        }
    }
}

void
if_mib_get_ifStackEntry(GSnmpSession *s, if_mib_ifStackEntry_t **ifStackEntry, gint32 ifStackHigherLayer, gint32 ifStackLowerLayer, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifStackEntry_oid, sizeof(ifStackEntry_oid));
    len = pack_ifStackEntry(base, ifStackHigherLayer, ifStackLowerLayer);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifStackEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *ifStackEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, ifStackEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *ifStackEntry = assign_ifStackEntry(out);
    }
}

void
if_mib_set_ifStackEntry(GSnmpSession *s, if_mib_ifStackEntry_t *ifStackEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifStackEntry_oid, sizeof(ifStackEntry_oid));
    len = pack_ifStackEntry(base, ifStackEntry->ifStackHigherLayer, ifStackEntry->ifStackLowerLayer);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifStackEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, ifStackEntry_attr, mask, ifStackEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
if_mib_free_ifStackEntry(if_mib_ifStackEntry_t *ifStackEntry)
{
    GSList *vbl;
    char *p;

    if (ifStackEntry) {
        p = (char *) ifStackEntry + sizeof(if_mib_ifStackEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(ifStackEntry);
    }
}

void
if_mib_free_ifStackTable(if_mib_ifStackEntry_t **ifStackEntry)
{
    int i;

    if (ifStackEntry) {
        for (i = 0; ifStackEntry[i]; i++) {
            if_mib_free_ifStackEntry(ifStackEntry[i]);
        }
        g_free(ifStackEntry);
    }
}

void
if_mib_create_ifStackEntry(GSnmpSession *s, gint32 ifStackHigherLayer, gint32 ifStackLowerLayer)
{
    if_mib_ifStackEntry_t *ifStackEntry;
    gint32 create = IF_MIB_IFSTACKSTATUS_CREATEANDGO;

    ifStackEntry = if_mib_new_ifStackEntry();
    ifStackEntry->ifStackHigherLayer = ifStackHigherLayer;
    ifStackEntry->ifStackLowerLayer = ifStackLowerLayer;
    ifStackEntry->ifStackStatus = &create;
    if_mib_set_ifStackEntry(s, ifStackEntry, IF_MIB_IFSTACKSTATUS);
    if_mib_free_ifStackEntry(ifStackEntry);
}

void
if_mib_delete_ifStackEntry(GSnmpSession *s, gint32 ifStackHigherLayer, gint32 ifStackLowerLayer)
{
    if_mib_ifStackEntry_t *ifStackEntry;
    gint32 destroy = IF_MIB_IFSTACKSTATUS_DESTROY;

    if_mib_get_ifStackEntry(s, &ifStackEntry, ifStackHigherLayer, ifStackLowerLayer, IF_MIB_IFSTACKSTATUS);
    if (s->error_status || !ifStackEntry) return;
    ifStackEntry->ifStackStatus = &destroy;
    if_mib_set_ifStackEntry(s, ifStackEntry, IF_MIB_IFSTACKSTATUS);
    if_mib_free_ifStackEntry(ifStackEntry);
}

if_mib_ifRcvAddressEntry_t *
if_mib_new_ifRcvAddressEntry()
{
    if_mib_ifRcvAddressEntry_t *ifRcvAddressEntry;

    ifRcvAddressEntry = (if_mib_ifRcvAddressEntry_t *) g_malloc0(sizeof(if_mib_ifRcvAddressEntry_t) + sizeof(gpointer));
    return ifRcvAddressEntry;
}

static inline int
unpack_ifRcvAddressEntry(GSnmpVarBind *vb, if_mib_ifRcvAddressEntry_t *ifRcvAddressEntry)
{
    guint8 idx = 11;
    guint16 i, len;

    if (vb->id_len < idx) return -1;
    ifRcvAddressEntry->ifIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    len = vb->id[idx++];
    if (len > 117) return -1;
    if (vb->id_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        ifRcvAddressEntry->ifRcvAddressAddress[i] = vb->id[idx++];
    }
    ifRcvAddressEntry->_ifRcvAddressAddressLength = len;
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifRcvAddressEntry(guint32 *base, gint32 ifIndex, guchar *ifRcvAddressAddress, guint16 _ifRcvAddressAddressLength)
{
    guint8 idx = 11;
    guint16 i, len;

    base[idx++] = ifIndex;
    len = _ifRcvAddressAddressLength;
    base[idx++] = len;
    if (len > 117) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = ifRcvAddressAddress[i];
        if (idx >= 128) return -1;
    }
    return idx;
}

static inline if_mib_ifRcvAddressEntry_t *
assign_ifRcvAddressEntry(GSList *vbl)
{
    if_mib_ifRcvAddressEntry_t *ifRcvAddressEntry;
    char *p;

    ifRcvAddressEntry = if_mib_new_ifRcvAddressEntry();
    if (! ifRcvAddressEntry) {
        return NULL;
    }

    p = (char *) ifRcvAddressEntry + sizeof(if_mib_ifRcvAddressEntry_t);
    * (GSList **) p = vbl;

    if (unpack_ifRcvAddressEntry((GSnmpVarBind *) vbl->data, ifRcvAddressEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifRcvAddressEntry");
        g_free(ifRcvAddressEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, ifRcvAddressEntry_oid, sizeof(ifRcvAddressEntry_oid)/sizeof(guint32),
                      ifRcvAddressEntry_attr, ifRcvAddressEntry);

    return ifRcvAddressEntry;
}

void
if_mib_get_ifRcvAddressTable(GSnmpSession *s, if_mib_ifRcvAddressEntry_t ***ifRcvAddressEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 0};

    *ifRcvAddressEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, ifRcvAddressEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *ifRcvAddressEntry = (if_mib_ifRcvAddressEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(if_mib_ifRcvAddressEntry_t *));
        if (! *ifRcvAddressEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*ifRcvAddressEntry)[i] = assign_ifRcvAddressEntry(row->data);
        }
    }
}

void
if_mib_get_ifRcvAddressEntry(GSnmpSession *s, if_mib_ifRcvAddressEntry_t **ifRcvAddressEntry, gint32 ifIndex, guchar *ifRcvAddressAddress, guint16 _ifRcvAddressAddressLength, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifRcvAddressEntry_oid, sizeof(ifRcvAddressEntry_oid));
    len = pack_ifRcvAddressEntry(base, ifIndex, ifRcvAddressAddress, _ifRcvAddressAddressLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifRcvAddressEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *ifRcvAddressEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, ifRcvAddressEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *ifRcvAddressEntry = assign_ifRcvAddressEntry(out);
    }
}

void
if_mib_set_ifRcvAddressEntry(GSnmpSession *s, if_mib_ifRcvAddressEntry_t *ifRcvAddressEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifRcvAddressEntry_oid, sizeof(ifRcvAddressEntry_oid));
    len = pack_ifRcvAddressEntry(base, ifRcvAddressEntry->ifIndex, ifRcvAddressEntry->ifRcvAddressAddress, ifRcvAddressEntry->_ifRcvAddressAddressLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifRcvAddressEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, ifRcvAddressEntry_attr, mask, ifRcvAddressEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
if_mib_free_ifRcvAddressEntry(if_mib_ifRcvAddressEntry_t *ifRcvAddressEntry)
{
    GSList *vbl;
    char *p;

    if (ifRcvAddressEntry) {
        p = (char *) ifRcvAddressEntry + sizeof(if_mib_ifRcvAddressEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(ifRcvAddressEntry);
    }
}

void
if_mib_free_ifRcvAddressTable(if_mib_ifRcvAddressEntry_t **ifRcvAddressEntry)
{
    int i;

    if (ifRcvAddressEntry) {
        for (i = 0; ifRcvAddressEntry[i]; i++) {
            if_mib_free_ifRcvAddressEntry(ifRcvAddressEntry[i]);
        }
        g_free(ifRcvAddressEntry);
    }
}

void
if_mib_create_ifRcvAddressEntry(GSnmpSession *s, gint32 ifIndex, guchar *ifRcvAddressAddress, guint16 _ifRcvAddressAddressLength)
{
    if_mib_ifRcvAddressEntry_t *ifRcvAddressEntry;
    gint32 create = IF_MIB_IFRCVADDRESSSTATUS_CREATEANDGO;

    ifRcvAddressEntry = if_mib_new_ifRcvAddressEntry();
    ifRcvAddressEntry->ifIndex = ifIndex;
    memcpy(ifRcvAddressEntry->ifRcvAddressAddress, ifRcvAddressAddress, _ifRcvAddressAddressLength);
    ifRcvAddressEntry->ifRcvAddressStatus = &create;
    if_mib_set_ifRcvAddressEntry(s, ifRcvAddressEntry, IF_MIB_IFRCVADDRESSSTATUS);
    if_mib_free_ifRcvAddressEntry(ifRcvAddressEntry);
}

void
if_mib_delete_ifRcvAddressEntry(GSnmpSession *s, gint32 ifIndex, guchar *ifRcvAddressAddress, guint16 _ifRcvAddressAddressLength)
{
    if_mib_ifRcvAddressEntry_t *ifRcvAddressEntry;
    gint32 destroy = IF_MIB_IFRCVADDRESSSTATUS_DESTROY;

    if_mib_get_ifRcvAddressEntry(s, &ifRcvAddressEntry, ifIndex, ifRcvAddressAddress, _ifRcvAddressAddressLength, IF_MIB_IFRCVADDRESSSTATUS);
    if (s->error_status || !ifRcvAddressEntry) return;
    ifRcvAddressEntry->ifRcvAddressStatus = &destroy;
    if_mib_set_ifRcvAddressEntry(s, ifRcvAddressEntry, IF_MIB_IFRCVADDRESSSTATUS);
    if_mib_free_ifRcvAddressEntry(ifRcvAddressEntry);
}

void
if_mib_set_ifRcvAddressType(GSnmpSession *s, gint32 ifIndex, guchar *ifRcvAddressAddress, guint16 _ifRcvAddressAddressLength, gint32 ifRcvAddressType)
{
    if_mib_ifRcvAddressEntry_t *ifRcvAddressEntry;

    if_mib_get_ifRcvAddressEntry(s, &ifRcvAddressEntry, ifIndex, ifRcvAddressAddress, _ifRcvAddressAddressLength, IF_MIB_IFRCVADDRESSTYPE);
    if (s->error_status || !ifRcvAddressEntry) return;
    ifRcvAddressEntry->ifRcvAddressType = &ifRcvAddressType;
    if_mib_set_ifRcvAddressEntry(s, ifRcvAddressEntry, IF_MIB_IFRCVADDRESSTYPE);
    if_mib_free_ifRcvAddressEntry(ifRcvAddressEntry);
}


