/*							-- DO NOT EDIT --
 * This file has been generated by smidump
 * version 0.3.1 for the scli package.
 *
 * Options:
 *   --scli-exclude='hrSWInstalled'
 *
 * Derived from HOST-RESOURCES-MIB:
 *   This MIB is for use in managing host systems. The term
 *   `host' is construed to mean any computer that communicates
 *   with other similar computers attached to the internet and
 *   that is directly used by one or more human beings. Although
 *   this MIB does not necessarily apply to devices whose primary
 *   function is communications services (e.g., terminal servers,
 *   routers, bridges, monitoring equipment), such relevance is
 *   not explicitly precluded.  This MIB instruments attributes
 *   common to all internet hosts including, for example, both
 *   personal computers and systems that run variants of Unix.
 *
 * Revision 2000-03-06 00:00:
 *   Clarifications and bug fixes based on implementation
 *   experience.  This revision was also reformatted in the SMIv2
 *   format. The revisions made were:
 *   
 *   New RFC document standards:
 *      Added Copyright notice, updated introduction to SNMP
 *      Framework, updated references section, added reference to
 *      RFC 2119, and added a meaningful Security Considerations
 *      section.
 *   
 *   New IANA considerations section for registration of new types
 *   
 *   Conversion to new SMIv2 syntax for the following types and
 *   macros:
 *       Counter32, Integer32, Gauge32, MODULE-IDENTITY,
 *       OBJECT-TYPE, TEXTUAL-CONVENTION, OBJECT-IDENTITY,
 *       MODULE-COMPLIANCE, OBJECT-GROUP
 *   
 *   Used new Textual Conventions:
 *       TruthValue, DateAndTime, AutonomousType,
 *       InterfaceIndexOrZero
 *   
 *   Fixed typo in hrPrinterStatus.
 *   
 *   Added missing error bits to hrPrinterDetectedErrorState and
 *   clarified confusion resulting from suggested mappings to
 *   hrPrinterStatus.
 *   Clarified that size of objects of type
 *   InternationalDisplayString is number of octets, not number
 *   of encoded symbols.
 *   
 *   Clarified the use of the following objects based on
 *   implementation experience:
 *       hrSystemInitialLoadDevice, hrSystemInitialLoadParameters,
 *       hrMemorySize, hrStorageSize, hrStorageAllocationFailures,
 *       hrDeviceErrors, hrProcessorLoad, hrNetworkIfIndex,
 *       hrDiskStorageCapacity, hrSWRunStatus, hrSWRunPerfCPU,
 *       and hrSWInstalledDate.
 *   
 *   Clarified implementation technique for hrSWInstalledTable.
 *   
 *   Used new AUGMENTS clause for hrSWRunPerfTable.
 *   
 *   Added Internationalization Considerations section.
 *   
 *   This revision published as RFC2790.
 *
 * Revision 1999-10-20 22:00:
 *   The original version of this MIB, published as
 *   RFC1514.
 *
 * $Id: host-resources-mib.c,v 1.22 2002/07/03 06:52:57 schoenw Exp $
 */

#include "host-resources-mib.h"

GSnmpEnum const host_resources_mib_enums_hrDeviceStatus[] = {
    { HOST_RESOURCES_MIB_HRDEVICESTATUS_UNKNOWN, "unknown" },
    { HOST_RESOURCES_MIB_HRDEVICESTATUS_RUNNING, "running" },
    { HOST_RESOURCES_MIB_HRDEVICESTATUS_WARNING, "warning" },
    { HOST_RESOURCES_MIB_HRDEVICESTATUS_TESTING, "testing" },
    { HOST_RESOURCES_MIB_HRDEVICESTATUS_DOWN,    "down" },
    { 0, NULL }
};

GSnmpEnum const host_resources_mib_enums_hrPrinterStatus[] = {
    { HOST_RESOURCES_MIB_HRPRINTERSTATUS_OTHER,    "other" },
    { HOST_RESOURCES_MIB_HRPRINTERSTATUS_UNKNOWN,  "unknown" },
    { HOST_RESOURCES_MIB_HRPRINTERSTATUS_IDLE,     "idle" },
    { HOST_RESOURCES_MIB_HRPRINTERSTATUS_PRINTING, "printing" },
    { HOST_RESOURCES_MIB_HRPRINTERSTATUS_WARMUP,   "warmup" },
    { 0, NULL }
};

GSnmpEnum const host_resources_mib_enums_hrDiskStorageAccess[] = {
    { HOST_RESOURCES_MIB_HRDISKSTORAGEACCESS_READWRITE, "readWrite" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEACCESS_READONLY,  "readOnly" },
    { 0, NULL }
};

GSnmpEnum const host_resources_mib_enums_hrDiskStorageMedia[] = {
    { HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA_OTHER,           "other" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA_UNKNOWN,         "unknown" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA_HARDDISK,        "hardDisk" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA_FLOPPYDISK,      "floppyDisk" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA_OPTICALDISKROM,  "opticalDiskROM" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA_OPTICALDISKWORM, "opticalDiskWORM" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA_OPTICALDISKRW,   "opticalDiskRW" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA_RAMDISK,         "ramDisk" },
    { 0, NULL }
};

GSnmpEnum const host_resources_mib_enums_hrDiskStorageRemoveble[] = {
    { HOST_RESOURCES_MIB_HRDISKSTORAGEREMOVEBLE_TRUE,  "true" },
    { HOST_RESOURCES_MIB_HRDISKSTORAGEREMOVEBLE_FALSE, "false" },
    { 0, NULL }
};

GSnmpEnum const host_resources_mib_enums_hrFSAccess[] = {
    { HOST_RESOURCES_MIB_HRFSACCESS_READWRITE, "readWrite" },
    { HOST_RESOURCES_MIB_HRFSACCESS_READONLY,  "readOnly" },
    { 0, NULL }
};

GSnmpEnum const host_resources_mib_enums_hrFSBootable[] = {
    { HOST_RESOURCES_MIB_HRFSBOOTABLE_TRUE,  "true" },
    { HOST_RESOURCES_MIB_HRFSBOOTABLE_FALSE, "false" },
    { 0, NULL }
};

GSnmpEnum const host_resources_mib_enums_hrSWRunType[] = {
    { HOST_RESOURCES_MIB_HRSWRUNTYPE_UNKNOWN,         "unknown" },
    { HOST_RESOURCES_MIB_HRSWRUNTYPE_OPERATINGSYSTEM, "operatingSystem" },
    { HOST_RESOURCES_MIB_HRSWRUNTYPE_DEVICEDRIVER,    "deviceDriver" },
    { HOST_RESOURCES_MIB_HRSWRUNTYPE_APPLICATION,     "application" },
    { 0, NULL }
};

GSnmpEnum const host_resources_mib_enums_hrSWRunStatus[] = {
    { HOST_RESOURCES_MIB_HRSWRUNSTATUS_RUNNING,     "running" },
    { HOST_RESOURCES_MIB_HRSWRUNSTATUS_RUNNABLE,    "runnable" },
    { HOST_RESOURCES_MIB_HRSWRUNSTATUS_NOTRUNNABLE, "notRunnable" },
    { HOST_RESOURCES_MIB_HRSWRUNSTATUS_INVALID,     "invalid" },
    { 0, NULL }
};


static guint16 hrSystemDate_constraints[] = {8, 8, 11, 11, 0, 0};
static guint32 hrSystemInitialLoadDevice_constraints[] = {1L, 2147483647L, 0, 0};
static guint16 hrSystemInitialLoadParameters_constraints[] = {0, 128, 0, 0};
static guint32 hrSystemMaxProcesses_constraints[] = {0L, 2147483647L, 0, 0};
static guint32 hrMemorySize_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 hrStorageDescr_constraints[] = {0, 255, 0, 0};
static guint32 hrStorageAllocationUnits_constraints[] = {1L, 2147483647L, 0, 0};
static guint32 hrStorageSize_constraints[] = {0L, 2147483647L, 0, 0};
static guint32 hrStorageUsed_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 hrDeviceDescr_constraints[] = {0, 64, 0, 0};
static guint32 hrProcessorLoad_constraints[] = {0L, 100L, 0, 0};
static guint32 hrNetworkIfIndex_constraints[] = {0L, 2147483647L, 0, 0};
static guint32 hrDiskStorageCapacity_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 hrPartitionLabel_constraints[] = {0, 128, 0, 0};
static guint32 hrPartitionSize_constraints[] = {0L, 2147483647L, 0, 0};
static guint32 hrPartitionFSIndex_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 hrFSMountPoint_constraints[] = {0, 128, 0, 0};
static guint16 hrFSRemoteMountPoint_constraints[] = {0, 128, 0, 0};
static guint32 hrFSStorageIndex_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 hrFSLastFullBackupDate_constraints[] = {8, 8, 11, 11, 0, 0};
static guint16 hrFSLastPartialBackupDate_constraints[] = {8, 8, 11, 11, 0, 0};
static guint32 hrSWOSIndex_constraints[] = {1L, 2147483647L, 0, 0};
static guint16 hrSWRunName_constraints[] = {0, 64, 0, 0};
static guint16 hrSWRunPath_constraints[] = {0, 128, 0, 0};
static guint16 hrSWRunParameters_constraints[] = {0, 128, 0, 0};
static guint32 hrSWRunPerfCPU_constraints[] = {0L, 2147483647L, 0, 0};
static guint32 hrSWRunPerfMem_constraints[] = {0L, 2147483647L, 0, 0};


static guint32 const hrSystem_oid[] = {1, 3, 6, 1, 2, 1, 25, 1};

static GSnmpAttribute hrSystem_attr[] = {
    { 1, G_SNMP_TIMETICKS,
      HOST_RESOURCES_MIB_HRSYSTEMUPTIME, "hrSystemUptime",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, hrSystemUptime),
      0,
      0 },
    { 2, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRSYSTEMDATE, "hrSystemDate",
       hrSystemDate_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, hrSystemDate),
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, _hrSystemDateLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSYSTEMINITIALLOADDEVICE, "hrSystemInitialLoadDevice",
       hrSystemInitialLoadDevice_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, hrSystemInitialLoadDevice),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRSYSTEMINITIALLOADPARAMETERS, "hrSystemInitialLoadParameters",
       hrSystemInitialLoadParameters_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, hrSystemInitialLoadParameters),
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, _hrSystemInitialLoadParametersLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, G_SNMP_UNSIGNED32,
      HOST_RESOURCES_MIB_HRSYSTEMNUMUSERS, "hrSystemNumUsers",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, hrSystemNumUsers),
      0,
      0 },
    { 6, G_SNMP_UNSIGNED32,
      HOST_RESOURCES_MIB_HRSYSTEMPROCESSES, "hrSystemProcesses",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, hrSystemProcesses),
      0,
      0 },
    { 7, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSYSTEMMAXPROCESSES, "hrSystemMaxProcesses",
       hrSystemMaxProcesses_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSystem_t, hrSystemMaxProcesses),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrStorage_oid[] = {1, 3, 6, 1, 2, 1, 25, 2};

static GSnmpAttribute hrStorage_attr[] = {
    { 2, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRMEMORYSIZE, "hrMemorySize",
       hrMemorySize_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrStorage_t, hrMemorySize),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrStorageEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 2, 3, 1};

static GSnmpAttribute hrStorageEntry_attr[] = {
    { 2, G_SNMP_OBJECTID,
      HOST_RESOURCES_MIB_HRSTORAGETYPE, "hrStorageType",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrStorageEntry_t, hrStorageType),
      G_STRUCT_OFFSET(host_resources_mib_hrStorageEntry_t, _hrStorageTypeLength),
      0 },
    { 3, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRSTORAGEDESCR, "hrStorageDescr",
       hrStorageDescr_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrStorageEntry_t, hrStorageDescr),
      G_STRUCT_OFFSET(host_resources_mib_hrStorageEntry_t, _hrStorageDescrLength),
      0 },
    { 4, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSTORAGEALLOCATIONUNITS, "hrStorageAllocationUnits",
       hrStorageAllocationUnits_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrStorageEntry_t, hrStorageAllocationUnits),
      0,
      0 },
    { 5, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSTORAGESIZE, "hrStorageSize",
       hrStorageSize_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrStorageEntry_t, hrStorageSize),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSTORAGEUSED, "hrStorageUsed",
       hrStorageUsed_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrStorageEntry_t, hrStorageUsed),
      0,
      0 },
    { 7, G_SNMP_COUNTER32,
      HOST_RESOURCES_MIB_HRSTORAGEALLOCATIONFAILURES, "hrStorageAllocationFailures",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrStorageEntry_t, hrStorageAllocationFailures),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrDeviceEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 3, 2, 1};

static GSnmpAttribute hrDeviceEntry_attr[] = {
    { 2, G_SNMP_OBJECTID,
      HOST_RESOURCES_MIB_HRDEVICETYPE, "hrDeviceType",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrDeviceEntry_t, hrDeviceType),
      G_STRUCT_OFFSET(host_resources_mib_hrDeviceEntry_t, _hrDeviceTypeLength),
      0 },
    { 3, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRDEVICEDESCR, "hrDeviceDescr",
       hrDeviceDescr_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrDeviceEntry_t, hrDeviceDescr),
      G_STRUCT_OFFSET(host_resources_mib_hrDeviceEntry_t, _hrDeviceDescrLength),
      0 },
    { 4, G_SNMP_OBJECTID,
      HOST_RESOURCES_MIB_HRDEVICEID, "hrDeviceID",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrDeviceEntry_t, hrDeviceID),
      G_STRUCT_OFFSET(host_resources_mib_hrDeviceEntry_t, _hrDeviceIDLength),
      0 },
    { 5, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRDEVICESTATUS, "hrDeviceStatus",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrDeviceEntry_t, hrDeviceStatus),
      0,
      0 },
    { 6, G_SNMP_COUNTER32,
      HOST_RESOURCES_MIB_HRDEVICEERRORS, "hrDeviceErrors",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrDeviceEntry_t, hrDeviceErrors),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrProcessorEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 3, 3, 1};

static GSnmpAttribute hrProcessorEntry_attr[] = {
    { 1, G_SNMP_OBJECTID,
      HOST_RESOURCES_MIB_HRPROCESSORFRWID, "hrProcessorFrwID",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrProcessorEntry_t, hrProcessorFrwID),
      G_STRUCT_OFFSET(host_resources_mib_hrProcessorEntry_t, _hrProcessorFrwIDLength),
      0 },
    { 2, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRPROCESSORLOAD, "hrProcessorLoad",
       hrProcessorLoad_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrProcessorEntry_t, hrProcessorLoad),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrNetworkEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 3, 4, 1};

static GSnmpAttribute hrNetworkEntry_attr[] = {
    { 1, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRNETWORKIFINDEX, "hrNetworkIfIndex",
       hrNetworkIfIndex_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrNetworkEntry_t, hrNetworkIfIndex),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrPrinterEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 3, 5, 1};

static GSnmpAttribute hrPrinterEntry_attr[] = {
    { 1, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRPRINTERSTATUS, "hrPrinterStatus",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrPrinterEntry_t, hrPrinterStatus),
      0,
      0 },
    { 2, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRPRINTERDETECTEDERRORSTATE, "hrPrinterDetectedErrorState",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrPrinterEntry_t, hrPrinterDetectedErrorState),
      G_STRUCT_OFFSET(host_resources_mib_hrPrinterEntry_t, _hrPrinterDetectedErrorStateLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrDiskStorageEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 3, 6, 1};

static GSnmpAttribute hrDiskStorageEntry_attr[] = {
    { 1, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRDISKSTORAGEACCESS, "hrDiskStorageAccess",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrDiskStorageEntry_t, hrDiskStorageAccess),
      0,
      0 },
    { 2, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRDISKSTORAGEMEDIA, "hrDiskStorageMedia",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrDiskStorageEntry_t, hrDiskStorageMedia),
      0,
      0 },
    { 3, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRDISKSTORAGEREMOVEBLE, "hrDiskStorageRemoveble",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrDiskStorageEntry_t, hrDiskStorageRemoveble),
      0,
      0 },
    { 4, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRDISKSTORAGECAPACITY, "hrDiskStorageCapacity",
       hrDiskStorageCapacity_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrDiskStorageEntry_t, hrDiskStorageCapacity),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrPartitionEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 3, 7, 1};

static GSnmpAttribute hrPartitionEntry_attr[] = {
    { 2, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRPARTITIONLABEL, "hrPartitionLabel",
       hrPartitionLabel_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrPartitionEntry_t, hrPartitionLabel),
      G_STRUCT_OFFSET(host_resources_mib_hrPartitionEntry_t, _hrPartitionLabelLength),
      0 },
    { 3, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRPARTITIONID, "hrPartitionID",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrPartitionEntry_t, hrPartitionID),
      G_STRUCT_OFFSET(host_resources_mib_hrPartitionEntry_t, _hrPartitionIDLength),
      0 },
    { 4, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRPARTITIONSIZE, "hrPartitionSize",
       hrPartitionSize_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrPartitionEntry_t, hrPartitionSize),
      0,
      0 },
    { 5, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRPARTITIONFSINDEX, "hrPartitionFSIndex",
       hrPartitionFSIndex_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrPartitionEntry_t, hrPartitionFSIndex),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrFSEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 3, 8, 1};

static GSnmpAttribute hrFSEntry_attr[] = {
    { 2, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRFSMOUNTPOINT, "hrFSMountPoint",
       hrFSMountPoint_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, hrFSMountPoint),
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, _hrFSMountPointLength),
      0 },
    { 3, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRFSREMOTEMOUNTPOINT, "hrFSRemoteMountPoint",
       hrFSRemoteMountPoint_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, hrFSRemoteMountPoint),
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, _hrFSRemoteMountPointLength),
      0 },
    { 4, G_SNMP_OBJECTID,
      HOST_RESOURCES_MIB_HRFSTYPE, "hrFSType",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, hrFSType),
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, _hrFSTypeLength),
      0 },
    { 5, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRFSACCESS, "hrFSAccess",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, hrFSAccess),
      0,
      0 },
    { 6, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRFSBOOTABLE, "hrFSBootable",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, hrFSBootable),
      0,
      0 },
    { 7, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRFSSTORAGEINDEX, "hrFSStorageIndex",
       hrFSStorageIndex_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, hrFSStorageIndex),
      0,
      0 },
    { 8, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRFSLASTFULLBACKUPDATE, "hrFSLastFullBackupDate",
       hrFSLastFullBackupDate_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, hrFSLastFullBackupDate),
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, _hrFSLastFullBackupDateLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRFSLASTPARTIALBACKUPDATE, "hrFSLastPartialBackupDate",
       hrFSLastPartialBackupDate_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, hrFSLastPartialBackupDate),
      G_STRUCT_OFFSET(host_resources_mib_hrFSEntry_t, _hrFSLastPartialBackupDateLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const hrSWRun_oid[] = {1, 3, 6, 1, 2, 1, 25, 4};

static GSnmpAttribute hrSWRun_attr[] = {
    { 1, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSWOSINDEX, "hrSWOSIndex",
       hrSWOSIndex_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRun_t, hrSWOSIndex),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const hrSWRunEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 4, 2, 1};

static GSnmpAttribute hrSWRunEntry_attr[] = {
    { 2, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRSWRUNNAME, "hrSWRunName",
       hrSWRunName_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, hrSWRunName),
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, _hrSWRunNameLength),
      0 },
    { 3, G_SNMP_OBJECTID,
      HOST_RESOURCES_MIB_HRSWRUNID, "hrSWRunID",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, hrSWRunID),
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, _hrSWRunIDLength),
      0 },
    { 4, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRSWRUNPATH, "hrSWRunPath",
       hrSWRunPath_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, hrSWRunPath),
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, _hrSWRunPathLength),
      0 },
    { 5, G_SNMP_OCTETSTRING,
      HOST_RESOURCES_MIB_HRSWRUNPARAMETERS, "hrSWRunParameters",
       hrSWRunParameters_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, hrSWRunParameters),
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, _hrSWRunParametersLength),
      0 },
    { 6, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSWRUNTYPE, "hrSWRunType",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, hrSWRunType),
      0,
      0 },
    { 7, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSWRUNSTATUS, "hrSWRunStatus",
       NULL,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunEntry_t, hrSWRunStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const hrSWRunPerfEntry_oid[] = {1, 3, 6, 1, 2, 1, 25, 5, 1, 1};

static GSnmpAttribute hrSWRunPerfEntry_attr[] = {
    { 1, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSWRUNPERFCPU, "hrSWRunPerfCPU",
       hrSWRunPerfCPU_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunPerfEntry_t, hrSWRunPerfCPU),
      0,
      0 },
    { 2, G_SNMP_INTEGER32,
      HOST_RESOURCES_MIB_HRSWRUNPERFMEM, "hrSWRunPerfMem",
       hrSWRunPerfMem_constraints,
      G_STRUCT_OFFSET(host_resources_mib_hrSWRunPerfEntry_t, hrSWRunPerfMem),
      0,
      0 },
    { 0, 0, 0, NULL }
};


host_resources_mib_hrSystem_t *
host_resources_mib_new_hrSystem()
{
    host_resources_mib_hrSystem_t *hrSystem;

    hrSystem = (host_resources_mib_hrSystem_t *) g_malloc0(sizeof(host_resources_mib_hrSystem_t) + sizeof(gpointer));
    return hrSystem;
}

static inline host_resources_mib_hrSystem_t *
assign_hrSystem(GSList *vbl)
{
    host_resources_mib_hrSystem_t *hrSystem;
    char *p;

    hrSystem = host_resources_mib_new_hrSystem();
    if (! hrSystem) {
        return NULL;
    }

    p = (char *) hrSystem + sizeof(host_resources_mib_hrSystem_t);
    * (GSList **) p = vbl;

    gsnmp_attr_assign(vbl, hrSystem_oid, sizeof(hrSystem_oid)/sizeof(guint32),
                      hrSystem_attr, hrSystem);

    return hrSystem;
}

void
host_resources_mib_get_hrSystem(GSnmpSession *s, host_resources_mib_hrSystem_t **hrSystem, gint mask)
{
    GSList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 1, 0};

    *hrSystem = NULL;

    gsnmp_attr_get(s, &in, base, 9, 8, hrSystem_attr, mask);

    out = g_snmp_session_sync_getnext(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrSystem = assign_hrSystem(out);
    }
}

void
host_resources_mib_set_hrSystem(GSnmpSession *s, host_resources_mib_hrSystem_t *hrSystem, gint mask)
{
    GSList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 1, 0, 0};

    gsnmp_attr_set(s, &in, base, 10, 8, hrSystem_attr, mask, hrSystem);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
host_resources_mib_free_hrSystem(host_resources_mib_hrSystem_t *hrSystem)
{
    GSList *vbl;
    char *p;

    if (hrSystem) {
        p = (char *) hrSystem + sizeof(host_resources_mib_hrSystem_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrSystem);
    }
}

host_resources_mib_hrStorage_t *
host_resources_mib_new_hrStorage()
{
    host_resources_mib_hrStorage_t *hrStorage;

    hrStorage = (host_resources_mib_hrStorage_t *) g_malloc0(sizeof(host_resources_mib_hrStorage_t) + sizeof(gpointer));
    return hrStorage;
}

static inline host_resources_mib_hrStorage_t *
assign_hrStorage(GSList *vbl)
{
    host_resources_mib_hrStorage_t *hrStorage;
    char *p;

    hrStorage = host_resources_mib_new_hrStorage();
    if (! hrStorage) {
        return NULL;
    }

    p = (char *) hrStorage + sizeof(host_resources_mib_hrStorage_t);
    * (GSList **) p = vbl;

    gsnmp_attr_assign(vbl, hrStorage_oid, sizeof(hrStorage_oid)/sizeof(guint32),
                      hrStorage_attr, hrStorage);

    return hrStorage;
}

void
host_resources_mib_get_hrStorage(GSnmpSession *s, host_resources_mib_hrStorage_t **hrStorage, gint mask)
{
    GSList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 2, 0};

    *hrStorage = NULL;

    gsnmp_attr_get(s, &in, base, 9, 8, hrStorage_attr, mask);

    out = g_snmp_session_sync_getnext(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrStorage = assign_hrStorage(out);
    }
}

void
host_resources_mib_free_hrStorage(host_resources_mib_hrStorage_t *hrStorage)
{
    GSList *vbl;
    char *p;

    if (hrStorage) {
        p = (char *) hrStorage + sizeof(host_resources_mib_hrStorage_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrStorage);
    }
}

host_resources_mib_hrStorageEntry_t *
host_resources_mib_new_hrStorageEntry()
{
    host_resources_mib_hrStorageEntry_t *hrStorageEntry;

    hrStorageEntry = (host_resources_mib_hrStorageEntry_t *) g_malloc0(sizeof(host_resources_mib_hrStorageEntry_t) + sizeof(gpointer));
    return hrStorageEntry;
}

static inline int
unpack_hrStorageEntry(GSnmpVarBind *vb, host_resources_mib_hrStorageEntry_t *hrStorageEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrStorageEntry->hrStorageIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrStorageEntry(guint32 *base, gint32 hrStorageIndex)
{
    guint8 idx = 11;

    base[idx++] = hrStorageIndex;
    return idx;
}

static inline host_resources_mib_hrStorageEntry_t *
assign_hrStorageEntry(GSList *vbl)
{
    host_resources_mib_hrStorageEntry_t *hrStorageEntry;
    char *p;

    hrStorageEntry = host_resources_mib_new_hrStorageEntry();
    if (! hrStorageEntry) {
        return NULL;
    }

    p = (char *) hrStorageEntry + sizeof(host_resources_mib_hrStorageEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrStorageEntry((GSnmpVarBind *) vbl->data, hrStorageEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrStorageEntry");
        g_free(hrStorageEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrStorageEntry_oid, sizeof(hrStorageEntry_oid)/sizeof(guint32),
                      hrStorageEntry_attr, hrStorageEntry);

    return hrStorageEntry;
}

void
host_resources_mib_get_hrStorageTable(GSnmpSession *s, host_resources_mib_hrStorageEntry_t ***hrStorageEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 0};

    *hrStorageEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrStorageEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrStorageEntry = (host_resources_mib_hrStorageEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrStorageEntry_t *));
        if (! *hrStorageEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrStorageEntry)[i] = assign_hrStorageEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrStorageEntry(GSnmpSession *s, host_resources_mib_hrStorageEntry_t **hrStorageEntry, gint32 hrStorageIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrStorageEntry_oid, sizeof(hrStorageEntry_oid));
    len = pack_hrStorageEntry(base, hrStorageIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrStorageEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrStorageEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrStorageEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrStorageEntry = assign_hrStorageEntry(out);
    }
}

void
host_resources_mib_set_hrStorageEntry(GSnmpSession *s, host_resources_mib_hrStorageEntry_t *hrStorageEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrStorageEntry_oid, sizeof(hrStorageEntry_oid));
    len = pack_hrStorageEntry(base, hrStorageEntry->hrStorageIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrStorageEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, hrStorageEntry_attr, mask, hrStorageEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
host_resources_mib_free_hrStorageEntry(host_resources_mib_hrStorageEntry_t *hrStorageEntry)
{
    GSList *vbl;
    char *p;

    if (hrStorageEntry) {
        p = (char *) hrStorageEntry + sizeof(host_resources_mib_hrStorageEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrStorageEntry);
    }
}

void
host_resources_mib_free_hrStorageTable(host_resources_mib_hrStorageEntry_t **hrStorageEntry)
{
    int i;

    if (hrStorageEntry) {
        for (i = 0; hrStorageEntry[i]; i++) {
            host_resources_mib_free_hrStorageEntry(hrStorageEntry[i]);
        }
        g_free(hrStorageEntry);
    }
}

host_resources_mib_hrDeviceEntry_t *
host_resources_mib_new_hrDeviceEntry()
{
    host_resources_mib_hrDeviceEntry_t *hrDeviceEntry;

    hrDeviceEntry = (host_resources_mib_hrDeviceEntry_t *) g_malloc0(sizeof(host_resources_mib_hrDeviceEntry_t) + sizeof(gpointer));
    return hrDeviceEntry;
}

static inline int
unpack_hrDeviceEntry(GSnmpVarBind *vb, host_resources_mib_hrDeviceEntry_t *hrDeviceEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrDeviceEntry->hrDeviceIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrDeviceEntry(guint32 *base, gint32 hrDeviceIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    return idx;
}

static inline host_resources_mib_hrDeviceEntry_t *
assign_hrDeviceEntry(GSList *vbl)
{
    host_resources_mib_hrDeviceEntry_t *hrDeviceEntry;
    char *p;

    hrDeviceEntry = host_resources_mib_new_hrDeviceEntry();
    if (! hrDeviceEntry) {
        return NULL;
    }

    p = (char *) hrDeviceEntry + sizeof(host_resources_mib_hrDeviceEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrDeviceEntry((GSnmpVarBind *) vbl->data, hrDeviceEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrDeviceEntry");
        g_free(hrDeviceEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrDeviceEntry_oid, sizeof(hrDeviceEntry_oid)/sizeof(guint32),
                      hrDeviceEntry_attr, hrDeviceEntry);

    return hrDeviceEntry;
}

void
host_resources_mib_get_hrDeviceTable(GSnmpSession *s, host_resources_mib_hrDeviceEntry_t ***hrDeviceEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 0};

    *hrDeviceEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrDeviceEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrDeviceEntry = (host_resources_mib_hrDeviceEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrDeviceEntry_t *));
        if (! *hrDeviceEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrDeviceEntry)[i] = assign_hrDeviceEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrDeviceEntry(GSnmpSession *s, host_resources_mib_hrDeviceEntry_t **hrDeviceEntry, gint32 hrDeviceIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrDeviceEntry_oid, sizeof(hrDeviceEntry_oid));
    len = pack_hrDeviceEntry(base, hrDeviceIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrDeviceEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrDeviceEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrDeviceEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrDeviceEntry = assign_hrDeviceEntry(out);
    }
}

void
host_resources_mib_free_hrDeviceEntry(host_resources_mib_hrDeviceEntry_t *hrDeviceEntry)
{
    GSList *vbl;
    char *p;

    if (hrDeviceEntry) {
        p = (char *) hrDeviceEntry + sizeof(host_resources_mib_hrDeviceEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrDeviceEntry);
    }
}

void
host_resources_mib_free_hrDeviceTable(host_resources_mib_hrDeviceEntry_t **hrDeviceEntry)
{
    int i;

    if (hrDeviceEntry) {
        for (i = 0; hrDeviceEntry[i]; i++) {
            host_resources_mib_free_hrDeviceEntry(hrDeviceEntry[i]);
        }
        g_free(hrDeviceEntry);
    }
}

host_resources_mib_hrProcessorEntry_t *
host_resources_mib_new_hrProcessorEntry()
{
    host_resources_mib_hrProcessorEntry_t *hrProcessorEntry;

    hrProcessorEntry = (host_resources_mib_hrProcessorEntry_t *) g_malloc0(sizeof(host_resources_mib_hrProcessorEntry_t) + sizeof(gpointer));
    return hrProcessorEntry;
}

static inline int
unpack_hrProcessorEntry(GSnmpVarBind *vb, host_resources_mib_hrProcessorEntry_t *hrProcessorEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrProcessorEntry->hrDeviceIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrProcessorEntry(guint32 *base, gint32 hrDeviceIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    return idx;
}

static inline host_resources_mib_hrProcessorEntry_t *
assign_hrProcessorEntry(GSList *vbl)
{
    host_resources_mib_hrProcessorEntry_t *hrProcessorEntry;
    char *p;

    hrProcessorEntry = host_resources_mib_new_hrProcessorEntry();
    if (! hrProcessorEntry) {
        return NULL;
    }

    p = (char *) hrProcessorEntry + sizeof(host_resources_mib_hrProcessorEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrProcessorEntry((GSnmpVarBind *) vbl->data, hrProcessorEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrProcessorEntry");
        g_free(hrProcessorEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrProcessorEntry_oid, sizeof(hrProcessorEntry_oid)/sizeof(guint32),
                      hrProcessorEntry_attr, hrProcessorEntry);

    return hrProcessorEntry;
}

void
host_resources_mib_get_hrProcessorTable(GSnmpSession *s, host_resources_mib_hrProcessorEntry_t ***hrProcessorEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 3, 3, 1, 0};

    *hrProcessorEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrProcessorEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrProcessorEntry = (host_resources_mib_hrProcessorEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrProcessorEntry_t *));
        if (! *hrProcessorEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrProcessorEntry)[i] = assign_hrProcessorEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrProcessorEntry(GSnmpSession *s, host_resources_mib_hrProcessorEntry_t **hrProcessorEntry, gint32 hrDeviceIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrProcessorEntry_oid, sizeof(hrProcessorEntry_oid));
    len = pack_hrProcessorEntry(base, hrDeviceIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrProcessorEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrProcessorEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrProcessorEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrProcessorEntry = assign_hrProcessorEntry(out);
    }
}

void
host_resources_mib_free_hrProcessorEntry(host_resources_mib_hrProcessorEntry_t *hrProcessorEntry)
{
    GSList *vbl;
    char *p;

    if (hrProcessorEntry) {
        p = (char *) hrProcessorEntry + sizeof(host_resources_mib_hrProcessorEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrProcessorEntry);
    }
}

void
host_resources_mib_free_hrProcessorTable(host_resources_mib_hrProcessorEntry_t **hrProcessorEntry)
{
    int i;

    if (hrProcessorEntry) {
        for (i = 0; hrProcessorEntry[i]; i++) {
            host_resources_mib_free_hrProcessorEntry(hrProcessorEntry[i]);
        }
        g_free(hrProcessorEntry);
    }
}

host_resources_mib_hrNetworkEntry_t *
host_resources_mib_new_hrNetworkEntry()
{
    host_resources_mib_hrNetworkEntry_t *hrNetworkEntry;

    hrNetworkEntry = (host_resources_mib_hrNetworkEntry_t *) g_malloc0(sizeof(host_resources_mib_hrNetworkEntry_t) + sizeof(gpointer));
    return hrNetworkEntry;
}

static inline int
unpack_hrNetworkEntry(GSnmpVarBind *vb, host_resources_mib_hrNetworkEntry_t *hrNetworkEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrNetworkEntry->hrDeviceIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrNetworkEntry(guint32 *base, gint32 hrDeviceIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    return idx;
}

static inline host_resources_mib_hrNetworkEntry_t *
assign_hrNetworkEntry(GSList *vbl)
{
    host_resources_mib_hrNetworkEntry_t *hrNetworkEntry;
    char *p;

    hrNetworkEntry = host_resources_mib_new_hrNetworkEntry();
    if (! hrNetworkEntry) {
        return NULL;
    }

    p = (char *) hrNetworkEntry + sizeof(host_resources_mib_hrNetworkEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrNetworkEntry((GSnmpVarBind *) vbl->data, hrNetworkEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrNetworkEntry");
        g_free(hrNetworkEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrNetworkEntry_oid, sizeof(hrNetworkEntry_oid)/sizeof(guint32),
                      hrNetworkEntry_attr, hrNetworkEntry);

    return hrNetworkEntry;
}

void
host_resources_mib_get_hrNetworkTable(GSnmpSession *s, host_resources_mib_hrNetworkEntry_t ***hrNetworkEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 3, 4, 1, 0};

    *hrNetworkEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrNetworkEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrNetworkEntry = (host_resources_mib_hrNetworkEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrNetworkEntry_t *));
        if (! *hrNetworkEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrNetworkEntry)[i] = assign_hrNetworkEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrNetworkEntry(GSnmpSession *s, host_resources_mib_hrNetworkEntry_t **hrNetworkEntry, gint32 hrDeviceIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrNetworkEntry_oid, sizeof(hrNetworkEntry_oid));
    len = pack_hrNetworkEntry(base, hrDeviceIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrNetworkEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrNetworkEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrNetworkEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrNetworkEntry = assign_hrNetworkEntry(out);
    }
}

void
host_resources_mib_free_hrNetworkEntry(host_resources_mib_hrNetworkEntry_t *hrNetworkEntry)
{
    GSList *vbl;
    char *p;

    if (hrNetworkEntry) {
        p = (char *) hrNetworkEntry + sizeof(host_resources_mib_hrNetworkEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrNetworkEntry);
    }
}

void
host_resources_mib_free_hrNetworkTable(host_resources_mib_hrNetworkEntry_t **hrNetworkEntry)
{
    int i;

    if (hrNetworkEntry) {
        for (i = 0; hrNetworkEntry[i]; i++) {
            host_resources_mib_free_hrNetworkEntry(hrNetworkEntry[i]);
        }
        g_free(hrNetworkEntry);
    }
}

host_resources_mib_hrPrinterEntry_t *
host_resources_mib_new_hrPrinterEntry()
{
    host_resources_mib_hrPrinterEntry_t *hrPrinterEntry;

    hrPrinterEntry = (host_resources_mib_hrPrinterEntry_t *) g_malloc0(sizeof(host_resources_mib_hrPrinterEntry_t) + sizeof(gpointer));
    return hrPrinterEntry;
}

static inline int
unpack_hrPrinterEntry(GSnmpVarBind *vb, host_resources_mib_hrPrinterEntry_t *hrPrinterEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrPrinterEntry->hrDeviceIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrPrinterEntry(guint32 *base, gint32 hrDeviceIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    return idx;
}

static inline host_resources_mib_hrPrinterEntry_t *
assign_hrPrinterEntry(GSList *vbl)
{
    host_resources_mib_hrPrinterEntry_t *hrPrinterEntry;
    char *p;

    hrPrinterEntry = host_resources_mib_new_hrPrinterEntry();
    if (! hrPrinterEntry) {
        return NULL;
    }

    p = (char *) hrPrinterEntry + sizeof(host_resources_mib_hrPrinterEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrPrinterEntry((GSnmpVarBind *) vbl->data, hrPrinterEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrPrinterEntry");
        g_free(hrPrinterEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrPrinterEntry_oid, sizeof(hrPrinterEntry_oid)/sizeof(guint32),
                      hrPrinterEntry_attr, hrPrinterEntry);

    return hrPrinterEntry;
}

void
host_resources_mib_get_hrPrinterTable(GSnmpSession *s, host_resources_mib_hrPrinterEntry_t ***hrPrinterEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 3, 5, 1, 0};

    *hrPrinterEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrPrinterEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrPrinterEntry = (host_resources_mib_hrPrinterEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrPrinterEntry_t *));
        if (! *hrPrinterEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrPrinterEntry)[i] = assign_hrPrinterEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrPrinterEntry(GSnmpSession *s, host_resources_mib_hrPrinterEntry_t **hrPrinterEntry, gint32 hrDeviceIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrPrinterEntry_oid, sizeof(hrPrinterEntry_oid));
    len = pack_hrPrinterEntry(base, hrDeviceIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrPrinterEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrPrinterEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrPrinterEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrPrinterEntry = assign_hrPrinterEntry(out);
    }
}

void
host_resources_mib_free_hrPrinterEntry(host_resources_mib_hrPrinterEntry_t *hrPrinterEntry)
{
    GSList *vbl;
    char *p;

    if (hrPrinterEntry) {
        p = (char *) hrPrinterEntry + sizeof(host_resources_mib_hrPrinterEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrPrinterEntry);
    }
}

void
host_resources_mib_free_hrPrinterTable(host_resources_mib_hrPrinterEntry_t **hrPrinterEntry)
{
    int i;

    if (hrPrinterEntry) {
        for (i = 0; hrPrinterEntry[i]; i++) {
            host_resources_mib_free_hrPrinterEntry(hrPrinterEntry[i]);
        }
        g_free(hrPrinterEntry);
    }
}

host_resources_mib_hrDiskStorageEntry_t *
host_resources_mib_new_hrDiskStorageEntry()
{
    host_resources_mib_hrDiskStorageEntry_t *hrDiskStorageEntry;

    hrDiskStorageEntry = (host_resources_mib_hrDiskStorageEntry_t *) g_malloc0(sizeof(host_resources_mib_hrDiskStorageEntry_t) + sizeof(gpointer));
    return hrDiskStorageEntry;
}

static inline int
unpack_hrDiskStorageEntry(GSnmpVarBind *vb, host_resources_mib_hrDiskStorageEntry_t *hrDiskStorageEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrDiskStorageEntry->hrDeviceIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrDiskStorageEntry(guint32 *base, gint32 hrDeviceIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    return idx;
}

static inline host_resources_mib_hrDiskStorageEntry_t *
assign_hrDiskStorageEntry(GSList *vbl)
{
    host_resources_mib_hrDiskStorageEntry_t *hrDiskStorageEntry;
    char *p;

    hrDiskStorageEntry = host_resources_mib_new_hrDiskStorageEntry();
    if (! hrDiskStorageEntry) {
        return NULL;
    }

    p = (char *) hrDiskStorageEntry + sizeof(host_resources_mib_hrDiskStorageEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrDiskStorageEntry((GSnmpVarBind *) vbl->data, hrDiskStorageEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrDiskStorageEntry");
        g_free(hrDiskStorageEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrDiskStorageEntry_oid, sizeof(hrDiskStorageEntry_oid)/sizeof(guint32),
                      hrDiskStorageEntry_attr, hrDiskStorageEntry);

    return hrDiskStorageEntry;
}

void
host_resources_mib_get_hrDiskStorageTable(GSnmpSession *s, host_resources_mib_hrDiskStorageEntry_t ***hrDiskStorageEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 0};

    *hrDiskStorageEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrDiskStorageEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrDiskStorageEntry = (host_resources_mib_hrDiskStorageEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrDiskStorageEntry_t *));
        if (! *hrDiskStorageEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrDiskStorageEntry)[i] = assign_hrDiskStorageEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrDiskStorageEntry(GSnmpSession *s, host_resources_mib_hrDiskStorageEntry_t **hrDiskStorageEntry, gint32 hrDeviceIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrDiskStorageEntry_oid, sizeof(hrDiskStorageEntry_oid));
    len = pack_hrDiskStorageEntry(base, hrDeviceIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrDiskStorageEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrDiskStorageEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrDiskStorageEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrDiskStorageEntry = assign_hrDiskStorageEntry(out);
    }
}

void
host_resources_mib_free_hrDiskStorageEntry(host_resources_mib_hrDiskStorageEntry_t *hrDiskStorageEntry)
{
    GSList *vbl;
    char *p;

    if (hrDiskStorageEntry) {
        p = (char *) hrDiskStorageEntry + sizeof(host_resources_mib_hrDiskStorageEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrDiskStorageEntry);
    }
}

void
host_resources_mib_free_hrDiskStorageTable(host_resources_mib_hrDiskStorageEntry_t **hrDiskStorageEntry)
{
    int i;

    if (hrDiskStorageEntry) {
        for (i = 0; hrDiskStorageEntry[i]; i++) {
            host_resources_mib_free_hrDiskStorageEntry(hrDiskStorageEntry[i]);
        }
        g_free(hrDiskStorageEntry);
    }
}

host_resources_mib_hrPartitionEntry_t *
host_resources_mib_new_hrPartitionEntry()
{
    host_resources_mib_hrPartitionEntry_t *hrPartitionEntry;

    hrPartitionEntry = (host_resources_mib_hrPartitionEntry_t *) g_malloc0(sizeof(host_resources_mib_hrPartitionEntry_t) + sizeof(gpointer));
    return hrPartitionEntry;
}

static inline int
unpack_hrPartitionEntry(GSnmpVarBind *vb, host_resources_mib_hrPartitionEntry_t *hrPartitionEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrPartitionEntry->hrDeviceIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    hrPartitionEntry->hrPartitionIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrPartitionEntry(guint32 *base, gint32 hrDeviceIndex, gint32 hrPartitionIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = hrPartitionIndex;
    return idx;
}

static inline host_resources_mib_hrPartitionEntry_t *
assign_hrPartitionEntry(GSList *vbl)
{
    host_resources_mib_hrPartitionEntry_t *hrPartitionEntry;
    char *p;

    hrPartitionEntry = host_resources_mib_new_hrPartitionEntry();
    if (! hrPartitionEntry) {
        return NULL;
    }

    p = (char *) hrPartitionEntry + sizeof(host_resources_mib_hrPartitionEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrPartitionEntry((GSnmpVarBind *) vbl->data, hrPartitionEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrPartitionEntry");
        g_free(hrPartitionEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrPartitionEntry_oid, sizeof(hrPartitionEntry_oid)/sizeof(guint32),
                      hrPartitionEntry_attr, hrPartitionEntry);

    return hrPartitionEntry;
}

void
host_resources_mib_get_hrPartitionTable(GSnmpSession *s, host_resources_mib_hrPartitionEntry_t ***hrPartitionEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 0};

    *hrPartitionEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrPartitionEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrPartitionEntry = (host_resources_mib_hrPartitionEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrPartitionEntry_t *));
        if (! *hrPartitionEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrPartitionEntry)[i] = assign_hrPartitionEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrPartitionEntry(GSnmpSession *s, host_resources_mib_hrPartitionEntry_t **hrPartitionEntry, gint32 hrDeviceIndex, gint32 hrPartitionIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrPartitionEntry_oid, sizeof(hrPartitionEntry_oid));
    len = pack_hrPartitionEntry(base, hrDeviceIndex, hrPartitionIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrPartitionEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrPartitionEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrPartitionEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrPartitionEntry = assign_hrPartitionEntry(out);
    }
}

void
host_resources_mib_free_hrPartitionEntry(host_resources_mib_hrPartitionEntry_t *hrPartitionEntry)
{
    GSList *vbl;
    char *p;

    if (hrPartitionEntry) {
        p = (char *) hrPartitionEntry + sizeof(host_resources_mib_hrPartitionEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrPartitionEntry);
    }
}

void
host_resources_mib_free_hrPartitionTable(host_resources_mib_hrPartitionEntry_t **hrPartitionEntry)
{
    int i;

    if (hrPartitionEntry) {
        for (i = 0; hrPartitionEntry[i]; i++) {
            host_resources_mib_free_hrPartitionEntry(hrPartitionEntry[i]);
        }
        g_free(hrPartitionEntry);
    }
}

host_resources_mib_hrFSEntry_t *
host_resources_mib_new_hrFSEntry()
{
    host_resources_mib_hrFSEntry_t *hrFSEntry;

    hrFSEntry = (host_resources_mib_hrFSEntry_t *) g_malloc0(sizeof(host_resources_mib_hrFSEntry_t) + sizeof(gpointer));
    return hrFSEntry;
}

static inline int
unpack_hrFSEntry(GSnmpVarBind *vb, host_resources_mib_hrFSEntry_t *hrFSEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrFSEntry->hrFSIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrFSEntry(guint32 *base, gint32 hrFSIndex)
{
    guint8 idx = 11;

    base[idx++] = hrFSIndex;
    return idx;
}

static inline host_resources_mib_hrFSEntry_t *
assign_hrFSEntry(GSList *vbl)
{
    host_resources_mib_hrFSEntry_t *hrFSEntry;
    char *p;

    hrFSEntry = host_resources_mib_new_hrFSEntry();
    if (! hrFSEntry) {
        return NULL;
    }

    p = (char *) hrFSEntry + sizeof(host_resources_mib_hrFSEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrFSEntry((GSnmpVarBind *) vbl->data, hrFSEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrFSEntry");
        g_free(hrFSEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrFSEntry_oid, sizeof(hrFSEntry_oid)/sizeof(guint32),
                      hrFSEntry_attr, hrFSEntry);

    return hrFSEntry;
}

void
host_resources_mib_get_hrFSTable(GSnmpSession *s, host_resources_mib_hrFSEntry_t ***hrFSEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 0};

    *hrFSEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrFSEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrFSEntry = (host_resources_mib_hrFSEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrFSEntry_t *));
        if (! *hrFSEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrFSEntry)[i] = assign_hrFSEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrFSEntry(GSnmpSession *s, host_resources_mib_hrFSEntry_t **hrFSEntry, gint32 hrFSIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrFSEntry_oid, sizeof(hrFSEntry_oid));
    len = pack_hrFSEntry(base, hrFSIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrFSEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrFSEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrFSEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrFSEntry = assign_hrFSEntry(out);
    }
}

void
host_resources_mib_set_hrFSEntry(GSnmpSession *s, host_resources_mib_hrFSEntry_t *hrFSEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrFSEntry_oid, sizeof(hrFSEntry_oid));
    len = pack_hrFSEntry(base, hrFSEntry->hrFSIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrFSEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, hrFSEntry_attr, mask, hrFSEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
host_resources_mib_free_hrFSEntry(host_resources_mib_hrFSEntry_t *hrFSEntry)
{
    GSList *vbl;
    char *p;

    if (hrFSEntry) {
        p = (char *) hrFSEntry + sizeof(host_resources_mib_hrFSEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrFSEntry);
    }
}

void
host_resources_mib_free_hrFSTable(host_resources_mib_hrFSEntry_t **hrFSEntry)
{
    int i;

    if (hrFSEntry) {
        for (i = 0; hrFSEntry[i]; i++) {
            host_resources_mib_free_hrFSEntry(hrFSEntry[i]);
        }
        g_free(hrFSEntry);
    }
}

host_resources_mib_hrSWRun_t *
host_resources_mib_new_hrSWRun()
{
    host_resources_mib_hrSWRun_t *hrSWRun;

    hrSWRun = (host_resources_mib_hrSWRun_t *) g_malloc0(sizeof(host_resources_mib_hrSWRun_t) + sizeof(gpointer));
    return hrSWRun;
}

static inline host_resources_mib_hrSWRun_t *
assign_hrSWRun(GSList *vbl)
{
    host_resources_mib_hrSWRun_t *hrSWRun;
    char *p;

    hrSWRun = host_resources_mib_new_hrSWRun();
    if (! hrSWRun) {
        return NULL;
    }

    p = (char *) hrSWRun + sizeof(host_resources_mib_hrSWRun_t);
    * (GSList **) p = vbl;

    gsnmp_attr_assign(vbl, hrSWRun_oid, sizeof(hrSWRun_oid)/sizeof(guint32),
                      hrSWRun_attr, hrSWRun);

    return hrSWRun;
}

void
host_resources_mib_get_hrSWRun(GSnmpSession *s, host_resources_mib_hrSWRun_t **hrSWRun, gint mask)
{
    GSList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 4, 0};

    *hrSWRun = NULL;

    gsnmp_attr_get(s, &in, base, 9, 8, hrSWRun_attr, mask);

    out = g_snmp_session_sync_getnext(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrSWRun = assign_hrSWRun(out);
    }
}

void
host_resources_mib_free_hrSWRun(host_resources_mib_hrSWRun_t *hrSWRun)
{
    GSList *vbl;
    char *p;

    if (hrSWRun) {
        p = (char *) hrSWRun + sizeof(host_resources_mib_hrSWRun_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrSWRun);
    }
}

host_resources_mib_hrSWRunEntry_t *
host_resources_mib_new_hrSWRunEntry()
{
    host_resources_mib_hrSWRunEntry_t *hrSWRunEntry;

    hrSWRunEntry = (host_resources_mib_hrSWRunEntry_t *) g_malloc0(sizeof(host_resources_mib_hrSWRunEntry_t) + sizeof(gpointer));
    return hrSWRunEntry;
}

static inline int
unpack_hrSWRunEntry(GSnmpVarBind *vb, host_resources_mib_hrSWRunEntry_t *hrSWRunEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrSWRunEntry->hrSWRunIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrSWRunEntry(guint32 *base, gint32 hrSWRunIndex)
{
    guint8 idx = 11;

    base[idx++] = hrSWRunIndex;
    return idx;
}

static inline host_resources_mib_hrSWRunEntry_t *
assign_hrSWRunEntry(GSList *vbl)
{
    host_resources_mib_hrSWRunEntry_t *hrSWRunEntry;
    char *p;

    hrSWRunEntry = host_resources_mib_new_hrSWRunEntry();
    if (! hrSWRunEntry) {
        return NULL;
    }

    p = (char *) hrSWRunEntry + sizeof(host_resources_mib_hrSWRunEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrSWRunEntry((GSnmpVarBind *) vbl->data, hrSWRunEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrSWRunEntry");
        g_free(hrSWRunEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrSWRunEntry_oid, sizeof(hrSWRunEntry_oid)/sizeof(guint32),
                      hrSWRunEntry_attr, hrSWRunEntry);

    return hrSWRunEntry;
}

void
host_resources_mib_get_hrSWRunTable(GSnmpSession *s, host_resources_mib_hrSWRunEntry_t ***hrSWRunEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 0};

    *hrSWRunEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrSWRunEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrSWRunEntry = (host_resources_mib_hrSWRunEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrSWRunEntry_t *));
        if (! *hrSWRunEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrSWRunEntry)[i] = assign_hrSWRunEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrSWRunEntry(GSnmpSession *s, host_resources_mib_hrSWRunEntry_t **hrSWRunEntry, gint32 hrSWRunIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrSWRunEntry_oid, sizeof(hrSWRunEntry_oid));
    len = pack_hrSWRunEntry(base, hrSWRunIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrSWRunEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrSWRunEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrSWRunEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrSWRunEntry = assign_hrSWRunEntry(out);
    }
}

void
host_resources_mib_set_hrSWRunEntry(GSnmpSession *s, host_resources_mib_hrSWRunEntry_t *hrSWRunEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrSWRunEntry_oid, sizeof(hrSWRunEntry_oid));
    len = pack_hrSWRunEntry(base, hrSWRunEntry->hrSWRunIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrSWRunEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, hrSWRunEntry_attr, mask, hrSWRunEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
host_resources_mib_free_hrSWRunEntry(host_resources_mib_hrSWRunEntry_t *hrSWRunEntry)
{
    GSList *vbl;
    char *p;

    if (hrSWRunEntry) {
        p = (char *) hrSWRunEntry + sizeof(host_resources_mib_hrSWRunEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrSWRunEntry);
    }
}

void
host_resources_mib_free_hrSWRunTable(host_resources_mib_hrSWRunEntry_t **hrSWRunEntry)
{
    int i;

    if (hrSWRunEntry) {
        for (i = 0; hrSWRunEntry[i]; i++) {
            host_resources_mib_free_hrSWRunEntry(hrSWRunEntry[i]);
        }
        g_free(hrSWRunEntry);
    }
}

host_resources_mib_hrSWRunPerfEntry_t *
host_resources_mib_new_hrSWRunPerfEntry()
{
    host_resources_mib_hrSWRunPerfEntry_t *hrSWRunPerfEntry;

    hrSWRunPerfEntry = (host_resources_mib_hrSWRunPerfEntry_t *) g_malloc0(sizeof(host_resources_mib_hrSWRunPerfEntry_t) + sizeof(gpointer));
    return hrSWRunPerfEntry;
}

static inline int
unpack_hrSWRunPerfEntry(GSnmpVarBind *vb, host_resources_mib_hrSWRunPerfEntry_t *hrSWRunPerfEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    hrSWRunPerfEntry->hrSWRunIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static inline int
pack_hrSWRunPerfEntry(guint32 *base, gint32 hrSWRunIndex)
{
    guint8 idx = 11;

    base[idx++] = hrSWRunIndex;
    return idx;
}

static inline host_resources_mib_hrSWRunPerfEntry_t *
assign_hrSWRunPerfEntry(GSList *vbl)
{
    host_resources_mib_hrSWRunPerfEntry_t *hrSWRunPerfEntry;
    char *p;

    hrSWRunPerfEntry = host_resources_mib_new_hrSWRunPerfEntry();
    if (! hrSWRunPerfEntry) {
        return NULL;
    }

    p = (char *) hrSWRunPerfEntry + sizeof(host_resources_mib_hrSWRunPerfEntry_t);
    * (GSList **) p = vbl;

    if (unpack_hrSWRunPerfEntry((GSnmpVarBind *) vbl->data, hrSWRunPerfEntry) < 0) {
        g_warning("%s: invalid instance identifier", "hrSWRunPerfEntry");
        g_free(hrSWRunPerfEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, hrSWRunPerfEntry_oid, sizeof(hrSWRunPerfEntry_oid)/sizeof(guint32),
                      hrSWRunPerfEntry_attr, hrSWRunPerfEntry);

    return hrSWRunPerfEntry;
}

void
host_resources_mib_get_hrSWRunPerfTable(GSnmpSession *s, host_resources_mib_hrSWRunPerfEntry_t ***hrSWRunPerfEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 25, 5, 1, 1, 0};

    *hrSWRunPerfEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, hrSWRunPerfEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *hrSWRunPerfEntry = (host_resources_mib_hrSWRunPerfEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(host_resources_mib_hrSWRunPerfEntry_t *));
        if (! *hrSWRunPerfEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*hrSWRunPerfEntry)[i] = assign_hrSWRunPerfEntry(row->data);
        }
    }
}

void
host_resources_mib_get_hrSWRunPerfEntry(GSnmpSession *s, host_resources_mib_hrSWRunPerfEntry_t **hrSWRunPerfEntry, gint32 hrSWRunIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, hrSWRunPerfEntry_oid, sizeof(hrSWRunPerfEntry_oid));
    len = pack_hrSWRunPerfEntry(base, hrSWRunIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "hrSWRunPerfEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *hrSWRunPerfEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, hrSWRunPerfEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *hrSWRunPerfEntry = assign_hrSWRunPerfEntry(out);
    }
}

void
host_resources_mib_free_hrSWRunPerfEntry(host_resources_mib_hrSWRunPerfEntry_t *hrSWRunPerfEntry)
{
    GSList *vbl;
    char *p;

    if (hrSWRunPerfEntry) {
        p = (char *) hrSWRunPerfEntry + sizeof(host_resources_mib_hrSWRunPerfEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(hrSWRunPerfEntry);
    }
}

void
host_resources_mib_free_hrSWRunPerfTable(host_resources_mib_hrSWRunPerfEntry_t **hrSWRunPerfEntry)
{
    int i;

    if (hrSWRunPerfEntry) {
        for (i = 0; hrSWRunPerfEntry[i]; i++) {
            host_resources_mib_free_hrSWRunPerfEntry(hrSWRunPerfEntry[i]);
        }
        g_free(hrSWRunPerfEntry);
    }
}


