# Web::Interface
# Copyright(c) 2002 MoonWolf <moonwolf@moonwolf.com>
require 'web/interface/basic'
require 'web/interface/cgi'      #CGI
require 'web/interface/mod_ruby' #mod_ruby
require 'web/interface/fastcgi'  #FastCGI
require 'web/interface/rinda'    #Rinda
require 'web/interface/rubymail' #RubyMail

module Web
  module Interface
    AUTO = 
      if defined?(MOD_RUBY)
        Web::Interface::ModRuby
      else
        begin
          s = Socket.for_fd($stdin.fileno)
          s.getpeername
          Web::Interface::FastCGI
        rescue Errno::ENOTCONN
          Web::Interface::FastCGI
        rescue Errno::ENOTSOCK,Errno::EINVAL
          Web::Interface::CGI
        end
      end
  end # Interface
end # Web
