# Web::Controller::Simple
# Copyright(c) 2004 MoonWolf <moonwolf@moonwolf.com>
require "web/escape"
require "web/response"

module Web
  module Controller
    class Simple
      module RunMode_cmd
        def run_mode(req)
          rm = req.get('cmd')
          if rm == nil
            req.form.keys.each {|k|
              if k=~/^cmd_/
                rm = $'
                break
              end
            }
          end
          rm ||= 'start'
          return rm
        end
      end
      
      module RunMode_mode
        def run_mode(req)
          rm = req.get('mode')
          if rm == nil
            req.form.keys.each {|k|
              if k=~/^mode_/
                rm = $'
                break
              end
            }
          end
          rm ||= 'start'
          return rm
        end
      end
      
      def initialize
      end
      
      def setup(opt={})
      end
      
      def teardown
      end
      
      def run_mode(req)
        rm = req.get('rm')
        if rm == nil
          req.form.keys.each {|k|
            if k=~/^rm_/
              rm = $'
              break
            end
          }
        end
        rm ||= 'start'
        return rm
      end
      
      def run(req)
        begin
          rsp = Web::Response.new
          rm = 'do_' + run_mode(req)
          send(rm, req, rsp)
          rsp
        rescue StandardError,ScriptError
          error($!.message + "\n" + $!.backtrace.join("\n"))
        end
      end
      
      def error(msg)
        rsp = Web::Response.new
        
        msg = h(msg).gsub(/\n/,"<br>")
        rsp.content_type = "text/html"
        rsp.write <<EOS
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN">
<html>
<head>
<title>ERROR #{self.class}</title>
<link rel="INDEX"  href="./">
</head>
<body>
  <h1>ERROR #{self.class}</h1>
  <pre>#{msg}</pre>
</body>
</html>
EOS
        rsp
      end
      
      def h(str)
        Web::escapeHTML(str)
      end
      
      def u(str)
        Web::escape(str.to_s)
      end

      def qs(hash)
        url = '?'
        url << hash.collect {|key,value|
          u(key.to_s) << '=' << u(value.to_s)
        }.sort.join(';')
        h(url)
      end

      def get_param(req, name, type, must = true)
        raise ArgumentError if must && !req.has_key?(name)
        value = req[name]
        return nil if !value and !must
        value = value.read if value.respond_to?(:read)
        case type
        when :text
          raise ArgumentError if must && value.empty?
          value
        when :flag
          case value.trim.downcase
          when /\A(?:on|yes|y|true|1)\z/
            true
          when /\A(?:off|no|n|false|0)\z/
            false
          else
            raise ArgumentError
          end
        when :integer
          Integer(value)
        when Array
          raise ArgumentError unless type.include?(value)
          value
        when Hash
          type[value]
        when Regexp
          m = type.match(value)
          raise ArgumentError unless value
          m
        end
      end
      
    end # Simple
  end # Controller
end # Web
