% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{[[.igraph}
\alias{[[.igraph}
\title{Query and manipulate a graph as it were an adjacency list}
\usage{
\method{[[}{igraph}(x, i, j, from, to, ..., directed = TRUE,
  edges = FALSE, exact = TRUE)
}
\arguments{
\item{x}{The graph.}

\item{i}{Index, integer, character or logical, see details below.}

\item{j}{Index, integer, character or logical, see details below.}

\item{from}{A numeric or character vector giving vertex ids or
names. Together with the \code{to} argument, it can be used to
query/set a sequence of edges. See details below. This argument cannot
be present together with any of the \code{i} and \code{j} arguments
and if it is present, then the \code{to} argument must be present as
well.}

\item{to}{A numeric or character vector giving vertex ids or
names. Together with the \code{from} argument, it can be used to
query/set a sequence of edges. See details below. This argument cannot
be present together with any of the \code{i} and \code{j} arguments
and if it is present, then the \code{from} argument must be present as
well.}

\item{...}{Additional arguments are not used currently.}

\item{directed}{Logical scalar, whether to consider edge directions
in directed graphs. It is ignored for undirected graphs.}

\item{edges}{Logical scalar, whether to return edge ids.}

\item{exact}{Ignored.}
}
\description{
Query and manipulate a graph as it were an adjacency list
}
\details{
The double bracket operator indexes the (imaginary) adjacency list
of the graph. This can used for the following operations:
\enumerate{
  \item Querying the adjacent vertices for one or more
    vertices: \preformatted{  graph[[1:3,]]
graph[[,1:3]]}
    The first form gives the successors, the second the predessors
    or the 1:3 vertices. (For undirected graphs they are equivalent.)
  \item Querying the incident edges for one or more vertices,
    if the \code{edges} argument is set to
    \code{TRUE}: \preformatted{  graph[[1:3, , edges=TRUE]]
graph[[, 1:3, edges=TRUE]]}
  \item Querying the edge ids between two sets or vertices,
    if both indices are used. E.g. \preformatted{  graph[[v, w, edges=TRUE]]}
    gives the edge ids of all the edges that exist from vertices
    \eqn{v} to vertices \eqn{w}.
 }

The alternative argument names \code{from} and \code{to} can be used
instead of the usual \code{i} and \code{j}, to make the code more
readable: \preformatted{ graph[[from = 1:3]]
graph[[from = v, to = w, edges = TRUE]]}

\sQuote{\code{[[}} operators allows logical indices and negative indices
as well, with the usual R semantics.

Vertex names are also supported, so instead of a numeric vertex id a
vertex can also be given to \sQuote{\code{[}} and \sQuote{\code{[[}}.
}
\seealso{
Other structural queries: \code{\link{[.igraph}},
  \code{\link{adjacent_vertices}},
  \code{\link{are_adjacent}}, \code{\link{ends}},
  \code{\link{get.edge.ids}}, \code{\link{gorder}},
  \code{\link{gsize}}, \code{\link{head_of}},
  \code{\link{incident_edges}}, \code{\link{incident}},
  \code{\link{is_directed}}, \code{\link{neighbors}},
  \code{\link{tail_of}}
}
\concept{structural queries}
